(*
   Hex View
   Version 1.00
   (C) 1996, Glen Why

   Main Form Class

*)
unit HEXVIEW1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ComCtrls, HexDump, AnotherReg;

const

  PANEL_HINT = 0;
  PANEL_SIZE = 1;


type

  TMainForm = class(TForm)
    HexDump: THexDump;
    StatusBar: TStatusBar;
    MainMenu: TMainMenu;
    FileItem: TMenuItem;
    FileOpenItem: TMenuItem;
    FileCloseItem: TMenuItem;
    N1: TMenuItem;
    FileExitItem: TMenuItem;
    OpenDialog: TOpenDialog;
    AppConfigKey: TAppConfigKey;
    MainFormRestorer: TFormRestorer;
    OptionsItem: TMenuItem;
    OptionsFontItem: TMenuItem;
    FontSmallItem: TMenuItem;
    FontNormalItem: TMenuItem;
    FontLargeItem: TMenuItem;
    HVOpenFile: TSoundEvent;
    HVCloseFile: TSoundEvent;
    HelpItem: TMenuItem;
    AboutItem: TMenuItem;
    OptionsKey: TRegKey;
    FontSize: TVariantProfile;
    History: TRegKey;
    procedure UpdateFileMenu(Sender: TObject);
    procedure OpenFIle(Sender: TObject);
    procedure CloseFile(Sender: TObject);
    procedure CloseApp(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure UpdateOptionsMenu(Sender: TObject);
    procedure UpdateFontMenu(Sender: TObject);
    procedure SmallFont(Sender: TObject);
    procedure NormalFont(Sender: TObject);
    procedure LageFont(Sender: TObject);
    procedure About(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    FData :TMemoryStream;
    FFileName :string;
    FHistory :TStringList;
    procedure AddHistoryItem( const ItemCaption :string );
    procedure ShowHint( Sender :TObject );
    function GetStatusPanel( index :integer ): TStatusPanel;
    procedure HistoryItemClick( Sender :TObject );
    procedure UpdateControls;
    procedure UpdateCaption;
    property HintPanel :TStatusPanel index PANEL_HINT read GetStatusPanel;
    property SizePanel :TStatusPanel index PANEL_SIZE read GetStatusPanel;
  public
    procedure LoadFile( const FileName :string );
  end;

var
  MainForm: TMainForm;

implementation

uses Registry, HexView2;

{$R *.DFM}

const

 SmallFontSize = 8;
 NormalFontSize = 10;
 LargeFontSize = 12;

 MAX_HISTORY = 8;

procedure TMainForm.UpdateFileMenu(Sender: TObject);
begin
  FileCloseItem.Enabled := FData <> Nil;
end;

procedure TMainForm.LoadFile( const FileName :string );
begin
  CloseFile ( self );
  FData := TMemoryStream.Create;
  try
    FData.LoadFromFile( FileName );
    HVOpenFile.Play;
    with HexDump do
      begin
        CurrentLine := 0;
        Address := FData.Memory;
        DataSize := FData.Size;
      end;
    FFileName := FileName;
    UpdateCaption;
    UpdateControls;
  except
    FData.Free;
    FData := Nil;
    raise;
  end;
end;

procedure TMainForm.OpenFIle(Sender: TObject);
begin
  with OpenDialog do
   begin
     FileName := '';
     if not Execute then raise EAbort.Create('');
     LoadFile( FileName );
   end;
end;

procedure TMainForm.CloseFile(Sender: TObject);
begin
  if ( FData <> Nil ) then
    begin
      HVCloseFile.Play;
      with HexDump do
       begin
         CurrentLine := -1;
         DataSize := 0;
         Address := Nil;
       end;
      FData.Free;
      FData := Nil;
      with FHistory do
       if IndexOf( FFileName ) < 0 then
         begin
           Insert( 0, FFIleName );
           if ( Count > MAX_HISTORY ) then Delete( Count - 1 );
         end;
      FFileName := '';
      UpdateControls;
      UpdateCaption;
    end;
end;

procedure TMainForm.CloseApp(Sender: TObject);
begin
 Close;
end;

procedure TMainForm.ShowHint( Sender :TObject );
begin
  HintPanel.Text := Application.Hint;
end;

function TMainForm.GetStatusPanel( index :integer ):TStatusPanel;
begin
 result := StatusBar.Panels[ index ];
end;

procedure TMainForm.AddHistoryItem( const ItemCaption :string );
var I :TMenuItem;
begin
  I := TMenuItem.Create( Self );
  with I do
  try
    Caption := ItemCaption;
    OnClick := HistoryItemClick;
    Visible := true;
  except
    I.Free;
    raise;
  end;
  FileItem.Add( I );
end;

procedure TMainForm.FormCreate(Sender: TObject);
var i, c :integer;
begin
  FHistory := TStringList.Create;
  if History.Exist then
    with TRegistry.Create do
      try
        RootKey := History.Handle;
        OpenKey( '', true );
        C := ReadInteger( 'C' );
        if C > 0 then
          begin
            AddHistoryItem( '-' );
            for i := 0 to C - 1
             do begin
               FHistory.Add( ReadString( IntToStr( I ) ) );
               AddHistoryItem( FHistory.Strings[ i ] );
             end;
          end;
      finally
        free;
      end;
  Application.OnHint := ShowHint;
  HintPanel.Text := '';
  if FontSize.Exist
    then HexDump.Font.Size := FontSize.Value
    else HexDump.Font.Size := NormalFontSize;
  UpdateControls;
end;

procedure TMainForm.UpdateControls;
var S :Integer;
begin
 UpdateFileMenu( self );
 UpdateFontMenu( self );
 UpdateOptionsMenu( self );
 if FData <> Nil then S := FData.Size else S := 0;
 SizePanel.Text := Format( 'File Size: %d  (%xh)', [ S, s ] );
end;


procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
var i :integer;
begin
  CloseFile( self );
  FontSize.Value := HexDump.Font.Size;
  with TRegistry.Create do
   try
     RootKey := History.Handle;
     OpenKey( '', true );
     WriteInteger( 'C', FHistory.Count );
     for i := 0 to FHistory.Count - 1
       do WriteString( IntToStr( I ), FHistory.Strings[ i ] );
   finally
     free;
   end;
end;

procedure TMainForm.UpdateOptionsMenu(Sender: TObject);
begin
{}
end;

procedure TMainForm.UpdateFontMenu(Sender: TObject);
begin
  case HexDump.Font.Size of
    SmallFontSize : FontSmallItem.Checked := true;
    NormalFontSize : FontNormalItem.Checked := true;
    LargeFontSize : FontLargeItem.Checked := true;
  end;
end;

procedure TMainForm.SmallFont(Sender: TObject);
begin
  HexDump.Font.Size := SmallFontSize;
end;

procedure TMainForm.NormalFont(Sender: TObject);
begin
  HexDump.Font.Size := NormalFontSize;
end;

procedure TMainForm.LageFont(Sender: TObject);
begin
  HexDump.Font.Size := LargeFontSize;
end;

procedure TMainForm.About(Sender: TObject);
begin
  AboutBox( Self );
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  FHistory.Free;
end;

procedure TMainForm.HistoryItemClick( Sender :TObject );
begin
  LoadFile( ( Sender as TMenuItem ).Caption );
end;

procedure TMainForm.UpdateCaption;
begin
 if FFileName = '' then Caption := 'Hex Viewer'
  else Caption := Format( 'Hex Viewer - %s', [ FFileName ] );
end;

end.
