unit TEST_A1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, GWCOmpress;

type
  TMainForm = class(TForm)
    Button1: TButton;
    OpenDialog: TOpenDialog;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    TimeLbl: TLabel;
    LZWCompressor: TLZWCompressor;
    procedure TestNullCompress(Sender: TObject);
    procedure TestNullDecompress(Sender: TObject);
    procedure TestLZWCompress(Sender: TObject);
    procedure TestLZWDecompress(Sender: TObject);
    procedure LZWCompressorGetData(Sender: TObject; pData: Pointer;
      var cbData: Integer);
    procedure LZWCompressorSetData(Sender: TObject; pData: Pointer;
      var cbData: Integer);
  private
    FInStream , FOutStream :TFileStream;
    procedure GetDataEvent( Sender :TObject;
      pData :Pointer; Var cbData :Integer );
    procedure SetDataEvent( Sender :TObject;
      pData :Pointer; Var cbData :Integer );
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.TestNullCompress(Sender: TObject);
begin
  if not OpenDialog.Execute then exit;
  FInStream := TFileStream.Create( OpenDialog.FileName, fmOpenRead);
  try
    FOutStream := TFileStream.Create(
      ChangeFileExt( OpenDialog.FileName, '.NUL' ), fmCreate );
    try
      with TNullCOmpressor.Create( nil ) do
      try
        OnGetData := GetDataEvent;
        OnSetData := SetDataEvent;
        Compress;
      finally
        Free;
      end;
    finally
      FOutStream.free;
      FOutStream := nil;
    end;
  finally
    FInStream.free;
    FInStream := nil;
  end;
end;

procedure TMainForm.GetDataEvent( Sender :TObject;
 pData :Pointer; Var cbData :Integer );
begin
  cbData := FInStream.Read( pData^, cbData );
end;


procedure TMainForm.SetDataEvent( Sender :TObject;
 pData :Pointer; Var cbData :Integer );
begin
  FOutStream.write( pData^, cbData );
end;

procedure TMainForm.TestNullDecompress(Sender: TObject);
begin
  if not OpenDialog.Execute then exit;
  FInStream := TFileStream.Create( OpenDialog.FileName, fmOpenRead);
  try
    FOutStream := TFileStream.Create(
      ChangeFileExt( OpenDialog.FileName, '.ORG' ), fmCreate );
    try
      with TNullCOmpressor.Create( nil ) do
      try
        OnGetData := GetDataEvent;
        OnSetData := SetDataEvent;
        DeCompress;
      finally
        Free;
      end;
    finally
      FOutStream.free;
      FOutStream := nil;
    end;
  finally
    FInStream.free;
    FInStream := nil;
  end;
end;

procedure TMainForm.TestLZWCompress(Sender: TObject);
begin
  if not OpenDialog.Execute then exit;
  FInStream := TFileStream.Create( OpenDialog.FileName, fmOpenRead);
  try
    FOutStream := TFileStream.Create(
      ChangeFileExt( OpenDialog.FileName, '.LZW' ), fmCreate );
    try
      with LZWCOmpressor do
        begin
          Compress;
          TimeLbl.Caption := IntToStr( ElapsedTime );
        end;
    finally
      FOutStream.free;
      FOutStream := nil;
    end;
  finally
    FInStream.free;
    FInStream := nil;
  end;
end;

procedure TMainForm.TestLZWDecompress(Sender: TObject);
begin
  if not OpenDialog.Execute then exit;
  FInStream := TFileStream.Create( OpenDialog.FileName, fmOpenRead);
  try
    FOutStream := TFileStream.Create(
      ChangeFileExt( OpenDialog.FileName, '.ORG' ), fmCreate );
    try
      with LZWCOmpressor do
        begin
          DeCompress;
          TimeLbl.Caption := IntToStr( ElapsedTime );
        end;
    finally
      FOutStream.free;
      FOutStream := nil;
    end;
  finally
    FInStream.free;
    FInStream := nil;
  end;
end;

procedure TMainForm.LZWCompressorGetData(Sender: TObject;
 pData: Pointer; var cbData: Integer);
begin
  cbData := FInStream.Read( pData^, cbData );
end;

procedure TMainForm.LZWCompressorSetData(Sender: TObject;
  pData: Pointer; var cbData: Integer);
begin
  FOutStream.write( pData^, cbData );
end;




end.
