unit TEST_A1;

interface

uses
  Windows, MMSystem, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, ExtCtrls, ComCtrls, WavParser;

type
  TMainForm = class(TForm)
    MainMenu: TMainMenu;
    FileItem: TMenuItem;
    FileOpenItem: TMenuItem;
    FileCloseItem: TMenuItem;
    N1: TMenuItem;
    FileExitItem: TMenuItem;
    HelpItem: TMenuItem;
    HelpAboutItem: TMenuItem;
    OpenDialog: TOpenDialog;
    Memo: TMemo;
    MenuBevel: TBevel;
    Label1: TLabel;
    WAVItem: TMenuItem;
    ExtractDataItem: TMenuItem;
    ExtractFormatItem: TMenuItem;
    StatusBar: TStatusBar;
    SaveDialog: TSaveDialog;
    procedure UpdateFileMenu(Sender: TObject);
    procedure OpenFile(Sender: TObject);
    procedure CloseFile(Sender: TObject);
    procedure FileExitItemClick(Sender: TObject);
    procedure About(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure UpdateWavMenu(Sender: TObject);
    procedure ExtractData(Sender: TObject);
    procedure ExtractFormat(Sender: TObject);
  private
    FFileName :TFileName;
    procedure SetFileName( const Value :TFileName );
    function GetFileLoaded :Boolean;
    function GetStatusPanel( index :integer ):TStatusPanel;
    procedure ShowHint( Sender :TObject );
  protected
    procedure UpdateMenus;
    procedure UpdateControls;
    property FileNamePanel :TStatusPanel index 0
      read GetStatusPanel;
    property HintPanel :TStatusPanel index 1
      read GetStatusPanel;
  public
    property FileLoaded :Boolean
      read GetFileLoaded;
    property FileName :TFileName
      read FFileName write SetFileName;
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}
{$I Strings.Inc}

procedure TMainForm.UpdateFileMenu(Sender: TObject);
begin
  FileCloseItem.Enabled := FileLoaded;
end;

procedure TMainForm.OpenFile(Sender: TObject);
begin
  if OpenDialog.Execute then FileName := OpenDialog.FileName;
end;

procedure TMainForm.CloseFile(Sender: TObject);
begin
  if FileLoaded then
    begin
      FFileName := '';
      UpdateMenus;
      UpdateControls;
    end;
end;

procedure TMainForm.FileExitItemClick(Sender: TObject);
begin
 Close;
end;

procedure TMainForm.About(Sender: TObject);
begin
  MessageDlg( 'WavParser Test A.01'#13#10'(C) 1996, Glen Why',
    mtInformation, [ mbOk ], 0 );
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  CloseFile( self );
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  UpdateMenus;
  UpdateControls;
  HintPanel.Text := LoadStr( SWelcome );
  Application.OnHint := ShowHint;
end;

procedure TMainForm.UpdateMenus;
begin
  UpdateFileMenu( self );
end;

procedure TMainForm.UpdateControls;
var
  RiffCK :TMMCKINFO;
  DataCK :TMMCKINFO;
  WavFmt :TWAVEFORMATEX;
begin
  FileNamePanel.Text := ExtractFileName( FFileName );
  memo.clear;

  // using WavParser instance to read WAV info

  if FileLoaded then begin

    with TWavParser.Create( nil ) do
     try
       FileName := Self.FileName;
       try
         RiffCk := RiffChunk[ FOURCC_WAVE ];
       except
         on EChunkNotFound do raise Exception.CreateRes( SInvalidWav );
         else raise;
       end;
       GetCkData( Chunks[ FOURCC_FMT_, RiffCk ], WavFmt );
       DataCk := Chunks[ FOURCC_DATA, RiffCk ];
     finally
       free;
     end;

     with memo.lines do begin
      BeginUpdate;
      with WavFmt do begin
       add( LoadStr( SFormatTitle ) );
       add( FmtLoadStr( SFormatTag, [ wFormatTag ] ) );
       add( FmtLoadStr( SChannels, [ nCHannels ] ) );
       add( FmtLoadStr( SSamplesPerSec, [ nSamplesPerSec ] ));
       add( FmtLoadStr( SAvgBytesPerSec, [ nAvgBytesPerSec ] ));
       add( FmtLoadStr( SBlockAlign, [ nBlockAlign ] ));
       add( FmtLoadStr( SBitsPerSample, [ wBitsPerSample ] ));
      end;
      with DataCk do begin
       add( LoadStr( SDataTitle ));
       add( FmtLoadStr( SDataLength, [ CkSize ] ));
       add( FmtLoadStr( SDataOffset, [ dwDataOffset ] ));
      end;
      EndUpdate;
     end;

  end;


end;

procedure TMainForm.SetFileName( const Value :TFileName );
begin
   CloseFile( self );
   FFileName := Value;
   UpdateMenus;
   UpdateControls;
end;

function TMainForm.GetFileLoaded :Boolean;
begin
 result := FFileName <> '';
end;


procedure TMainForm.UpdateWavMenu(Sender: TObject);
begin
  ExtractDataItem.Enabled := FileLoaded;
  ExtractFormatItem.Enabled := FileLoaded;
end;

procedure TMainForm.ExtractData(Sender: TObject);
var d :pointer;
begin
  if FileLoaded then
    if SaveDialog.Execute then
      with TWaveDataExtractor.Create( Self.FileName ) do
       try
         GetMem( D, DataLength + 32 );
         try
           Extract( D^ );
           with TFileStream.Create( SaveDialog.FileName, fmCreate ) do
            try
              write( d^, DataLength );
            finally
              free;
            end;
         finally
           FreeMem( D );
         end;
       finally
         free;
       end;
end;

procedure TMainForm.ExtractFormat(Sender: TObject);
var d :pointer;
begin
  if FileLoaded then
    if SaveDialog.Execute then
      with TWaveFormatExtractor.Create( Self.FileName ) do
       try
         GetMem( D, DataLength + 32 );
         try
           Extract( D^ );
           with TFileStream.Create( SaveDialog.FileName, fmCreate ) do
            try
              write( d^, DataLength );
            finally
              free;
            end;
         finally
           FreeMem( D );
         end;
       finally
         free;
       end;
end;


function TMainForm.GetStatusPanel( index :integer ):TStatusPanel;
begin
  result := StatusBar.Panels[ index ];
end;

procedure TMainForm.ShowHint( Sender :TObject );
begin
  HintPanel.Text := Application.Hint;
end;

end.
