(*

  TFileResource Component
  (C) 1996, Glen Why

*)

unit FileResource;

interface
uses
  SysUtils, Classes;


type

  TFileResource = class( TComponent )
  private
    FFileName :TFileName;
    FData :Pointer;
    FDataSize :Integer;
    procedure ReadData( stream :tstream );
    procedure WriteData( stream :tstream );
    procedure SetFileName( const Value :TFileName );
  protected
    procedure DefineProperties( Filer :TFiler ); override;
  public
    destructor Destroy; override;
    property Data :Pointer read FData;
    property DataSize :Integer read FDataSize;
  published
    property FileName :TFileName read FFileName write SetFileName;
  end;


procedure register;

implementation
uses
  DsgnIntf, FileNameProp;

procedure register;
begin
 RegisterPropertyEditor( TypeInfo( TFileName ),
  TFileResource, 'FileName', TFileNameProperty );
  RegisterComponents ( 'more...', [ TFileResource ] );
end;


procedure TFileResource.DefineProperties( Filer :TFiler );
begin
  inherited DefineProperties( Filer );
  Filer.DefineBinaryProperty( 'DATA', ReadData, WriteData, FData <> nil );
end;

procedure TFileResource.ReadData( stream :tstream );
begin
  with stream do
   begin
     read( FDataSize, sizeof( FDataSize ) );
     GetMem( FData, FDataSize + 32 );
     try
       read( FData^, FDataSize );
     except
       FreeMem( FData );
       FData := nil;
       FDataSize := 0;
       raise;
     end;
   end;
end;

procedure TFileResource.WriteData( stream :tstream );
begin
  with stream do
   begin
     Write( FDataSize, Sizeof( FDataSize ) );
     write( FData^, FDataSize );
   end;
end;


procedure TFileResource.SetFileName( const Value :String );
begin
  if Value <> FFileName then
   with TFileStream.Create( Value, fmOpenRead ) do
    try
      FFileName := '';
      if FData <> Nil  then
        begin
         FreeMem( FData );
         FData := nil;
        end;
      FDataSize := Size + 32;
      GetMem( FData, FDataSize );
      try
        read( FData^, FDataSize );
      except
        FreeMem( FData );
        FDataSize := 0;
        FData := nil;
        raise;
      end;
      FFileName := Value;
    finally
      free;
    end;
end;


destructor TFileResource.Destroy;
begin
  if FData <> Nil then FreeMem( FData );
  inherited Destroy;
end;


end.
