(*

  File Mapping Class
  by Glen Why
  1996
*)

{$B-}

unit FileMapping;

interface
uses
  WIndows, SysUtils, Classes;

type

 {

   File Mapping Class is a simple interface for the Windows' file
   mappings. Use file mapping object to associate file on disk
   to the application's address space. This allows application to
   access file in the same way as dynamically allocated memory.

   TFileMapping maps the whole file into application's
   address space. Use the Memory property to access
   file's data. WARNING: TFileMapping provides read-only
   access, attempt to write data will result into the
   access violation.

   for more information on using file mappings see "Win32
   Programmer's Reference".


}

  EFileMappingError = class( exception );

  TFileMapping = class
  private
    FMappingHandle :THandle;
    FMemory :Pointer;
  public
    constructor Create( Stream :TFileStream );
    destructor Destroy; override;
    property Memory :Pointer read FMemory;
  end;

implementation

{$Resource FileMapping.Res}
{$Include FileMapping.Inc}

{ TFileMapping }

constructor TFIleMapping.Create( Stream :TFileStream );
begin
  if ( stream = nil ) or ( stream.handle = 0 )
    then raise EFileMappingError.CreateRes( SInvalidParams );
  FMappingHandle := CreateFileMapping( stream.handle,
    nil, PAGE_READONLY, 0, 0, PChar( IntToStr( stream.handle ) ));
  if ( FMappingHandle = 0 )
    then raise EFileMappingError.CreateRes( SCreateHandleError );
  FMemory := MapViewOfFile( FMappingHandle, FILE_MAP_READ, 0, 0, 0 );
  if ( FMemory = Nil )
    then raise EFileMappingError.CreateRes( SMapViewError );
end;


destructor TFIleMapping.Destroy;
begin
  if ( FMemory <> Nil ) then
    begin
      if not UnmapViewOfFile( FMemory )
        then raise EFileMappingError.CreateRes( SUnmapViewError );
      FMemory := Nil;
    end;
  if ( FMappingHandle <> 0 ) then
    if not CloseHandle( FMappingHandle )
      then raise EFileMappingError.CreateRes( SCloseMappingHandle );
  inherited Destroy;
end;


end.
