unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DB, DBTables, ExtCtrls, Grids, DBGrids, grTool, StdCtrls;

type
  TForm1 = class(TForm)
    Table1: TTable;
    DataSource1: TDataSource;
    Table1CustNo: TFloatField;
    Table1Company: TStringField;
    Table1Addr1: TStringField;
    Table1Addr2: TStringField;
    Table1City: TStringField;
    Table1State: TStringField;
    Table1Zip: TStringField;
    Table1Country: TStringField;
    Table1Phone: TStringField;
    Table1FAX: TStringField;
    Table1TaxRate: TFloatField;
    Table1Contact: TStringField;
    Table1LastInvoiceDate: TDateTimeField;
    DBgrTool1: TDBgrTool;
    DBGrid1: TDBGrid;
    Panel1: TPanel;
    SrchBtn: TButton;
    FiltBtn: TButton;
    ViewBtn: TButton;
    CloseBtn: TButton;
    SaveBtn: TButton;
    RestoreBtn: TButton;
    procedure SrchBtnClick(Sender: TObject);
    procedure FiltBtnClick(Sender: TObject);
    procedure ViewBtnClick(Sender: TObject);
    procedure SaveBtnClick(Sender: TObject);
    procedure CloseBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure RestoreBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  Table1.Open;

  { there is some tricks - you can set this property in design time }
  Table1Addr2.Tag:=100; { user can't filter data with this field !!! }

  { Field City is non-visible, but user can set this field to visible
    with function ExecView }
  Table1City.Visible:=False;

  { Field Contact is non-visible, and user can't set this field to
    visible with function ExecView }
  Table1Contact.Visible:=False;
  Table1Contact.Tag:=1000;

  { if Tag is 1100 - user can't filter data and can't set this field
    to visible }
end;

procedure TForm1.SrchBtnClick(Sender: TObject);
begin
  DBgrTool1.ExecSearch;
end;

procedure TForm1.FiltBtnClick(Sender: TObject);
begin
  DBgrTool1.ExecFilter;
end;

procedure TForm1.ViewBtnClick(Sender: TObject);
begin
  DBgrTool1.ExecView;
end;


{ those two function you can use, if DBgrTool1.IniSaveGrid property is
  set to False }
procedure TForm1.SaveBtnClick(Sender: TObject);
begin
  { manual save position and width of fields in grid }
  DBgrTool1.SaveDataSet;
end;

procedure TForm1.RestoreBtnClick(Sender: TObject);
begin
  { manual restore position and width of fields in grid }
  DBgrTool1.RestoreDataSet;
end;

procedure TForm1.CloseBtnClick(Sender: TObject);
begin
  Close;
end;

end.
