unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Mask, ToolEdit, GridBox, ExtCtrls, PicClip;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    ComboBox98: TComboBox98;
    Label1: TLabel;
    GroupBox2: TGroupBox;
    GridBox1: TGridBox;
    Label2: TLabel;
    GroupBox3: TGroupBox;
    GridBox2: TGridBox;
    Label3: TLabel;
    GroupBox4: TGroupBox;
    GridBox3: TGridBox;
    Label4: TLabel;
    Bevel1: TBevel;
    Button1: TButton;
    PicClip: TPicClip;
    CheckBox1: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure GridBox2DrawItem(Sender: TObject; Index, Col: Integer;
              Rect: TRect; State: TOwnerDrawState);
    procedure GridBox3ClickItem(Sender: TObject; Index, Col: Integer;
              var CanSelect: Boolean);
  private
    { Private declarations }
  protected
    { Protected declarations }
    procedure Loaded; override;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Loaded;
begin
  inherited;

  // Zero based index
  GridBox3.ColWidths[0] := 100;
  GridBox3.ColWidths[1] :=  75;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  nItem: Integer;
begin
  GridBox1.ItemIndex := 0;
  with GridBox2 do
    begin
    DefaultColWidth  := PicClip.Width + 6;
    DefaultRowHeight := PicClip.Height + 6;
    for nItem := 0 to PicClip.Cols * PicClip.Rows - 1 do
      Items.Add(IntToStr(nItem));
    ItemIndex := 0;
    end;
  GridBox3.ItemIndex := 0;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  with (Sender as TCheckBox) do
    begin
    ComboBox98.Enabled := Checked;
    GridBox1.Enabled := Checked;
    GridBox2.Enabled := Checked;
    GridBox3.Enabled := Checked;
    end;
end;

procedure TForm1.GridBox2DrawItem(Sender: TObject; Index, Col: Integer;
          Rect: TRect; State: TOwnerDrawState);
begin
  if Index > -1 then
    begin
    // Center if necesary
    if Rect.Right - Rect.Left > PicClip.Width then
      Rect.Left := Rect.Left + (Rect.Right - Rect.Left - PicClip.Width) div 2;
    if Rect.Bottom - Rect.Top > PicClip.Height then
      Rect.Top := Rect.Top + (Rect.Bottom - Rect.Top - PicClip.Height) div 2;
    PicClip.Draw((Sender as TGridBox).Canvas, Rect.Left, Rect.Top, Index);
    end;
end;


procedure TForm1.GridBox3ClickItem(Sender: TObject; Index, Col: Integer;
          var CanSelect: Boolean);
var
  sCol: string;
begin
  // Change column values if the user click on them.
  // Only click's on columns 1 or 2 select the item and close the dropdown grid.
  if Col >= 2 then
    begin
    sCol := (Sender as TGridBox).ItemCol[Index, Col];
    if sCol = 'Bien' then
      sCol := 'Mal'
    else
      if sCol = 'Mal' then
        sCol := 'Bien'
      else
        if sCol = 'Si' then
          sCol := 'No'
        else
          if sCol = 'No' then
            sCol := 'Si'
          else
            if sCol = 'Cierto' then
              sCol := 'Falso'
            else
              if sCol = 'Falso' then
                sCol := 'Cierto';
    (Sender as TGridBox).ItemCol[Index, Col] := sCol;
    CanSelect := False;
    end;
end;

end.
