Program testregex;

{$APPTYPE CONSOLE}

Uses
  regex, SysUtils;

Type
  a_test = Record
    expected: integer;
    pattern: String;
    Data: String;
  End;

Const
  the_tests                             : Array[0..213] Of a_test =
    (
    {0}(expected: 0; pattern: '((a|b{10,11})|(b))*-\2'; Data: 'aaab-a'),
    (expected: 0; pattern: '(a)*-\1'; Data: 'aaa-a'),
    (expected: 1; pattern: '(a)*-\1b'; Data: 'aaa-b'),
    (expected: 1; pattern: '([xyz])(-\2)'; Data: 'x-y'),
    (expected: 1; pattern: '(([xyz])(-\2))'; Data: 'x-y'),
    (expected: 0; pattern: '(([xyz])(-\2)*)*'; Data: 'x-y'),
    (expected: 0; pattern: '(([xyz])(-\2)*)*'; Data: 'x-'),
    (expected: 0; pattern: '(([xyz])(-\2)*)*'; Data: 'xy-yz-y'),
    (expected: 1; pattern: '((.*)\1)+'; Data: 'xxxxxx'),
    (expected: 0; pattern: '(a*)\1\1(a*)\2\2\2'; Data: 'aaaaaa'),
    {10}(expected: 0; pattern: '(a*)(a*)\1\2'; Data: 'aaaa'),
    (expected: 0; pattern: '(a*)\1(a*)\2\2'; Data: 'aaaa'),
    (expected: 0; pattern: '(a*)\1\1(a*)'; Data: 'aaaaaa'),
    (expected: 0; pattern: '(a*)\1\1(a*)\2'; Data: 'aaaaaa'),
    (expected: 0; pattern: '(a*)\1\1(a*)\2\2'; Data: 'aaaaaa'),
    (expected: 0; pattern: '(.*)\1\1(.*)\2\2\2'; Data: 'aaaaaa'),
    (expected: 0; pattern: '(.*)\1\1(.*)\2\2\2'; Data: 'aaaaaaa'),
    (expected: 0; pattern: '(.*)\1\1(.*)\2\2\2'; Data: 'aaaaaa'),
    (expected: 0; pattern: '(.*)\1\1(.*)\2\2\2'; Data: 'aaaaaaa'),
    (expected: 0; pattern: '(.*)\1\1(.*)\2\2\2'; Data: 'aaaaa'),
    {20}(expected: 0; pattern: 'a*a*a*a*'; Data: 'aaaaaa'),
    (expected: 0; pattern: 'a*a*a*a*a*'; Data: 'aaaaaa'),
    (expected: 0; pattern: 'a*a*a*a*a*a*'; Data: 'aaaaaa'),
    (expected: 0; pattern: 'a*a*a*a*a*a*a*'; Data: 'aaaaaa'),
    (expected: 0; pattern: ''; Data: ''),
    (expected: 0; pattern: 'b{0,6}'; Data: ''),
    (expected: 1; pattern: 'ab{0,0}c'; Data: 'abc'),
    (expected: 1; pattern: 'ab{1,1}c'; Data: 'abbc'),
    (expected: 1; pattern: 'ab{3,7}c'; Data: 'abbbbbbbbc'),
    (expected: 1; pattern: 'ab{3,7}c'; Data: 'abbbbbbbbbc'),
    {30}(expected: 1; pattern: 'ab{3,7}c'; Data: 'abbbbbbbbbbc'),
    (expected: 1; pattern: 'ab{3,7}c'; Data: 'abbbbbbbbbbbc'),
    (expected: 0; pattern: 'b{2,7}'; Data: 'bb'),
    (expected: 1; pattern: 'b{1,6}'; Data: ''),
    (expected: 0; pattern: 'b{1,6}'; Data: 'b'),
    (expected: 1; pattern: 'b{2,7}'; Data: 'b'),
    (expected: 0; pattern: 'ab{0,7}c'; Data: 'ac'),
    (expected: 0; pattern: 'ab{1,7}c'; Data: 'abc'),
    (expected: 0; pattern: 'ab{2,7}c'; Data: 'abbc'),
    (expected: 0; pattern: 'ab{3,7}c'; Data: 'abbbc'),
    {40}(expected: 0; pattern: 'ab{3,7}c'; Data: 'abbbbc'),
    (expected: 0; pattern: 'ab{3,7}c'; Data: 'abbbbbc'),
    (expected: 0; pattern: 'ab{3,7}c'; Data: 'abbbbbbc'),
    (expected: 0; pattern: 'ab{3,7}c'; Data: 'abbbbbbbc'),
    (expected: 1; pattern: 'ab{3,7}c'; Data: 'abbbbbbbbc'),
    (expected: 1; pattern: 'ab{3,7}c'; Data: 'abbc'),
    (expected: 1; pattern: 'ab{3,7}c'; Data: 'abc'),
    (expected: 1; pattern: '[]][[.].]][[.right-square-bracket.]]	a]]]'; Data: 'foo'),
    (expected: 0; pattern: 'a*a*'; Data: 'aaaaaa'),
    (expected: 0; pattern: 'a*a*a*'; Data: 'aaaaaa'),
    {50}(expected: 0; pattern: '(.*)\1\1'; Data: 'aaa'),
    (expected: 0; pattern: '(a|b)*c|(a|ab)*c'; Data: 'xc'),
    (expected: 0; pattern: '(a)*'; Data: 'b'),
    (expected: 0; pattern: '(..)*(...)*'; Data: 'a'),
    (expected: 0; pattern: '(..)*(...)*'; Data: 'abc'),
    (expected: 0; pattern: '(.*)*\1'; Data: 'xx'),
    (expected: 0; pattern: '^'; Data: ''),
    (expected: 0; pattern: '$'; Data: ''),
    (expected: 0; pattern: '^$'; Data: ''),
    (expected: 0; pattern: '^a$'; Data: 'a'),
    {60}(expected: 0; pattern: 'abc'; Data: 'abc'),
    (expected: 1; pattern: 'abc'; Data: 'xbc'),
    (expected: 1; pattern: 'abc'; Data: 'axc'),
    (expected: 1; pattern: 'abc'; Data: 'abx'),
    (expected: 0; pattern: 'abc'; Data: 'xabcy'),
    (expected: 0; pattern: 'abc'; Data: 'ababc'),
    (expected: 0; pattern: 'ab*c'; Data: 'abc'),
    (expected: 0; pattern: 'ab*bc'; Data: 'abc'),
    (expected: 0; pattern: 'ab*bc'; Data: 'abbc'),
    (expected: 0; pattern: 'ab*bc'; Data: 'abbbbc'),
    {70}(expected: 0; pattern: 'ab+bc'; Data: 'abbc'),
    (expected: 1; pattern: 'ab+bc'; Data: 'abc'),
    (expected: 1; pattern: 'ab+bc'; Data: 'abq'),
    (expected: 0; pattern: 'ab+bc'; Data: 'abbbbc'),
    (expected: 0; pattern: 'ab?bc'; Data: 'abbc'),
    (expected: 0; pattern: 'ab?bc'; Data: 'abc'),
    (expected: 1; pattern: 'ab?bc'; Data: 'abbbbc'),
    (expected: 0; pattern: 'ab?c'; Data: 'abc'),
    (expected: 0; pattern: '^abc$'; Data: 'abc'),
    (expected: 1; pattern: '^abc$'; Data: 'abcc'),
    {80}(expected: 0; pattern: '^abc'; Data: 'abcc'),
    (expected: 1; pattern: '^abc$'; Data: 'aabc'),
    (expected: 0; pattern: 'abc$'; Data: 'aabc'),
    (expected: 0; pattern: '^'; Data: 'abc'),
    (expected: 0; pattern: '$'; Data: 'abc'),
    (expected: 0; pattern: 'a.c'; Data: 'abc'),
    (expected: 0; pattern: 'a.c'; Data: 'axc'),
    (expected: 0; pattern: 'a.*c'; Data: 'axyzc'),
    (expected: 1; pattern: 'a.*c'; Data: 'axyzd'),
    (expected: 1; pattern: 'a[bc]d'; Data: 'abc'),
    {90}(expected: 0; pattern: 'a[bc]d'; Data: 'abd'),
    (expected: 1; pattern: 'a[b-d]e'; Data: 'abd'),
    (expected: 0; pattern: 'a[b-d]e'; Data: 'ace'),
    (expected: 0; pattern: 'a[b-d]'; Data: 'aac'),
    (expected: 0; pattern: 'a[-b]'; Data: 'a-'),
    (expected: 0; pattern: 'a[b-]'; Data: 'a-'),
    (expected: 1; pattern: 'a[b-a]'; Data: '-'),
    (expected: 2; pattern: 'a[]b'; Data: '-'),
    (expected: 2; pattern: 'a['; Data: '-'),
    (expected: 0; pattern: 'a]'; Data: 'a]'),
    {100}(expected: 0; pattern: 'a[]]b'; Data: 'a]b'),
    (expected: 0; pattern: 'a[^bc]d'; Data: 'aed'),
    (expected: 1; pattern: 'a[^bc]d'; Data: 'abd'),
    (expected: 0; pattern: 'a[^-b]c'; Data: 'adc'),
    (expected: 1; pattern: 'a[^-b]c'; Data: 'a-c'),
    (expected: 1; pattern: 'a[^]b]c'; Data: 'a]c'),
    (expected: 0; pattern: 'a[^]b]c'; Data: 'adc'),
    (expected: 0; pattern: 'ab|cd'; Data: 'abc'),
    (expected: 0; pattern: 'ab|cd'; Data: 'abcd'),
    (expected: 0; pattern: '()ef'; Data: 'def'),
    {110}(expected: 0; pattern: '()*'; Data: '-'),
    (expected: 1; pattern: '*a'; Data: '-'),
    (expected: 0; pattern: '^*'; Data: '-'),
    (expected: 0; pattern: '$*'; Data: '-'),
    (expected: 1; pattern: '(*)b'; Data: '-'),
    (expected: 1; pattern: '$b'; Data: 'b'),
    (expected: 2; pattern: 'a\'; Data: '-'),
    (expected: 0; pattern: 'a\(b'; Data: 'a(b'),
    (expected: 0; pattern: 'a\(*b'; Data: 'ab'),
    (expected: 0; pattern: 'a\(*b'; Data: 'a((b'),
    {120}(expected: 1; pattern: 'a\x'; Data: 'a\x'),
    (expected: 1; pattern: 'abc)'; Data: '-'),
    (expected: 2; pattern: '(abc'; Data: '-'),
    (expected: 0; pattern: '((a))'; Data: 'abc'),
    (expected: 0; pattern: '(a)b(c)'; Data: 'abc'),
    (expected: 0; pattern: 'a+b+c'; Data: 'aabbabc'),
    (expected: 0; pattern: 'a**'; Data: '-'),
    (expected: 0; pattern: 'a*?'; Data: '-'),
    (expected: 0; pattern: '(a*)*'; Data: '-'),
    (expected: 0; pattern: '(a*)+'; Data: '-'),
    {130}(expected: 0; pattern: '(a|)*'; Data: '-'),
    (expected: 0; pattern: '(a*|b)*'; Data: '-'),
    (expected: 0; pattern: '(a+|b)*'; Data: 'ab'),
    (expected: 0; pattern: '(a+|b)+'; Data: 'ab'),
    (expected: 0; pattern: '(a+|b)?'; Data: 'ab'),
    (expected: 0; pattern: '[^ab]*'; Data: 'cde'),
    (expected: 0; pattern: '(^)*'; Data: '-'),
    (expected: 0; pattern: '(ab|)*'; Data: '-'),
    (expected: 2; pattern: ')('; Data: '-'),
    (expected: 1; pattern: 'abc'; Data: ''),
    {140}(expected: 1; pattern: 'abc'; Data: ''),
    (expected: 0; pattern: 'a*'; Data: ''),
    (expected: 0; pattern: '([abc])*d'; Data: 'abbbcd'),
    (expected: 0; pattern: '([abc])*bcd'; Data: 'abcd'),
    (expected: 0; pattern: 'a|b|c|d|e'; Data: 'e'),
    (expected: 0; pattern: '(a|b|c|d|e)f'; Data: 'ef'),
    (expected: 0; pattern: '((a*|b))*'; Data: '-'),
    (expected: 0; pattern: 'abcd*efg'; Data: 'abcdefg'),
    (expected: 0; pattern: 'ab*'; Data: 'xabyabbbz'),
    (expected: 0; pattern: 'ab*'; Data: 'xayabbbz'),
    {150}(expected: 0; pattern: '(ab|cd)e'; Data: 'abcde'),
    (expected: 0; pattern: '[abhgefdc]ij'; Data: 'hij'),
    (expected: 1; pattern: '^(ab|cd)e'; Data: 'abcde'),
    (expected: 0; pattern: '(abc|)ef'; Data: 'abcdef'),
    (expected: 0; pattern: '(a|b)c*d'; Data: 'abcd'),
    (expected: 0; pattern: '(ab|ab*)bc'; Data: 'abc'),
    (expected: 0; pattern: 'a([bc]*)c*'; Data: 'abc'),
    (expected: 0; pattern: 'a([bc]*)(c*d)'; Data: 'abcd'),
    (expected: 0; pattern: 'a([bc]+)(c*d)'; Data: 'abcd'),
    (expected: 0; pattern: 'a([bc]*)(c+d)'; Data: 'abcd'),
    {160}(expected: 0; pattern: 'a[bcd]*dcdcde'; Data: 'adcdcde'),
    (expected: 1; pattern: 'a[bcd]+dcdcde'; Data: 'adcdcde'),
    (expected: 0; pattern: '(ab|a)b*c'; Data: 'abc'),
    (expected: 0; pattern: '((a)(b)c)(d)'; Data: 'abcd'),
    (expected: 0; pattern: '[A-Za-z_][A-Za-z0-9_]*'; Data: 'alpha'),
    (expected: 0; pattern: '^a(bc+|b[eh])g|.h$'; Data: 'abh'),
    (expected: 0; pattern: '(bc+d$|ef*g.|h?i(j|k))'; Data: 'effgz'),
    (expected: 0; pattern: '(bc+d$|ef*g.|h?i(j|k))'; Data: 'ij'),
    (expected: 1; pattern: '(bc+d$|ef*g.|h?i(j|k))'; Data: 'effg'),
    (expected: 1; pattern: '(bc+d$|ef*g.|h?i(j|k))'; Data: 'bcdd'),
    {170}(expected: 0; pattern: '(bc+d$|ef*g.|h?i(j|k))'; Data: 'reffgz'),
    (expected: 1; pattern: '((((((((((a))))))))))'; Data: '-'),
    (expected: 0; pattern: '(((((((((a)))))))))'; Data: 'a'),
    (expected: 1; pattern: 'multiple words of text'; Data: 'uh-uh'),
    (expected: 0; pattern: 'multiple words'; Data: 'multiple words, yeah'),
    (expected: 0; pattern: '(.*)c(.*)'; Data: 'abcde'),
    (expected: 1; pattern: '\((.*),'; Data: '(.*)\)'),
    (expected: 1; pattern: '[k]'; Data: 'ab'),
    (expected: 0; pattern: 'abcd'; Data: 'abcd'),
    (expected: 0; pattern: 'a(bc)d'; Data: 'abcd'),
    {180}(expected: 0; pattern: 'a[ - ]?c'; Data: 'a c'),
    (expected: 0; pattern: '(....).*\1'; Data: 'beriberi'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Muammar Qaddafi'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Mo''ammar Gadhafi'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Muammar Kaddafi'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Muammar Qadhafi'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Moammar El Kadhafi'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Muammar Gadafi'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Mu''ammar al-Qadafi'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Moamer El Kazzafi'),
    {190}(expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Moamar al-Gaddafi'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Mu''ammar Al Qathafi'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Muammar Al Qathafi'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Mo''ammar el-Gadhafi'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Moamar El Kadhafi'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Muammar al-Qadhafi'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Mu''ammar al-Qadhdhafi'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Mu''ammar Qadafi'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Moamar Gaddafi'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Mu''ammar Qadhdhafi'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Muammar Khaddafi'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Muammar al-Khaddafi'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Mu''amar al-Kadafi'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Muammar Ghaddafy'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Muammar Ghadafi'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Muammar Ghaddafi'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Muamar Kaddafi'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Muammar Quathafi'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Muammar Gheddafi'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Muamar Al-Kaddafi'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Moammar Khadafy '),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Moammar Qudhafi'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Mu''ammar al-Qaddafi'),
    (expected: 0; pattern: 'M[ou]''?am+[ae]r .*([AEae]l[- ])?[GKQ]h?[aeu]+([dtz][dhz]?)+af[iy]'; Data: 'Mulazim Awwal Mu''ammar Muhammad Abu Minyar al-Qadhafi')
    );

Var
  last_pattern                          : String = '';
  r                                     : regex_t;

Procedure run_a_test_posix(id: integer; t: a_test);
Var
  err                                   : integer;
  errmsg                                : Array[0..100] Of char;
  x                                     : integer;
  regs                                  : Array[0..9] Of regmatch_t;
Begin
  If (last_pattern = '') Or (CompareStr(last_pattern, t.pattern) <> 0) Then
  Begin
    If last_pattern <> '' Then
    Begin
      regfree(r);
      last_pattern := '';
    End;
    err := regcomp(r, pchar(t.pattern), REG_EXTENDED);
    If err <> 0 Then
    Begin
      If t.expected <> 0 Then
        exit;
      regerror(err, r, errmsg, 100);
      Write('test ', id, ' error: ');
      writeln(errmsg);
      exit;
    End;
  End;
  last_pattern := t.pattern;

  err := regexec(r, pchar(t.Data), 10, @regs, 0);

  If (err <> t.expected) Then
  Begin
    regerror(err, r, errmsg, 100);
    writeln(format('### test %d', [id]));
    writeln(format('### pattern "%s" Data "%s" wanted %d got %s',
      [t.pattern, t.Data, t.expected, errmsg]));
    For x := 0 To 9 Do
    Begin
      writeln(format('### reg %d == (%d, %d)%d. * s\n',
        [x,
        regs[x].rm_so,
          regs[x].rm_eo,
          regs[x].rm_eo - regs[x].rm_so,
          Copy(t.Data, regs[x].rm_so, regs[x].rm_eo - regs[x].rm_so)]));
    End;
  End;
End;

Procedure run_a_test_gnu(id: integer; t: a_test);
Var
  err                                   : integer;
  errm                                  : pchar;
  errmsg                                : Array[0..100] Of char;
  x                                     : integer;
  regs                                  : re_registers;
Begin
  Try
    FillChar(regs, SizeOf(regs), 0);
    If (last_pattern = '') Or (CompareStr(last_pattern, t.pattern) <> 0) Then
    Begin
      If last_pattern <> '' Then
      Begin
        regfree(r);
        last_pattern := '';
      End;
      errm := re_compile_pattern(pchar(t.pattern), Length(t.pattern), r);
      If errm <> Nil Then
      Begin
        If t.expected <> 0 Then
          exit;
        Write('test ', id, ' error: ');
        writeln(errm);
        exit;
      End;
    End;
    last_pattern := t.pattern;

    err := re_search(r, pchar(t.Data), Length(t.Data), 0, Length(t.Data), regs);

    // a dirty hack

    If err > 0 Then err := 0;
    err := -err;

    If (err <> t.expected) Then
    Begin
      regerror(err, r, errmsg, 100);
      writeln(format('### test %d', [id]));
      writeln(format('### pattern "%s" Data "%s" wanted %d got %s',
        [t.pattern, t.Data, t.expected, errmsg]));
      For x := 0 To regs.num_regs - 1 Do
      Begin
        writeln(format('### reg %d == (%d, %d)%d. * s\n',
          [x,
          regs.pstart^[x],
            regs.pend^[x],
            regs.pend^[x] - regs.pstart^[x],
            Copy(t.Data, regs.pstart^[x], regs.pend^[x] - regs.pstart^[x])]));
      End;
    End;
  Finally
    If regs.pstart <> Nil Then FreeMem(regs.pstart);
    If regs.pend <> Nil Then FreeMem(regs.pend);
  End;
End;

Var
  i                                     : integer;

Begin
  writeln('*** Testing unit regex ***');
  writeln('*** first test the POSIX functions ***');
  For i := low(the_tests) To High(the_tests) Do
  Begin
    writeln('#', i);
    run_a_test_posix(i, the_tests[i]);
  End;
  writeln('*** and now the GNU functions ***');
  re_set_syntax(RE_SYNTAX_POSIX_EXTENDED);
  For i := low(the_tests) To High(the_tests) Do
  Begin
    writeln('#', i);
    run_a_test_gnu(i, the_tests[i]);
  End;
  writeln('*** Testing unit regex was successful ***');
End.

