Unit regex;

{
   Translation to Delphi by Daniel Biehl dbiehl@gmx.de

   Definitions for data structures and routines for the regular
   expression library, version 0.12.
   Copyright (C) 1985,89,90,91,92,93,95,96,97 Free Software Foundation, Inc.

   NOTE: The canonical source of this file is maintained with the GNU C Library.
   Bugs can be reported to bug-glibc@prep.ai.mit.edu.

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any
   later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
   USA.  }

Interface

Type

  { The following two types have to be signed and unsigned integer type
     wide enough to hold a value of a pointer.  For most ANSI compilers
     ptrdiff_t and size_t should be likely OK.  Still size of these two
     types is 2 for Microsoft C.  Ugh... }

  s_reg_t = longint;
  active_reg_t = longword;

  { The following bits are used to determine the regexp syntax we
     recognize.  The set/not-set meanings are chosen so that Emacs syntax
     remains the value 0.  The bits are given in alphabetical order, and
     the definitions shifted by one from the previous bit; thus, when we
     add or remove a bit, only one other definition need change.  }

  reg_syntax_t = longword;

Const
  { If this bit is not set, then \ inside a bracket expression is literal.
     If set, then such a \ quotes the following character.  }

  RE_BACKSLASH_ESCAPE_IN_LISTS {: loginword } = 1;

  { If this bit is not set, then + and ? are operators, and \+ and \? are
       literals.
     If set, then \+ and \? are operators and + and ? are literals.  }

  RE_BK_PLUS_QM                         = RE_BACKSLASH_ESCAPE_IN_LISTS Shl 1;

  { If this bit is set, then character classes are supported.  They are:
       [:alpha:], [:upper:], [:lower:],  [:digit:], [:alnum:], [:xdigit:],
       [:space:], [:print:], [:punct:], [:graph:], and [:cntrl:].
     If not set, then character classes are not supported.  }

  RE_CHAR_CLASSES                       = (RE_BK_PLUS_QM Shl 1);

  { If this bit is set, then ^ and $ are always anchors (outside bracket
       expressions, of course).
     If this bit is not set, then it depends:
          ^  is an anchor if it is at the beginning of a regular
             expression or after an open-group or an alternation operator;
          $  is an anchor if it is at the end of a regular expression, or
             before a close-group or an alternation operator.

     This bit could be (re)combined with RE_CONTEXT_INDEP_OPS, because
     POSIX draft 11.2 says that * etc. in leading positions is undefined.
     We already implemented a previous draft which made those constructs
     invalid, though, so we haven't changed the code back.  }

  RE_CONTEXT_INDEP_ANCHORS              = (RE_CHAR_CLASSES Shl 1);

  { If this bit is set, then special characters are always special
       regardless of where they are in the pattern.
     If this bit is not set, then special characters are special only in
       some contexts; otherwise they are ordinary.  Specifically,
       * + ? and intervals are only special when not after the beginning,
       open-group, or alternation operator.  }

  RE_CONTEXT_INDEP_OPS                  = (RE_CONTEXT_INDEP_ANCHORS Shl 1);

  { If this bit is set, then *, +, ?, and { cannot be first in an re or
       immediately after an alternation or begin-group operator.  }

  RE_CONTEXT_INVALID_OPS                = (RE_CONTEXT_INDEP_OPS Shl 1);

  { If this bit is set, then . matches newline.
     If not set, then it doesn't.  }

  RE_DOT_NEWLINE                        = (RE_CONTEXT_INVALID_OPS Shl 1);

  { If this bit is set, then . doesn't match NUL.
     If not set, then it does.  }
  RE_DOT_NOT_NULL                       = (RE_DOT_NEWLINE Shl 1);

  { If this bit is set, nonmatching lists [^...] do not match newline.
     If not set, they do.  }
  RE_HAT_LISTS_NOT_NEWLINE              = (RE_DOT_NOT_NULL Shl 1);

  (* If this bit is set, either \{...\} or {...} defines an
       interval, depending on RE_NO_BK_BRACES.
     If not set, \{, \}, {, and } are literals.  *)
  RE_INTERVALS                          = (RE_HAT_LISTS_NOT_NEWLINE Shl 1);

  { If this bit is set, +, ? and | aren't recognized as operators.
     If not set, they are.  }
  RE_LIMITED_OPS                        = (RE_INTERVALS Shl 1);

  { If this bit is set, newline is an alternation operator.
     If not set, newline is literal.  }
  RE_NEWLINE_ALT                        = (RE_LIMITED_OPS Shl 1);

  (* If this bit is set, then `{...}' defines an interval, and \{ and \}
       are literals.
    If not set, then `\{...\}' defines an interval.  *)
  RE_NO_BK_BRACES                       = (RE_NEWLINE_ALT Shl 1);

  { If this bit is set, (...) defines a group, and \( and \) are literals.
     If not set, \(...\) defines a group, and ( and ) are literals.  }
  RE_NO_BK_PARENS                       = (RE_NO_BK_BRACES Shl 1);

  { If this bit is set, then \<digit> matches <digit>.
     If not set, then \<digit> is a back-reference.  }
  RE_NO_BK_REFS                         = (RE_NO_BK_PARENS Shl 1);

  { If this bit is set, then | is an alternation operator, and \| is literal.
     If not set, then \| is an alternation operator, and | is literal.  }
  RE_NO_BK_VBAR                         = (RE_NO_BK_REFS Shl 1);

  { If this bit is set, then an ending range point collating higher
       than the starting range point, as in [z-a], is invalid.
     If not set, then when ending range point collates higher than the
       starting range point, the range is ignored.  }
  RE_NO_EMPTY_RANGES                    = (RE_NO_BK_VBAR Shl 1);

  { If this bit is set, then an unmatched ) is ordinary.
     If not set, then an unmatched ) is invalid.  }
  RE_UNMATCHED_RIGHT_PAREN_ORD          = (RE_NO_EMPTY_RANGES Shl 1);

  { If this bit is set, succeed as soon as we match the whole pattern,
     without further backtracking.  }
  RE_NO_POSIX_BACKTRACKING              = (RE_UNMATCHED_RIGHT_PAREN_ORD Shl 1);

  { If this bit is set, do not process the GNU regex operators.
     If not set, then the GNU regex operators are recognized. }
  RE_NO_GNU_OPS                         = (RE_NO_POSIX_BACKTRACKING Shl 1);

  { If this bit is set, turn on internal regex debugging.
     If not set, and debugging was on, turn it off.
     This only works if regex.c is compiled -DDEBUG.
     We define this bit always, so that all that's needed to turn on
     debugging is to recompile regex.c; the calling code can always have
     this bit set, and it won't affect anything in the normal case. }
  RE_DEBUG                              = (RE_NO_GNU_OPS Shl 1);

Var
  { This global variable defines the particular regexp syntax to use (for
     some interfaces).  When a regexp is compiled, the syntax used is
     stored in the pattern buffer, so changing this does not affect
     already-compiled regexps.  }
  re_syntax_options                     : reg_syntax_t;

Const
  { Syntax bits common to both basic and extended POSIX regex syntax.  }

  _RE_SYNTAX_POSIX_COMMON               =
    (RE_CHAR_CLASSES Or RE_DOT_NEWLINE Or RE_DOT_NOT_NULL
    Or RE_INTERVALS Or RE_NO_EMPTY_RANGES);

  RE_SYNTAX_POSIX_BASIC                 =
    (_RE_SYNTAX_POSIX_COMMON Or RE_BK_PLUS_QM);

  { Differs from ..._POSIX_BASIC only in that RE_BK_PLUS_QM becomes
     RE_LIMITED_OPS, i.e., \? \+ \| are not recognized.  Actually, this
     isn't minimal, since other operators, such as \`, aren't disabled.  }

  RE_SYNTAX_POSIX_MINIMAL_BASIC         =
    (_RE_SYNTAX_POSIX_COMMON Or RE_LIMITED_OPS);

  RE_SYNTAX_POSIX_EXTENDED              =
    (_RE_SYNTAX_POSIX_COMMON Or RE_CONTEXT_INDEP_ANCHORS
    Or RE_CONTEXT_INDEP_OPS Or RE_NO_BK_BRACES
    Or RE_NO_BK_PARENS Or RE_NO_BK_VBAR
    Or RE_UNMATCHED_RIGHT_PAREN_ORD);

  { Differs from ..._POSIX_EXTENDED in that RE_CONTEXT_INVALID_OPS
     replaces RE_CONTEXT_INDEP_OPS and RE_NO_BK_REFS is added.  }

  RE_SYNTAX_POSIX_MINIMAL_EXTENDED      =
    (_RE_SYNTAX_POSIX_COMMON Or RE_CONTEXT_INDEP_ANCHORS
    Or RE_CONTEXT_INVALID_OPS Or RE_NO_BK_BRACES
    Or RE_NO_BK_PARENS Or RE_NO_BK_REFS
    Or RE_NO_BK_VBAR Or RE_UNMATCHED_RIGHT_PAREN_ORD);

  { Define combinations of the above bits for the standard possibilities.
     (The [[[ comments delimit what gets put into the Texinfo file, so
     don't delete them!)  }
  { [[[begin syntaxes]]] }

  RE_SYNTAX_EMACS                       = 0;

  RE_SYNTAX_AWK                         =
    (RE_BACKSLASH_ESCAPE_IN_LISTS Or RE_DOT_NOT_NULL
    Or RE_NO_BK_PARENS Or RE_NO_BK_REFS
    Or RE_NO_BK_VBAR Or RE_NO_EMPTY_RANGES
    Or RE_DOT_NEWLINE Or RE_CONTEXT_INDEP_ANCHORS
    Or RE_UNMATCHED_RIGHT_PAREN_ORD Or RE_NO_GNU_OPS);

  RE_SYNTAX_GNU_AWK                     =
    ((RE_SYNTAX_POSIX_EXTENDED Or RE_BACKSLASH_ESCAPE_IN_LISTS Or RE_DEBUG)
    And Not (RE_DOT_NOT_NULL Or RE_INTERVALS Or RE_CONTEXT_INDEP_OPS));

  RE_SYNTAX_POSIX_AWK                   =
    (RE_SYNTAX_POSIX_EXTENDED Or RE_BACKSLASH_ESCAPE_IN_LISTS
    Or RE_INTERVALS Or RE_NO_GNU_OPS);

  RE_SYNTAX_GREP                        =
    (RE_BK_PLUS_QM Or RE_CHAR_CLASSES
    Or RE_HAT_LISTS_NOT_NEWLINE Or RE_INTERVALS
    Or RE_NEWLINE_ALT);

  RE_SYNTAX_EGREP                       =
    (RE_CHAR_CLASSES Or RE_CONTEXT_INDEP_ANCHORS
    Or RE_CONTEXT_INDEP_OPS Or RE_HAT_LISTS_NOT_NEWLINE
    Or RE_NEWLINE_ALT Or RE_NO_BK_PARENS
    Or RE_NO_BK_VBAR);

  RE_SYNTAX_POSIX_EGREP                 =
    (RE_SYNTAX_EGREP Or RE_INTERVALS Or RE_NO_BK_BRACES);

  { P1003.2/D11.2, section 4.20.7.1, lines 5078ff.  }

  RE_SYNTAX_ED                          = RE_SYNTAX_POSIX_BASIC;

  RE_SYNTAX_SED                         = RE_SYNTAX_POSIX_BASIC;

  { [[[end syntaxes]]] }

  { Maximum number of duplicates an interval can allow.  Some systems
     (erroneously) define this in other header files, but we want our
     value, so remove any previous define.  }
  { If sizeof(int) == 2, then ((1 << 15) - 1) overflows.  }

  RE_DUP_MAX                            = ($7FFF);

  { POSIX `cflags' bits (i.e., information for `regcomp').  }

  { If this bit is set, then use extended regular expression syntax.
     If not set, then use basic regular expression syntax.  }

  REG_EXTENDED                          = 1;

  { If this bit is set, then ignore case when matching.
     If not set, then case is significant.  }

  REG_ICASE                             = (REG_EXTENDED Shl 1);

  { If this bit is set, then anchors do not match at newline
       characters in the string.
     If not set, then anchors do match at newlines.  }

  REG_NEWLINE                           = (REG_ICASE Shl 1);

  { If this bit is set, then report only success or fail in regexec.
     If not set, then returns differ between not matching and errors.  }

  REG_NOSUB                             = (REG_NEWLINE Shl 1);

  { POSIX `eflags' bits (i.e., information for regexec).  }

  { If this bit is set, then the beginning-of-line operator doesn't match
       the beginning of the string (presumably because it's not the
       beginning of a line).
     If not set, then the beginning-of-line operator does match the
       beginning of the string.  }
  REG_NOTBOL                            = 1;

  { Like REG_NOTBOL, except for the end-of-line.  }
  REG_NOTEOL                            = (1 Shl 1);

  { If any error codes are removed, changed, or added, update the
     `re_error_msg' table in regex.c.  }

  REG_NOERROR                           = 0; { Success.  }
  REG_NOMATCH                           = 1; { Didn't find a match (for regexec).  */

  { POSIX regcomp return error codes.  (In the order listed in the
     standard.)  }
  REG_BADPAT                            = 2; { Invalid pattern.  }
  REG_ECOLLATE                          = 3; { Not implemented.  }
  REG_ECTYPE                            = 4; { Invalid character class name.  }
  REG_EESCAPE                           = 5; { Trailing backslash.  }
  REG_ESUBREG                           = 6; { Invalid back reference.  }
  REG_EBRACK                            = 7; { Unmatched left bracket.  }
  REG_EPAREN                            = 8; { Parenthesis imbalance.  }
  REG_EBRACE                            = 9; { Unmatched \{.  }
  REG_BADBR                             = 10; (* Invalid contents of \{\}.*)
  REG_ERANGE                            = 11; { Invalid range end.  }
  REG_ESPACE                            = 12; { Ran out of memory.  }
  REG_BADRPT                            = 13; { No preceding re for repetition op.  }

  { Error codes we've added.  }
  REG_EEND                              = 14; { Premature end.  }
  REG_ESIZE                             = 15; { Compiled pattern bigger than 2^16 bytes.  }
  REG_ERPAREN                           = 16; { Unmatched ) or \); not returned from regcomp.  }

  { Constants to emulate the bitfields of C/C++.
    In Delphi must use you re_pattern_buffer.bits and a combination of these constants
    instead of the C fields can_be_null, reg_allocated ...}

  REGS_CAN_BE_NULL                      = 1;
  REGS_UNALLOCATED                      = 2;
  REGS_REALLOCATE                       = 4;
  REGS_FIXED                            = 6;
  REGS_FASTMAP_ACCURATE                 = 8;
  REGS_NO_SUB                           = REGS_FASTMAP_ACCURATE Shl 1;
  REGS_NOT_BOL                          = REGS_NO_SUB Shl 1;
  REGS_NOT_EOL                          = REGS_NOT_BOL Shl 1;
  REGS_NEWLINE_ANCHOR                   = REGS_NOT_EOL Shl 1;

Type

  RE_TRANSLATE_TYPE = pchar;

  { This data structure represents a compiled pattern.  Before calling
     the pattern compiler, the fields `buffer', `allocated', `fastmap',
     `translate', and `no_sub' can be set.  After the pattern has been
     compiled, the `re_nsub' field is available.  All other fields are
     private to the regex routines.  }

  re_pattern_buffer = Packed Record

    { [[[begin pattern_buffer]]] }
    { Space that holds the compiled pattern.  It is declared as
      `unsigned char *' because its elements are
       sometimes used as array indexes.  }
    Buffer: pchar;

    { Number of bytes to which `buffer' points.  }
    allocated: longword;

    { Number of bytes actually used in `buffer'.  }
    used: longword;

    { Syntax setting with which the pattern was compiled.  }
    syntax: reg_syntax_t;

    { Pointer to a fastmap, if any, otherwise zero.  re_search uses
       the fastmap, if there is one, to skip over impossible
       starting points for matches.  }
    fastmap: pchar;

    { Either a translate table to apply to all characters before
       comparing them, or zero for no translation.  The translation
       is applied to a pattern when it is compiled and to a string
       when it is matched.  }
    translate: RE_TRANSLATE_TYPE;

    { Number of subexpressions found by the compiler.  }
    re_nsub: longword;

    bits: longword;
    { Zero if this pattern cannot match the empty string, one else.
       Well, in truth it's used only in `re_search_2', to see
       whether or not we should use the fastmap, so we don't set
       this absolutely perfectly; see `re_compile_fastmap' (the
       `duplicate' case).  }
   (* can_be_null: longword {=1 };*)

    { If REGS_UNALLOCATED, allocate space in the `regs' structure
         for `max (RE_NREGS, re_nsub + 1)' groups.
       If REGS_REALLOCATE, reallocate space if necessary.
       If REGS_FIXED, use what's there.  }
   (* regs_allocated: longword {=2}; *)

    { Set to zero when `regex_compile' compiles a pattern; set to one
       by `re_compile_fastmap' if it updates the fastmap.  }
   (* fastmap_accurate: longword {=1};*)

    { If set, `re_match_2' does not return information about
       subexpressions.  }
   (* no_sub: longword {=1};*)

    { If set, a beginning-of-line anchor doesn't match at the
       beginning of the string.  }
   (* not_bol: longword {=1};*)

    { Similarly for an end-of-line anchor.  }
   (* not_eol: longword {=1};*)

    { If true, an anchor at a newline matches.  }
   (* newline_anchor: longword {=1};*)

    { [[[end pattern_buffer]]] }
  End;

  pregex_t = ^regex_t;
  regex_t = re_pattern_buffer;

  { Type for byte offsets within the string.  POSIX mandates this.  }

  pregoff_t = ^regoff_t;
  regoff_t = integer;

  { Delphi construct for an open array of regoff_t to use with re_registers }

  pregoff_a = ^regoff_a;
  regoff_a = Array[0..0] Of regoff_t;

  { This is the structure we store register match data in.  See
     regex.texinfo for a full description of what registers match.  }

  re_registers = Packed Record
    num_regs: longword;
    pstart: pregoff_a;
    pend: pregoff_a;
  End;

Const
  { If `regs_allocated' is REGS_UNALLOCATED in the pattern buffer,
     `re_match_2' returns information about at least this many registers
     the first time a `regs' structure is passed.  }

  RE_NREGS                              = 30;

Type
  { POSIX specification for registers.  Aside from the different names than
     `re_registers', POSIX uses an array of structures, instead of a
     structure of arrays.  }
  pregmatch_t = ^regmatch_t;
  regmatch_t = Packed Record
    rm_so: regoff_t; { Byte offset from string's start to substring's start.  }
    rm_eo: regoff_t; {byte Offset from String 's start to substring' s End.}
  End;

  { Declarations for routines. }

  { Sets the current default syntax to SYNTAX, and return the old syntax.
     You can also simply assign to the `re_syntax_options' variable.  }
Function re_set_syntax(syntax: reg_syntax_t): reg_syntax_t;
// TODO: 1 re_get_syntax

{ Compile the regular expression PATTERN, with length LENGTH
   and syntax given by the global `re_syntax_options', into the buffer
   BUFFER.  Return NULL if successful, and an error string if not.  }
Function re_compile_pattern(Const pattern: pchar; Length: longword; Var Buffer: re_pattern_buffer): pchar;

{ Compile a fastmap for the compiled pattern in BUFFER; used to
   accelerate searches.  Return 0 if successful and -2 if was an
   internal error.  }
Function re_compile_fastmap(Var Buffer: re_pattern_buffer): integer;

{ Search in the string STRING (with length LENGTH) for the pattern
   compiled into BUFFER.  Start searching at position START, for RANGE
   characters.  Return the starting position of the match, -1 for no
   match, or -2 for an internal error.  Also return register
   information in REGS (if REGS and BUFFER->no_sub are nonzero).  }
Function re_search(Var Buffer: re_pattern_buffer; Const Str: pchar;
  Length: integer; Start: integer; Range: integer; Var regs: re_registers): integer;

{ Like `re_search', but search in the concatenation of STRING1 and
   STRING2.  Also, stop searching at index START + STOP.  }
Function re_search_2(Var Buffer: re_pattern_buffer; Const string1: pchar;
  length1: integer; Const string2: pchar; length2: integer;
  Start: integer; Range: integer; Var regs: re_registers; Stop: integer): integer;

{ Like `re_search', but return how many characters in STRING the regexp
   in BUFFER matched, starting at position START.  }
Function re_match(Var Buffer: re_pattern_buffer; Const Str: pchar;
  Length: integer; Start: integer; Var regs: re_registers): integer;

{ Relates to `re_match' as `re_search_2' relates to `re_search'.  }
Function re_match_2(Var Buffer: re_pattern_buffer; Const string1: pchar;
  length1: integer; Const string2: pchar; length2: integer;
  Start: integer; Var regs: re_registers; Stop: integer): integer;

{ Set REGS to hold NUM_REGS registers, storing them in STARTS and
   ENDS.  Subsequent matches using BUFFER and REGS will use this memory
   for recording register information.  STARTS and ENDS must be
   allocated with malloc, and must each be at least `NUM_REGS * sizeof
   (regoff_t)' bytes long.

   If NUM_REGS == 0, then subsequent matches should allocate their own
   register data.

   Unless this function is called, the first search or match using
   PATTERN_BUFFER will allocate its own register data, without
   freeing the old data.  }
Procedure re_set_registers(Var Buffer: re_pattern_buffer; Var regs: re_registers;
  num_regs: longword; Var starts: regoff_t; Var ends: regoff_t);

{ POSIX compatibility. }
Function regcomp(Var preg: regex_t; Const pattern: pchar; cflags: integer): integer;
Function regexec(Var preg: regex_t; Const Str: pchar; nmatch: longword; pmatch: pregmatch_t; eflags: integer): integer;
Function regerror(errcode: integer; Var preg: regex_t; errbuf: pchar; errbuf_size: longword): longword;
Procedure regfree(Var preg: regex_t);

Implementation

Uses SysUtils;

// Delphi styled C funktions needed for regex.obj

Function _malloc(Size: integer): pointer; cdecl;
Begin
  GetMem(Result, Size);
End;

Procedure _free(p: pointer); cdecl;
Begin
  FreeMem(p);
End;

Procedure _memset(p: pointer; b: byte; Count: integer); cdecl;
Begin
  FillChar(p^, Count, b);
End;

Procedure _memcpy(Dest, Source: pointer; Count: integer); cdecl;
Begin
  Move(Source^, Dest^, Count);
End;

Function _realloc(memblock: pointer; Size: integer): pointer; cdecl;
Begin
  ReallocMem(memblock, Size);
  Result := memblock;
End;

Function _memcmp(Const buf1: pointer; Const buf2: pointer; Size: integer): integer; cdecl;
Begin
  Result := strlcomp(buf1, buf2, Size);
End;

Function _isalnum(c: integer): integer; cdecl;
Begin
  Result := integer(char(c) In ['a'..'z', 'A'..'Z', '0'..'9']);
End;

Function _isalpha(c: integer): integer; cdecl;
Begin
  Result := integer(char(c) In ['a'..'z', 'A'..'Z']);
End;

Function _iscntrl(c: integer): integer; cdecl;
Begin
  Result := integer(char(c) In [#$0..#$1F, #$7F]);
End;

Function _isdigit(c: integer): integer; cdecl;
Begin
  Result := integer(char(c) In ['0'..'9']);
End;

Function _isprint(c: integer): integer; cdecl;
Begin
  Result := integer(char(c) In [#$20..#$7E]);
End;

Function _isspace(c: integer): integer; cdecl;
Begin
  Result := integer(char(c) In [#$09..#$0D, #$20]);
End;

Function _islower(c: integer): integer; cdecl;
Begin
  Result := integer(char(c) In ['a'..'z']);
End;

Function _isupper(c: integer): integer; cdecl;
Begin
  Result := integer(char(c) In ['A'..'Z']);
End;

Function _ispunct(c: integer): integer; cdecl;
Begin
  Result := integer(Not _isspace(c) Or Not _isalnum(c));
End;

Function _isxdigit(c: integer): integer; cdecl;
Begin
  Result := integer(char(c) In ['A'..'F', 'a'..'f', '0'..'9']);
End;

Procedure _abort; cdecl;
Begin
  Abort;
End;

Function _strlen(Const Str: pchar): integer; cdecl;
Begin
  Result := strLen(Str);
End;

{$L regex.obj}

Function re_set_syntax; external;
Function re_compile_pattern; external;
Function re_compile_fastmap; external;
Function re_search; external;
Function re_search_2; external;
Function re_match; external;
Function re_match_2; external;
Procedure re_set_registers; external;
Function regcomp; external;
Function regexec; external;
Function regerror; external;
Procedure regfree; external;

End.

