/////////////////////////////////////////////////////////////////////////
// Industrial Software Solutions
// 4205 Hideaway
// Arlington, Texas 76017
// Mitchell E. James
// May 18, 1996
// mjames@cyberhighway.net
// http://www.cyberhighway.net/~mjames/

unit GLUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ComCtrls, Gl, Glu, StdCtrls, GLPanel;
const
  DRAWCUBE = 1;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    Timer1: TTimer;
    TrackBar1: TTrackBar;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    GLPanel1: TGLPanel;
    procedure GLPanel1GLDraw(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure GLPanel1GLInit(Sender: TObject);
    procedure GLPanel1GLPrep(Sender: TObject);
    procedure SetProjection(Sender: TObject);
  private
    { Private declarations }
    Angle: GLfloat;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.GLPanel1GLDraw(Sender: TObject);
var
  i, j, k: GLdouble;

begin
  //
  // Clear the color and depth buffers.
  //
  glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);

  //
  // Define the modelview transformation.
  //
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity;
  glTranslatef(0.0, 0.0, -32.0);
  glRotatef(30.0, 1.0, 0.0, 0.0);
  glRotatef(Angle, 0.0, 1.0, 0.0);

  //
  // Draw a three-dimensional array of cubes.
  //
  i := -3.0;

  while (i <= 3.0) do begin
    j := -3.0;

    while (j <= 3.0) do begin
      k := -3.0;

      while (k <= 3.0) do begin
        glPushMatrix;
        glTranslatef(i, j, k);
        glCallList(DRAWCUBE);
        glPopMatrix;
        k := k + 3.0;
      end;

      j := j + 3.0;
    end;

    i := i + 3.0;
  end;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  Angle := Angle + 2.0;

  if (Angle >= 90.0) then
    Angle := 0.0;
  Label1.Caption := FloatToStr(Timer1.Interval);
  GLPanel1.GLReDraw;
end;

procedure TForm1.TrackBar1Change(Sender: TObject);
begin
  Timer1.Interval :=  TrackBar1.Position * 10;
end;

procedure TForm1.GLPanel1GLInit(Sender: TObject);
const
  glfLightAmbient : Array[0..3] of GLfloat = (0.1, 0.1, 0.1, 1.0);
  glfLightDiffuse : Array[0..3] of GLfloat = (0.7, 0.7, 0.7, 1.0);
  glfLightSpecular: Array[0..3] of GLfloat = (0.0, 0.0, 0.0, 1.0);

begin
  //
  // Enable depth testing and backface culling.
  //
  glEnable(GL_DEPTH_TEST);
  glEnable(GL_CULL_FACE);
  Timer1.Interval :=  TrackBar1.Position * 10;

  //
  // Add a light to the scene.
  //
  glLightfv(GL_LIGHT0, GL_AMBIENT, @glfLightAmbient);
  glLightfv(GL_LIGHT0, GL_DIFFUSE, @glfLightDiffuse);
  glLightfv(GL_LIGHT0, GL_SPECULAR,@glfLightSpecular);
  glEnable(GL_LIGHTING);
  glEnable(GL_LIGHT0);
end;

procedure TForm1.SetProjection(Sender: TObject);
var
  gldAspect : GLdouble;
begin
   // Redefine the viewing volume and viewport when the window size changes.
  gldAspect := GLPanel1.Width / GLPanel1.Height;

  glMatrixMode(GL_PROJECTION);
  glLoadIdentity;
  gluPerspective(30.0,           // Field-of-view angle
                 gldAspect,      // Aspect ratio of viewing volume
                 1.0,            // Distance to near clipping plane
                 100.0);          // Distance to far clipping plane
  glViewport(0, 0, GLPanel1.Width, GLPanel1.Height);
  InvalidateRect(Handle, nil, False);

end;

procedure TForm1.GLPanel1GLPrep(Sender: TObject);
const
  glfMaterialColor: Array[0..3] of GLfloat = (0.0, 0.0, 1.0, 1.0);

begin
  glNewList(DRAWCUBE, GL_COMPILE);
    //
    // Define the reflective properties of the cube's faces.
    //
    glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, @glfMaterialColor);

    //
    // Draw the six faces of the cube.
    //
    glBegin(GL_POLYGON);
      glNormal3f(0.0, 0.0, 1.0);
      glVertex3f(1.0, 1.0, 1.0);
      glVertex3f(-1.0, 1.0, 1.0);
      glVertex3f(-1.0, -1.0, 1.0);
      glVertex3f(1.0, -1.0, 1.0);
    glEnd;

    glBegin(GL_POLYGON);
      glNormal3f(0.0, 0.0, -1.0);
      glVertex3f(1.0, 1.0, -1.0);
      glVertex3f(1.0, -1.0, -1.0);
      glVertex3f(-1.0, -1.0, -1.0);
      glVertex3f(-1.0, 1.0, -1.0);
    glEnd;

    glBegin(GL_POLYGON);
      glNormal3f(-1.0, 0.0, 0.0);
      glVertex3f(-1.0, 1.0, 1.0);
      glVertex3f(-1.0, 1.0, -1.0);
      glVertex3f(-1.0, -1.0, -1.0);
      glVertex3f(-1.0, -1.0, 1.0);
    glEnd;

    glBegin(GL_POLYGON);
      glNormal3f(1.0, 0.0, 0.0);
      glVertex3f(1.0, 1.0, 1.0);
      glVertex3f(1.0, -1.0, 1.0);
      glVertex3f(1.0, -1.0, -1.0);
      glVertex3f(1.0, 1.0, -1.0);
    glEnd;

    glBegin(GL_POLYGON);
      glNormal3f(0.0, 1.0, 0.0);
      glVertex3f(-1.0, 1.0, -1.0);
      glVertex3f(-1.0, 1.0, 1.0);
      glVertex3f(1.0, 1.0, 1.0);
      glVertex3f(1.0, 1.0, -1.0);
    glEnd;

    glBegin(GL_POLYGON);
      glNormal3f(0.0, -1.0, 0.0);
      glVertex3f(-1.0, -1.0, -1.0);
      glVertex3f(1.0, -1.0, -1.0);
      glVertex3f(1.0, -1.0, 1.0);
      glVertex3f(-1.0, -1.0, 1.0);
    glEnd;

  glEndList ();
end;

end.
