unit Moreutil;
{ Exports some general purpose routines:
ChooseString, EnterInteger, FindCommonStrings, FreeObject,
OpenIniFile, RunDOSCommand, RunProgram, ShowMessage

R.P. Sterkenburg, TNO PML Rijswijk, The Netherlands

22 Aug 95: - added ChooseString
 4 Sep 95: - added ChooseStrings
28 Aug 96: - added OpenIniFile
10 Sep 96: - added RunDosCommand
13 Nov 96: - deleted ChooseString, ChooseStrings and EnterInteger;
             they weren't used (it's too easy to make a nicer one
             when needed)
           - added FindCommonStrings
30 Dec 96: - added ShowMessage
 6 Feb 97: - added FreeObject
12 Feb 97: - made compilable under Delphi 2 too
           - renamed from MoreUtils to MoreUtil
13 Feb 97: - replaced FreeObject with the original version of the code
             that came with The Delphi Magazine, issue 18
           - improved comments and layout a little bit
10 Mar 97: - commented out the use of StrFunc
}

(*************************) interface (*************************)

uses
  Classes,         { Imports TStringlist }
  IniFiles{,        { Imports TIniFile }
  {StrFunc};         { Imports CRLF }

const
  CRLF = #13+#10;


{$ifdef ver80}
procedure ChooseString(message: String;
                       stringlist: stringlisttype;
                       var ChosenString: String);
{ Lets the user choose a string from a string list }

procedure ChooseStrings(message: String;
                        stringlist: stringlisttype;
                        var ChosenStrings: stringlisttype);
{ Lets the user choose strings from a string list }
{$endif ver80}

procedure ErStop(message: String);
{ Terminates execution of the program, giving the message 'message' }

procedure FindCommonStrings(List1, List2: TStringlist;
                            var CommonStrings: TStringlist);
{ Returns in CommonStrings the stings that are present in
both List1 and List2 }

procedure FreeObject(var o; q: TObject);
{ Frees the object that's pointed to by o AND sets o to nil, so
that it can't be Destroyed a second time (which would cause a GPF) }

function LeftStr(s: String; count: Integer): String;
{ Returns a string with the first 'count' characters of s }

procedure OpenIniFile(var Inifile: TIniFile);
{ Opens the ini file of the 'current application'.
It is assumed to be at the same location as the executable }

procedure RunDosCommand(CmdLine: String);
{ Runs Dos command as if it were started from the command line,
explicitly calling command.com }

procedure RunProgram(CmdLine: String);
{ Runs program as if it were started from the command line }

procedure ShowMessage(message: String);
{ Same as Dialogs' ShowMessage, but sets the cursor to crDefault
before displaying the dialog and sets it back to what it was
afterwards }

(*************************) implementation (*************************)

uses
  Controls,        { Imports TCursor }
{$ifdef ver80}
  FmChsstr,        { Imports TChooseStringDlg }
  FmEntint,        { Imports TEnterIntegerDialog }
{$endif ver80}
  Dialogs,         { Imports ShowMessage }
  Forms,           { Imports Application }
  SysUtils,        { Imports ChangeFileExt }
  WinProcs,        { Imports WinExec }
  WinTypes;        { Imports sw_restore }


{$ifdef ver80}
procedure ChooseString(message: String;
                       stringlist: stringlisttype;
                       var ChosenString: String);
{ Lets the user choose a string from a string list }
var ChooseStringDlg: TChooseStringDlg;
    result: Integer;
begin { ChooseString }
  ChooseStringDlg := TChooseStringDlg.Create(nil);
  ChooseStringDlg.Label1.Caption := message;
  ChooseStringDlg.SetStringlist(stringlist);
  ChooseStringDlg.ShowModal;
  ChosenString := ChooseStringDlg.ChosenString
end;  { ChooseString }

procedure ChooseStrings(message: String;
                        stringlist: stringlisttype;
                        var ChosenStrings: stringlisttype);
var ItemNr: Integer;
begin { ChooseStrings }
  ChooseStringDlg := TChooseStringDlg.Create(nil);
  with ChooseStringDlg
  do begin
    Label1.Caption := message;
    SetStringlist(stringlist);
    Listbox1.MultiSelect := True;
    ShowModal;
    ChosenStrings.init;
    for ItemNr := 0 to Listbox1.Items.Count - 1
    do if Listbox1.Selected[Itemnr]
       then ChosenStrings.insertstr(ListBox1.Items[ItemNr])
  end; { with }
end;  { ChooseStrings }
{$endif ver80}

procedure FindCommonStrings(List1, List2: TStringlist;
                            var CommonStrings: TStringlist);
{ Returns in CommonStrings the stings that are present in
both List1 and List2 }
var Value: String;
    i: Integer;
begin { FindCommonStrings }
  CommonStrings := TStringlist.Create;
  for i := 1 to List1.Count
  do begin
    Value := List1[i-1];
    if List2.IndexOf(Value) <> -1
    then if CommonStrings.IndexOf(Value) = -1
    then CommonStrings.Add(Value);
  end;
  for i := 1 to List2.Count
  do begin
    Value := List2[i-1];
    if List1.IndexOf(Value) <> -1
    then if CommonStrings.IndexOf(Value) = -1
    then CommonStrings.Add(Value);
  end;
end;  { FindCommonStrings }

procedure FreeObject(var o; q:TObject);
{ This code came with The Delphi Magazine, Issue 18, TipTrix }
var p: TObject absolute o;
begin { FreeObject }
  if p <> q  { check if both parameters point to the same instance }
  then raise exception.Create('"FreeObject": different params');
  p.free;
  p := nil;
end;  { FreeObject }
(*procedure FreeObject(var p: TObject);
{ This gives compiler error 'types of actual and formal var
parameters must be identical' in the calling source code }
begin { FreeObject }
  p.Free;
  p := nil;
end;  { FreeObject }*)

procedure ErStop(message: String);
{ Terminates execution of the program, giving the message 'message' }
begin
  MessageDlg(message, mtError, [mbOK], 0);
  Halt;
end;  { ErStop }

function LeftStr(s: String; count: Integer): String;
begin    LeftStr := Copy(s, 1, count)
end;  { LeftStr }

procedure OpenIniFile(var Inifile: TIniFile);
{ Opens the ini file of the 'current application'.
It is assumed to be at the same location as the executable }
var IniFilename: String;
begin { OpenIniFile }
  IniFilename := Application.Exename;
  IniFilename := ChangeFileExt(Inifilename, '.ini');
  IniFile := TIniFile.Create(IniFilename);
end;  { OpenIniFile }

procedure RunDosCommand(CmdLine: String);
{ Runs Dos command as if it were started from the command line,
explicitly calling command.com }
var Result: Integer;
begin { RunDosCommand }
  CmdLine := 'command.com' + ' /C ' + Cmdline + Chr(0);
  Result := WinExec(@CmdLine[1], sw_minimize);
  if Result < 32
  then ShowMessage('Execution of command line' + CRLF +
                   LeftStr(CmdLine, Length(CmdLine)-1) + CRLF +
                   'failed. Error code:' + IntToStr(result));
end;  { RunDosCommand }

procedure RunProgram(CmdLine: String);
{ Runs program as if it were started from the command line }
var
  ExecResult: Integer;
  Filename: array[0..100] of Char;
  p, H: Integer;
begin { RunProgram }
  CmdLine := Cmdline + Chr(0);
  ExecResult := WinExec(@CmdLine[1], sw_restore);
  if ExecResult < 32
  then ShowMessage('Execution of command line' + CRLF +
                   LeftStr(CmdLine, Length(CmdLine)-1) + CRLF +
                   'failed. Error code:' + IntToStr(ExecResult));
  {p := Pos(' ', CmdLine);
  CmdLine := LeftStr(CmdLine, p-1) + Chr(0);}
  Application.ProcessMessages;
  H := GetModuleHandle(@CmdLine[1]);
end;  { RunProgram }

procedure ShowMessage(message: String);
{ Same as Dialogs' ShowMessage, but sets the cursor to crDefault
before displaying the dialog and sets it back to what it was
afterwards }
var oldCursor: TCursor;  
begin { ShowMessage }
  OldCursor := Screen.Cursor;
  Screen.Cursor := crDefault;
  Dialogs.ShowMessage(message);
  Screen.Cursor := OldCursor;
end;  { ShowMessage }

end.  { Uniy MoreUtils }
