(**************************     TGammaPanel     *******************************

 TGammaPanel is a Simple Color Panel like a Paint Shop Pro Color Panel
 
 This component can be freely used and distributed in commercial and private
 environments, provided this notice is not modified in any way.
 Feel free to contact us if you have any questions, comments or suggestions
 at TRSOFT@Menden.net

    Copyright  1998 by TRSOFT  All Rights Reserved.
    Thomas Radtke Software Entwicklung.
    http://www.abcnet.de/TRSOFT/

  THIS SOFTWARE IS PROVIDED AS IS AND WITHOUT WARRANTY OF ANY KIND,
  EITHER EXPRESSED OR IMPLIED.

------------------------------- History --------------------------------------
 Ver 1.0 10.02.98
         Main Component Build.

 Ver 2.0 08.03.98
         OnChange property added.

 Ver 2.1 09.03.98
         FirstMouseMove and SecondMouseMove added.
         FSwapLabel.OnMouseMove added.
         New Cursor added.
         FImagePanel OnMouseMove is now AllMouseMove. (Previous
                Version was ImgMouseMove - not good...) 
------------------------------------------------------------------------------
******************************************************************************)

unit GammaPanel;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls;

type
  TGammaPanel = class(TCustomPanel)
  private
     FImagePanel    : TPanel;
     FStatePanel    : TPanel;
     FControlPanel  : TPanel;
     FViewWindow    : TPanel;
     RLabel         : TLabel;
     GLabel         : TLabel;
     BLabel         : TLabel;
     FSecond        : TShape;
     FFirst         : TShape;
     FGamma         : TImage;
     FSwapLabel     : TLabel;
     FColDlg        : TColorDialog;
     FFirstColor    : TColor;
     FSecondColor   : TColor;
     FOnChange      : TNotifyEvent;
     PipCursor      : TCursor;
     Swap           : Boolean;

     procedure SetFirstColor(Value : TColor);
     procedure SetSecondColor(Value : TColor);
  protected
     procedure Change;
     procedure DoSwap(Sender: TObject);
     procedure GammaClick(Sender: TObject);
     procedure FirstMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
     procedure SecondMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
     procedure AllMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
     procedure ImgMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
     procedure SecondMouseDown(Sender: TObject;
                Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
     procedure FirstMouseDown(Sender: TObject;
                Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
     procedure CMFontChanged (var Message: TMessage); message CM_FONTCHANGED;
     procedure CMColorChanged (var Message: TMessage); message CM_COLORCHANGED;
     procedure WMSize(var Message: TWMSize); message WM_SIZE;
     procedure Loaded; override;
  public
     constructor Create(AOwner: TComponent); override;
     destructor Destroy; override;
  published
     property FirstColor     :TColor      read FFirstColor   write SetFirstColor  default clBlack;
     property SecondColor    :TColor      read FSecondColor  write SetSecondColor default clWhite;
     property Font;
     property BevelInner;
     property BevelOuter;
     property BevelWidth;
     property Enabled;
     property Color;
     property ParentColor;
     property ParentFont;
     property ParentShowHint;
     property PopupMenu;
     property ShowHint;
     property Visible;
     property OnClick;
     property OnMouseDown;
     property OnMouseMove;
     property OnMouseUp;
     property OnChange: TNotifyEvent read FOnChange write FOnChange;
  end;


procedure Register;

implementation

{$R GammaPanel}

const MyCursor = 1;

procedure Register;
begin
  RegisterComponents('TRSOFT', [TGammaPanel]);
end;

constructor TGammaPanel.Create(aOwner: TComponent);
begin
     inherited Create(aOwner);
     ControlStyle := [csCaptureMouse,csClickEvents,csOpaque,csFixedWidth,csFixedHeight];
     Swap := False;
     Width := 65;
     Height := 250;
     Visible:=True;
     Enabled := True;
     Align :=alNone;
     Alignment:=taCenter;
     BevelInner:=bvRaised;
     BevelOuter:=bvLowered;
     BevelWidth:=1;
     BorderStyle:=bsNone;
     BorderWidth:=0;
     Screen.Cursors[MyCursor] := LoadCursor(hInstance, pChar('PIP'));
     PipCursor:=MyCursor;
     Color:=clBtnFace;
     Font.Name:='MS Serif';
     Font.Size:=7;
     OnMouseMove:=AllMouseMove;
     FFirstColor:=clBlack;
     FSecondColor:=clWhite;

     FImagePanel:= TPanel.Create(Self);
     FImagePanel.SetBounds(8, 7, 50, 100);
     FImagePanel.Parent:=Self;
     FImagePanel.Align :=alNone;
     FImagePanel.Alignment:=taCenter;
     FImagePanel.BevelInner:=bvLowered;
     FImagePanel.BevelOuter:=bvNone;
     FImagePanel.BevelWidth:=1;
     FImagePanel.BorderStyle:=bsNone;
     FImagePanel.BorderWidth:=0;
     FImagePanel.Color:=Color;
     FImagePanel.Caption:='';
     FImagePanel.Cursor:=PipCursor;
     FImagePanel.PopupMenu:=PopupMenu;
     FImagePanel.Visible:=True;
     FImagePanel.Enabled := True;
     FImagePanel.OnMouseMove :=AllMouseMove;

     FStatePanel:= TPanel.Create(Self);
     FStatePanel.SetBounds(8, 165, 50, 80);
     FStatePanel.Parent:=Self;
     FStatePanel.Align :=alNone;
     FStatePanel.Alignment:=taCenter;
     FStatePanel.BevelInner:=bvLowered;
     FStatePanel.BevelOuter:=bvRaised;
     FStatePanel.BevelWidth:=1;
     FStatePanel.BorderStyle:=bsNone;
     FStatePanel.BorderWidth:=0;
     FStatePanel.ParentColor:=True;
     FStatePanel.Color:=Color;
     FStatePanel.Caption:='';
     FStatePanel.Cursor:=crDefault;
     FStatePanel.PopupMenu:=PopupMenu;
     FStatePanel.Visible:=True;
     FStatePanel.Enabled := True;
     FStatePanel.OnMouseMove:=AllMouseMove;

     FControlPanel:= TPanel.Create(Self);
     FControlPanel.SetBounds(8, 111, 50, 50);
     FControlPanel.Parent:=Self;
     FControlPanel.Align :=alNone;
     FControlPanel.Alignment:=taCenter;
     FControlPanel.BevelInner:=bvLowered;
     FControlPanel.BevelOuter:=bvRaised;
     FControlPanel.BevelWidth:=1;
     FControlPanel.BorderStyle:=bsNone;
     FControlPanel.BorderWidth:=0;
     FControlPanel.ParentColor:=True;
     FControlPanel.Color:=Color;
     FControlPanel.Caption:='';
     FControlPanel.Cursor:=crDefault;
     FControlPanel.PopupMenu:=PopupMenu;
     FControlPanel.Visible:=True;
     FControlPanel.Enabled := True;
     FControlPanel.OnMouseMove:=AllMouseMove;

     FViewWindow:= TPanel.Create(Self);
     FViewWindow.SetBounds(6, 44, 36, 30);
     FViewWindow.Parent:=FStatePanel;
     FViewWindow.Align :=alNone;
     FViewWindow.Alignment:=taCenter;
     FViewWindow.BevelInner:=bvNone;
     FViewWindow.BevelOuter:=bvLowered;
     FViewWindow.BevelWidth:=1;
     FViewWindow.BorderStyle:=bsNone;
     FViewWindow.BorderWidth:=0;
     FViewWindow.Color:=clGray;
     FViewWindow.Caption:='None';
     FViewWindow.Cursor:=crDefault;
     FViewWindow.PopupMenu:=PopupMenu;
     FViewWindow.Visible:=True;
     FViewWindow.Enabled := True;
     FViewWindow.OnMouseMove:=AllMouseMove;

     RLabel:= TLabel.Create(Self);
     RLabel.SetBounds(11, 3, 21, 11);
     RLabel.Parent:=FStatePanel;
     RLabel.Align :=alNone;
     RLabel.Alignment:=taLeftJustify;
     RLabel.AutoSize:=True;
     RLabel.ParentColor:=True;
     RLabel.Color:=Color;
     RLabel.Font:=Font;
     RLabel.Caption:='R - - -';
     RLabel.Cursor:=crDefault;
     RLabel.Visible:=True;
     RLabel.Enabled := True;

     GLabel:= TLabel.Create(Self);
     GLabel.SetBounds(11, 16, 21, 11);
     GLabel.Parent:=FStatePanel;
     GLabel.Align :=alNone;
     GLabel.Alignment:=taLeftJustify;
     GLabel.AutoSize:=True;
     GLabel.ParentColor:=True;
     GLabel.Color:=Color;
     GLabel.Font:=Font;
     GLabel.Caption:='G - - -';
     GLabel.Cursor:=crDefault;
     GLabel.Visible:=True;
     GLabel.Enabled := True;

     BLabel:= TLabel.Create(Self);
     BLabel.SetBounds(11, 30, 21, 11);
     BLabel.Parent:=FStatePanel;
     BLabel.Align :=alNone;
     BLabel.Alignment:=taLeftJustify;
     BLabel.AutoSize:=True;
     BLabel.ParentColor:=True;
     BLabel.Color:=Color;
     BLabel.Font:=Font;
     BLabel.Caption:='B - - -';
     BLabel.Cursor:=crDefault;
     BLabel.Visible:=True;
     BLabel.Enabled := True;

     FSecond:= TShape.Create(Self);
     FSecond.SetBounds(16, 16, 30, 30);
     FSecond.Parent:=FControlPanel;
     FSecond.Brush.Color:=FSecondColor;
     FSecond.Visible:=True;
     FSecond.Enabled := True;
     FSecond.OnMouseDown := SecondMouseDown;
     FSecond.OnMouseMove := SecondMouseMove;

     FFirst:= TShape.Create(Self);
     FFirst.SetBounds(4, 4, 30, 30);
     FFirst.Parent:=FControlPanel;
     FFirst.Brush.Color:=FFirstColor;
     FFirst.Visible:=True;
     FFirst.Enabled := True;
     FFirst.OnMouseDown := FirstMouseDown;
     FFirst.OnMouseMove := FirstMouseMove;

     FSwapLabel:=TLabel.Create(Self);
     FSwapLabel.SetBounds(6, 35 , 9, 13);
     FSwapLabel.Parent:=FControlPanel;
     FSwapLabel.Align :=alNone;
     FSwapLabel.Alignment:=taLeftJustify;
     FSwapLabel.AutoSize:=True;
     FSwapLabel.ParentColor:=True;
     FSwapLabel.Color:=Color;
     FSwapLabel.Font:=Font;
     FSwapLabel.Caption:='X';
     FSwapLabel.Cursor:=crDefault;
     FSwapLabel.Visible:=True;
     FSwapLabel.Enabled := True;
     FSwapLabel.OnMouseMove:=AllMouseMove;
     FSwapLabel.OnClick := DoSwap;

     FGamma:= TImage.Create(Self);
     FGamma.SetBounds(1, 1 , 48, 98);
     FGamma.Parent:=FImagePanel;
     FGamma.Picture.Bitmap.LoadFromResourceName(HInstance,'GAMMA');
     FGamma.Align:=alClient;
     FGamma.Stretch:=False;
     FGamma.AutoSize:=True;
     FGamma.Center:=True;
     FGamma.Cursor:=PipCursor;
     FGamma.Visible:=True;
     FGamma.Enabled := True;
     FGamma.OnClick:= GammaClick;
     FGamma.OnMouseMove :=ImgMouseMove;

     FColDlg:=TColorDialog.Create(Self);
     FColDlg.Options:=[cdFullOpen,cdAnyColor];
end;

destructor TGammaPanel.Destroy;
begin
     FColDlg.Free;
     FGamma.Free;
     FFirst.Free;
     FSecond.Free;
     BLabel.Free;
     GLabel.Free;
     RLabel.Free;
     FControlPanel.Free;
     FViewWindow.Free;
     FStatePanel.Free;
     FImagePanel.Free;
     inherited Destroy;
end;

procedure TGammaPanel.AllMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin
     FViewWindow.Caption:='None';
     FViewWindow.Color:=clGray;
     RLabel.Caption:='R - - -';
     GLabel.Caption:='G - - -';
     BLabel.Caption:='B - - -';
end;

procedure TGammaPanel.ImgMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin
     FViewWindow.Caption:='';
     FViewWindow.Color:= FGamma.Canvas.Pixels[x,y];
     RLabel.Caption:='R '+ IntToStr(GetRValue(ColorToRGB(FViewWindow.Color)));
     GLabel.Caption:='G '+ IntToStr(GetGValue(ColorToRGB(FViewWindow.Color)));
     BLabel.Caption:='B '+ IntToStr(GetBValue(ColorToRGB(FViewWindow.Color)));
end;

procedure TGammaPanel.DoSwap(Sender: TObject);
begin
       Swap:= not Swap;
     if not Swap
       then
           begin
                FSecond.SendToBack;
                FFirst.BringToFront
           end
       else
           begin
                FFirst.SendToBack;
                FSecond.BringToFront;
           end;
end;

procedure TGammaPanel.GammaClick(Sender: TObject);
begin
     if not Swap
      then
       begin
            FFirst.Brush.Color:=FViewWindow.Color;
            FFirstColor:=FViewWindow.Color;
       end
      else
       begin
            FSecond.Brush.Color:=FViewWindow.Color;
            FSecondColor:=FViewWindow.Color;
       end;
      if Assigned(FOnChange) then FOnChange(Self);
end;

procedure TGammaPanel.SecondMouseDown(Sender: TObject;
                Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     if Button <> mbLeft then Exit;
     
     FColDlg.Color:=FSecond.Brush.Color;
     if FColDlg.Execute then
       begin
            FSecond.Brush.Color:=FColDlg.Color;
            FSecondColor:=FSecond.Brush.Color;
       end;
     if Assigned(FOnChange) then FOnChange(Self);
end;

procedure TGammaPanel.FirstMouseDown(Sender: TObject;
                Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     if Button <> mbLeft then Exit;

     FColDlg.Color:=FFirst.Brush.Color;
     if FColDlg.Execute then
       begin
            FFirst.Brush.Color:=FColDlg.Color;
            FFirstColor:=FFirst.Brush.Color;
       end;
     if Assigned(FOnChange) then FOnChange(Self);
end;

procedure TGammaPanel.FirstMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin
     FViewWindow.Caption:='';
     FViewWindow.Color:= FFirst.Brush.Color;
     RLabel.Caption:='R '+ IntToStr(GetRValue(ColorToRGB(FFirst.Brush.Color)));
     GLabel.Caption:='G '+ IntToStr(GetGValue(ColorToRGB(FFirst.Brush.Color)));
     BLabel.Caption:='B '+ IntToStr(GetBValue(ColorToRGB(FFirst.Brush.Color)));
end;

procedure TGammaPanel.SecondMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin
     FViewWindow.Caption:='';
     FViewWindow.Color:= FSecond.Brush.Color;
     RLabel.Caption:='R '+ IntToStr(GetRValue(ColorToRGB(FSecond.Brush.Color)));
     GLabel.Caption:='G '+ IntToStr(GetGValue(ColorToRGB(FSecond.Brush.Color)));
     BLabel.Caption:='B '+ IntToStr(GetBValue(ColorToRGB(FSecond.Brush.Color)));
end;

procedure TGammaPanel.CMFontChanged (var Message: TMessage);
begin
     inherited;
     Invalidate;
end;

procedure TGammaPanel.WMSize (var Message: TWMSize);
begin
     inherited;
     Width := 65;
     Height := 250;
     Invalidate;
end;

procedure TGammaPanel.CMColorChanged (var Message: TMessage);
begin
     inherited;
     Invalidate;
end;

procedure TGammaPanel.SetFirstColor(Value : TColor);
begin
     FFirstColor:=Value;
     FFirst.Brush.Color:=FFirstColor;
     if Assigned(FOnChange) then FOnChange(Self);
     Invalidate;
end;

procedure TGammaPanel.SetSecondColor(Value : TColor);
begin
     FSecondColor:=Value;
     FSecond.Brush.Color:=FSecondColor;
     if Assigned(FOnChange) then FOnChange(Self);
     Invalidate;
end;

procedure TGammaPanel.Loaded;
begin
     inherited Loaded;
end;

procedure TGammaPanel.Change;
begin
     inherited Changed;
     if Assigned(FOnChange) then FOnChange(Self);
     Invalidate;
end;

end.
