(*
  TFormPositionKeeper Component
  by Glen Why
  No rights reserved
 
  Version 01.00.00


  Version history
  
  01.00.00  - first version

*)
unit fpkeep;

interface
uses
 windows, classes, controls, forms, regappc;

type

  TFormPositionKeeper = class( TRegApp )
  private
    FOldOnClose :TCloseEvent;
    procedure OurOnClose(Sender: TObject; var Action: TCloseAction);
    function GetParentForm :TForm;
    function FindRegAppx :TRegApp;
  protected
    procedure Loaded; override;
    property ParentForm :TForm read GetParentForm;
  public
    constructor Create( anOwner :TComponent ); override;
  published
    property RootKey;
    property Company;
    property ApplicationName;
    property RelativePath;
  end;

procedure Register;

implementation

procedure Register;
begin
 RegisterComponents( 'more...', [ TFormPositionKeeper ] );
end;


procedure TFormPositionKeeper.Loaded;
var F :TForm;
begin
 inherited Loaded;
 F := ParentForm;
 if ( F <> Nil ) then
  begin
    Active := true;
    if ValueExists( 'L' ) then F.Left := ReadInteger( 'L' );
    if ValueExists( 'T' ) then F.Top := ReadInteger( 'T' );
    if ValueExists( 'W' ) then F.Width := ReadInteger( 'W' );
    if ValueExists( 'H' ) then F.Height := ReadInteger( 'H' );
    Active := false;
    FOldOnClose := F.OnClose;
    F.OnClose := OurOnClose;
  end;
end;

procedure TFormPositionKeeper.OurOnClose(Sender: TObject; var Action: TCloseAction);
begin
 with Sender as TForm do
  begin
    Self.Active := true;
    WriteInteger( 'L', Left );
    WriteInteger( 'T', Top );
    WriteInteger( 'W', Width );
    WriteInteger( 'H', Height );
    Self.Active := false;
  end;
 if assigned( FOldOnClose ) then FOldOnCLose( Sender, Action );
end;

constructor TFormPositionKeeper.Create( anOwner :TComponent );
var R :TRegApp;
begin
 inherited Create( anOwner );
 RootKey := rhCurrentUser;
 R := FindRegAppx;
 if R <> Nil then
   begin
     Company := TRegAppConfig( R ).Company;
     ApplicationName := TRegAppConfig( R ).ApplicationName;
     RootKey := TRegAppConfig( R ).RootKey;
     Version := TRegAppConfig( R ).Version;
   end;
end;

function TFormPositionKeeper.GetParentForm :TForm;
var C :TComponent;
begin
  C := Self;
  while assigned( C ) do
   begin
    if ( C is TForm ) then break;
    C := C.Owner;
   end;
  result := TForm( C );
end;


function TFormPositionKeeper.FindRegAppx :TRegApp;
var i :integer; c :TComponent;
begin
  result := nil;
  C := ParentForm;
  if assigned( C ) then
   for i := 0 to C.ComponentCount - 1 do
    if ( C.Components[ i ] is TRegApp ) and
     ( C.Components[ i ] <> Self ) then
       begin
         result := TRegApp( C.Components[ i ] );
         break;
       end;
end;




end.
