{
FormWizard Component Version 1.0 (c) 2000
Create : 9 Feb 2000
This component for change for your form.
Artik formlarinizi birakin sekilden sekile girsin!
izzet uslu
istanbul-TURKEY
http://members.xoom.com/izus
izus6@hotmail.com
}
unit FormWizard;
{$R FormWizard.res}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,dsgnintf;

type

  TAboutFormWizard = class(TPropertyEditor)
  private
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
  end;

  TFormShowStyle = (fssDrawRndRectRegion,fssDrawEllipticRegion,fssDrawPolygonRegion);

  TFormWizard = class(TComponent)
  private
    { Private declarations }
    FAbout           : TAboutFormWizard;
    fFormShowStyle   : TFormShowStyle;
    fProcessForm     : TForm;
    fNumPoints       : integer;
    fDoStarShape     : boolean;
    fFormBrushColor  : TColor;
    fCaption         : string;
    fActive          : boolean;
  protected
    { Protected declarations }
    Rgn       : HRGN;
    Rect      : TRect;
    frmPoints : array[0..100] of TPoint;
    procedure WMNCHitTest(var M: TWMNCHitTest); message wm_NCHitTest;
    procedure SetFormShowStyle(value : TFormShowStyle);
    procedure SetNumPoints(value : integer);
    procedure SetDoStarShape(value : boolean);
    procedure SetFormBrushColor(value : TColor);
    procedure SetCaption(value : string);
    procedure SetActive(value : boolean);
  public
    constructor Create(aOwner: TComponent); override;
    destructor Destroy; override;
    procedure Refresh;
    procedure DrawRndRectRegion(wnd : HWND; rect : TRect);
    procedure DrawEllipticRegion(wnd : HWND; rect : TRect);
    procedure DrawPolygonRegion(wnd : HWND; rect : TRect; NumPoints :
              Integer; DoStarShape : Boolean);
  published
    { Published declarations }
    property About          : TAboutFormWizard read FAbout write FAbout;
    property FormShowStyle  : TFormShowStyle read fFormShowStyle write SetFormShowStyle;
    property ProcessForm    : TForm read fProcessForm write fProcessForm;
    property NumPoints      : integer read fNumPoints write SetNumPoints;
    property DoStarShape    : boolean read fDoStarShape write SetDoStarShape;
    property FormBrushColor : TColor read fFormBrushColor write SetFormBrushColor;
    property Caption        : string read fCaption write SetCaption;
    property Active         : boolean read fActive write SetActive;
  end;

procedure Register;

implementation

{ TAboutFormWizard }

procedure TAboutFormWizard.Edit;
begin
  Application.MessageBox('By izzet uslu - 2000'#13#13'E-Mail : izus6@hotmail.com'#13'WEB : http://members.xoom.com/izus','FormWizard component version 1.0', MB_OK+ MB_ICONINFORMATION);
end;

function TAboutFormWizard.GetAttributes: TPropertyAttributes;
begin
  GetAttributes:=[paDialog, paReadOnly];
end;

function TAboutFormWizard.GetValue: string;
begin
  GetValue:='(About)';
end;

{ TFormWizard }
constructor TFormWizard.Create(aOwner: TComponent);
begin
  inherited Create(aOwner);
  fFormShowStyle  := fssDrawPolygonRegion;
  fNumPoints      := 51;
  fDoStarShape    := true;
  fFormBrushColor := clGreen;
  fCaption        := 'FormWizard';
  with aOwner as TForm do
    fProcessForm := TForm(aOwner);
  fActive         := false;
  Refresh;
end;

destructor TFormWizard.Destroy;
begin
  inherited Destroy;
end;

procedure TFormWizard.SetFormShowStyle(value : TFormShowStyle);
begin
  if fFormShowStyle = Value then exit;
  fFormShowStyle := Value;
  Refresh;
end;

procedure TFormWizard.SetNumPoints(Value:integer);
begin
  if fNumPoints = Value then exit;
  fNumPoints := Value;
  if Value<3 then fNumPoints := 3;
  if (fDoStarShape) and (Value > 51) then fNumPoints := 51;
  if (not FDoStarShape) and (Value > 100) then
     fNumPoints := 100;
  Refresh;
end;

procedure TFormWizard.SetDoStarShape(value : boolean);
begin
  if fDoStarShape = Value then exit;
  fDoStarShape := Value;
  if (fDoStarShape) and (fNumPoints > 51) then fNumPoints:=51;
  Refresh;
end;

procedure TFormWizard.SetFormBrushColor(value : TColor);
begin
  if fFormBrushColor = Value then exit;
  fFormBrushColor := Value;
  Refresh;
end;

procedure TFormWizard.SetCaption(value : string);
begin
  if fCaption = Value then exit;
  fCaption := Value;
  Refresh;
end;

procedure TFormWizard.SetActive(Value:boolean);
begin
  if fActive = Value then exit;
  fActive := Value;
  Refresh;
end;

procedure TFormWizard.Refresh;
begin
  if fActive then begin
     if fFormShowStyle = fssDrawRndRectRegion then begin
        DrawRndRectRegion(fProcessForm.Handle,fProcessForm.BoundsRect);
     end;   
     if fformShowStyle = fssDrawEllipticRegion then begin
        DrawEllipticRegion(fProcessForm.Handle,fProcessForm.BoundsRect);
     end;
     if fformShowStyle = fssDrawPolygonRegion then begin
        DrawPolygonRegion(fProcessForm.Handle, fProcessForm.BoundsRect, fNumPoints, fDoStarShape);
        fProcessForm.Brush.Color := fFormBrushColor;
        fProcessForm.Canvas.Polygon(frmPoints);
        fProcessForm.Canvas.TextOut(frmPoints[3].X,frmPoints[3].Y, fCaption);
     end;
  end else begin
     rgn:=0;
     SetWindowRgn(fProcessForm.Handle,rgn,TRUE);
  end;
  fProcessForm.Refresh;
end;

procedure TFormWizard.DrawRndRectRegion(wnd : HWND; rect : TRect);
begin
  rgn := CreateRoundRectRgn(rect.left, rect.top, rect.right, rect.bottom, 30, 30);
  SetWindowRgn(wnd, rgn, TRUE);
end;

procedure TFormWizard.DrawEllipticRegion(wnd : HWND; rect : TRect);
begin
  rgn := CreateEllipticRgn(rect.left, rect.top, rect.right, rect.bottom);
  SetWindowRgn(wnd, rgn, TRUE);
end;

procedure TFormWizard.DrawPolygonRegion(wnd : HWND; rect : TRect; NumPoints : Integer; DoStarShape : Boolean);
const
  RadConvert = PI/180;
  Degrees    = 360;
  MaxLines   = 100;
var
  x, y,
  xCenter,
  yCenter,
  radius,
  pts,
  I       : Integer;
  angle,
  rotation: Extended;
  arPts   : Array[0..MaxLines] of TPoint;
begin
  xCenter := (rect.Right - rect.Left) div 2;
  yCenter := (rect.Bottom - rect.Top) div 2;
  if DoStarShape then
    begin
      rotation := Degrees/(2*NumPoints);
      pts := 2 * NumPoints;
    end
  else
    begin
      rotation := Degrees/NumPoints;
      pts := NumPoints
    end;
  radius := yCenter;

  for I := 0 to pts - 1 do begin
    if DoStarShape then
      if (I mod 2) = 0 then
        radius := Round(radius/2)
      else
        radius := yCenter;
    angle := ((I * rotation) + 90) * RadConvert;
    x := xCenter + Round(cos(angle) * radius);
    y := yCenter - Round(sin(angle) * radius);
    arPts[I].X := x;
    frmPoints[I].X := x;
    arPts[I].Y := y;
    frmPoints[I].Y := y;
  end;
  rgn := CreatePolygonRgn(arPts, pts, WINDING);
  SetWindowRgn(wnd, rgn, TRUE);
end;

procedure TFormWizard.WMNCHitTest(var M: TWMNCHitTest);
begin
  inherited;
  if M.Result = htClient then
     M.Result := htCaption;
end;

procedure Register;
begin
  RegisterComponents('izus', [TFormWizard]);
  RegisterPropertyEditor(TypeInfo(TAboutFormWizard), TFormWizard, 'ABOUT', TAboutFormWizard);
end;


end.
