unit TFntCombo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DsgnIntf;

type
  TAboutFontComboBox = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
  end;

  TFontComboBox = class(TComboBox)
  private
    AboutBox: TAboutFontComboBox;
    procedure GetFontNames;
  public
    procedure AddFonts;
  published
    property About: TAboutFontComboBox read AboutBox write AboutBox;
  end;

procedure Register;

implementation

procedure TAboutFontComboBox.Edit;
begin
  Application.MessageBox('TFontComboBox component v1.00 for Delphi 2.0. (C) 1997 Ivan Azic. For details, see README.TXT file.',
                         'About TFontComboBox Component', MB_OK + MB_ICONINFORMATION);
end;

function TAboutFontComboBox.GetAttributes: TPropertyAttributes;
begin
  Result:= [paMultiSelect, paDialog, paReadOnly];
end;

function TAboutFontComboBox.GetValue: string;
begin
  Result:= '(about)';
end;

function EnumFontsProc(var LogFont: TLogFont; var TextMetric: TTextMetric;
  FontType: Integer; Data: Pointer): Integer; stdcall;
begin
  TStrings(Data).Add(LogFont.lfFaceName);
  Result:= 1;
end;

procedure TFontComboBox.GetFontNames;
var
  DC: HDC;
begin
  DC:= GetDC(0);
  EnumFonts(DC, nil, @EnumFontsProc, Pointer(Items));
  ReleaseDC(0, DC);
  Sorted:= True;
end;

procedure TFontComboBox.AddFonts;
begin
  GetFontNames;
end;

procedure Register;
begin
  RegisterComponents('Samples', [TFontComboBox]);
  RegisterPropertyEditor(TypeInfo(TAboutFontComboBox), TFontComboBox, 'ABOUT', TAboutFontComboBox);
end;

end.
