unit Paneles;
(***********************************************************************
 *                                                                     *
 *  Copyright (C) 1996-1998                                            *
 *  Erol S. Uzuner                                                     *
 *                                                                     *
 *  Modul       :       Paneles                                        *
 *  Version     :       1.0 (26.05.98)                                 *
 *                                                                     *
 *  Beschreibung:      TPaneles Komponente                             *
 *                                                                     *
 *  Autor       :       Erol S. Uzuner                                 *
 *                                                                     *
 *  Datum       :       26.05.98  22:23:00 1998                        *
 *                                                                     *
 *                                                                     *
 *  Aenderungen :                                                      *
 *  Datum        Autor          Beschreibung                           *
 *
 ***********************************************************************)



interface

uses               
  Windows, Messages, Controls, Classes, Graphics, ExtCtrls, BitmapHolder;

type
  TPaneles = class(TPanel)
  private
    { Private-Deklarationen }
    FBitmap : TBitmap;
    FBitmapHolder : TBitmapHolder;
    FImageChangeLink: TLinkChange;
    procedure WMEraseBkgnd(var MSG: TWMEraseBkgnd); message wm_EraseBkgnd;  {Hintergund zeichnen}
    procedure DrawBackground(TheHandle : THandle);
  protected
    { Protected-Deklarationen }
    function GetBitmap : TBitmap;
    procedure SetBitmap(Value : TBitmap);
    function GetBitmapHolder : TBitmapHolder;
    procedure SetBitmapHolder(Value : TBitmapHolder);
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure DrawBorder;
    procedure Paint; override;
    procedure BitmapHolderChange(Sender: TObject);
  public
    { Public-Deklarationen }
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
  published
    { Published-Deklarationen }
    property Bitmap : TBitmap read GetBitmap write SetBitmap;
    property BitmapHolder : TBitmapHolder read GetBitmapHolder write SetBitmapHolder;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('sarcon', [TPaneles]);
end;

constructor TPaneles.Create(AOwner : TComponent);
begin
     inherited Create(AOwner);
     FBitmap := TBitmap.Create;
     FBitmapHolder := NiL;
     FImageChangeLink := TLinkChange.Create;
     FImageChangeLink.OnChange := BitmapHolderChange;
end;

destructor TPaneles.Destroy;
begin
     FBitmap.Free;
     if FBitmapHolder <> NIL then
       FBitmapHolder.UnRegisterChanges(FImageChangeLink);
     FImageChangeLink.Free;
     inherited Destroy;
end;

procedure TPaneles.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if Assigned(FBitmapHolder) AND (Operation = opRemove) AND (AComponent = FBitmapHolder) then
     FBitmapHolder := NIL;
end;


procedure TPaneles.WMEraseBkgnd(var MSG: TWMEraseBkgnd);
begin
  inherited;
  if (FBitmap.Empty) AND (NoT(Assigned(FBitmapHolder)) OR
       (Assigned(FBitmapHolder) AND (FBitmapHolder.isEmpty))) then begin
       Canvas.Brush.Color := Color;
       Windows.FillRect(MSG.DC, GetClientRect, Canvas.Brush.Handle);
       DrawBorder;
  end else
    DrawBackground(MSG.DC);
end;

procedure DrawTiled(DC : HDC; CR: TRect; Bitmap : TBitmap);
var
  Row, Col : Integer;
  NumRows, NumCols: Integer;
  DrawX, DrawY, DrawWidth, DrawHeight: Integer;
  OldRect : TRect;
begin

  NumRows := CR.Bottom DIV Bitmap.Height;
  NumCols := CR.Right DIV Bitmap.Width;
  for Row := 0 to NumRows+1 do
    for Col := 0 to NumCols+1  do
    begin
      DrawX :=  (Col * Bitmap.Width) + CR.Left;
      DrawY :=  (Row * Bitmap.Height) + CR.Top;
      if (DrawX + Bitmap.Width) > CR.Right then
         DrawWidth :=  CR.Right - DrawX
      else
         DrawWidth :=  Bitmap.Width;

      if (DrawY + Bitmap.Height) > CR.Bottom then
         DrawHeight :=  CR.Bottom - DrawY
      else
         DrawHeight := Bitmap.Height;
      GetClipBox(DC, OldRect);
      IntersectCliprect(DC, CR.Left, CR.Top, CR.Right, CR.Bottom);
      BitBlt( DC,
              DrawX, DrawY, DrawWidth, DrawHeight,
              Bitmap.Canvas.Handle,
              0, 0, SRCCOPY);
      IntersectCliprect(DC, OldRect.Left, OldRect.Top, OldRect.Right, OldRect.Bottom);
    end;
end;


procedure TPaneles.DrawBackground(TheHandle : THandle);
var Rect : TRect;
//    bmp : TBitmap;
begin
  Rect := GetClientRect;
  Rect.TopLeft := ClientRect.TopLeft;
  Rect.BottomRight := ClientRect.BottomRight;

  if NoT(FBitmap.Empty) then
      DrawTiled(TheHandle, rect, FBitmap)
  else if Assigned(FBitmapHolder) AND (NoT FBitmapHolder.isEmpty) then
    FBitmapHolder.TiledOnH(rect, TheHandle);

  {
  if (Assigned(bmp)) then begin
  (*  if BevelInner <> bvNone then
      InflateRect(rect, -BevelWidth, -BevelWidth);
    if BevelOuter <> bvNone then
      InflateRect(rect, -BevelWidth, -BevelWidth);
  *)
  end;
  }
  DrawBorder;
end;

procedure TPaneles.DrawBorder;
var
  Rect: TRect;
  TopColor, BottomColor: TColor;

  procedure AdjustColors(Bevel: TPanelBevel);
  begin
    TopColor := clBtnHighlight;
    if Bevel = bvLowered then TopColor := clBtnShadow;
    BottomColor := clBtnShadow;
    if Bevel = bvLowered then BottomColor := clBtnHighlight;
  end;
begin
  Rect := GetClientRect;
  if BevelOuter <> bvNone then begin
    AdjustColors(BevelOuter);
    Frame3D(Canvas, Rect, TopColor, BottomColor, BevelWidth);
  end;

  Frame3D(Canvas, Rect, Color, Color, BorderWidth);
  if BevelInner <> bvNone then begin
    AdjustColors(BevelInner);
    Frame3D(Canvas, Rect, TopColor, BottomColor, BevelWidth);
  end;
end;

procedure TPaneles.Paint;
var
  Rect: TRect;
  FontHeight: Integer;
const
  Alignments: array[TAlignment] of Word = (DT_LEFT, DT_RIGHT, DT_CENTER);

begin
  Rect := GetClientRect;
  with Canvas do begin
    Brush.Color := Color;
    if (FBitmap.Empty) AND (NoT(Assigned(FBitmapHolder)) OR
       (Assigned(FBitmapHolder) AND (FBitmapHolder.isEmpty))) then
       FillRect(Rect)
    else
      DrawBackground(Canvas.handle);

    DrawBorder;
    Brush.Style := bsClear;
    Font := Self.Font;
    FontHeight := TextHeight('W');
    with Rect do begin
      Top := ((Bottom + Top) - FontHeight) div 2;
      Bottom := Top + FontHeight;
    end;
    DrawText(Handle, PChar(Caption), -1, Rect, (DT_EXPANDTABS or
      DT_VCENTER) or Alignments[Alignment]);
  end;

end;

function TPaneles.GetBitmap : TBitmap;
begin Result := FBitmap;
end;

procedure TPaneles.SetBitmap(Value : TBitmap);
begin
   FBitmap.Assign(Value);
   if FBitmapHolder <> nil then begin
    if Value <> NIL then
      FBitmapHolder.UnRegisterChanges(FImageChangeLink)
    else
      FBitmapHolder.RegisterChanges(FImageChangeLink);
   end;
   inherited Invalidate;
end;

function TPaneles.GetBitmapHolder : TBitmapHolder;
begin Result := FBitmapHolder;
end;

procedure TPaneles.SetBitmapHolder(Value : TBitmapHolder);
begin
  if FBitmapHolder <> nil then FBitmapHolder.UnRegisterChanges(FImageChangeLink);
  FBitmapHolder := Value;
  if FBitmapHolder <> nil then
  begin
     FBitmapHolder.RegisterChanges(FImageChangeLink);
     Value.FreeNotification(Self);
  end;
  invalidate;
end;

procedure TPaneles.BitmapHolderChange(Sender: TObject);
begin inherited invalidate;
end;

end.
