unit FoldPanel;
(***********************************************************************
 *                                                                     *
 *  Copyright (C) 1996-2000                                            *
 *  Erol S. Uzuner                                                     *
 *                                                                     *
 *  Modul       :       Foldpanel                                      *
 *  Version     :       1.3 (26.04.00)                                 *
 *                                                                     *
 *  Description :      TFoldPanel Komponente                           *
 *                                                                     *
 *  Author      :       Erol S. Uzuner  <sarcon@tzi.de>                *
 *                                                                     *
 *  Date        :       Die Aug 29.08.97  23:37:00 1997                *
 *                                                                     *
 *                                                                     *
 *  Modifikations :                                                    *
 *
 *  Date        Author         Description                             *
 * 26.04.00    Erol S. Uzuner  Added Timer to catch unregistered Mouse-Leave
 *                             Added Orientation all changes marked with (ESU 000426)
 *
 * 24.02.99    Erol S. Uzuner  Fehler beim auslsen von
 *                             On- und BevorExpand/Collapse beseitigt
 * 31.03.00    Erol S. Uzuner  Fixed Bug with BitmapChange-Event and ActiveGlyphs
 * 31.03.00    Erol S. Uzuner  Added Property - CollapsedHeight
 *                             (see BugReport - Richard Chang)
 * 31.03.00    Bartosz Dzido   BUG-Report and Fix
 * 11.04.00    Carsten Butzek  Fixed some FoldBitmaps-Repainting-Problems
 * 16.01.99    Erol S. Uzuner  Das ClientWindows wurde zu einem
 *                             TPaneles umgewandelt.
 * 16.09.97    Erol S. Uzuner  Wenn Collapsed kann die Hoehe nicht veraendert
 *                             werden.
 * 11.09.97    Erol S. Uzuner  Jetzt auch lauffhig auf Delphi 2
 *                             Wenn DELPHI3 definiert ist wirds es
 *                             fr Delphi3 compiliert
 * 11.09.97    Erol S. Uzuner  FoldPosition eingefuegt.
 * 09.09.97    Erol S. Uzuner  Die Komponente wurde auf den CLientWindow
 *                             angepasst.                              *
 * 08.09.97    Erol S. Uzuner  TFoldPanelClient als ClientWindow       *
 *                             eingefhrt                              *
 *
 ***********************************************************************)

 {++++[ Bug Reports ]+++++++++++++++++++++++++++++++++++++++++++++++++++
  +
  + 31.03.00  Bartosz Dzido <bdzido@ely.pga.gda.pl>
  +           P- If you collapse the Panel and change align from alClient
  +             to alTop and change the size too, something went wrong
  +             with minimizing the Panel
  +           M- Modifications are Marked with (BD 31.03.2000)
  +           S- Fixed by Bartosz Dzido
  +
  + 31.03.00  Richard Chang <ksbing@hotmail.com>
  +           P- Cound't set CaptionFont Size, missed CollapsedHeight-Property
  +           M- Modifications made by me, not marked
  +           S- Fixed by me
  +
  + 11.04.00  Carsten Butzek <cabutzek@muenster.de>
  +           P- Some Problems with Repainting FoldBitmaps
  +           M- Modifications are marked with (CB 11.04.2000)
  +           S- Fixed by Carsten Butzek
  +
  +
  ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

  {
    KOWN BUGS  - Not Fixed

    1) If You change FoldPosition in Collapsed State, the Panel will
       not Expand like it should do

  }


 (**********************************************************************

     TFoldPanel  besteht aus einem TCustomPanel als Hauptcontainer und
     einem TCustomControl als TPaneles (ehemals ClientWindow), welches
     die auf dem FoldPanel plazierten Elemente beinhaltet.
     Das ClientWindow bekommt man durch die Funktion GetClientWindow.

  *********************************************************************)

interface

  {$I ES.inc}

uses
   Windows, Messages, Classes, ExtCtrls, Graphics, Controls, Forms, Paneles,
   BitmapHolder;

const MINIMUM_COLLAPS_SIZE = 12;

type

  TFoldStatus = (fsExpanded, fsCollapsed);
  TFoldPosition = (fpLeftTop, fpRightTop, fpLeftBottom, fpRightBottom);
  TFoldOrientation = (foHorizontal, foVertical); //(ESU 000426)
  TFoldClickEvent = procedure( Sender:TObject; Status: TFoldStatus;
                               VAR DoFoldAction : Boolean) of object;

  TFoldPanel = class;
  
  TFoldPanelClient = class(TPaneles)
   protected
     FFoldPanel : TFoldPanel;
     procedure Paint; override;
   public
     MyDiff : Integer;
     NoFolding : Boolean;
     // (ESU 000426) FoldPosition : TFoldPosition;
     property FoldPanel : TFoldPanel read FFoldPanel;
     // ---Till Here ---
     constructor create(AOwner : TComponent); override;
     procedure setBounds(ALeft, ATop, AWidth, AHeight : Integer); override;
  end;

  TFoldPanel = class(TCustomPanel)
  private
      { Private-Deklarationen }
    FClientWindow : TFoldPanelClient;
    (* Status des Foldings, Expanded oder Collapsed *)
    FFoldStatus : TFoldStatus;
    (* Blocking the HeightChange in Collapsed State
       Die Hhe oder Breite kann im collapsed Zustand nicht verndert werden *)
    FDimLock : boolean;

    (* Glyphs zur Darstellung der Beiden Stati *)
    FCurrBmp,
    FExpandGlyph, FCollapsGlyph, FActiveExpandGlyph, FActiveCollapsGlyph  : TBitmap;
    (* Sollen die Bitmaps in den Stream geschrieben werden ? *)
    FStoreExpandGlyph, FStoreCollapsGlyph : Boolean;
    (* Active Color, wenn das Foldelement active ist *)
     FFoldActiveColor : TColor;
    (* Position des Fold Elements *)
    FFoldPosition : TFoldPosition;
    (* Wurde das Foldelement gedrckt *)
    FFoldBtnDown : Boolean;
    (* Dies ist die Trennlinie zwishen dem unterem Panel und dem
       ClientWindow *)
     FSeperated : Boolean;
     FLineStyle : TBevelStyle;

    (* Wird bentigt um den Mausclick abzufangen der auf den Folds
       gettigt wird, beinhaltet abwechselnd (je nach Status)
       den Rahmen der Glyphs *)
    FFoldRect : TRect;
    (* Um ein CLick ereignis auszulsen merken wir uns bei mouse down
       den Punkt und beim loslassen schauen wir ob dieser und der neue Punkt
       im FFoldRect liegen, wenn das der Fall ist, habn wir ein FoldClick
       Da Die Bitmaps nur gezeichnet werden und keine Ereignisse abfangen
       knnen, mssen wir uns auf diese weise helfen.
    *)
    FLastPoint : TPoint;
    (* Nach dem Collapsen muss die vorherige Gre hergestellt werden,
       deshalb merken wir uns die Gre hier und passen sie auch an bei einer
       grennderung durch den Benutzer *)
    FLastDim : Integer; //(ES 000426) Changed FLastDim to FLastDim

    (* Beim gefalteten Zustand kann ein Text als Infiormation ntzlich sein *)
    FCaption : TCaption;
    FCaptionFont : TFont;

    (* Folding, Einschalten, Ausschalten des Foldings *)
    FFolding : Boolean;

    (* Controll ob es ein FoldClick war *)
    FIsFoldClick : Boolean;

    (*  Events zum Folding *)
    FOnFoldClick : TFoldClickEvent;
    FBeforeExpand,
    FAfterExpand,
    FBeforeCollaps,
    FAfterCollaps : TNotifyEvent;

    //(ESU 000426)
    FOrientation : TFoldOrientation;

    //(CB 11.04.2000)
    //--- This property is to true if the mouse button has been pushed and not released...
    FMouseIsDown: Boolean;

    (* Property Proceduren *)
    function GetControl(Index: Integer): TControl;
    function GetControlCount: Integer;
    function GetComponent(AIndex: Integer): TComponent;
    function GetComponentCount: Integer;
    procedure setFoldStatus(value : TFoldStatus);
    function GetExpandGlyph: TBitmap;
    procedure SetExpandGlyph(Value: TBitmap);
    function GetCollapsGlyph: TBitmap;
    procedure SetCollapsGlyph(Value: TBitmap);
    procedure setInfoCaption(value : TCaption);
    procedure SetCaptionFont(Value: TFont);
    function StoreCaptionFont : Boolean;
    procedure SetFolding(Value : Boolean);
    function StoreExpandGlyph : Boolean;
    function StoreCollapsGlyph : Boolean;
    function GetBevelStyle(index : Integer) : TPanelBevel;
    procedure SetBevelStyle(index : Integer; Value : TPanelBevel);
    function GetBevelWidth(index : Integer) : TBevelWidth;
    procedure SetBevelWidth(index : Integer; Value : TBevelWidth);
    procedure SetLineStyle(Value: TBevelStyle);
    procedure SetSeperated(Value: Boolean);
    procedure SetFoldPosition(Value : TFoldPosition);
    procedure SetFoldActiveColor(Value : TColor);
    function getCollapsedHeight : Integer;
    function getCollapsedWidth : Integer; //(ESU 000426)
    procedure SetOrientation(Value : TFoldOrientation); //(ESU 000426)

    {surfacing events}
    procedure FClick(Sender : TObject);
    procedure FDblClick(Sender : TObject);
    procedure FDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure FDragOver(Sender, Source: TObject; X, Y: Integer;
                        State: TDragState; var Accept: Boolean);
    procedure FEndDrag(Sender, Target: TObject; X, Y: Integer);
    procedure FEnter(Sender : TObject);
    procedure FExit(Sender : TObject);
    procedure FKeyDown(Sender : TObject; var Key: Word; Shift: TShiftState);
    procedure FKeyPress(Sender : TObject; var Key: Char);
    procedure FKeyUp(Sender : TObject; var Key: Word; Shift: TShiftState);
    procedure FStartDrag(Sender : TObject; var DragObject: TDragObject);

    procedure FMouseDown(Sender: TObject; Button : TMouseButton;
                         Shift: TShiftState;X, Y: Integer);
    procedure FMouseUp(Sender: TObject; Button : TMouseButton;
                         Shift: TShiftState;X, Y: Integer);
    procedure FMouseMove(Sender: TObject; Shift: TShiftState;X, Y: Integer);

    {Procedures}
    function MakeLocalPoint(Control: TControl; X, Y: integer): TPoint;
    procedure DrawGlyph;
    procedure SetClientWindowBounds;
     procedure LoadDefaultGlyph(foldState : TFoldStatus); // (ES 000426)

    (* Message handler *)
    procedure WMLButtonUp(var Message: TWMLButtonUp); message WM_LBUTTONUP;
    procedure WMLButtonDown(var Message: TWMLButtonDown); message WM_LBUTTONDOWN;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
  {$IFDEF DELPHI3}
     procedure CMControlChange(var Message: TMessage); message CM_CONTROLCHANGE;
  {$ELSE}
    procedure CMControlChange(var Message: TMessage); message CM_CONTROLLISTCHANGE;
  {$ENDIF}

   {Bitmap Changes}
   procedure OnExpandGlyphChange(Sender : TObject);
   procedure OnCollapsGlyphChange(Sender : TObject);

   {Timer Event  (ESU 000426)}
   procedure OnMouseTimer(Sender : TObject);

  protected
    { Protected-Deklarationen }
    procedure CreateActiveGlyph(source, dest : TBitmap);
    procedure Paint; override;
    (* Wir haben einen Click auf die Fold elemente entdeckt,
        also reagieren wir darauf *)
    procedure FoldClick; dynamic;
    (* Streaming der nicht Pulished Eigenschaften, des ClientPanels*)
   {$IFDEF DELPHI3}
     procedure GetChildren(Proc: TGetChildProc; Root: TComponent); override;
   {$ELSE}
     procedure GetChildren(Proc: TGetChildProc); override;
   {$ENDIF}
    procedure Click; override;
    procedure SetChildOrder(Child: TComponent; Order: Integer); override;
    function GetBitmap : TBitmap;
    procedure SetBitmap(Value : TBitmap);
    function GetBitmapHolder : TBitmapHolder;
    procedure SetBitmapHolder(Value : TBitmapHolder);

  public
    { Public-Deklarationen }
    constructor create(AOwner : TComponent); override;
    destructor destroy; override;
    {Liefert das Clients fenster Zurck indem die Elemente Plaziert sind }
    function GetClientWindow : TCustomControl;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
    procedure setBounds(ALeft, ATop, AWidth, AHeight : Integer); override;

    {Liefert die Taborder}
    procedure GetTabOrderList(List: TList); override;

    function isCollapsed : Boolean;
    function isExpanded : Boolean;
    procedure Collaps;
    procedure Expand;

    {Controls auf dem Panel}
    property Controls[Index: Integer]: TControl read GetControl;
    property ControlCount: Integer read GetControlCount;
    property Components[Index: Integer]: TComponent read GetComponent;
    property ComponentCount: Integer read GetComponentCount;

  published
    { Published-Deklarationen }
    property Align;
    property BevelInner : TPanelBevel index 1 read GetBevelStyle write SetBevelStyle;
    property BevelOuter : TPanelBevel index 2 read GetBevelStyle write SetBevelStyle;
    property BevelWidth : TBevelWidth index 1 read GetBevelWidth write SetBevelWidth;
    property BorderWidth;
    property BorderStyle;
    property ClientBevelInner : TPanelBevel index 3 read GetBevelStyle write SetBevelStyle;
    property ClientBevelOuter : TPanelBevel index 4 read GetBevelStyle write SetBevelStyle;
    property ClientBevelWidth : TBevelWidth index 2 read GetBevelWidth write SetBevelWidth;
    property DragCursor;
    property DragMode;
    property Enabled;
    property FullRepaint;
    property Color;
    property Ctl3D;
    property Font;
    property Locked;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Visible;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnResize;
    property OnStartDrag;

    property FoldStatus : TFoldStatus read FFoldStatus write setFoldStatus default fsExpanded;
    property Folding : Boolean read FFolding write setFolding default true;
    property Caption : TCaption  read FCaption write setInfoCaption;
    property CaptionFont : TFont read FCaptionFont write SetCaptionFont stored StoreCaptionFont;
    property GlyphExpand : TBitmap read GetExpandGlyph write SetExpandGlyph stored StoreExpandGlyph;
    property GlyphCollaps : TBitmap read GetCollapsGlyph write SetCollapsGlyph stored StoreCollapsGlyph;
    property Seperated : Boolean read FSeperated write SetSeperated stored true default true;
    property SeperatorLineStyle : TBevelStyle read FLineStyle write SetLineStyle stored true default bsLowered;
    property FoldPosition : TFoldPosition read FFoldPosition write SetFoldPosition default fpLeftTop;
    property FoldActiveColor : TColor read FFoldActiveColor write SetFoldActiveColor default clAqua;
    property Orientation : TFoldOrientation read FOrientation write SetOrientation default foVertical; //(ESU 000426)

    {Events}
    property OnFoldClick: TFoldClickEvent read FOnFoldClick write FOnFoldClick;
    property BeforeExpand: TNotifyEvent read FBeforeExpand write FBeforeExpand;
    property AfterExpand: TNotifyEvent read FAfterExpand write FAfterExpand;
    property BeforeCollaps: TNotifyEvent read FBeforeCollaps write FBeforeCollaps;
    property AfterCollaps: TNotifyEvent read FAfterCollaps write FAfterCollaps;

    property Bitmap : TBitmap read GetBitmap write SetBitmap;
    property BitmapHolder : TBitmapHolder read GetBitmapHolder write SetBitmapHolder;

    property CollapsedHeight : Integer read getCollapsedHeight;
    property CollapsedWidth  : Integer read getCollapsedWidth; // (ESU 000426)
  end;


procedure Register;

implementation
  {$R *.RES}

//---(ESU 000426)-------------------------------
resourcestring
  sEXPAND_V  = 'EXPAND_V';
  sCOLLAPS_V = 'COLLAPS_V';
  sEXPAND_H  = 'EXPAND_H';
  sCOLLAPS_H = 'COLLAPS_H';

procedure RegisterTimer; forward;
procedure UnregisterTimer; forward;
procedure RequestTimer(eventFunc : TNotifyEvent); forward;
procedure ReleaseTimer; forward;
//-------------------------------

procedure Register;
begin
  RegisterComponents('sarcon', [TFoldPanel]);
end;

function Rechteck(Left, Top, Right, Bottom : Integer) : TRect;
begin
    Result.Left := Left; Result.Top := Top;
    Result.Right := Right; Result.Bottom := Bottom;
end;

procedure TFoldPanelClient.setBounds(ALeft, ATop, AWidth, AHeight : Integer);
begin
   if NoFolding then
     inherited setBounds(ALeft, ATop, AWidth, AHeight)
   else begin
     // (ESU 000426)
     if Assigned(FFoldPanel) then begin
       case FFoldPanel.Orientation of
         foVertical : begin
            case FoldPanel.FoldPosition of
              fpLeftTop, fpLeftBottom :
                       inherited setBounds(MyDiff, ATop, AWidth - ABS(ALeft - MyDiff), AHeight);
              fpRightTop, fpRightBottom :
                       inherited setBounds(ALeft, ATop, AWidth - MyDiff, AHeight);
            end;
         end;

         foHorizontal : begin
            case FoldPanel.FoldPosition of
              fpLeftTop, fpRightTop :
                       inherited setBounds(ALeft, MyDiff, AWidth, AHeight - ABS(ATop - MyDiff));
              fpLeftBottom, fpRightBottom :
                       inherited setBounds(ALeft, ATop, AWidth, AHeight - MyDiff);
            end;
         end;
       end;
     end else
       Inherited setBounds(ALeft, ATop, AWidth, AHeight);
     // ------Till here --------
   end;
end;

constructor TFoldPanelClient.Create(AOwner : TComponent);
begin
    inherited Create(AOwner);
    ControlStyle := [csAcceptsControls, csCaptureMouse, csClickEvents,
                     csSetCaption, csOpaque, csDoubleClicks, csReplicatable];
    MyDiff := 0;
    NoFolding := false;
    FFoldPanel := NiL;
    Align := alClient;
end;

constructor TFoldPanel.create(AOwner : TComponent);
begin
     inherited create(AOwner);

     FClientWindow := TFoldPanelClient.Create(self);
     with FClientWindow do
     begin
       FFoldPanel  := self; {first this}
       Parent      := self;
       OnClick     := FCLick;
       OnDblCLick  := FDblCLick;
       OnDragDrop  := FDragDrop;
       OnDragOver  := FDragOver;
       OnEndDrag   :=  FEndDrag;
       OnEnter     := FEnter;
       OnExit      := FExit;
       OnKeyDown   := FKeyDown;
       OnKeyUp     := FKeyUp;
       OnKeyPress  := FKeyPress;
       OnMouseDown := FMouseDown;
       OnMouseMove := FMouseMove;
       OnMouseUp   := FMouseUp;
       OnStartDrag := FStartDrag;
       BevelInner  := bvNone;
       BevelOuter  := bvNone;
     end;

     ControlStyle           := ControlStyle - [csSetCaption]; {csAcceptsControls];}
     FStoreExpandGlyph      := true;
     FStoreCollapsGlyph     := true;
     FExpandGlyph           := TBitmap.Create;
     FExpandGlyph.OnChange  := OnExpandGlyphChange;
     FCollapsGlyph          := TBitmap.Create;
     FCollapsGlyph.OnChange := OnCollapsGlyphChange;
     FActiveExpandGlyph     := TBitmap.Create;
     FActiveCollapsGlyph    := TBitmap.Create;
     FCaptionFont           := TFont.Create;
     {Wenn der Font verndert wird bitte auch  StoreCaptionFont anpassen}
     FCaptionFont.Name      := 'Small Fonts';
     FCaptionFont.Size      := 7;
     FFolding               := true;
     FSeperated             := true;
     FFoldBtnDown           := false;
     FIsFoldClick           := false;
     FDimLock               := false;
     FFoldActiveColor       := clAqua;
     FLastDim               := height;
     FOrientation           := foVertical;
     FFoldStatus            := fsCollapsed; {Damit auch setFoldStatus beim ersten mal funktioniert }
     {!! call this After setting Orientation !!!}
     setExpandGlyph(nil);
     setCollapsGlyph(nil);
     setFoldStatus(fsExpanded);
     RegisterTimer; // (ESU 000426)
end;

destructor TFoldPanel.destroy;
begin
    FClientWindow.Free;
    FExpandGlyph.Free;
    FCollapsGlyph.Free;
    FActiveExpandGlyph.Free;
    FActiveCollapsGlyph.Free;
    FCaptionFont.Free;
    UnregisterTimer; // (ESU 000426)
    inherited destroy;
end;

procedure TFoldPanelClient.Paint;
begin
    Canvas.Brush.Color := Color;
//(ESU 000426)    Canvas.FillRect(ClientRect);
    inherited Paint;
end;

(***************************************************
 *
 *  Message Handler
 *
 ***************************************************)

procedure TFoldPanel.CMControlChange(var Message: TMessage);
var
  Control : TControl;
begin
   (* Ein untergeordnetes Element wird eingefgt,
      aufpassen das die Foldelemente nicht berlagert werden *)
   if Boolean(Message.lParam) then {InsertControl}
   begin
        Control := TControl(Message.wParam);
        if (Control <> FClientWindow) AND (Control.Parent <> FClientWindow) then
        begin
           Self.RemoveControl(Control);
           FClientWindow.InsertControl(Control);
        end;
   end else
      inherited;
end;

procedure TFoldPanel.WMLButtonDown(var Message: TWMLButtonDown);
var
   R : TRect;
begin
     FLastPoint := SmallPointToPoint(Message.Pos);
     if PtInRect(FFoldRect, FLastPoint) then
     begin
        R.left :=  FFoldRect.left + 1; R.Top := FFoldRect.Top + 1;
        R.right :=  FFoldRect.right - 1; R.bottom := FFoldRect.bottom - 1;
        FFoldBtnDown := true;
        Canvas.Pen.Color :=  clBtnShadow;
        Canvas.Rectangle(R.Left + 1, R.Top +1, R.Right, R.Bottom);
        FMouseIsDown:=True;
        Frame3D(Canvas, R, clBtnShadow, clBtnHighlight, 1);
     end;
     inherited;
end;

procedure TFoldPanel.WMLButtonUp(var Message: TWMLButtonUp);
begin
    if FFolding then
   begin
      if not (csDesigning in ComponentState) then
      begin
         (* Schauen wir mal ob wir ein Foldelement erwischt haben *)
          if PtInRect(FFoldRect, FLastPoint) AND
             PtInRect(FFoldRect, SmallPointToPoint(Message.Pos)) then
                     FIsFoldClick := true;

          FMouseIsDown:=False;
          if FFoldBtnDown then
          begin
             DrawGlyph;
             FFoldBtnDown := false;
          end;
      end;
   end;
   inherited;
end;

procedure TFoldPanel.MouseMove(Shift: TShiftState; X, Y: Integer);
var
  doit : Boolean;
  R: TRect;
begin
   (* Zum einfrben der Foldelemente, aktivierungs anzeige und so weiter ...*)
  doit := true;
  if FFolding then
  begin
       if PtInRect(FFoldRect, Point(X, Y)) then
       begin
          case FFoldStatus of
            fsExpanded :  if FCurrBmp = FActiveCollapsGlyph then doit := false
                          else FCurrBmp := FActiveCollapsGlyph;
            fsCollapsed : if FCurrBmp = FActiveExpandGlyph then doit := false
                          else FCurrBmp := FActiveExpandGlyph;
          end;
          RequestTimer(OnMouseTimer);
       end else
       begin
           case FFoldStatus of
            fsExpanded :  if FCurrBmp = FCollapsGlyph then doit := false
                          else FCurrBmp := FCollapsGlyph;
            fsCollapsed : if FCurrBmp = FExpandGlyph then doit := false
                          else FCurrBmp := FExpandGlyph;
           end;

       end;
       if doit then begin
         DrawGlyph;
// (CB 11.04.2000)
//--- If the mouse is down, we have to paint a 3D Frame (if you remove this code, when the mouse
//reenters the control after it has left it, the 3D frame isn't repaint...
         if FMouseIsDown then
         begin
            R.left :=  FFoldRect.left + 1; R.Top := FFoldRect.Top + 1;
            R.right :=  FFoldRect.right - 1; R.bottom := FFoldRect.bottom - 1;
            FFoldBtnDown := true;
            Canvas.Pen.Color :=  clBtnShadow;
            Canvas.Rectangle(R.Left + 1, R.Top +1, R.Right, R.Bottom);
            Frame3D(Canvas, R, clBtnShadow, clBtnHighlight, 1);
         end;
//--- End of add
       end;
  end;

  inherited MouseMove(Shift, X, Y);

end;

// Modifikations (CB 11.04.2000)
procedure TFoldPanel.CMMouseLeave(var Message: TMessage);
//--- "Doit" : Not anymore used : the bitmap must be updated every time the mouse leave
// the control if the control is folding.

(*var
  doit : Boolean;*)
begin
(*   doit := true;*)
   if FFolding then
   begin
(*     case FFoldStatus of
       fsExpanded :  if FCurrBmp = FCollapsGlyph then doit := false
                     else FCurrBmp := FCollapsGlyph;
       fsCollapsed : if FCurrBmp = FExpandGlyph then doit := false
                     else FCurrBmp := FExpandGlyph;
      end;
*)
      DrawGlyph;
(*      if doit then DrawGlyph;*)
  end;
  inherited;
end;

procedure TFoldPanel.Paint;
begin

   inherited Paint;

   if FFolding then begin
     case FFoldStatus of
       fsExpanded : FCurrBmp := FCollapsGlyph;
       fsCollapsed : begin
            FCurrBmp := FExpandGlyph;
               if (BevelInner = bvNone) AND (BevelOuter = bvNone) then
               begin
                 Canvas.Pen.Color := clBtnShadow;
                 Canvas.Rectangle(-1, -1, Width, Height);
                 Canvas.Pen.Color := clBtnHighlight;
                 Canvas.Rectangle(0, 0, Width + 1, Height + 1);
               end;
         end;
     end;
     DrawGlyph;
   end;
end;

(***************************************************
 *
 *  Methods
 *
 ***************************************************)

function TFoldPanel.GetBitmap : TBitmap;
begin Result := FClientWindow.Bitmap;
end;

procedure TFoldPanel.SetBitmap(Value : TBitmap);
begin FClientWindow.Bitmap := Value;
end;

function TFoldPanel.GetBitmapHolder : TBitmapHolder;
begin Result := FClientWindow.BitmapHolder;
end;

procedure TFoldPanel.SetBitmapHolder(Value : TBitmapHolder);
begin FClientWindow.BitmapHolder := Value;
end;

// Modification made by Bartosz Dzido <bdzido@ely.pga.gda.pl>
// are Marked with (BD 31.03.2000)
procedure TFoldPanel.SetBounds(ALeft, ATop, AWidth, AHeight : Integer);
var LastDimLock : Boolean; // (BD 31.03.2000)
begin
   (* Wird die Gre gendert paen wir auch FLastDim an damit
     wir nach dem entfalten auch die richtige Gre herstellen *)
  if FFoldStatus = fsExpanded then  begin
    // (ESU 000426)
    case FOrientation of
     foVertical   : FLastDim :=  AHeight;
     foHorizontal : FLastDim :=  AWidth;
    end;
   // ---- Till Here ---
  end;

  // (ESU 000426)
  if FDimLock then begin
      case FOrientation of
       foVertical   : AHeight := Self.Height;
       foHorizontal : AWidth :=  Self.Width;
      end;
   // ---- Till Here ---
  end;

  LastDimLock := FDimLock; // (BD 31.03.2000)
  FDimLock := true;            // (BD 31.03.2000)

  inherited SetBounds(ALeft, ATop, AWidth, AHeight);

  FDimLock := LastDimLock; // (BD 31.03.2000)
end;

{$IFDEF DELPHI3}
procedure TFoldPanel.GetChildren(Proc: TGetChildProc; Root: TComponent);
{$ELSE}
procedure TFoldPanel.GetChildren(Proc: TGetChildProc);
{$ENDIF}
var
  I: Integer;
  Control: TControl;
begin
  with FClientWindow do
  begin
     for I := 0 to ControlCount - 1 do
     begin
       Control := Controls[I];
       if Control.Parent = FClientWindow then Proc(Control);
     end;
  end;
end;

procedure TFoldPanel.SetChildOrder(Child: TComponent; Order: Integer);
begin
     FClientWindow.SetChildOrder(Child, Order);
     inherited SetChildOrder(Child, Order);
end;

procedure TFoldPanel.Click;
begin
    if FIsFoldClick then begin FoldClick;  FIsFoldClick := false; end
    else inherited Click;
end;
 
procedure TFoldPanel.FoldClick;
var
   DoAction : Boolean;
begin
     DoAction := True;
     if Assigned(FOnFoldClick) then OnFoldClick(self, FFoldStatus, DoAction);

     if DoAction then begin
        case FFoldStatus of
            fsExpanded :  setFoldStatus(fsCollapsed);
            fsCollapsed : setFoldStatus(fsExpanded);
        end;
     end;
end;

function TFoldPanel.GetClientWindow : TCustomControl;
begin Result := FClientWindow;
end;

procedure TFoldPanel.GetTabOrderList(List: TList);
begin FClientWindow.GetTabOrderList(List);
end;

function TFoldPanel.MakeLocalPoint(Control: TControl;
                                       X, Y: integer): TPoint;
{ this function takes a coordinate relative to some arbitrary }
{ control and returns a coordinate relative to self }
begin
  Result.X := X;
  Result.Y := Y;
  Result := ScreenToClient(Control.ClientToScreen(Result));
end;

procedure TFoldPanel.SetClientWindowBounds;
var
   rect : TRect;
begin
   // (ESU 000426)
   FClientWindow.MyDiff :=  0;
   if Assigned(FCurrBmp) then begin
     case FOrientation of
      foVertical   : FClientWindow.MyDiff := FCurrBmp.Width;
      foHorizontal : FClientWindow.MyDiff := FCurrBmp.Height;
     end;
   end;
   // --- Till Here ---
   if BevelInner <> bvNone then Inc(FClientWindow.MyDiff, BevelWidth);
   if BevelOuter <> bvNone then Inc(FClientWindow.MyDiff, BevelWidth);
   if FFolding and FSeperated then Inc(FClientWindow.MyDiff, 2);

   rect := Bounds(0, 0, Width, Height);
   AlignControls(FClientWindow, rect);
end;

procedure TFoldPanel.DrawGlyph;
var
   dy, th, cl, deg : Integer;
   r, d : TRect;

   procedure IncRect(VAR rect : TRect; n : Integer);
   begin
       case FFoldPosition of
          fpLeftTop :
             begin
                  INC(rect.Left, n);  INC(rect.Top, n);
                  INC(rect.Right, n); INC(rect.Bottom, n);
             end;
          fpLeftBottom :
             begin
                  INC(rect.Left, n);  DEC(rect.Top, n);
                  INC(rect.Right, n); DEC(rect.Bottom, n);
             end;
          fpRightTop:
             begin
                  DEC(rect.Left, n);  INC(rect.Top, n);
                  DEC(rect.Right, n); INC(rect.Bottom, n);
             end;

          fpRightBottom :
             begin
                  DEC(rect.Left, n);  DEC(rect.Top, n);
                  DEC(rect.Right, n); DEC(rect.Bottom, n);
             end;
       end;
   end;

   procedure BevelLine(C: TColor; X1, Y1, X2, Y2: Integer);
   begin
     with Canvas do
     begin
       Pen.Color := C;
       MoveTo(X1, Y1);
       LineTo(X2, Y2);
     end;
   end;

   procedure Seperator;
   var
      Color1, Color2: TColor;
      l : TRect;
   begin
       with Canvas do
       begin
          if FLineStyle = bsLowered then
          begin
            Color1 := clBtnShadow;
            Color2 := clBtnHighlight;
          end
          else
          begin
            Color1 := clBtnHighlight;
            Color2 := clBtnShadow;
          end;

          // (ESU 000426)
          case FOrientation of
            foVertical : begin
              case FFoldPosition of
                fpLeftTop:     l := Rechteck( d.right, d.top, d.right, Height - d.top);
                fpLeftBottom : l := Rechteck( d.right, Height - d.Bottom, d.right, d.bottom);
                fpRightTop:    l := Rechteck( d.left, d.top, d.left, Height - d.top);
                fpRightBottom: l := Rechteck( d.left, Height - d.Bottom, d.left, d.bottom);
              end;
              BevelLine(Color1, l.left, l.top, l.right, l.bottom);
              BevelLine(Color2, l.left+1, l.top, l.right+1, l.bottom);
            end;

            foHorizontal : begin
              case FFoldPosition of
                fpLeftTop:     l := Rechteck( d.left, d.bottom, Width-d.left, d.bottom);
                fpLeftBottom : l := Rechteck( d.left, d.top, width-d.left, d.top);
                fpRightTop:    l := Rechteck( Width-d.right, d.bottom, d.right, d.bottom);
                fpRightBottom: l := Rechteck( Width-d.right, d.top, d.right, d.top);
              end;
              BevelLine(Color2, l.left, l.top, l.right, l.bottom);
              BevelLine(Color1, l.left, l.top-1, l.right, l.bottom-1);
            end;
          end;
          // --- Till Here ---
       end;
   end;

   // (ESU 000426)
   //  Yes we Rotate the Text using A True Type Font
   procedure TextRotate(const S: string; x,y, deg : integer);
   var
      LogFont : tLogFont;
      oldFont : TFont;
   begin
      oldFont := self.Canvas.Font;
      GetObject(oldFont.handle, sizeof(tLogFont),@Logfont);
      Logfont.lfEscapement := deg * 10;
      Logfont.lfOrientation := Logfont.lfEscapement;
      Logfont.lfOutPrecision := OUT_TT_ONLY_PRECIS;   // We need TrueType Fonts
      self.Canvas.Font.handle := CreateFontIndirect(logfont);
      Self.Canvas.textout(x,y,S);
      DeleteObject(self.Canvas.Font.handle);
      self.Canvas.Font := oldFont;
   end;
   // --------- Till Here ------------

begin
   r.left := 0; r.top := 0; r.bottom := FCurrBmp.height; r.right := FCurrBmp.width;
   // (ESU 000426)
   d := r;
   case FOrientation of
     foVertical : begin
         case FFoldPosition of
              fpLeftTop : ;
              fpLeftBottom :
                  begin
                       d.top    := Self.Height - (r.top + r.Bottom);
                       Inc(d.bottom, d.top);
                  end;
              fpRightTop:
                  begin
                      d.left := Self.Width - (r.left + r.right);
                      INC(d.right, d.left);
                  end;
              fpRightBottom :
                  begin
                      d.left := Self.Width - (r.left + r.right);
                      d.top := Self.Height - (r.top + r.Bottom);
                      INC(d.right, d.left);
                      Inc(d.bottom, d.top);
                  end;
           end;
      end;

     foHorizontal : begin
         case FFoldPosition of
              fpLeftTop : ;
              fpLeftBottom :
                  begin
                       d.Top  := Self.Height - (r.top + r.Bottom);
                       Inc(d.bottom, d.top);
                  end;
              fpRightTop:
                  begin
                      d.left := Self.Width - (r.left + r.right);
                      INC(d.right, d.left);
                  end;
              fpRightBottom :
                  begin
                      d.left := Self.Width - (r.left + r.right);
                      d.top := Self.Height - (r.top + r.Bottom);
                      INC(d.right, d.left);
                      Inc(d.bottom, d.top);
                  end;
           end;
      end;
   end;
   // -----Till Here -----

   {IncRect Arbeitet je nach FoldPosition, bei linke Seite wird addiert,
    bei der Rechten Seite subtrahiert}
   if BevelInner <> bvNone then IncRect(d, BevelWidth);
   if BevelOuter <> bvNone then IncRect(d, BevelWidth);

   Canvas.BrushCopy(d, FCurrBmp, r, FCurrBmp.TransparentColor);

   {Zeichne trennlinie}
    if FFolding AND FSeperated then Seperator;

   {Setze FoldRect }
   FFoldRect := d;

   if (FFoldStatus = fsCollapsed) AND (FCaption <> '') then
   begin
        Canvas.Font.Assign(FCaptionFont);
        th := Canvas.TextHeight(FCaption);
        // (ESU 000426)
        case FOrientation of
          foVertical : begin
            if  th > d.bottom then  dy := 0
            else dy := d.top + ((d.bottom - th) DIV 2);
            cl := 0;
            case FFoldPosition of
               fpLeftTop, fpLeftBottom : cl :=  d.right + 10;
               fpRightTop, fpRightBottom : cl := d.left - (Canvas.TextWidth(FCaption) + 10);
            end;
            Canvas.TextOut(cl, dy, FCaption);

           end;
          foHorizontal : begin
            cl := 0;
            dy := 0;
            deg := 270;
            case FFoldPosition of
               fpLeftTop, fpRightTop   : begin
                 cl  := d.Right;
                 if  th < d.right then
                      cl := d.left + ((d.right + th) DIV 2);
                  dy  := d.Bottom + 10;
                  deg := 270;
                 end;
               fpLeftBottom, fpRightBottom : begin
                 if  th < d.right then
                      cl := d.left + ((d.right - th) DIV 2);
                  dy  := d.Top - 10;
                  deg := 90;
                 end;
            end;
            TextRotate(FCaption, cl, dy, deg);
          end;
        end;
        // ------- Till Hereee ----------
   end;
end;

(***************************************************
 *
 *  Property Methods
 *
 ***************************************************)

function TFoldPanel.GetControl(Index: Integer): TControl;
begin Result := FClientWindow.Controls[Index];
end;

function TFoldPanel.GetControlCount: Integer;
begin Result := FClientWindow.ControlCount;
end;

function TFoldPanel.GetComponent(AIndex: Integer): TComponent;
begin Result := FClientWindow.Components[AIndex];
end;

function TFoldPanel.GetComponentCount: Integer;
begin Result := FClientWindow.ComponentCount;
end;

function TFoldPanel.GetBevelStyle(index : Integer) : TPanelBevel;
begin
    Result := bvNone;
    case index of
       1: Result := inherited BevelInner;
       2: Result := inherited BevelOuter;
       3 : Result := FClientWindow.BevelInner;
       4 : Result := FClientWindow.BevelOuter;
    end;
end;

procedure TFoldPanel.SetBevelStyle(index : Integer; Value : TPanelBevel);
begin
    case index of
       1: begin
              if inherited BevelInner <> Value then
              begin
                  inherited BevelInner := Value;
                  SetClientWindowBounds;
              end;
          end;
       2: begin
               inherited BevelOuter := Value;
               SetClientWindowBounds;
          end;
       3 : begin
                if FClientWindow.BevelInner <> Value then
                   FClientWindow.BevelInner := Value;
           end;
       4 : begin
                if FClientWindow.BevelOuter <> Value then
                   FClientWindow.BevelOuter := Value;
           end;
    end;
end;

function TFoldPanel.GetBevelWidth(index : Integer) : TBevelWidth;
begin
  case index of
   1 : Result := inherited BevelWidth;
   2 : Result := FClientWindow.BevelWidth;
   else Result := inherited BevelWidth;
  end;
end;

procedure TFoldPanel.SetBevelWidth(index : Integer; Value : TBevelWidth);
begin
   case index of
     1: begin
           if inherited BevelWidth <> Value then
           begin
               inherited BevelWidth := Value;
               SetClientWindowBounds;
           end;
        end;
     2 : begin
           if FClientWindow.BevelWidth <> Value then
               FClientWindow.BevelWidth := Value;
         end;
   end;
end;

procedure TFoldPanel.SetLineStyle(Value: TBevelStyle);
begin
     if FLineStyle <> Value then
     begin
         FLineStyle := Value;
         if FFolding then Invalidate;
     end;
end;

procedure TFoldPanel.SetSeperated(Value: Boolean);
begin
     if FSeperated <> Value then
     begin
         FSeperated := Value;
         if FFolding then Invalidate;
     end;
end;

procedure TFoldPanel.SetFoldPosition(Value : TFoldPosition);
var
   rect : TRect;
begin
    if FFoldPosition <> Value then
    begin
        FFoldPosition := Value;
        if FFolding then begin
           rect := Bounds(0, 0, Width, Height);
           AlignControls(FClientWindow, rect);
           Invalidate;
        end;
    end;
end;

procedure TFoldPanel.SetFoldActiveColor(Value : TColor);
begin
   if FFoldActiveColor <> Value then
   begin
     FFoldActiveColor := value;
     CreateActiveGlyph(FExpandGlyph, FActiveExpandGlyph);
     CreateActiveGlyph(FCollapsGlyph, FActiveCollapsGlyph);
    end;
end;

//(ESU 000426)
procedure TFoldPanel.SetOrientation(Value : TFoldOrientation);
var doIt : Boolean;
begin
  if Value <> FOrientation then begin
     case Value of
       foVertical   : FLastDim := Height;
       foHorizontal : FLastDim := Width;
     end;
     doIt := false;
     if FFoldStatus = fsCollapsed then begin
       FoldStatus := fsExpanded;
       doIt := true;
     end;

     FOrientation := Value;
     if Not FStoreExpandGlyph then
           LoadDefaultGlyph(fsExpanded);
     if Not FStoreCollapsGlyph then
           LoadDefaultGlyph(fsCollapsed);

     if doIt then begin
       FoldStatus := fsCollapsed;
     end;

     SetClientWindowBounds;
  end;
end;

function TFoldPanel.getCollapsedHeight : Integer;
begin
  Result := MINIMUM_COLLAPS_SIZE;
  if Assigned(FExpandGlyph) then begin
    // (ESU 000426)
    case FOrientation of
      foVertical   : Result := FExpandGlyph.Height;
      foHorizontal : Result := Self.Height;
    end;
    //--TILL HERE
  end;
  if Result < MINIMUM_COLLAPS_SIZE then
     Result := MINIMUM_COLLAPS_SIZE;
end;

// (ESU 000426)
function TFoldPanel.getCollapsedWidth : Integer;
begin
  Result := MINIMUM_COLLAPS_SIZE;
  if Assigned(FExpandGlyph) then begin
    case FOrientation of
      foVertical   : Result := Self.Width;
      foHorizontal : Result := FExpandGlyph.Width;
    end;
  end;
  if Result < MINIMUM_COLLAPS_SIZE then
     Result := MINIMUM_COLLAPS_SIZE;
end;
//--TILL HERE

procedure TFoldPanel.CreateActiveGlyph(source, dest : TBitmap);
var
   r : TRect;
   BlueScreen : TBitmap;
begin

   dest.Assign(source);
   r := Rechteck(0, 0, dest.Width, dest.Height);

   BlueScreen := TBitmap.Create;
   with BlueScreen DO begin
        Width := r.right;
        Height := r.bottom;
        Canvas.Brush.Color := FFoldActiveColor;
        Canvas.FillRect(r);
   end;

   WITH dest.Canvas DO BEGIN
     copymode := cmSrcAnd;
     CopyRect(r, BlueScreen.Canvas,r);
   END;
   BlueScreen.Free;
end;

function TFoldPanel.GetExpandGlyph: TBitmap;
begin
  Result := FExpandGlyph;
end;

procedure TFoldPanel.SetExpandGlyph(Value: TBitmap);

begin
   if Assigned(value) then
   begin
     FExpandGlyph.Assign(Value);
     FStoreExpandGlyph := true;
  end else
    LoadDefaultGlyph(fsExpanded); // (ES 000426)
end;

function TFoldPanel.GetCollapsGlyph: TBitmap;
begin
  Result := FCollapsGlyph;
end;

procedure TFoldPanel.SetCollapsGlyph(Value: TBitmap);
begin
  if Assigned(value) then
  begin
     FCollapsGlyph.Assign(Value);
     FStoreCollapsGlyph := true;
 end else
    LoadDefaultGlyph(fsCollapsed); // (ES 000426)

end;

procedure TFoldPanel.SetFolding(Value: Boolean);
begin
  if FFolding <> Value then
  begin
       FFolding := Value;
       if NoT(value) then
       begin
        FClientWindow.NoFolding := true;
        if (FFoldStatus = fsCollapsed) then
          setFoldStatus(fsExpanded)
       end else begin
          FClientWindow.NoFolding := false;
          Invalidate;
       end;
  end;
end;

procedure TFoldPanel.setFoldStatus(value : TFoldStatus);
var  w, h, x : Integer;
begin
   if (NoT(FFolding) OR (csDesigning in ComponentState))
      AND (value = fsCollapsed) then Exit;

   FCurrBmp := nil;
   if value <>  FFoldStatus then begin
     case value of
       fsExpanded : begin
           if Assigned(FBeforeExpand) then FBeforeExpand(self);
           FFoldStatus := value;
           FDimLock := false;
           FCurrBmp := FCollapsGlyph;
          // (ESU 000426)
           case FOrientation of
             foVertical : begin
                 w := Width;
                 h := FLastDim;
                 case FFoldPosition of
                   fpLeftTop, fpRightTop :
                      SetBounds(Left, Top, w, h);
                   fpLeftBottom, fpRightBottom :
                      SetBounds(Left, Top - (h - Height), w, h);
                 end;
               end;
             foHorizontal : begin
                 h := Height;
                 w := FLastDim;
                 case FFoldPosition of
                   fpLeftTop, fpLeftBottom :
                      SetBounds(Left, Top, w, h);
                   fpRightTop, fpRightBottom :
                      SetBounds(Left-(w-width), Top, w, h);
                 end;
               end;
           end;

          // -------- Till Here ------
           SetClientWindowBounds;
           FClientWindow.Visible := true;
          end;
       fsCollapsed : begin
          if Assigned(FBeforeCollaps) then FBeforeCollaps(self);
          FFoldStatus := value;
          FClientWindow.Visible := False;
          FCurrBmp := FExpandGlyph;
          // (ESU 000426)
          x := 0;
          case FOrientation of
            foVertical   : x := getCollapsedHeight;
            foHorizontal : x := getCollapsedWidth;
          end;

          if BorderStyle = bsSingle then Inc(x, 2);
          if BevelInner <> bvNone   then Inc(x, BevelWidth * 2);
          if BevelOuter <> bvNone   then Inc(x, BevelWidth * 2);
          
          case FOrientation of
            foVertical   : begin
                w := Width;
                h := x;
                case FFoldPosition of
                   fpLeftTop, fpRightTop  :
                      SetBounds(Left, Top, w, h);
                   fpLeftBottom, fpRightBottom :
                      SetBounds(Left, (Top + Height) - h, w, h);
                end;
              end;
            foHorizontal : begin
                w := x;
                h := Height;
                case FFoldPosition of
                   fpLeftTop, fpLeftBottom :
                      SetBounds(Left, Top, w, h);
                   fpRightTop, fpRightBottom :
                      SetBounds(Left+Width-w, Top, w, h);
                end;
              end;
          end;
          // ------ Till Here ----
          FDimLock := true;
        end;
     end;
     FFoldRect := Bounds(0, 0, FCurrBmp.width, FCurrBmp.height);
     invalidate;

     case value of
       fsExpanded  : if Assigned(FAfterExpand) then AfterExpand(self);
       fsCollapsed : if Assigned(FAfterCollaps) then AfterCollaps(self);
     end;
   end;
end;

procedure TFoldPanel.setInfoCaption(value : TCaption);
begin
     if Value <> FCaption then
     begin
         FCaption := Value;
          if not (csDesigning in ComponentState) then invalidate;
     end;
end;

procedure TFoldPanel.SetCaptionFont(Value: TFont);
begin
    FCaptionFont.Assign(Value);
end;

function  TFoldPanel.StoreCaptionFont : Boolean;
var
   tmpf : tFont;
begin
     tmpf := TFont.Create;
     tmpf.Name := 'Small Fonts';
     tmpf.Size := 7;

     Result := {$IFDEF DELPHI3} (FCaptionFont.Charset = tmpf.Charset) AND {$ENDIF}
               (FCaptionFont.Color  = tmpf.Color) AND
               (FCaptionFont.Height = tmpf.Height) AND
               (FCaptionFont.Name   = tmpf.Name) AND
               (FCaptionFont.Pitch  = tmpf.Pitch) AND
               (FCaptionFont.Size   = tmpf.Size) AND
               (FCaptionFont.Style  = tmpf.Style);
     Result := Not(Result);
end;

function TFoldPanel.StoreExpandGlyph : Boolean;
begin Result := FStoreExpandGlyph;
end;

function TFoldPanel.StoreCollapsGlyph : Boolean;
begin  Result := FStoreCollapsGlyph;
end;

{Surfaced Events}
procedure TFoldPanel.FClick(Sender: TObject);
begin
 if Assigned(OnClick) then OnClick(Self);
end;

procedure TFoldPanel.FDblClick(Sender: TObject);
begin
 if Assigned(OnDblClick) then OnDblClick(Self);
end;

procedure TFoldPanel.FDragDrop(Sender, Source: TObject; X, Y: Integer);
var
  Pt: TPoint;
begin
  Pt := MakeLocalPoint(Sender as TControl, X, Y);
  if Assigned(OnDragDrop) then OnDragDrop(Self, Source, Pt.X, Pt.Y);
end;

procedure TFoldPanel.FDragOver(Sender, Source: TObject; X, Y: Integer;
                         State: TDragState; var Accept: Boolean);
var
  Pt: TPoint;
begin
  Pt := MakeLocalPoint(Sender as TControl, X, Y);
  if Assigned(OnDragOver) then OnDragOver(Self, Source, Pt.X, Pt.Y, State, Accept);
end;

procedure TFoldPanel.FEndDrag(Sender, Target: TObject; X, Y: Integer);
var
  Pt: TPoint;
begin
  Pt := MakeLocalPoint(Sender as TControl, X, Y);
  if Assigned(OnEndDrag) then OnEndDrag(Self, Target, Pt.X, Pt.Y);
end;

procedure TFoldPanel.FEnter(Sender : TObject);
begin
      if Assigned(OnEnter) then OnEnter(Self);
end;

procedure TFoldPanel.FExit(Sender : TObject);
begin
      if Assigned(OnExit) then OnExit(Self);
end;

procedure TFoldPanel.FKeyDown(Sender : TObject; var Key: Word; Shift: TShiftState);
begin
     if Assigned(OnKeyDown) then OnKeyDown(Self, Key, Shift);
end;
procedure TFoldPanel.FKeyPress(Sender : TObject; var Key: Char);
begin
   if Assigned(OnKeyPress) then OnKeyPress(Self, Key);
end;

procedure TFoldPanel.FKeyUp(Sender : TObject; var Key: Word; Shift: TShiftState);
begin
     if Assigned(OnKeyUp) then OnKeyUp(Self, Key, Shift);
end;

procedure TFoldPanel.FMouseDown(Sender: TObject; Button: TMouseButton;
                                    Shift: TShiftState; X, Y: Integer);
{ OnMouseDown handler  Resurfaces event. }
var
  Pt: TPoint;
begin
  Pt := MakeLocalPoint(Sender as TControl, X, Y);
  if Assigned(OnMouseDown) then OnMouseDown(Self, Button, Shift, Pt.X, Pt.Y);
end;

procedure TFoldPanel.FMouseUp(Sender: TObject; Button: TMouseButton; Shift:
                                 TShiftState; X, Y: Integer);
{ OnMouseUp handler.  Resurfaces event. }
var
  Pt: TPoint;
begin
  Pt := MakeLocalPoint(Sender as TControl, X, Y);
  if Assigned(OnMouseUp) then OnMouseUp(Self, Button, Shift, Pt.X, Pt.Y);
end;

procedure TFoldPanel.FMouseMove(Sender: TObject; Shift: TShiftState;
                                   X, Y: Integer);
{ OnMouseMove handler,  Resurfaces event. }
var
  Pt: TPoint;
begin
  Pt := MakeLocalPoint(Sender as TControl, X, Y);
  if Assigned(OnMouseMove) then OnMouseMove(Self, Shift, Pt.X, Pt.Y);
end;

procedure TFoldPanel.FStartDrag(Sender : TObject; var DragObject: TDragObject);
begin
   if Assigned(OnStartDrag) then OnStartDrag(Self, DragObject);
end;


function TFoldPanel.isCollapsed : Boolean;
begin Result := FFoldStatus = fsCollapsed;
end;

function TFoldPanel.isExpanded : Boolean;
begin Result := FFoldStatus = fsExpanded;
end;

procedure TFoldPanel.Collaps;
begin  setFoldStatus(fsCollapsed);
end;

procedure TFoldPanel.Expand;
begin setFoldStatus(fsExpanded);
end;

procedure TFoldPanel.LoadDefaultGlyph(foldState : TFoldStatus);
var s    : String;
    glyph, activeGlyph : TBitmap;
begin

  glyph := NiL; activeGlyph := NiL;
  
  case foldState of
    fsExpanded : begin
       case FOrientation of
         foVertical   : s := sEXPAND_V;
         foHorizontal : s := sEXPAND_H;
       end;
       glyph := FExpandGlyph;
       activeGlyph := FActiveExpandGlyph;
       FStoreExpandGlyph := false;
    end;
    fsCollapsed : begin
       case FOrientation of
         foVertical   : s := sCOLLAPS_V;
         foHorizontal : s := sCOLLAPS_H;
       end;
       glyph := FCollapsGlyph;
       activeGlyph := FActiveCollapsGlyph;
       FStoreCollapsGlyph := false;
    end;
  end;

  glyph.LoadFromResourceName(HInstance, s);
  CreateActiveGlyph(glyph, activeGlyph);
end;

procedure TFoldPanel.OnExpandGlyphChange(Sender : TObject);
begin
  if FExpandGlyph.Empty then
     // (ES 000426)
     LoadDefaultGlyph(fsExpanded);
  SetClientWindowBounds;
  Invalidate;
end;

procedure TFoldPanel.OnCollapsGlyphChange(Sender : TObject);
begin

  if FCollapsGlyph.Empty then
      LoadDefaultGlyph(fsCollapsed); // (ES 000426)

  SetClientWindowBounds;
  Invalidate;
end;

procedure TFoldPanel.OnMouseTimer(Sender : TObject);
var
  P: TPoint;
begin
  GetCursorPos (P);
  if FindDragTarget(P, True) <> Self then begin
    ReleaseTimer;
    Invalidate;
  end;
end;


{Timer Functions  //(ESU 000426)}
var
  {Timer for MousePosition Checks if Active Glyph Drawed}
  Timer4Mouse    : TTimer;
  ReferenceCount : Integer;

procedure RegisterTimer;
begin Inc(ReferenceCount);
end;

procedure UnregisterTimer;
begin
 Dec(ReferenceCount);
 if (ReferenceCount<1) then begin // sicher ist sicher :)
    ReferenceCount := 0;
    if Assigned(Timer4Mouse) then begin
       Timer4Mouse.Free; Timer4Mouse := NiL;
    end;
 end;
end;

procedure RequestTimer(eventFunc : TNotifyEvent);
begin
  if Assigned(Timer4Mouse) then begin
    if Timer4Mouse.Enabled AND Assigned(Timer4Mouse.OnTimer) then
       Timer4Mouse.OnTimer(NiL);
  end else begin
    Timer4Mouse := TTimer.Create(NiL);
    Timer4Mouse.Interval := 300;
  end;
  Timer4Mouse.Enabled := false;
  Timer4Mouse.OnTimer := eventFunc;
  Timer4Mouse.Enabled := true;
end;

procedure ReleaseTimer;
begin
  Timer4Mouse.Enabled := false;
  Timer4Mouse.OnTimer := NiL;
end;

initialization
  Timer4Mouse     := NiL;
  ReferenceCount  := 0;
finalization
  if Assigned(Timer4Mouse) then Timer4Mouse.Free;
end.
