unit FormInfo;

interface
uses
  Windows, Messages, SysUtils, Classes, Controls, Forms,Registry;

type
  TFormInfo = class(TComponent)
  private
    { Private declarations }
    FCompany       : string;
    FSectionName   : string;
    FAppName       : string;
    FAutomatic     : boolean;
  protected
    { Protected declarations }
  public
    { Public declarations }
  published
    { Published declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Loaded; override;
    Procedure Load; {Get the app position from registry, use defaults if necessary}
    Procedure Save; {Save the app position to registry}
    property AutoLoad : boolean read FAutomatic write FAutomatic default true;
    Property Company : string read FCompany write FCompany;
    Property AppName : string read FAppName write FAppName;
    Property FormName: string read FSectionName write FSectionName;
  end;

procedure Register;

implementation

constructor TFormInfo.Create(AOwner: TComponent);
begin
   inherited CREATE(Aowner);
   FSectionName := AOwner.Name;
   FCompany     := 'Delphi Developer';
   FAppName     := '';
   FAutomatic   := True;
End;

destructor TFormInfo.Destroy;
begin
  inherited Destroy;
end;

procedure TFormInfo.Loaded;
begin
   if (not (csDesigning in ComponentState)) and FAutomatic then Load;
end;

procedure TFormInfo.Load;
var FFileName : string;
begin
     FFileName := ExtractFileName(Application.Exename);
     if FAppName = '' then
        FAppName := Copy(FFileName,1, Length(FFileName)-4);
     if FSectionName = '' then FSectionName := Owner.name;
     if FCompany = '' then FCompany := 'Delphi Developer';
     with TRegINIFile.Create('Software\'+FCompany+'\'+FAppName) do begin
          with TForm(Owner) do begin
               Width  := ReadInteger(FSectionName,'Width',Width);
               Height := ReadInteger(FSectionName,'Height',Height);
               Left   := ReadInteger(FSectionName,'Left',Left);
               Top    := ReadInteger(FSectionName,'Top',Top);
               if ReadBool(FSectionName,'WindowState',(WindowState=wsNormal)) then
                  WindowState := wsNormal
               else
                   WindowState := wsMaximized;
          end;
          Free;
     end;
end;

procedure TFormInfo.Save;
var FFileName : string;
begin
     FFileName := ExtractFileName(Application.Exename);
     if FAppName = '' then
        FAppName := Copy(FFileName,1, Length(FFileName)-4);
     if FSectionName = '' then FSectionName := Owner.name;
     if FCompany = '' then FCompany := 'Delphi Developer';
     with TRegINIFile.Create('Software\'+FCompany+'\'+FAppName) do begin
          with TForm(Owner) do begin
               WriteBool(FSectionName,'WindowState',(WindowState=wsNormal));
               WriteInteger(FSectionName,'Top',Top);
               WriteInteger(FSectionName,'Left',Left);
               WriteInteger(FSectionName,'Width',Width);
               WriteInteger(FSectionName,'Height',Height);
          end;
          Free;
     end;
end;

procedure Register;
begin
  RegisterComponents('Thomas', [TFormInfo]);
end;

end.
