unit MinMax;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TMinMaxOptions = set of (moMinW,moMaxW,moMinH,moMaxH);
  TMinMax = class(TComponent)
  private

    //Proc Pointers
    OldWndProc : TFarProc;
    NewWndProc : Pointer;

    //MinMax Size Property values
    FMinW  : Integer;
    FMinH  : Integer;
    FMaxW  : Integer;
    FMaxH  : Integer;

    //Design Time setting of MinMax size properties
    FDTProp : TMinMaxOptions;

    procedure HookParent;
    procedure UnhookParent;

    procedure HookWndProc(var Message: TMessage);
  protected
    { Protected declarations }
  public
    constructor Create(AOwner:TComponent); override;
    destructor  Destroy; override;
  published
    property MinWidth:Integer  Read FMinW Write FMinW;
    property MaxWidth:Integer  Read FMaxW Write FMaxW;
    property MinHeight:Integer Read FMinH Write FMinH;
    property MaxHeight:Integer Read FMaxH Write FMaxH;

    property DTOptions:TMinMaxOptions read fdtProp write FdtProp;
  end;

procedure Register;

implementation

constructor TMinMax.Create(AOwner:TComponent);
Begin
     Inherited Create(AOwner);

     NewWndProc := NIL;
     OldWndProc := NIL;

     //If ComponentState<>[csDesigning] Then
        HookParent;
End;

destructor TMinMax.Destroy;
begin
     UnhookParent;
     inherited Destroy;
end;

procedure TMinMax.HookParent;
begin
     // Exit if parent doesn't exist
     if (Owner As TWinControl) = NIL then exit;

     //Install Hook
     OldWndProc := TFarProc(GetWindowLong((Owner As TWinControl).Handle, GWL_WNDPROC));
     NewWndProc := MakeObjectInstance(HookWndProc);
     SetWindowLong((Owner As TWinControl).Handle, GWL_WNDPROC, LongInt(NewWndProc));
end;

procedure TMinMax.UnhookParent;
begin
     if ((Owner As TWinControl)<>NIL) and Assigned(OldWndProc) then
        SetWindowLong((Owner As TWinControl).Handle, GWL_WNDPROC, LongInt(OldWndProc));
     if assigned(NewWndProc) then
        FreeObjectInstance(NewWndProc);

     NewWndProc := NIL;
     OldWndProc := NIL;
end;

procedure TMinMax.HookWndProc(var Message: TMessage);
begin
     if (Owner As TWinControl) = NIL then
        exit;

     With Message Do
     Begin
          Result := CallWindowProc(OldWndProc, (Owner As TWinControl).Handle, Msg, wParam, lParam);

          If (Msg=WM_SIZE) And (ComponentState=[csDesigning]) Then
          Begin
               If moMinW In FdtProp Then
                  FMinW := (Owner As TWinControl).Width;
               If moMaxW In FdtProp Then
                  FMaxW := (Owner As TWinControl).Width;
               If moMinH In FdtProp Then
                  FMinH := (Owner As TWinControl).Height;
               If moMaxH In FdtProp Then
                  FMaxH := (Owner As TWinControl).Height;
          End;

          If ComponentState=[csDesigning] Then
             Exit;  // Don't modify anything at Design Time

          //Handle the WM_GETMINMAXINFO message
          If (Msg = WM_GETMINMAXINFO) Then
          Begin
               With PMinMaxInfo(Message.lParam)^ do
               Begin
                    If (FMinW>0) Then
                       ptMinTrackSize.X := FMinW;

                    If (FMaxW>0) Then
                       ptMaxTrackSize.X := FMaxW;

                    If (FMinH>0) Then
                       ptMinTrackSize.Y := FMinH;

                    If (FMaxH>0) Then
                       ptMaxTrackSize.Y := FMaxH;
               End;
          End;

     End;
end;

procedure Register;
begin
  RegisterComponents('System', [TMinMax]);
end;

end.
