{
 Program    : Find and Replace
 Version    : 1.1 Freeware
 Author     : Tom van Breukelen

 Module     : PgmQuery.Pas
 Description: Form in which the Find and Replace options are defined
}

unit PgmQuery;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TFQuery = class(TForm)
    Panel1     : TPanel;
    Label1     : TLabel;
    Label2     : TLabel;
    Edit1      : TEdit;
    Edit2      : TEdit;
    Button1    : TButton;             {Find/Replace}
    Button2    : TButton;
    GroupBox1: TGroupBox;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    procedure FormActivate(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    WholeWords : boolean;
    IgnoreCase : boolean;
    Prompt     : boolean;
    Backup     : boolean;
    FindOnly   : boolean;
    FindText   : string;
    ReplaceText: string;
  end;

var
  FQuery: TFQuery;

implementation

{$R *.DFM}

procedure TFQuery.FormActivate(Sender: TObject);
begin
  if FindOnly then
  begin
    Edit2.Enabled     := false;
    CheckBox3.Enabled := false;
    CheckBox4.Enabled := false;
    Button1.Caption   := '&Find';
    Button1.Hint      := 'Find the text in every selected file';
  end;
end;

procedure TFQuery.Edit1Change(Sender: TObject);
begin
  Button1.Enabled := Edit1.Text <> '';
  if Button1.Enabled and (FindOnly = False) then Edit2Change(Self);
end;

procedure TFQuery.Edit2Change(Sender: TObject);
begin
  if Button1.Enabled and CheckBox1.Checked then
  Button1.Enabled := Edit1.Text <> Edit2.Text;
end;

procedure TFQuery.Button1Click(Sender: TObject);
begin
  IgnoreCase  := not CheckBox1.Checked;
  WholeWords  := CheckBox2.Checked;
  Backup      := CheckBox3.Checked;
  Prompt      := CheckBox4.Checked;
  FindText    := Edit1.Text;
  ReplaceText := Edit2.Text;
end;

end.
