unit FindDialogs;

{**********************************************************}
{                                                          }
{  TFindFilesDialog & TFindComputerDialog Unit             }
{  Copyright 1999 Workshell Software.                     }
{							   }
{  Version 1.0						   }
{                                                          }
{                                                          }
{  Web      -> http://www.workshell.uni.cc/                }
{  E - Mail -> finddlgs@kinsella.u-net.com                 }
{                                                          }
{**********************************************************}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ShlObj;

type
  TFindFilesDialog = class(TComponent)
  private
    { Private declarations }
  protected
    { Protected declarations }
  public
    { Public declarations }
    function Execute: Boolean;
    function ExecuteEx(pidlRoot, pidlSavedSearch: PItemIDList): Boolean;
  published
    { Published declarations }
  end;

type
  TFindComputerDialog = class(TComponent)
  private
    { Private declarations }
  protected
    { Protected declarations }
  public
    { Public declarations }
    function Execute: Boolean;
    function ExecuteEx(pidlRoot, pidlSavedSearch: PItemIDList): Boolean;
  published
    { Published declarations }
  end;

procedure Register;

implementation

function SHFindFiles(pidlRoot: PItemIDList; pidlSavedSearch: PItemIDList): Boolean;
 stdcall; external 'Shell32.dll' index 90;

function SHFindComputer(pidlRoot: PItemIDList; pidlSavedSearch: PItemIDList): Boolean;
 stdcall; external 'Shell32.dll' index 91;

function TFindFilesDialog.Execute: Boolean;
begin
Result := SHFindFiles(nil,nil);
end;

function TFindFilesDialog.ExecuteEx(pidlRoot, pidlSavedSearch: PItemIDList): Boolean;
begin
Result := SHFindFiles(pidlRoot,pidlSavedSearch);
end;

function TFindComputerDialog.Execute: Boolean;
begin
Result := SHFindComputer(nil,nil);
end;

function TFindComputerDialog.ExecuteEx(pidlRoot, pidlSavedSearch: PItemIDList): Boolean;
begin
Result := SHFindComputer(pidlRoot,pidlSavedSearch);
end;

procedure Register;
begin
  RegisterComponents('Dialogs', [TFindFilesDialog,TFindComputerDialog]);
end;

end.
