unit FILTER_SU;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	Grids,DB, DBTables, DBGrids, StdCtrls, Buttons, ExtCtrls, Menus;

type
	TFILTER_SU_W = class(TForm)
		StringGrid1: TStringGrid;
    Panel1: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure StringGrid1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
	private
		{ Private-Deklarationen }
		FUNCTION TRIM(S:String):STRING;
		function SUBSTR(INP:STRING;VON:INTEGER;ANZ:INTEGER):STRING;
		function Vorgabe(Value:String):String;
	public
		{ Public-Deklarationen }
		FDATASET:TDataSet;
		S:INTEGER;
		Parent :TComponent;
		procedure SETDATA;
	end;

var
	FILTER_SU_W: TFILTER_SU_W;

implementation

{$R *.DFM}

USES
	FILTER_MA;
	
FUNCTION TFILTER_SU_W.TRIM(S:String):STRING;
VAR
	I,A,E:INTEGER;
BEGIN
	I:=LENGTH(S);
	IF I>0 THEN
		BEGIN
			A:=1;
			WHILE (A<I)AND(S[A]=' ') DO
				A:=A+1;
			E:=I;
			WHILE (E>1)AND(S[E]=' ') DO
				E:=E-1;
			IF A>E THEN
				TRIM:=''
			ELSE
				IF (A=E)AND(S[A]=' ') THEN
					TRIM:=''
				ELSE
					TRIM:=COPY(S,A,E-A+1);
		END
	ELSE
		 TRIM:='';
END;

function TFILTER_SU_W.SUBSTR(INP:STRING;VON:INTEGER;ANZ:INTEGER):STRING;
VAR
	HILF:STRING;
	X:INTEGER;
	L:INTEGER;
BEGIN
	L:=LENGTH(INP);
	HILF:='';
	FOR X:=1 to ANZ DO
		HILF:=HILF+' ';
	IF (ANZ > 0) AND (VON > 0) THEN
		FOR X:=1 TO ANZ DO
			IF VON+x-1 > L THEN
				HILF[X] :=' '
			ELSE
				HILF[X]:=INP[VON+X-1];
	Result :=HILF;
END;

function TFILTER_SU_W.Vorgabe(Value:String):String;
VAR
	F:STRING;
	X:INTEGER;
BEGIN
	RESULT:='';
	IF NOT TTABLE(FDATASET).FILTERED THEN EXIT;
	F:=TTABLE(FDATASET).FILTER;
	X:=POS(UPPERCASE(VALUE),UPPERCASE(F));
	IF X>0 THEN
		BEGIN
			X:=X+LENGTH(Value)+1;
			F:=TRIM(SUBSTR(F,X,LENGTH(F)));
			IF POS(#39,F)>0 THEN
				BEGIN
					X:=POS(#39,F)+1;
					F:=TRIM(SUBSTR(F,X,LENGTH(F)));
					IF POS(#39,F)>0 THEN
						BEGIN
							X:=POS(#39,F)-1;
							F:=TRIM(SUBSTR(F,1,X));
							RESULT:=F;
						END;
				END;
		END;
END;

procedure TFILTER_SU_W.SETDATA;
VAR
	X:INTEGER;
	D,V:String;
BEGIN
	S:=0;
	StringGrid1.DefaultColWidth:=StringGrid1.GridWidth;
	StringGrid1.CELLS[0,S]:='Fields';
	StringGrid1.CELLS[1,S]:='Search Value';
	S:=S+1;
	FOR X:=0 TO TTABLE(FDATASET).FIELDCOUNT -1 DO
		BEGIN
			CASE TFilterSearch(Parent).FIELDSTATUS(TTABLE(FDATASET).FIELDS[X].FieldName,D,V) OF
				fstOff:
					BEGIN
						IF TTABLE(FDATASET).FIELDS[X].VISIBLE THEN
							BEGIN
								StringGrid1.ROWCOUNT:=S+1;
								StringGrid1.CELLS[0,S]:=TTABLE(FDATASET).FIELDS[X].DisplayLabel;
								StringGrid1.CELLS[1,S]:=VORGABE(TTABLE(FDATASET).FIELDS[X].FieldName);
								S:=S+1;
						END;
					END;
				fstHide:;
				fstTrue:
					BEGIN
						StringGrid1.ROWCOUNT:=S+1;
						StringGrid1.CELLS[0,S]:=D;
						StringGrid1.CELLS[1,S]:=V;
						S:=S+1;
					END;
				fstFalse:;
				fstVisibleTrue:
					BEGIN
						IF TTABLE(FDATASET).FIELDS[X].VISIBLE THEN
							BEGIN
								StringGrid1.ROWCOUNT:=S+1;
								StringGrid1.CELLS[0,S]:=D;
								StringGrid1.CELLS[1,S]:=V;
								S:=S+1;
						END;
					END;
				fstVisibleFalse:
					BEGIN
						IF NOT TTABLE(FDATASET).FIELDS[X].VISIBLE THEN
							BEGIN
								StringGrid1.ROWCOUNT:=S+1;
								StringGrid1.CELLS[0,S]:=D;
								StringGrid1.CELLS[1,S]:=V;
								S:=S+1;
						END;
					END;
			END;
		END;
	StringGrid1.ColWidths[0]:=(StringGrid1.GridWidth*4) DIV 10;
	StringGrid1.ColWidths[1]:=StringGrid1.GridWidth-StringGrid1.ColWidths[0];
	StringGrid1.COL:=1;
	StringGrid1.ROW:=1;
END;

procedure TFILTER_SU_W.BitBtn1Click(Sender: TObject);
VAR
	X,Y,Z:INTEGER;
	F,H,S,V:STRING;
	K:TFilterSearchType;
	FUNCTION CHR39(S:STRING):STRING;
	VAR
		X:INTEGER;
		H:STRING;
	BEGIN
		H:='';
		FOR X:=1 TO LENGTH(S) DO
			IF SUBSTR(S,X,1)<>#39 THEN
				H:=H+SUBSTR(S,X,1);
		RESULT:=H;
	END;
begin
	F:='';
	FOR X:=1 TO StringGrid1.ROWCOUNT -1 DO
		BEGIN
			IF TRIM(StringGrid1.CELLS[1,X])<>'' THEN
				BEGIN
					H:=TFilterSearch(Parent).FINDFIELD(StringGrid1.CELLS[0,X]);
					IF TRIM(H)<>'' THEN
						BEGIN
							IF LENGTH(F)>0 THEN F:=F+' AND ';
							F:=F+' '+TRIM(H)+' = '''+CHR39(TRIM(StringGrid1.CELLS[1,X]))+''' ';
						END
					ELSE
						BEGIN
							Z:=-1;
							FOR Y:=0 TO TTABLE(FDATASET).FIELDCOUNT -1 DO
								IF TRIM(UPPERCASE(TTABLE(FDATASET).FIELDS[Y].DisplayLabel))=TRIM(UPPERCASE(StringGrid1.CELLS[0,X])) THEN Z:=Y;
							IF Z>-1 THEN
								BEGIN
									IF LENGTH(F)>0 THEN F:=F+' AND ';
									F:=F+' '+TTABLE(FDATASET).FIELDS[Z].FieldName+' = '''+CHR39(TRIM(StringGrid1.CELLS[1,X]))+''' ';
								END;
						END;
				END;
		END;
	X:=0;
	K:=fstOff;
	WHILE K<>fstError DO
		BEGIN
			K:=TFilterSearch(Parent).GetStatus(X,S,V);
			IF K=fstHide THEN
				BEGIN
					IF LENGTH(F)>0 THEN F:=F+' AND ';
					F:=F+' '+S+' = '''+CHR39(V)+''' ';

				END;
			X:=X+1;
		END;
	TRY
		TTABLE(FDATASET).FILTER:=F;
		TTABLE(FDATASET).FILTERED:=(TRIM(F)<>'');
	EXCEPT
		MessageDlg('Error: '+Exception(ExceptObject).Message,mtError,[mbOK],0);
		EXIT;
	END;
	FILTER_SU_W.CLOSE;
end;

procedure TFILTER_SU_W.BitBtn2Click(Sender: TObject);
begin
	FILTER_SU_W.CLOSE;
end;

procedure TFILTER_SU_W.StringGrid1KeyDown(Sender: TObject; var Key: Word;
	Shift: TShiftState);
begin
	IF KEY=13 THEN BitBtn1Click(Sender);
end;

end.
