//The is a component to control the filter of a TTabel
//If you make changes send me a copy to jcc@megabug.de
//IF you use this component in comercial then send me 10 Euro for using.
//Bank:
//		 Sparkasse in Bremen
//		 BLZ  290 50 101
//		 Kto.  10 69 012
//You can change this component where you want, but not this text !
//
//
//
unit FILTER_MA;

interface

uses
	SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
	Forms, Dialogs, FileCtrl, DB, DBTables, DBGrids, Grids;

TYPE
	TFilterSearchType = (fstOff,fstTrue,fstFalse,fstVisibleTrue,fstVisibleFalse,fstHide,fstError);

	TFilterSearchMerk = class(TComponent)
	private
		{ Private-Deklarationen }
		IType:TFilterSearchType;
		IFieldName:String;
		IDisplayName:String;
		IValue:String;
	protected
		{ Protected-Deklarationen }
	public
		{ Public-Deklarationen }
		constructor Create(AOwner : TComponent); override;
		destructor Destroy; override;
	published
		{ Published-Deklarationen }
		property UsesType:TFilterSearchType read IType write IType;
		property FieldName:String	read IFieldName write IFieldName;
		property DisplayName:String read IDisplayName write IDisplayName;
		property Value:String read IValue write IValue;
	end;

	TFilterSearch = class(TComponent)
	private
		{ Private-Deklarationen }
		FDataSet:TDataSet;
		MERK:TList;
		procedure SetDataSet(ADataSet: TDataSet);
	protected
		{ Protected-Deklarationen }
	public
		{ Public-Deklarationen }
		constructor Create(AOwner : TComponent); override;
		destructor Destroy; override;
		procedure Search;
		procedure add(UsesType:TFilterSearchType;FieldName:String;DisplayName:String;Value:String);
		Function FIELDSTATUS(FieldName:String;VAR DisplayName:String;VAR Value:String):TFilterSearchType;
		Function FINDFIELD(DisplayName:String):STRING;
		Function GetStatus(NR:INTEGER;VAR FieldName:String;VAR Value:String):TFilterSearchType;
		Procedure Clear;
	published
		{ Published-Deklarationen }
		property DataSet: TDataSet read FDataSet write SetDataSet;
	end;

procedure Register;

implementation

USES
	FILTER_SU;

{$R FILTER_MA.RES}

{###########################################################################}
{###########################################################################}
{###########################################################################}
{###########################################################################}
constructor TFilterSearchMerk.Create(AOwner : TComponent);
BEGIN
	inherited Create(AOwner);
	IType:=fstOff;
	IFieldName:='';
	IDisplayName:='';
	IValue:='';
END;
{###########################################################################}
destructor TFilterSearchMerk.Destroy;
BEGIN
	inherited Destroy;
END;
{###########################################################################}
{###########################################################################}
constructor TFilterSearch.Create(AOwner : TComponent);
BEGIN
	inherited Create(AOwner);
	MERK:=TLIST.CREATE;
	FDataSet:=NIL;
END;
{###########################################################################}
destructor TFilterSearch.Destroy;
VAR
	H:TLIST;
BEGIN
	WHILE MERK.COUNT>0 DO
		BEGIN
			H:=MERK[0];
			MERK.DELETE(0);
			H.FREE;
		END;
	MERK.Free;
	inherited Destroy;
END;
{###########################################################################}
procedure TFilterSearch.SetDataSet(ADataSet: TDataSet);
BEGIN
	IF ADataSet=NIL THEN FDataSet:=NIL;
	IF NOT ASSIGNED(ADataSet) THEN EXIT;
	IF NOT (ADataSet IS TTABLE) THEN
		BEGIN
			FDataSet:=NIL;
			EXIT;
		END;
	FDataSet:=ADataSet;
END;
{###########################################################################}
procedure TFilterSearch.Search;
BEGIN
	IF FDataSet=NIL THEN EXIT;
	IF NOT ASSIGNED(FDataSet) THEN EXIT;
	IF NOT TTABLE(FDATASET).ACTIVE THEN EXIT;
	TRY
		APPLICATION.CreateForm(TFILTER_SU_W,FILTER_SU_W);
		FILTER_SU_W.FDataSet:=FDataSet;
		FILTER_SU_W.Parent:=Self;
		FILTER_SU_W.SETDATA;
		FILTER_SU_W.SHOWMODAL;
	FINALLY
		FILTER_SU_W.Release;
	END;
END;
{###########################################################################}
Procedure TFilterSearch.Clear;
VAR
	H:TLIST;
BEGIN
	WHILE MERK.COUNT>0 DO
		BEGIN
			H:=MERK[0];
			MERK.DELETE(0);
			H.FREE;
		END;
END;
{###########################################################################}
procedure TFilterSearch.add(UsesType:TFilterSearchType;FieldName:String;DisplayName:String;Value:String);
VAR
	H:TFilterSearchMerk;
BEGIN
	H:=TFilterSearchMerk.Create(SELF);
	H.UsesType:=UsesType;
	H.FieldName:=FieldName;
	H.DisplayName:=DisplayName;
	H.Value:=Value;
	MERK.Add(H);
END;
{###########################################################################}
Function TFilterSearch.GetStatus(NR:INTEGER;VAR FieldName:String;VAR Value:String):TFilterSearchType;
BEGIN
	RESULT:=fstError;
	FieldName:='';
	Value:='';
	IF NR<0 THEN EXIT;
	IF NR>(MERK.COUNT-1)THEN EXIT;
	RESULT:=TFilterSearchMerk(MERK[NR]).UsesType;
	FieldName:=TFilterSearchMerk(MERK[NR]).FieldName;
	Value:=TFilterSearchMerk(MERK[NR]).Value;
END;
{###########################################################################}
Function TFilterSearch.FINDFIELD(DisplayName:String):STRING;
VAR
	X:INTEGER;
BEGIN
	RESULT:='';
	DisplayName:=UPPERCASE(TRIM(DisplayName));
	IF MERK.COUNT=0 THEN EXIT;
	FOR X:=0 TO MERK.COUNT-1 DO
		IF UPPERCASE(TRIM(TFilterSearchMerk(MERK[X]).DisplayName))=DisplayName THEN
			RESULT:=TFilterSearchMerk(MERK[X]).FieldName;
END;
{###########################################################################}
Function TFilterSearch.FIELDSTATUS(FieldName:String;VAR DisplayName:String;VAR Value:String):TFilterSearchType;
VAR
	X:INTEGER;
BEGIN
	RESULT:=fstOff;
	DisplayName:='';
	Value:='';
	FieldName:=UPPERCASE(TRIM(FieldName));
	IF MERK.COUNT=0 THEN EXIT;
	FOR X:=0 TO MERK.COUNT-1 DO
		IF UPPERCASE(TRIM(TFilterSearchMerk(MERK[X]).FieldName))=FieldName THEN
			BEGIN
				RESULT:=TFilterSearchMerk(MERK[X]).UsesType;
				DisplayName:=TFilterSearchMerk(MERK[X]).DisplayName;
				Value:=TFilterSearchMerk(MERK[X]).Value;
			END;
END;
{###########################################################################}
procedure Register;
begin
	RegisterComponents('JCC', [TFilterSearch]);
end;

end.
