unit TEST_A1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  FileIterator, StdCtrls;

type
  TMainForm = class(TForm)
    ListBox: TListBox;
    Iterator: TFileIterator;
    StartBtn: TButton;
    CancelBtn: TButton;
    Label1: TLabel;
    lblCount: TLabel;
    procedure IteratorActivate(Sender: TObject);
    procedure IteratorTerminate(Sender: TObject);
    procedure IteratorAddFile(Sender: TObject; const FileName: string;
      const FileInfo: TFileInfo);
    procedure StartBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure IteratorAddFileQuery(Sender: TObject; const FileName: string;
      const FileInfo: TFileInfo; var CanAdd: Boolean);
  private
    FFileCount :Integer;
    procedure UpdateControls;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.IteratorActivate(Sender: TObject);
begin
  with ListBox do
   begin
    Clear;
    Items.BeginUpdate;
    FFileCount := 0;
   end;
  UpdateControls;
end;

procedure TMainForm.IteratorTerminate(Sender: TObject);
begin
 with ListBox do
  begin
    Items.EndUpdate;
  end;
 UpdateControls;
end;

procedure TMainForm.IteratorAddFile(Sender: TObject;
  const FileName: string; const FileInfo: TFileInfo);
begin
 ListBox.Items.Add( FileName );
 inc( FFileCount );
 UpdateControls;
end;

procedure TMainForm.UpdateControls;
begin
 with lblCount do Caption := IntToHex( FFileCount , 8 );
 StartBtn.Enabled := Iterator.Status = fsIdle;
 CancelBtn.Enabled := Iterator.Status <> fsIdle;
end;

procedure TMainForm.StartBtnClick(Sender: TObject);
begin
 TFileIteratorThread.Create( Iterator, false );
 UpdateControls;
end;

procedure TMainForm.CancelBtnClick(Sender: TObject);
begin
 Iterator.Cancel;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  UpdateControls;
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if Iterator.Status = fsActive then
   begin
     Iterator.Cancel;  // cancel operation
     while ( Iterator.Status <> fsIdle ) do sleep( 200 );  // give some time to complete
   end;
end;

procedure TMainForm.IteratorAddFileQuery(Sender: TObject;
  const FileName: string; const FileInfo: TFileInfo; var CanAdd: Boolean);
begin
 CanAdd := UpperCase( ExtractFileExt( FileName ) ) = '.EXE'; 
end;

end.
