(*

   TDriveList Component
   Version 1.00.00
   (C)  1996, Glen Why. No rights reserved.

*)
unit DriveList;

interface
uses
  Windows, SysUtils, Classes;

type

  TDriveType = ( dtUnknown, dtInvalid, dtRemovable,
   dtFixed, dtRemote, dtCDROM, dtRAM );

  TDriveList = class( TComponent )
  private
    FCount :Longint;
    FDrives :String;
    procedure GetDrives;
    function GetDriveCount :Integer;
    function GetDriveType( index :integer ):TDriveType;
    function GetDriveName( index :integer ):String;
  public
    constructor Create( anOwner :TComponent ); override;
    property DriveCount :Integer
      read GetDriveCount;
    property DriveType[ index :integer ] :TDriveType
      read GetDriveType;
    property Drives[ index :integer ] :String
      read GetDriveName;
  end;

implementation

constructor TDriveList.Create( anOwner :TComponent );
begin
  inherited Create( anOwner );
  GetDrives;
end;

procedure TDriveList.GetDrives;
var S, I :Integer;
begin
  FCount := 0;
  S := GetLogicalDriveStrings( 0, nil );
  SetLength( FDrives, S );
  if S = 0 then exit;
  GetLogicalDriveStrings( S, PChar( FDrives ) );
  for i := 1 to S - 1 do
   if FDrives[ i ] = #0 then
     begin
       FDrives[ i ] := ',';
       Inc( FCount );
     end;
end;

function TDriveList.GetDriveCount :Integer;
begin
  GetDrives;
 result := FCount;
end;


function TDriveList.GetDriveType( index :integer ):TDriveType;
begin
  case Windows.GetDriveType( PChar( Drives[ index ] ) ) of
   0 : result := dtUnknown;
   DRIVE_REMOVABLE : result := dtRemovable;
   DRIVE_FIXED : result := dtFixed;
   DRIVE_REMOTE : result := dtRemote;
   DRIVE_CDROM : result := dtCDROM;
   DRIVE_RAMDISK : result := dtRam;
   else result := dtInvalid;
  end;
end;

function TDriveList.GetDriveName( index :integer ):String;
var i :integer;
begin
  if Index >= DriveCount then result := 'error'
   else begin
     result := FDrives;
     for i := 1 to index do Delete( result, 1, Pos( ',', result ) );
     Delete( result, Pos( ',', result ), MaxInt );
   end;
end;


end.
