unit TEST_B1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ComCtrls, Menus, FileIterator, DriveList, Buttons;

type
  TMainForm = class(TForm)
    List: TListView;
    StatusBar: TStatusBar;
    MainMenu: TMainMenu;
    FileItem: TMenuItem;
    ExitItem: TMenuItem;
    ViewItem: TMenuItem;
    RefreshItem: TMenuItem;
    Iterator: TFileIterator;
    DriveList: TDriveList;
    Panel1: TPanel;
    procedure UpdateViewMenu(Sender: TObject);
    procedure RefreshList(Sender: TObject);
    procedure UpdateFileMenu(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ExitItemClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure IteratorActivate(Sender: TObject);
    procedure IteratorTerminate(Sender: TObject);
    procedure IteratorAddFile(Sender: TObject; const FileName: string;
      const FileInfo: TFileInfo);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormDestroy(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    FCounter :Integer;
    FFileList :TStringList;
    procedure ClearFileList;
    procedure UpdateControls;
    procedure FindDuplicates;
    procedure SBtnClick( Sender :TObject );
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

type

TFileInformation = class
 Size :Integer;
 Time :TDateTime;
 Path :String;
 constructor Create( D :TFileInfo; const APath :String );
end;

constructor TFileInformation.Create( D :TFileInfo; const APath :String );
begin
 Size := D.Size;
 try
   Time := FileDateToDateTime( D.Time );
 except
   Time := 0;
 end;
 Path := APath;
end;


procedure TMainForm.UpdateViewMenu(Sender: TObject);
begin
 RefreshItem.Enabled := Iterator.Status = fsIdle;
end;

procedure TMainForm.RefreshList(Sender: TObject);
begin
 if ( Iterator.Status <> fsIdle ) then exit;
 TFileIteratorThread.Create( Iterator, false );
 UpdateControls;
end;

procedure TMainForm.UpdateControls;
begin
 UpdateViewMenu( Self );
 UpdateFileMenu( Self );
end;

procedure TMainForm.UpdateFileMenu(Sender: TObject);
begin
{}
end;

procedure TMainForm.FormCreate(Sender: TObject);
var i , x, y :integer;
begin
 FFileList := TStringList.Create;
 x := 3; y := 3;
 for i := 0 to DriveList.DriveCount - 1 do
  begin
    with TSpeedButton.Create( Panel1) do
     begin
       AllowAllUp := false;
       GroupIndex := 1;
       Caption := DriveList.Drives[ i ];
       Left := X;
       Top := Y;
       Parent := Panel1;
       Visible := true;
       inc( x, Width + 1 );
       OnClick := SBtnClick;
     end;
    ( Panel1.Components[ 0 ] as TSpeedButton ).Down := true;
  end;
 UpdateControls;
end;

procedure TMainForm.ExitItemClick(Sender: TObject);
begin
 Close;
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if ( Iterator.Status = fsActive ) then
   begin
     Iterator.Cancel;
     while Iterator.Status <> fsIdle do Sleep( 100 );
   end;
end;

procedure TMainForm.IteratorActivate(Sender: TObject);
begin
  with List.Items do
   begin
     BeginUpdate;
     Clear;
   end;
  FCounter := 0;
  UpdateControls;
end;

procedure TMainForm.FindDuplicates;

  procedure AddListItem( Index :Integer );
  var A :TListItem;
  begin
   with FFileList do
    begin
      A := List.Items.Add;
      with Objects[ index ] as TFileInformation do
        begin
          A.SubItems.Add( IntToStr( Size ) );
          try
             A.SubItems.Add( DateTimeToStr( Time ) );
          except
             A.SubItems.Add( 'error' );
          end;
          A.SubItems.Add( Path );
        end;
      A.Caption := Strings[ index ];
    end;
   end;


var
 FF :TStringList;
 I, II :Integer;
begin
  FF := TStringList.Create;
  try
    FF.Sorted := true;
    FF.Duplicates := dupError;
    with FFileList do
     for i := 0 to Count - 1 do
      begin
       try
         FF.Add( UpperCase( Strings[ i ] ) );
       except
         AddListItem( I );
         II := FFileList.IndexOf( Strings[ i ] );
         if ( Strings[ II ] <> '' ) then
           begin
             AddListItem( II );
             Strings[ ii ] := '';
           end;
       end;
       Dec( FCounter );
       if ( FCounter mod 10 ) = 0
        then StatusBar.Panels[ 0 ].Text := IntToStr( FCounter );
      end;
  finally
    FF.Free;
  end;
end;

procedure TMainForm.IteratorTerminate(Sender: TObject);
begin
  FindDuplicates;
  with List.Items do EndUpdate;
  UpdateControls;
  ClearFileList;
end;

procedure TMainForm.IteratorAddFile(Sender: TObject;
  const FileName: string; const FileInfo: TFileInfo);
begin
 inc( FCounter );
 if ( FCounter mod 10 ) = 0
   then StatusBar.Panels[ 0 ].Text := IntToStr( FCounter );
 FFileList.AddObject( ExtractFileName( FileName ),
  TFileInformation.Create( FileInfo, ExtractFilePath( FileName ) ) );
end;

procedure TMainForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  CanClose := Iterator.Status = fsIdle;
end;

procedure TMainForm.ClearFileList;
var i :integer;
begin
 with FFileList do
  begin
    for i := 0 to Count - 1 do Objects[ i ].free;
    clear;
  end;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  ClearFIleList;
  FFileList.Free;
end;

procedure TMainForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 if Key = VK_ESCAPE then Iterator.Cancel;
end;


procedure TMainForm.SBtnClick( Sender :TObject );
begin
 Iterator.RootFolder := ( Sender as TSpeedButton ).Caption;
 RefreshList( self );
end;

end.


