{=============================================================================}
{  LsFileExplorer27 Demo1 (version 2.70)                                      }
{=============================================================================}
{
This Demo was compiled by Delphi 5. The DFM files (ie. FileExpl27Demo1Main.dfm
and About,dfm) are saved in binary format instead of its default TextFormat,
thus it will be bachwards compatible with previous versions of Delphi.

If you want to re-compile it under Delphi 4 or 3, just load all files (including
FileExpl27Demo1.dpr, FileExpl27Demo1Main.pas and About.pas) into Delphi's IDE
befor rebuilding it. However, under D3 you'll encounter many error messages,
because some properties on Form1 and Form2 are not available in D3. But don't
worry, just ignore all error messages, then proceed.

The binary DFM files created by D5 can be converted to D5's default text format
by using 'textDFM' option in D5's context menu.

{=============================================================================}


unit FileExpl27Demo1Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ComCtrls, LsFileExplorer27, Menus, Buttons, StdCtrls, FileCtrl;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    EditPath: TEdit;
    View1: TMenuItem;
    Tools1: TMenuItem;
    Help1: TMenuItem;
    Open1: TMenuItem;
    QuickView1: TMenuItem;
    N1: TMenuItem;
    NewFolder1: TMenuItem;
    RenameFolder1: TMenuItem;
    DeleteFolder1: TMenuItem;
    N2: TMenuItem;
    Attribute1: TMenuItem;
    N3: TMenuItem;
    Exit1: TMenuItem;
    LargeIcon1: TMenuItem;
    SmallIcon1: TMenuItem;
    List1: TMenuItem;
    Detail1: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    N4: TMenuItem;
    SelectAll1: TMenuItem;
    Panel1: TPanel;
    StatusBar1: TStatusBar;
    Panel2: TPanel;
    Splitter1: TSplitter;
    BtnExit: TSpeedButton;
    BtnAddFolder: TSpeedButton;
    BtnDeleteFolder: TSpeedButton;
    BtnEditFolder: TSpeedButton;
    BtnPrevLevel: TSpeedButton;
    BtnRefresh: TSpeedButton;
    BtnCut: TSpeedButton;
    BtnCopy: TSpeedButton;
    BtnPaste: TSpeedButton;
    BtnIcon: TSpeedButton;
    BtnSIcon: TSpeedButton;
    BtnList: TSpeedButton;
    BtnDetail: TSpeedButton;
    Label1: TLabel;
    MaskCombo1: TComboBox;
    CbxShowFolder: TCheckBox;
    BtnSearch: TSpeedButton;
    DeleteFiles1: TMenuItem;
    RenameFile1: TMenuItem;
    N5: TMenuItem;
    N6: TMenuItem;
    Refresh1: TMenuItem;
    FindFolderorFiles1: TMenuItem;
    GoTo1: TMenuItem;
    LsDirTree20ShortCuts1: TMenuItem;
    LsFileListView27ShortCuts1: TMenuItem;
    N7: TMenuItem;
    AboutLsFileExplorer271: TMenuItem;
    BtnGoTo: TSpeedButton;
    Label2: TLabel;
    LsDirTree201: TLsDirTree20;
    LsFilelistView271: TLsFilelistView27;
    BtnTreeSize: TSpeedButton;

    procedure SetBtnMenuState(Sender: TObject);
    procedure GetStatistics(Sender: TObject);
    procedure BtnExitClick(Sender: TObject);
    procedure LsFileListView271DblClick(Sender: TObject);
    procedure BtnCutClick(Sender: TObject);
    procedure BtnCopyClick(Sender: TObject);
    procedure BtnPasteClick(Sender: TObject);
    procedure BtnIconClick(Sender: TObject);
    procedure BtnDetailClick(Sender: TObject);
    procedure BtnPrevLevelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CbxShowFolderClick(Sender: TObject);
    procedure BtnGoToClick(Sender: TObject);
    procedure LsFileListView271KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure BtnRefreshClick(Sender: TObject);
    procedure BtnAddFolderClick(Sender: TObject);
    procedure BtnDeleteFolderClick(Sender: TObject);
    procedure BtnEditFolderClick(Sender: TObject);
    procedure LsDirTree20ShortCuts1Click(Sender: TObject);
    procedure LsFileListView27ShortCuts1Click(Sender: TObject);
    procedure AboutLsFileExplorer271Click(Sender: TObject);
    procedure BtnSIconClick(Sender: TObject);
    procedure BtnListClick(Sender: TObject);
    procedure LsFileListView271Click(Sender: TObject);
    procedure LsFileListView271MouseUp(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure MaskCombo1Click(Sender: TObject);
    procedure BtnSearchClick(Sender: TObject);
    procedure LsFileListView271Change(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure DeleteFiles1Click(Sender: TObject);
    procedure RenameFile1Click(Sender: TObject);
    procedure Attribute1Click(Sender: TObject);
    procedure SelectAll1Click(Sender: TObject);
    procedure QuickView1Click(Sender: TObject);
    procedure BtnTreeSizeClick(Sender: TObject);
  private
    { Private declarations }
    CanPaste : Boolean;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses About;



procedure TForm1.FormCreate(Sender: TObject);
var
  CurDir : string;
begin
  CurDir := GetCurrentDir;
  if CurDir <> '' then
  begin
    LsFileListView271.Directory := CurDir;
    LsDirTree201.OpenPath(CurDir);
  end;
  SetBtnMenuState(Sender);
end; //FormCreate

procedure TForm1.SetBtnMenuState(Sender: TObject);
begin
  BtnAddFolder.Enabled := (Assigned(LsDirTree201.Selected)) and
                          (LsDirTree201.Selected.Level > 0);
  BtnDeleteFolder.Enabled := (Assigned(LsDirTree201.Selected)) and
                          (LsDirTree201.Selected.Level > 1);
  BtnEditFolder.Enabled := (Assigned(LsDirTree201.Selected)) and
                          (LsDirTree201.Selected.Level > 1);
  BtnTreeSize.Enabled := (Assigned(LsDirTree201.Selected)) and
                          (LsDirTree201.Selected.Level > 0);
  BtnCut.Enabled := Assigned(LsFileListView271.Selected);
  BtnCopy.Enabled := Assigned(LsFileListView271.Selected);
  BtnPaste.Enabled := (CanPaste = True);
  Cut1.Enabled := Assigned(LsFileListView271.Selected);
  Copy1.Enabled := Assigned(LsFileListView271.Selected);
  Paste1.Enabled := CanPaste = True;
  Open1.Enabled := Assigned(LsFileListView271.Selected);
  QuickView1.Enabled := Assigned(LsFileListView271.Selected);
  DeleteFiles1.Enabled := Assigned(LsFileListView271.Selected);
  RenameFile1.Enabled := Assigned(LsFileListView271.Selected);
  Attribute1.Enabled := Assigned(LsFileListView271.Selected);
end; //SetBtnMenuState

procedure TForm1.GetStatistics(Sender: TObject);
begin
  StatusBar1.Panels[0].Text := '';
  StatusBar1.Panels[1].Text := '';
  with LsFileListView271 do
  begin
    if Selected <> nil then
    begin
      StatusBar1.Panels[0].Text := IntToStr(Items.Count) + ' object(s)  --  ' +
        IntToStr(SelectedNumber) + '  selected ';
      StatusBar1.Panels[1].Text := ' Selected Size = ' +
        FormatFloat('###,##0.00 KB', (SelectedSize/1024)) +
        '( Disk free space: ' +
        FormatFloat('###,### MB', (DriveFreeSpace)) + ' )';
    end
    else begin
      StatusBar1.Panels[0].Text := IntToStr(Items.Count) + ' object(s)';
      StatusBar1.Panels[1].Text := ' Selected Size = 0 KB' +
        '  ( Disk free space: '+
        FormatFloat('###,### MB', (DriveFreeSpace)) + ' )';
    end;
  end;
  EditPath.Text := LsFileListView271.Directory;
end; //GetStatistics

procedure TForm1.BtnAddFolderClick(Sender: TObject);
var
  PNode     : TTreeNode;
  NewFolder : string;
begin
  with LsDirTree201 do
  begin
    NewFolder := '';
    PNode := Selected;
    if Assigned(Selected) then
    begin
//      if not InputQuery('Create New Folder',
//        'Enter the new folder name', NewFolder) then
//        exit;
//      LsDirTree201.AddNewNode(PNode, NewFolder);
      LsDirTree201.AddNewNode(PNode, '');
    end;
  end;
end; //BtnAddFolderClick

procedure TForm1.BtnDeleteFolderClick(Sender: TObject);
begin
  with LsDirTree201 do
  begin
    if (Selected <> nil) and (Assigned(Selected)) then
      DeleteNode(Selected);
  end;
end; //BtnDeleteFolderClick

procedure TForm1.BtnEditFolderClick(Sender: TObject);
begin
  with LsDirTree201 do
  begin
    if (Selected <> nil) and (Assigned(Selected)) then
      Selected.EditText;
  end;
end; //BtnEditFolderClick

procedure TForm1.BtnTreeSizeClick(Sender: TObject);
begin
  if LsDirTree201.Selected <> nil then
    LsDirTree201.GetTreeSize;
end;

procedure TForm1.BtnSearchClick(Sender: TObject);
begin
  LsFileListView271.SetFocus;
  LsFileListView271.FindFile;
end; //BtnSearchClick

procedure TForm1.BtnGoToClick(Sender: TObject);
var
  PathName: string;
begin
  InputQuery('Go to Folder', 'Enter the name and path of the folder to open',
             PathName);
  if (PathName = '') or (Length(PathName) = 1) then exit;
  if PathName[Length(PathName)] <> '\' then
    PathName := PathName + '\';
  if DirectoryExists(PathName) then
  begin
    LsFileListView271.Directory := PathName;
    LsDirTree201.OpenPath(PathName);
  end
  else begin
    if (Length(PathName) <= 3) and (PathName[2] = ':') then
      MessageDlg(UpperCase(PathName) + '  not ready', mtError, [mbOK], 0)
    else
      MessageDlg(PathName + '  not found', mtError, [mbOK], 0);
      exit;
  end;
end; //BtnSearchClick

procedure TForm1.LsFileListView271DblClick(Sender: TObject);
begin
  LsFileListView271.OpenItem;
end; //LsFileListView271DblClick

procedure TForm1.BtnCutClick(Sender: TObject);
begin
  LsFileListView271.CutCopy(2);
  Cut1.Enabled := False;
  CanPaste := True;
  SetBtnMenuState(Sender);
end; //BtnCutClick

procedure TForm1.BtnCopyClick(Sender: TObject);
begin
  LsFileListView271.CutCopy( 0 );
  Copy1.Enabled := False;
  CanPaste := True;
  SetBtnMenuState(Sender);
end; //BtnCopyClick

procedure TForm1.BtnPasteClick(Sender: TObject);
begin
  LsFileListView271.Paste;
  CanPaste := False;
  Cut1.Enabled := True;
  Copy1.Enabled := True;
  SetBtnMenuState(Sender);
end; //BtnPasteClick

procedure TForm1.BtnPrevLevelClick(Sender: TObject);
begin
  LsFileListView271.OneLevelUp;
  SetBtnMenuState(Sender);
end; //BtnPrevLevelClick

procedure TForm1.BtnRefreshClick(Sender: TObject);
var
  TreePath: string;
begin
  with LsDirTree201 do
  begin
    if (Selected <> nil) and  (Assigned(Selected)) then
      TreePath := SelectedPath;
    ReLoad;
    OpenPath(SelectedPath);
    LsFileListView271.Directory := SelectedPath;
    LsFileListView271.UpdateFileList;
  end;
end; //BtnRefreshClick

procedure TForm1.CbxShowFolderClick(Sender: TObject);
begin
  with CBxShowFolder do
  begin
    if Checked = True then
      LsFileListView271.ShowFolders := True
    else
      LsFileListView271.ShowFolders := False;
  end;
end; //CbxShowFolderClick

procedure TForm1.LsFileListView271MouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  GetStatistics(Sender);
end; //LsFileListView271MouseUp

procedure TForm1.LsFileListView271KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Key = VK_Return) or (key = VK_Space) or (Key = VK_BACK) or
     (Key = VK_Up) or (Key = VK_Down)  then
    GetStatistics(Sender);
end; //LsFileListView271KeyUp

procedure TForm1.SelectAll1Click(Sender: TObject);
var
  i: integer;
begin
  if not Assigned(LsFileListView271) then exit;
  with LsFileListView271 do
  begin
    if Items.Count = 0 then exit;
    for i := 0 to Items.Count - 1  do
      Selected := Items[ i ];
  end;
end; //SelectAll1Click

procedure TForm1.LsDirTree20ShortCuts1Click(Sender: TObject);
begin
  AboutForm.PageControl1.ActivePage := AboutForm.TabSheet1;
  AboutForm.ShowModal;
end; //LsDirTree20ShortCuts1Click

procedure TForm1.LsFileListView27ShortCuts1Click(Sender: TObject);
begin
  AboutForm.PageControl1.ActivePage := AboutForm.TabSheet2;
  AboutForm.ShowModal;
end; //LsFileListView27ShortCuts1Click

procedure TForm1.AboutLsFileExplorer271Click(Sender: TObject);
begin
  AboutForm.PageControl1.ActivePage := AboutForm.TabSheet3;
  AboutForm.ShowModal;
end; //AboutLsFileExplorer261Click

procedure TForm1.LsFileListView271Click(Sender: TObject);
begin
  SetBtnMenuState(Sender);
  EditPath.Text := LsFileListView271.Directory;
end; //LsFileListView271Click

procedure TForm1.MaskCombo1Click(Sender: TObject);
begin
  LsFileListView271.Mask := MaskCombo1.Text;
end; //MaskCombo1Click

procedure TForm1.LsFileListView271Change(Sender: TObject; Item: TListItem;
  Change: TItemChange);
begin
  SetBtnMenuState(Sender);
end; //LsFileListView271Change

procedure TForm1.DeleteFiles1Click(Sender: TObject);
begin
  LsFileListView271.DeleteItems;
end; //DeleteFiles1Click

procedure TForm1.RenameFile1Click(Sender: TObject);
begin
  LsFileListView271.RenameFile;
end; //RenameFile1Click

procedure TForm1.QuickView1Click(Sender: TObject);
begin
  if Assigned(LsFileListView271) then
    if LsFileListView271.Selected <> nil then
      LsFileListView271.ViewFile;
end; //QuickView1Click

procedure TForm1.Attribute1Click(Sender: TObject);
begin
  if Assigned(LsFileListView271) then
    if LsFileListView271.Selected <> nil then
      LsFileListView271.FileAttr;
end; //Attribute1Click

procedure TForm1.BtnIconClick(Sender: TObject);
begin
  LsFileListView271.ViewStyle := vsIcon;
end; //BtnIconClick

procedure TForm1.BtnSIconClick(Sender: TObject);
begin
  LsFileListView271.ViewStyle := vsSmallIcon;
end; //BtnSIconClick

procedure TForm1.BtnListClick(Sender: TObject);
begin
  LsFileListView271.ViewStyle := vsList;
end; //BtnListClick

procedure TForm1.BtnDetailClick(Sender: TObject);
begin
  LsFileListView271.ViewStyle := vsReport;
end; //BtnDetailClick

procedure TForm1.BtnExitClick(Sender: TObject);
begin
  Close;
end;


end.
