(*******************************************)
(* Founder Lite Library                    *)
(* Version 1.0                             *)
(* Common tools and utils                  *)
(*                                         *)
(*******************************************)
(* (c) 1996-98 Evgesoft Company.           *)
(* All right reserved.                     *)
(*                                         *)
(*******************************************)
(* Internet: dev@evgesoft.com              *)
(* WWW:                                    *)
(*   http://www.evgesoft.com/dev/          *)
(*******************************************)

unit fdrlitereg;

interface

uses Classes, Menus, dialogs;

procedure Register;

implementation {===========================================================}

uses fdr_common, fdr_toolbar, pm97frm, sb97frm, Controls,
     DsgnIntf, GSEdit, Forms;

{ TToolBarEditor }

type

  TGlyphsProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
    procedure SetValue(const Value: string); override;
  end;

  TGlyphIndexProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
    procedure SetValue(const Value: string); override;
  end;

  TToolBarEditor = class(TDefaultEditor)
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

  TMenuBarEditor = class(TDefaultEditor)
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

{ TGlyphsEditor }

  TGlyphsEditor = class(TComponentEditor)
    procedure ExecuteVerb(Index: Integer); override;
    function GetVerb(Index: Integer): string; override;
    function GetVerbCount: Integer; override;
  end;

{ TGlyphsEditor }

procedure TGlyphsEditor.ExecuteVerb(Index: Integer);
var
  G: TitaGlyphs;
  GForm: TfrmGlyphsEdit;
begin
  G := Component as TitaGlyphs;
  if Index = 0 then begin
    GForm := TfrmGlyphsEdit.Create(Application);
    GForm.Execute(G);
    GForm.Free;
  end;
end;

function TGlyphsEditor.GetVerb(Index: Integer): string;
begin
  case Index of
    0: Result := 'Glyphs Edit';
    else Result := '';
  end;
end;

function TGlyphsEditor.GetVerbCount: Integer;
begin
  Result := 1;
end;

{ TGlyphs ====================================== }

procedure TGlyphsProperty.Edit;
var
  GlyphsForm: TfrmGlyphs;
  Comp: TitaOfficePopupMenu;
begin
  GlyphsForm := TfrmGlyphs.Create(nil);
  try
    Comp := TitaOfficePopupMenu(GetComponent(0));
    If (Comp.Glyphs = nil) and (Comp.Images = nil) Then
      MsgError('You mast insert TGlyph or TImageList component on the form.')
    else
    begin
      Glyphsform.Caption := Comp.Name + '.' +
        GetName + ' - ' + GlyphsForm.Caption;
      GlyphsForm.SetItems(Comp);
      GlyphsForm.ShowModal;
    end;
  finally
    GlyphsForm.Free;
  end;
end;

function TGlyphsProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;

function TGlyphsProperty.GetValue: string;
begin
  Result := '(Edit)';
end;

procedure TGlyphsProperty.SetValue(const Value: string);
begin
  if Value = '' then SetOrdValue(0);
end;

{ TGlyphIndex ====================================== }

procedure TGlyphIndexProperty.Edit;
var
  SBGlyphsForm: TfrmSBGlyphs;
  Comp: TitaSpeedButton;
begin
  SBGlyphsForm := TfrmSBGlyphs.Create(nil);
  try
    Comp := TitaSpeedButton(GetComponent(0));
    If (Comp.Glyphs = nil) and (Comp.Images = nil) Then
      MsgError('Property Glyphs or Images must not empty.')
    else
    begin
      SBGlyphsform.Caption := Comp.Name + '.' +
        GetName + ' - ' + SBGlyphsForm.Caption;
      SBGlyphsForm.SetItems(Comp);
      SBGlyphsForm.ShowModal;
    end;
  finally
    SBGlyphsForm.Free;
  end;
end;

function TGlyphIndexProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;

function TGlyphIndexProperty.GetValue: string;
begin
  Result := '(Index)';
end;

procedure TGlyphIndexProperty.SetValue(const Value: string);
begin
  if Value = '' then SetOrdValue(0);
end;

{ TToolbar ============================================== }

const
  ToolBarVerbs: array[0..2] of String = ('New separator', 'New button',
                'New popup button');

procedure TToolBarEditor.ExecuteVerb(Index: Integer);
var
  ToolBar: TitaToolBar;
  Tool: TControl;
{$IFDEF VER120}
  Designer: IFormDesigner;
{$ELSE}
  Designer: TFormDesigner;
{$ENDIF}
begin
  If Component is TitaToolBar Then
    ToolBar := Component as TitaToolBar
  else
    If (Component is TControl) Then
      ToolBar := (Component as TControl).Parent as TitaToolBar
    else
      ToolBar := nil;

  if ToolBar <> nil then
  begin
    Designer := Self.Designer;
    Tool := nil;
    case Index of
    0:begin
        Tool := TitaTBSeparator.Create(Designer.Form);
        try
          Tool.Name := Designer.UniqueName(TitaTBSeparator.ClassName);
          Tool.Parent := ToolBar;
        except
          Tool.Free;
          raise;
        end;
      end;
    1:begin
        Tool := TitaTBButton.Create(Designer.Form);
        try
          Tool.Name := Designer.UniqueName(TitaTBButton.ClassName);
          Tool.Parent := ToolBar;
        except
          Tool.Free;
          raise;
        end;
      end;
    2:begin
        Tool := TitaTBPopup.Create(Designer.Form);
        try
          Tool.Name := Designer.UniqueName(TitaTBPopup.ClassName);
          Tool.Parent := ToolBar;
        except
          Tool.Free;
          raise;
        end;
      end;
    end;
    If Tool <> nil Then
      If ToolBar.Parent.Align in [alTop, alBottom] Then
      begin
        Tool.Left := ToolBar.Width;
        Tool.Align := alLeft;
      end
      else
      begin
        Tool.Top := ToolBar.Height;
        Tool.Align := alTop;
      end;
    ToolBar.Aligning;
    Designer.SelectComponent(Tool);
    Designer.Modified;
  end;
end;

function TToolBarEditor.GetVerb(Index: Integer): string;
begin
  Result := ToolBarVerbs[Index];
end;

function TToolBarEditor.GetVerbCount: Integer;
begin
  Result := High(ToolBarVerbs) + 1;
end;

{ TMenuBar ============================================== }

const
  MenuBarVerbs: array[0..0] of String = ('New menu button');

procedure TMenuBarEditor.ExecuteVerb(Index: Integer);
var
  MenuBar: TitaMenuBar;
  Tool: TControl;
{$IFDEF VER120}
  Designer: IFormDesigner;
{$ELSE}
  Designer: TFormDesigner;
{$ENDIF}
begin
  If Component is TitaToolBar Then
    MenuBar := Component as TitaMenuBar
  else
    If (Component is TControl) Then
      MenuBar := (Component as TControl).Parent as TitaMenuBar
    else
      MenuBar := nil;

  if MenuBar <> nil then
  begin
    Designer := Self.Designer;
    Tool := nil;
    case Index of
      0:begin
          Tool := TitaMenuButton.Create(Designer.Form);
          try
            Tool.Name := Designer.UniqueName(TitaMenuButton.ClassName);
            Tool.Parent := MenuBar;
          except
            Tool.Free;
            raise;
          end;
        end;
    end;
    If Tool <> nil Then
      If MenuBar.Parent.Align in [alTop, alBottom] Then
      begin
        Tool.Left := MenuBar.Width;
        Tool.Align := alLeft;
      end
      else
      begin
        Tool.Top := MenuBar.Height;
        Tool.Align := alTop;
      end;
    MenuBar.Aligning;
    Designer.SelectComponent(Tool);
    Designer.Modified;
  end;
end;

function TMenuBarEditor.GetVerb(Index: Integer): string;
begin
  Result := MenuBarVerbs[Index];
end;

function TMenuBarEditor.GetVerbCount: Integer;
begin
  Result := High(MenuBarVerbs) + 1;
end;

{ Registration }

procedure Register;
begin
  RegisterComponents('FDR Lite',
  [
// Common //
    TitaPanel,
    TitaMenu,
    TitaPopupMenu,
// Menus //
    TitaMenuBar,
    TitaOfficePopupMenu,
    TitaMenuButton,
// Glyphs //
    TitaGlyphs,
// Buttons //
    TitaSpeedButton,
    TitaPopupButton,
// ToolBar //
    TitaDock,
    TitaToolBar
  ]);

  RegisterClass(TitaTBSeparator);
  RegisterClass(TitaTBButton);
  RegisterClass(TitaTBPopup);

  RegisterComponentEditor(TitaToolBar, TToolBarEditor);
  RegisterComponentEditor(TitaMenuBar, TMenuBarEditor);
  RegisterComponentEditor(TitaGlyphs, TGlyphsEditor);

  RegisterPropertyEditor(TypeInfo(Integer), TitaCustomPopupMenu, 'GlyphsEdit',
    TGlyphsProperty);
  RegisterPropertyEditor(TypeInfo(Integer), TitaSpeedButton, 'GlyphIndex',
    TGlyphIndexProperty);
end;

end.
