unit sb97frm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ComCtrls, Buttons, Menus, fdr_toolbar, Grids;

type

  TfrmSBGlyphs = class(TForm)
    Label2: TLabel;
    btnClose: TBitBtn;
    Grid: TDrawGrid;
    procedure btnChangeClick(Sender: TObject);
    procedure GridDrawCell(Sender: TObject; Col, Row: Longint; Rect: TRect;
      State: TGridDrawState);
  private
    FGlyphs: TitaGlyphs;
    FImages: TImageList;
    Fbtn: TitaSpeedButton;
  public
    procedure SetItems(btn: TitaSpeedButton);
  end;

var
  frmSBGlyphs: TfrmSBGlyphs;

implementation

{$R *.DFM}

{ Forms ================================= }

procedure TfrmSBGlyphs.SetItems(btn: TitaSpeedButton);
begin
  Fbtn := btn;
  FGlyphs := Btn.Glyphs;
  FImages := Btn.Images;
  If FGlyphs <> nil Then
  begin
    Grid.ColCount := FGlyphs.Cols;
    Grid.RowCount := FGlyphs.Rows;
    Grid.DefaultColWidth := FGlyphs.Width+4;
    Grid.DefaultRowHeight := FGlyphs.Height+4;
  end;
  If FImages <> nil Then
  begin
    Grid.ColCount := 8;
    Grid.RowCount := FImages.Count div 8 + 1;
    Grid.DefaultColWidth := FImages.Width+4;
    Grid.DefaultRowHeight := FImages.Height+4;
  end;
  Grid.Col := btn.GlyphIndex mod Grid.ColCount;
  Grid.Row := btn.GlyphIndex div Grid.ColCount;
end;

procedure TfrmSBGlyphs.btnChangeClick(Sender: TObject);
begin
  Fbtn.GlyphIndex := Grid.Row*Grid.ColCount+Grid.Col;
end;

procedure TfrmSBGlyphs.GridDrawCell(Sender: TObject; Col, Row: Longint;
  Rect: TRect; State: TGridDrawState);
var
  B: TBitmap;
begin
  If FGlyphs <> nil Then
    FGlyphs.DrawCenter(Grid.Canvas, Rect, Row*Grid.ColCount+Col);
  If FImages <> nil Then
  begin
    B := TBitmap.Create;
    FImages.GetBitmap(Row*Grid.ColCount+Col, B);
    DrawBitmapTransparent(Grid.Canvas, Rect.Left, Rect.Top, B,
      B.Canvas.Pixels[0, B.Height-1]);
    B.Free;
  end;
end;

end.
