(*******************************************)
(* Founder Lite Library                    *)
(* Version 1.0                             *)
(* Common tools and utils                  *)
(*                                         *)
(*******************************************)
(* (c) 1996-98 Evgesoft Company.           *)
(* All right reserved.                     *)
(*                                         *)
(*******************************************)
(* Internet: dev@evgesoft.com              *)
(* WWW:                                    *)
(*   http://www.evgesoft.com/dev/          *)
(*******************************************)

unit pm97frm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, ComCtrls, Buttons, Menus, fdr_toolbar, Grids;

type

  TfrmGlyphs = class(TForm)
    tvMenuItems: TTreeView;
    Label1: TLabel;
    Label2: TLabel;
    ImageList: TImageList;
    btnClose: TBitBtn;
    Grid: TDrawGrid;
    btnNone: TBitBtn;
    procedure tvMenuItemsChange(Sender: TObject; Node: TTreeNode);
    procedure btnChangeClick(Sender: TObject);
    procedure GridDrawCell(Sender: TObject; Col, Row: Longint; Rect: TRect;
      State: TGridDrawState);
  private
    FMenu: TitaOfficePopupMenu;
    FGlyphs: TitaGlyphs;
    FImages: TImageList;
  public
    procedure SetItems(Items: TitaOfficePopupMenu);
  end;

var
  frmGlyphs: TfrmGlyphs;

implementation

{$R *.DFM}

{ Forms ================================= }

procedure TfrmGlyphs.SetItems(Items: TitaOfficePopupMenu);
 procedure AddItems(M: TMenuItem; OwnerN: TTreeNode);
 var
   i: integer;
   N: TTreeNode;
 begin
   N := tvMenuItems.Items.AddChildFirst(OwnerN, M[0].Caption);
   N.ImageIndex := M[0].Tag-1;
   N.SelectedIndex := M[0].Tag-1;
   If M[0].Count > 0 Then AddItems(M[0], N);
   for i := 1 to M.Count-1 do
   begin
     N := tvMenuItems.Items.Add(N, M[i].Caption);
     N.ImageIndex := M[i].Tag-1;
     N.SelectedIndex := M[i].Tag-1;
     If M[i].Count > 0 Then AddItems(M[i], N);
   end;
 end;
var
  i: integer;
  B: TBitmap;
begin
  FMenu := Items;
  FGlyphs := FMenu.Glyphs;
  FImages := FMenu.Images;
  If FGlyphs <> nil Then
  begin
    ImageList.Width := FGlyphs.Width;
    ImageList.Height := FGlyphs.Height;
    for i := 0 to FGlyphs.Cols*FGlyphs.Rows-1 do
    begin
      B := FGlyphs.GraphicCell[i];
      ImageList.AddMasked(B, B.Canvas.Pixels[0, B.Height-1]);
    end;
    Grid.ColCount := FGlyphs.Cols;
    Grid.RowCount := FGlyphs.Rows;
    Grid.DefaultColWidth := FGlyphs.Width+4;
    Grid.DefaultRowHeight := FGlyphs.Height+4;
  end;
  If FImages <> nil Then
  begin
    ImageList.Assign(FImages);
    Grid.ColCount := 8;
    Grid.RowCount := FImages.Count div 8 + 1;
    Grid.DefaultColWidth := FImages.Width+4;
    Grid.DefaultRowHeight := FImages.Height+4;
  end;

  FMenu := Items;
  AddItems(Items.Items, nil);
end;

procedure TfrmGlyphs.tvMenuItemsChange(Sender: TObject; Node: TTreeNode);
begin
  If tvMenuItems.Selected.ImageIndex > 0 Then
  begin
    Grid.Col := tvMenuItems.Selected.ImageIndex mod Grid.ColCount;
    Grid.Row := tvMenuItems.Selected.ImageIndex div Grid.ColCount;
  end
  else
    ActiveControl := btnNone;
end;

procedure TfrmGlyphs.btnChangeClick(Sender: TObject);
 function FindItem(M: TMenuItem; S: String): TMenuITem;
 var
   i: integer;
 begin
   Result := nil;
   for i := 0 to M.Count-1 Do
   begin
     If M.Items[i].Caption = S Then
     begin
       Result := M.Items[i];
       Break;
     end;
     If M.Items[i].Count > 0 Then
     begin
       Result := FindItem(M.Items[i], S);
       If Result <> nil Then Break;
     end;
   end;
 end;
var
  M: TMenuItem;
begin
  tvMenuItems.Selected.ImageIndex := Grid.Row*Grid.ColCount+Grid.Col;
  tvMenuItems.Selected.SelectedIndex := tvMenuItems.Selected.ImageIndex;
  Activecontrol := tvMenuItems;

  M := FindItem(FMenu.Items, tvMenuItems.Selected.Text);
  If M <> nil Then M.Tag := tvMenuItems.Selected.ImageIndex+1;
end;

procedure TfrmGlyphs.GridDrawCell(Sender: TObject; Col, Row: Longint;
  Rect: TRect; State: TGridDrawState);
var
  B: TBitmap;
begin
  If FGlyphs <> nil Then
    FGlyphs.DrawCenter(Grid.Canvas, Rect, Row*Grid.ColCount+Col);
  If FImages <> nil Then
  begin
    B := TBitmap.Create;
    FImages.GetBitmap(Row*Grid.ColCount+Col, B);
    DrawBitmapTransparent(Grid.Canvas, Rect.Left, Rect.Top, B,
      B.Canvas.Pixels[0, B.Height-1]);
    B.Free;
  end;
end;

end.
