(*******************************************)
(* Founder Lite Library                    *)
(* Version 1.0                             *)
(* Common tools and utils                  *)
(*                                         *)
(*******************************************)
(* (c) 1996-98 Evgesoft Company.           *)
(* All right reserved.                     *)
(*                                         *)
(*******************************************)
(* Internet: dev@evgesoft.com              *)
(* WWW:                                    *)
(*   http://www.evgesoft.com/dev/          *)
(*******************************************)

unit gsedit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, fdr_toolbar, Grids, StdCtrls, Buttons, ExtCtrls;

type

  TfrmGlyphsEdit = class(TForm)
    lbGlyphs: TLabel;
    sgGlyphs: TDrawGrid;
    btnAdd: TBitBtn;
    btnDelete: TBitBtn;
    btnCancel: TBitBtn;
    btnClose: TBitBtn;
    Bevel1: TBevel;
    Browse: TOpenDialog;
    procedure btnCloseClick(Sender: TObject);
    procedure sgGlyphsDrawCell(Sender: TObject; Col, Row: Longint;
      Rect: TRect; State: TGridDrawState);
    procedure btnAddClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnDeleteClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    GWidth, GHeight, GCount: integer;
    Bitmaps: array [1..500] of TBitmap;
    Glyphs: TitaGlyphs;
    procedure Execute(AGlyphs: TitaGlyphs);
  end;

implementation

{$R *.DFM}

function isEmpty(B: Tbitmap): boolean;
var
  i, j: integer;
  C: TColor;
begin
  C := B.Canvas.Pixels[0, 0];
  for i := 0 to B.Width-1 do
    for j := 0 to B.Height-1 do
      If B.Canvas.Pixels[i, j] <> C Then
      begin
        Result := false;
        Exit;
      end;
  Result := true;
end;

procedure TfrmGlyphsEdit.Execute;
var
  i: integer;
begin
  Glyphs := AGlyphs;
  Caption := Caption + Glyphs.Name;
  GCount := 1;
  If Glyphs.Picture.Bitmap.Width > 0 Then
    with Glyphs do
    begin
      // Already exist
      sgGlyphs.DefaultColWidth := Glyphs.Width+2;
      sgGlyphs.DefaultRowHeight := Glyphs.Height+2;
      for i := 0 to Cols*Rows do
      begin
        If (isEmpty(GraphicCell[i])) and (i > (Rows-1)*Cols) Then Break;
        Bitmaps[i+1] := TBitmap.Create;
        Bitmaps[i+1].Assign(GraphicCell[i]);
      end;
      GWidth := Glyphs.Width;
      GHeight := Glyphs.Height;
      GCount := i+1;
    end;
  ShowModal;
end;

procedure TfrmGlyphsEdit.btnCloseClick(Sender: TObject);
var
  i, x, y: integer;
  B: TBitmap;
begin
  X := 0;
  Y := 0;
  B := Tbitmap.Create;
  B.Width := GWidth*8;
  B.Height := GHeight * ((GCount div 8) + 1);
  with B.Canvas do
  begin
    Brush.Color := clOlive;
    Rectangle(-1, -1, B.Width+1, B.Height+1);
  end;
  for i := 1 to GCount do
  begin
    If Bitmaps[i] <> nil Then
      DrawBitmapTransparent(B.Canvas, X*GWidth, Y*GHeight, Bitmaps[i],
        Bitmaps[i].Canvas.Pixels[0, 0]);
    Inc(X);
    If X = 8 Then
    begin
      X := 0;
      Inc(Y);
    end;
  end;
  Glyphs.Picture.Bitmap := B;
  Glyphs.Width := GWidth;
  Glyphs.Height := GHeight;
  B.Free;
  Close;
end;

procedure TfrmGlyphsEdit.sgGlyphsDrawCell(Sender: TObject; Col,
  Row: Longint; Rect: TRect; State: TGridDrawState);
begin
  // Draw Cell
  with sgGlyphs.Canvas do
  begin
    Brush.Color := clWindow;
    Pen.Color := clWindowText;
    Pen.Style := psSolid;
    If gdSelected in State Then
      Brush.Color := clHighlight;
    Rectangle(Rect.Left, Rect.Top, Rect.Right+2, Rect.Bottom+2);
    If Bitmaps[Row*8+Col+1] <> nil Then
      DrawBitmapTransparent(sgGlyphs.Canvas, Rect.Left+2, Rect.Top+2,
        Bitmaps[Row*8+Col+1],
        Bitmaps[Row*8+Col+1].Canvas.Pixels[0, Bitmaps[Row*8+Col+1].Height-1]);
  end;
end;

procedure TfrmGlyphsEdit.btnAddClick(Sender: TObject);
var
  tmpB, B: TBitmap;
begin
  If Browse.Execute Then
  begin
    tmpB := TBitmap.Create;
    tmpB.LoadFromFile(Browse.FileName);
    If GWidth > 0 Then
    begin
      B := TBitmap.Create;
      B.Width := GWidth;
      B.Height := GHeight;
      B.Canvas.Draw(0, 0, tmpB);
      tmpB.Free;
      tmpB := B; 
    end
    else
    begin
      GWidth := tmpB.Height;
      GHeight := tmpB.Height;
      B := TBitmap.Create;
      B.Width := GWidth;
      B.Height := GHeight;
      B.Canvas.Draw(0, 0, tmpB);
      tmpB.Free;
      tmpB := B; 
      sgGlyphs.DefaultColWidth := GWidth+2;
      sgGlyphs.DefaultRowHeight := GHeight+2;
    end;
    Bitmaps[GCount] := tmpB;
    Inc(GCount);
    sgGlyphs.Invalidate;
  end;
end;

procedure TfrmGlyphsEdit.FormCreate(Sender: TObject);
var
  i: integer;
begin
  for i := 1 to GCount do
    If Bitmaps[i] <> nil Then Bitmaps[i].Free;
end;

procedure TfrmGlyphsEdit.btnDeleteClick(Sender: TObject);
var
  p, i: integer;
begin
  If Gcount > 1 Then
  begin
    p := sgGlyphs.Col + sgGlyphs.Row*8 + 1;
    If p >= GCount Then Exit;
    If Bitmaps[p] <> nil Then Bitmaps[p].Free;
    for i := p to GCount-1 do
      Bitmaps[i] := Bitmaps[i+1];
    Dec(GCount);
    sgGlyphs.Invalidate;
  end;
end;

end.
