(*******************************************)
(* Founder Lite Library                    *)
(* Version 1.0                             *)
(* Common tools and utils                  *)
(*                                         *)
(*******************************************)
(* (c) 1996-98 Evgesoft Company.           *)
(* All right reserved.                     *)
(*                                         *)
(*******************************************)
(* Internet: dev@evgesoft.com              *)
(* WWW:                                    *)
(*   http://www.evgesoft.com/dev/          *)
(*******************************************)

unit flpfrm97;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, fdr_toolbar;

type

  TFPForm97 = class(TForm)
    procedure FormCreate(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDeactivate(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    procedure WMNCHitTest(var Msg: TWMNCHitTest); message WM_NCHITTEST;
  protected
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
  public
    Panel: TitaToolBar;
  end;

var
  FPForm97: TFPForm97;

implementation

{$R *.DFM}

procedure TFPForm97.FormCreate(Sender: TObject);
begin
  Panel := nil;
end;

procedure TFPForm97.WMNCHitTest(var Msg: TWMNCHitTest);
begin
  inherited;
  If Msg.Result = htCaption Then
    Msg.Result := HTCLIENT;
end;

procedure TFPForm97.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  If Panel <> nil Then
    Panel.PublicMouseMove(Shift, X,Y);
end;

procedure TFPForm97.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  If Panel <> nil Then
    Panel.PublicMouseDown(Button, Shift, X,Y);
end;

procedure TFPForm97.FormMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  If Panel <> nil Then
    Panel.PublicMouseUp(Button, Shift, X,Y);
end;

procedure TFPForm97.MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer);
begin
  If Panel <> nil Then
    Panel.PublicMouseDown(Button, Shift, X,Y);
end;

procedure TFPForm97.MouseMove(Shift: TShiftState; X, Y: Integer);
begin
  If Panel <> nil Then
    Panel.PublicMouseMove(Shift, X,Y);
end;

procedure TFPForm97.MouseUp(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer);
begin
  If Panel <> nil Then
    Panel.PublicMouseUp(Button, Shift, X,Y);
end;

procedure TFPForm97.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  If Panel <> nil Then
    Panel.HidePanel;
end;

procedure TFPForm97.FormDeactivate(Sender: TObject);
begin
  If Panel <> nil Then ;
end;

procedure TFPForm97.FormResize(Sender: TObject);
begin
  If Panel <> nil Then
  begin
    Panel.Width := ClientWidth;
    Panel.Height := ClientHeight;
  end;
end;

end.
