unit uexam2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Math;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

uses FastFrm;

{$R *.DFM}

// Functions to be added with TFastFormula.AddFunction have to be declared stdcall

function NewFunc1(const A : Array of Extended):Extended;stdcall;
// This example multiplies all parameters
var I : LongInt;
begin
   Result:=1;
   For i:=0 to High(A) do Result:=Result*A[i];
end;

function NewFunc2(const A : Array of Extended):Extended;stdcall;
// Calculates the arg2.th. root of arg1
begin
   Result:=Power( A[0], 1 / A[1] );
end;

procedure TForm1.Button1Click(Sender: TObject);
var FF1 : TFastFormula;
begin
   FF1:=TFastFormula.Create(Self);
   FF1.AddFunction( 'newfunc1',  // name of my new function
                    -1,          // unlimited number of parameters
                    @NewFunc1,   // address of my new function
                    2,           // this function needs 2 registers on the FPU-Stack
                    false );     // no need to save the stack
   FF1.AddFunction( 'newfunc2',
                    2,           // this routine needs two parameters
                    @NewFunc2,
                    4,           // I don't really know how many stack-registers power needs,
                                 // so just say 4
                    false );     // because we don't know how many stack-registers are used,
                                 // we could also say true here, so that TFastFormula saves
                                 // its values in the FPU-stack.

   FF1.Formula:='newfunc1( 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 )';  // I want to multiply 1 to 10
   FF1.Compile;
   ShowMessage('fact(10)=10*9*8*7*6*5*4*3*2*1 = '+#13#10#13#10+
                      '= '+FloatToStr(FF1.Calculate2));       // no variables, so use calculate2





   FF1.Formula:='newfunc2( 8, 3 )';     // we want to calculate the 3rd root of 8 = 2
   FF1.Compile;
   ShowMessage('3rd. root of 8 = newfunc2(8,3) = '+#13#10#13#10+
                      '= '+FloatToStr(FF1.Calculate2));
   FF1.Free;
end;



procedure TForm1.Button2Click(Sender: TObject);
const CodeArr : array[0..5] of Byte = ($D9,$C0,      // fld st(0)
                                       $DC,$C8,      // fmul st, st
                                       $DE,$C9);     // fmul
var FF1 : TFastFormula;
begin
   FF1:=TFastFormula.Create(Self);
   FF1.AddInlineFunction( 'cube',    // we add a function that calculates the cube of x
                          1,         // One Parameter
                          2,         // we need two FPU-registers
                          true,      // Parameters are transferred over the FPU-registers
                          6,         // codesize = 6 bytes
                          @CodeArr,  // Address of the code-array
                          0);        // we don't need any additional FPU-registers
   FF1.Formula:='cube(x)';
   FF1.Parameters.Clear;
   FF1.Parameters.Add('x');

   FF1.Compile;
   ShowMessage('Cube(4) = 4*4*4 = '+#13#10#13#10+
                     '= '+FloatToStr(FF1.Calculate( [4] )));
   FF1.Free;

end;

end.
