unit example;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,Math, ExtCtrls, fastfrm;

type
  TForm1 = class(TForm)
    FastFormula1: TFastFormula;
    GroupBox1: TGroupBox;
    Button1: TButton;
    Button2: TButton;
    Panel1: TPanel;
    GroupBox2: TGroupBox;
    RB1: TRadioButton;
    RB2: TRadioButton;
    RB3: TRadioButton;
    RB4: TRadioButton;
    Image1: TImage;
    CheckBox1: TCheckBox;
    GroupBox3: TGroupBox;
    Memo1: TMemo;
    procedure formula1ValidateParameter(Sender: TObject; Parameter: string;
      var Valid: Boolean);
    procedure formula1GetParameterValue(Sender: TObject; Parameter: string;
      var Value: extended);
    procedure Button5Click(Sender: TObject);
    procedure RB1Click(Sender: TObject);
    procedure RB2Click(Sender: TObject);
    procedure RB3Click(Sender: TObject);
    procedure RB4Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private-Deklarationen }
    StList : TStringList;
    procedure ShowGraph;
    procedure ShowRect;
  public
    { Public-Deklarationen }
  end;





var
  Form1: TForm1;

implementation

{$R *.DFM}



procedure TForm1.formula1ValidateParameter(Sender: TObject;
  Parameter: string; var Valid: Boolean);
begin
     valid:=true;
end;

procedure TForm1.formula1GetParameterValue(Sender: TObject;
  Parameter: string; var Value: extended);
begin
   case Parameter[1] of
    'N' : Value:=49;
    'K' : Value:=6;
   end;
end;

procedure TForm1.Button5Click(Sender: TObject);
var T1,T2,TR1,TR2 : Double;
    hour1,hour2,min1,min2,sec1,sec2,MSec1,MSec2 : word;
    i : Word;
    j : word;
    x : Extended;
begin
   if MessageDlg('We now calculate the faculties of 1 through 1754, displaying'+#13#10+
              'the results in the PANEL below.'+#13#10#13#10+
              'Hit OK to start.',mtInformation,[mbok,mbCancel],0)=mrOK then
   begin
      FastFormula1.Formula:='fact(x)';
      FastFormula1.Parameters.Clear;
      FastFormula1.Parameters.Add('x');
      FastFormula1.Compile;
      Screen.Cursor:=crHourGlass;
      T1:=Time;
      For i:=1 to 1754 do x:=FastFormula1.Calculate([i]);
      T2:=Time;
      TR1:=T2-T1;
      T1:=Time;
      For i:=1 to 1754 do
      begin
         Panel1.Caption:='Fact('+IntToStr(i)+') = '+FloatToStrF(FastFormula1.Calculate([i]),ffGeneral,20,20);// Formula1.Calculate([i]),ffGeneral,20,20);
         Panel1.Refresh;
      end;
      T2:=Time;
      TR2:=T2-T1-TR1;
      Screen.Cursor:=crArrow;
      DecodeTime(TR1,hour1,min1,sec1,Msec1);
      DecodeTime(TR2,hour2,min2,sec2,Msec2);
      ShowMessage('Time needed for calculation : '+TimeToStr(TR1)+':'+intToStr(Msec1)+#13#10#13#10+
                  'Time needed for display : '+TimeToStr(TR2)+':'+intToStr(MSec2)+#13#10#13#10#13#10+
                  ' (times in Hour:Min:Sec:MSec)');
   end;
end;

procedure TForm1.RB1Click(Sender: TObject);
begin
   RB2.Checked:=False;
   RB3.Checked:=False;
   RB4.Checked:=False;
   ShowGraph;
end;

procedure TForm1.RB2Click(Sender: TObject);
begin
   RB1.Checked:=False;
   RB3.Checked:=False;
   RB4.Checked:=False;
   ShowGraph;
end;

procedure TForm1.RB3Click(Sender: TObject);
begin
   RB1.Checked:=False;
   RB2.Checked:=False;
   RB4.Checked:=False;
   ShowGraph;
end;

procedure TForm1.RB4Click(Sender: TObject);
begin
   RB1.Checked:=False;
   RB2.Checked:=False;
   RB3.Checked:=False;
   ShowGraph;
end;


procedure TForm1.FormCreate(Sender: TObject);
begin
   ShowRect;
   StList:=TStringList.Create;
   FastFormula1.GetFunctionList(StList);
   Memo1.Lines:=StList;
end;

procedure TForm1.ShowRect;
var L,T,R,B : Integer;
begin
   L:=0;
   T:=0;
   R:=Image1.Width;
   B:=Image1.Height;
   With Image1.Canvas do
   begin
      Brush.Color:=clBlack;
      Rectangle(L,T,R,B);
      Pen.Color:=clWhite;
      MoveTo(R div 2, 0);
      LineTo(R div 2, B);
      MoveTo(0, B div 2);
      LineTo(R, B div 2);
   end;
end;


procedure TForm1.ShowGraph;
var MinX,MaxX,MinY,MaxY,NillX,NillY : Integer;
    RXMin,RYMin,RXMax,RYMax,Fx,Fy,X,Y,Step : Extended;
begin
   If CheckBox1.Checked then ShowRect;
   NillX:=Image1.Width div 2;
   NillY:=Image1.Height div 2;
   MinX:=2;
   MaxX:=Image1.Width-4;
   MinY:=Image1.Height-4;
   MaxY:=2;
   RXMin:=-2*pi;
   RXMax:=2*pi;
   RYMin:=-1.5;
   RYMax:=1.5;
   Fx:=(MaxX-MinX)/(RXMax-RXMin);
   Fy:=(MaxY-MinY)/(RYMax-RYMin);
   Step:=1/Fx;
   Image1.Canvas.Pen.Color:=clWhite;
   If RB1.Checked then
   begin
      FastFormula1.Formula:='sin(x)';
      If not CheckBox1.Checked then Image1.Canvas.Pen.Color:=clYellow;
   end else
   If RB2.Checked then
   begin
      FastFormula1.Formula:='cos(x)';
      If not CheckBox1.Checked then Image1.Canvas.Pen.Color:=clRed;
   end else
   If RB3.Checked then
   begin
      FastFormula1.Formula:='sin(x)*cos(x)';
      If not CheckBox1.Checked then Image1.Canvas.Pen.Color:=clBlue;
   end else
   begin
      FastFormula1.Formula:='sqrt(abs(x/2.5))*cos(x)';
      If not CheckBox1.Checked then Image1.Canvas.Pen.Color:=clGreen;
   end;
   FastFormula1.Parameters.Clear;
   FastFormula1.Compile;
   X:=RXMin;
   Y:=FastFormula1.Calculate([x]);
   Image1.Canvas.MoveTo(Round(NillX+Fx*X),Round(NillY+Fy*Y));
   Repeat
      Try
         Y:=FastFormula1.Calculate([x]);
      except
      end;
      Image1.Canvas.LineTo(Round(NillX+Fx*X),Round(NillY+Fy*Y));
      x:=x+Step;
   until X>=RXMax;
end;


procedure TForm1.Button1Click(Sender: TObject);
var Error : TFastFormulaError;
    t : extended;
    txt : AnsiString;
begin
   FastFormula1.Formula:='BiCo(49,6)';
   FastFormula1.Parameters.Clear;
   Error:=FastFormula1.Compile;
   If Error.Code<>0 then
   begin
      MessageDlg(FastFormula1.Formula+#13#10+inttostr(Error.Position)+#13#10+Error.Text,mtError,[mbok],0);
   end else
   begin
      txt:='If you play a lottery where you take six balls'+#13#10+
           'out of a bowl with 49 numbered balls, how many'+#13#10+
           'different variations do exist ?'+#13#10+'(order not important)'+#13#10#13#10+
           'answer : the binominal coefficient (n over k)'+#13#10#13#10+

           'BiCo(49,6) = '+FloatToStrF(

           FastFormula1.Calculate2,

           ffFixed,20,0)+#13#10#13#10#13#10+
           'What is the probability that you can tell the right'+#13#10+'six balls in one guess ?'+#13#10#13#10+
           'answer : 1/BiCo(49,6) = '+FloatToStrF(

           1/FastFormula1.Calculate([49,6])

           ,ffFixed,20,15)+#13#10;
      MessageDlg(txt,mtInformation,[mbok],0);
   end;
end;

end.







