// *************************************************
// ExtListBox.pas
//
// Copyright  1999 by Dani Seelhofer for Goldfish Software GmbH
// Email : Dani.Seelhofer@goldfish-software.ch
//
// This component is freeware. Use it as you like.
// If you do use it, however, send me a short email.
//
// Otherwise standard disclaimer, standard freeware.
// No warranty is given, expressed or implied.
// Use at your own risk.
//
// *************************************************
// Vers.  Date         Remarks
// 1.0.0  May 28, 1999  Initial release
// *************************************************

unit ExtListBox;

interface

uses
     Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, StdCtrls;

type
     TExtListBox = class(TCustomListBox)
     private
          FColor: TColor;
          FLineColorOdd: TColor;
          FLineColorEven: TColor;
          FLineColorSelected: TColor;
          FFontSelectedColor: TColor;
     protected
          procedure DrawItem(Index: Integer; Rect: TRect; State: TOwnerDrawState); override;
          procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
          procedure KeyDown(var Key: Word; Shift: TShiftState); override;
     public
          constructor Create(AOwner: TComponent); override;
          destructor Destroy; override;
     published
          property LineColorOdd: TColor read FLineColorOdd write FLineColorOdd;
          property LineColorEven: TColor read FLineColorEven write FLineColorEven;
          property LineColorSelected: TColor read FLineColorSelected write FLineColorSelected;
          property FontSelectedColor: TColor read FFontSelectedColor write FFontSelectedColor;
          property Color: TColor read FColor write FColor;

          //Pusblish some of the TListBox properties...
          property Align;
          property BorderStyle;
          property Columns;
          property Ctl3D;
          property DragCursor;
          property DragMode;
          property Enabled;
          property ExtendedSelect;
          property Font;
          property IntegralHeight;
          property ItemHeight;
          property Items;
          property MultiSelect;
          property ParentColor;
          property ParentCtl3D;
          property ParentFont;
          property ParentShowHint;
          property PopupMenu;
          property ShowHint;
          property Sorted;
          property Style default lbOwnerDrawFixed;
          property TabOrder;
          property TabWidth;
          property Visible;

          //Pusblish some of the TListBox events...
          property OnClick;
          property OnDblClick;
          property OnDragDrop;
          property OnDragOver;
          property OnEndDrag;
          property OnEnter;
          property OnExit;
          property OnKeyDown;
          property OnKeyPress;
          property OnKeyUp;
          property OnMeasureItem;
          property OnMouseDown;
          property OnMouseMove;
          property OnMouseUp;
          property OnStartDrag;
     end;

procedure Register;

implementation

constructor TExtListBox.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     Style := lbOwnerDrawFixed;
     FColor := clWhite;
     FLineColorEven := clWhite;
     FLineColorOdd := clYellow;
     FLineColorSelected := clActiveCaption;
     FFontSelectedColor := clCaptionText;
end;

destructor TExtListBox.Destroy;
begin
     inherited Destroy;
end;

procedure TExtListBox.KeyDown(var Key: Word; Shift: TShiftState);
begin
     Invalidate;
     inherited;
end;


procedure TExtListBox.MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
     Invalidate;
     inherited;
end;

procedure TExtListBox.DrawItem(Index: Integer; Rect: TRect; State: TOwnerDrawState);
begin
     with Self as TCustomListBox do
          begin
               Canvas.Brush.Color := FColor;
               Canvas.FillRect(Rect);
               InflateRect(Rect, -1, -1);
               if Index = ItemIndex then          //Selected?
                    begin
                         Canvas.Brush.Color := FLineColorSelected;
                         Canvas.Font.Color := FFontSelectedColor;
                    end
               else
                    begin
                         Canvas.Font.Color := Font.Color;
                         if (Index mod 2) = 0 then //Even line numbers...
                              Brush.Color := FLineColorEven
                         else
                              Canvas.Brush.Color := FLineColorOdd;
                    end;
               Canvas.FillRect(Rect);
               Canvas.TextOut(Rect.Left, Rect.Top, Items[Index]);
          end;
end;


//==============================================================================

procedure Register;
begin
     RegisterComponents('Dan' + #39 + 's Components', [TExtListBox]);
end;

end.

