{-------------------------------------------------------------------------------

	TExtForm v0.2 beta - Freeware

		Created by
			Thomas Fischer
			fischer@rbg.informatik.tu-darmstadt.de
			http://www.student.informatik.tu-darmstadt.de/~fischer  (only in German!)

	Replacement for Delphi's TForm

	Tested with Delphi 2. May run with minor changes in other (later) Delphi versions, too.

	See EXTFORM.TXT for further information.

-------------------------------------------------------------------------------}
unit ExtForm;

interface

uses Classes, Forms, Windows, Messages, ShellAPI, SysUtils, Graphics, Dialogs;

type
	TWMNCPaint = record
		Msg: Cardinal;
		hRgn: LongInt;
		Unused: Longint;
    Result: Longint;
  end;

	TGradient = record
		Enabled: Boolean;
		Quality: Integer;
	end;

	TDropEvent = procedure (Sender: TObject; DragFiles: TStrings; p: TPoint) of object;

	TExtForm = class(TForm)
	private
		FOnDrop: TDropEvent;
		FUseTahoma, FAcceptFiles: Boolean;
		FGradient: TGradient;
		FMinX, FMaxX, FMinY, FMaxY: Integer;

		procedure SetAcceptFiles(Value: Boolean);
		procedure SetGradient(g: TGradient);
		procedure SetUseTahoma(b: Boolean);

		procedure wmSetText(var TextMsg: TWMSetText); message WM_SETTEXT;
		procedure wmDropFiles(var DragMsg: TWMDropFiles); message WM_DROPFILES;
		procedure wmNCPaint(var Msg: TWMNCPaint); message WM_NCPAINT;
		procedure wmNCActivate(var Msg: TMessage); message WM_NCACTIVATE;
		procedure wmSettingChange(var Msg: TMessage); message WM_SETTINGCHANGE;
		procedure wmGetMinMaxInfo(var Msg: TMessage); message wm_GetMinMaxInfo;

		procedure CalcGradientCaption;
		procedure DrawGradientCaption;
	public
		constructor Create(AOwner: TComponent); override;
		constructor CreateNew(AOwner: TComponent);
		destructor Destroy; override;

		procedure Center;
	published
		property AcceptDragFiles: Boolean read FAcceptFiles write SetAcceptFiles;
		property MinX: Integer read FMinX write FMinX;
		property MaxX: Integer read FMaxX write FMaxX;
		property MinY: Integer read FMinY write FMinY;
		property MaxY: Integer read FMaxY write FMaxY;
		property Gradient: TGradient read FGradient write SetGradient;
		property UseTahoma: Boolean read FUseTahoma write SetUseTahoma;

		property OnDrop: TDropEvent read FOnDrop write FOnDrop;
	end;

	function MessageDlgT(const Msg: string; DlgType: TMsgDlgType; Buttons: TMsgDlgButtons; HelpCtx: Longint): Integer;
	function MessageDlgPosT(const Msg: string; DlgType: TMsgDlgType; Buttons: TMsgDlgButtons; HelpCtx: Longint; X, Y: Integer): Integer;

implementation

var
	MessageUseTahoma: Boolean;

//************************************************************************************
constructor TExtForm.Create(AOwner: TComponent);
begin
	With FGradient do begin
		//Font:=TFont.Create;
		Enabled:=True;
		Quality:=9;
	end;

	Inherited Create(AOwner);

	FAcceptFiles:=True; DragAcceptFiles(Handle, FAcceptFiles);
	UseTahoma:=True;
end;

constructor TExtForm.CreateNew(AOwner: TComponent);
begin
	Inherited CreateNew(AOwner);
	FAcceptFiles:=True; DragAcceptFiles(Handle, FAcceptFiles);
end;

destructor TExtForm.Destroy;
begin
	If FAcceptFiles Then DragAcceptFiles(Handle, False);
	Inherited Destroy;
end;

//************************************************************************************
procedure TExtForm.SetGradient(g: TGradient);
begin
	Move(g, FGradient, SizeOf(FGradient));

	If FGradient.Enabled Then begin
		CalcGradientCaption;
		DrawGradientCaption;
	end else begin
		SendMessage(Self.Handle, WM_NCACTIVATE, 1, 0);
	end;
end;

procedure TExtForm.SetUseTahoma(b: Boolean);
var n: String;
begin
	FUseTahoma:=b; MessageUseTahoma:=b;

	If FUseTahoma and (Screen.Fonts.IndexOf('Tahoma')<>-1) Then n:='Tahoma'
	else n:='MS Sans Serif';

	Font.Name:=n;// Gradient.Font.Name:=n;
	CalcGradientCaption; DrawGradientCaption;
end;

procedure TExtForm.Center;
begin
	Left:=(Screen.Width-Width) div 2; Top:=(Screen.Height-Height) div 2;
end;
//************************************************************************************
var FormActive: Boolean;
		BMP: TBitmap;

procedure TExtForm.DrawGradientCaption;
var
	hDC: THandle;
	x, y: Integer;
begin
	If Not FGradient.Enabled Then Exit;

	x:=GetSystemMetrics(SM_CXSIZEFRAME);
	y:=GetSystemMetrics(SM_CYSIZEFRAME);
	hDC:=GetWindowDC(Handle);
	BitBlt(hDC, x, y, BMP.Width, BMP.Height, BMP.Canvas.Handle, 0, 0, SRCCOPY);
	ReleaseDC(Handle, hDC);
end;

procedure TExtForm.CalcGradientCaption;
var hDC: THandle;
		i, xs, x, y: Integer;
		wr: TRect;
		faz, cy, cr, cg, cb: Integer;
		FileInfo: TSHFileInfo;

begin
	If Not FGradient.Enabled Then Exit;
	If BorderStyle<>bsSizeable Then Exit;

	If Assigned(BMP) Then BMP.Free;
	BMP:=TBitmap.Create;
	BMP.Canvas.Font.Assign(Font);
//	BMP.Canvas.Font.Assign(FGradient.Font);

	hDC:=GetWindowDC(Handle);
	GetWindowRect(Handle, wr);

	x:=GetSystemMetrics(SM_CXSIZEFRAME);
	y:=GetSystemMetrics(SM_CYSIZEFRAME);

	BMP.Width:=wr.Right-wr.Left-x shl 1-GetSystemMetrics(SM_CXSIZE)*3;
	BMP.Height:=GetSystemMetrics(SM_CYCAPTION)-1;

	BitBlt(BMP.Canvas.Handle, 0, 0, BMP.Width, BMP.Height, hDC, x, y, SRCCOPY);

	With BMP.Canvas do Begin
		If FormActive Then Begin
			cr:=GetRValue(ColorToRGB(clActiveCaption));
			cg:=GetGValue(ColorToRGB(clActiveCaption));
			cb:=GetBValue(ColorToRGB(clActiveCaption));
		End Else Begin
			cr:=GetRValue(ColorToRGB(clInactiveCaption));
			cg:=GetGValue(ColorToRGB(clInactiveCaption));
			cb:=GetBValue(ColorToRGB(clInactiveCaption));
		End;

		xs:=0; wr.Top:=0; wr.Bottom:=BMP.Height; faz:=FGradient.Quality;
		i:=BMP.Width-faz shl 1;
		Repeat
			Brush.Color:=RGB(cr*xs div i, cg*xs div i, cb*xs div i);

			wr.Left:=xs; wr.Right:=xs+faz;
			FillRect(wr);

			Inc(xs, faz);
		Until xs>i;

		wr.Left:=xs; wr.Right:=BMP.Width;
		FillRect(wr);

		Brush.Style:=bsClear;
		If FormActive Then Font.Color:=clCaptionText else Font.Color:=clInactiveCaptionText;
		cy:=(BMP.Height-TextHeight(Caption)) div 2;
		TextOut(4+GetSystemMetrics(SM_CXSMICON), cy, Caption);

		SHGetFileInfo(PChar(Application.ExeName), 0, FileInfo, SizeOf(FileInfo), SHGFI_ICON or SHGFI_SMALLICON);
		DrawIconEx(BMP.Canvas.Handle, 2, 1, FileInfo.hIcon, GetSystemMetrics(SM_CXSMICON), GetSystemMetrics(SM_CYSMICON), 0, 0, DI_NORMAL);
	End;

end;

procedure TExtForm.wmNCPaint(var Msg: TWMNCPaint);
begin
	CalcGradientCaption;
	Inherited;
	DrawGradientCaption;
end;

procedure TExtForm.wmNCActivate(var Msg: TMessage);
begin
	FormActive:=Msg.WParam<>0;
	CalcGradientCaption;
	Inherited;

	DrawGradientCaption;
end;

procedure TExtForm.wmSettingChange(var Msg: TMessage);
begin
	Inherited;
	CalcGradientCaption;
	DrawGradientCaption;
end;

//************************************************************************************
procedure TExtForm.SetAcceptFiles(Value: Boolean);
begin
	FAcceptFiles:=Value;
	DragAcceptFiles(Handle, FAcceptFiles);
end;

procedure TExtForm.wmDropFiles(var DragMsg: TWMDropFiles);
var DName: PChar;
		i, AnzFiles, DLen: Word;
		Liste: TStrings;
		p: TPoint;
begin
	AnzFiles:=DragQueryFile(DragMsg.Drop, $FFFFFFFF, nil, 0);
	Liste:=TStringList.Create;

	Try
		For i:=0 to AnzFiles-1 do Begin
			DLen:=DragQueryFile(DragMsg.Drop, i, nil, 0);
			DName:=StrAlloc(DLen+5);
			DragQueryFile(DragMsg.Drop, i, DName, DLen+1);
			Liste.Add(String(DName));
		end;

		DragQueryPoint(DragMsg.Drop, p);
		If Assigned(FOnDrop) Then FOnDrop(Self, Liste, p);
	Finally
		Liste.Free;
		DragFinish(DragMsg.Drop);
	End;
end;
//************************************************************************************
procedure TExtForm.wmSetText(var TextMsg: TWMSetText);
begin
	Inherited;
	SendMessage(Handle, WM_NCPAINT, 0, 0);
end;
//************************************************************************************
procedure TExtForm.wmGetMinMaxInfo(var Msg: TMessage);
var mx, my: Integer;

begin
	If MaxX=0 Then mx:=Screen.Width shl 2 else mx:=MaxX;
	If MaxY=0 Then my:=Screen.Height shl 2 else my:=MaxY;

	PMinMaxInfo(Msg.lParam)^.ptMinTrackSize:=Point(MinX, MinY);
	PMinMaxInfo(Msg.lParam)^.ptMaxTrackSize:=Point(mx, my);
End;
//************************************************************************************
function MessageDlgT(const Msg: string; DlgType: TMsgDlgType;
	Buttons: TMsgDlgButtons; HelpCtx: Longint): Integer;
begin
	Result := MessageDlgPosT(Msg, DlgType, Buttons, HelpCtx, -1, -1);
end;

function MessageDlgPosT(const Msg: string; DlgType: TMsgDlgType;
	Buttons: TMsgDlgButtons; HelpCtx: Longint; X, Y: Integer): Integer;
begin
	with CreateMessageDialog(Msg, DlgType, Buttons) do
		try
			HelpContext := HelpCtx;
			If MessageUseTahoma and (Screen.Fonts.IndexOf('Tahoma')<>-1) Then Font.Name:='Tahoma';
			if X >= 0 then Left := X;
			if Y >= 0 then Top := Y;
			Result := ShowModal;
		finally
			Free;
		end;
end;
//************************************************************************************

begin
	MessageUseTahoma:=True;
end.
