unit DemoForm;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	ExtForm, StdCtrls, ComCtrls;

type
	TDemoMain = class(TExtForm)
    gbFeature1: TGroupBox;
    cbGradientEnabled: TCheckBox;
    Label4: TLabel;
    tbQuality: TTrackBar;
    lblQuality: TLabel;
    Label5: TLabel;
    gbFeature2: TGroupBox;
    cbUseTahoma: TCheckBox;
    btnMDT: TButton;
    btnMDPT: TButton;
    gbFeature3: TGroupBox;
    lbFiles: TListBox;
    Label1: TLabel;
    cbAcceptFiles: TCheckBox;
    gbFeature4: TGroupBox;
    Label2: TLabel;
    Label3: TLabel;
    edMinX: TEdit;
    edMaxX: TEdit;
    Label6: TLabel;
    edMinY: TEdit;
    Label7: TLabel;
    edMaxY: TEdit;
    Label8: TLabel;
    btnImportant: TButton;
    btnRangeApply: TButton;
    Label9: TLabel;
    procedure cbUseTahomaClick(Sender: TObject);
    procedure cbGradientEnabledClick(Sender: TObject);
    procedure tbQualityChange(Sender: TObject);
    procedure btnMDTClick(Sender: TObject);
		procedure btnMDPTClick(Sender: TObject);
		procedure FormDrop(Sender: TObject; DragFiles: TStrings; p: TPoint);
    procedure cbAcceptFilesClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure RangeKeyPress(Sender: TObject; var Key: Char);
    procedure btnImportantClick(Sender: TObject);
    procedure btnRangeApplyClick(Sender: TObject);
	private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
	end;

var
  DemoMain: TDemoMain;

implementation

{$R *.DFM}

procedure TDemoMain.FormCreate(Sender: TObject);
begin
	OnDrop:=FormDrop;

	btnRangeApplyClick(Sender);
end;

procedure TDemoMain.FormDrop(Sender: TObject; DragFiles: TStrings; p: TPoint);
begin
	With lbFiles.Items do begin
		Clear; AddStrings(DragFiles);
	end;
end;

procedure TDemoMain.cbUseTahomaClick(Sender: TObject);
begin
	UseTahoma:=cbUseTahoma.Checked;
end;

procedure TDemoMain.cbGradientEnabledClick(Sender: TObject);
var g: TGradient;
begin
	g:=Gradient;
	g.Enabled:=cbGradientEnabled.Checked;
	Gradient:=g;
end;

procedure TDemoMain.tbQualityChange(Sender: TObject);
var g: TGradient;
begin
	g:=Gradient;
	g.Quality:=tbQuality.Position*2-1;
	Gradient:=g;
end;

procedure TDemoMain.btnMDTClick(Sender: TObject);
begin
	MessageDlgT('If you have selected "UseTahoma" this message dialog uses the "Tahoma" font.', mtInformation, [mbOK], 0);
end;

procedure TDemoMain.btnMDPTClick(Sender: TObject);
begin
	MessageDlgPosT('This window ist located at (42, 42).'+#13#10#13#10+'If you have selected "UseTahoma" this message dialog uses the "Tahoma" font.', mtInformation, [mbOK], 0, 42, 42);
end;

procedure TDemoMain.cbAcceptFilesClick(Sender: TObject);
begin
	AcceptDragFiles:=cbAcceptFiles.Checked;
end;

procedure TDemoMain.RangeKeyPress(Sender: TObject; var Key: Char);
begin
	If not (Key in ['0'..'9', #8]) Then Key:=#0;
end;

procedure TDemoMain.btnImportantClick(Sender: TObject);
begin
	MessageDlgT('You may use the ExtForm unit for free.'+#13#10#13#10+'I would be pleased if you send me a post card or a email so I know if anybody use this unit. Please report all bugs, too.'+#13#10#13#10+'My email adress:'+#13#10+'  fischer@rbg.informatik.tu-darmstadt.de'+#13#10#13#10+'My post adress:'+#13#10+'  Thomas Fischer'+#13#10+'  Am Rundacker 8'+#13#10+'  D-65366 Geisenheim'+#13#10+'  Germany'+#13#10#13#10+'Enjoy using "TExtForm".', mtInformation, [mbOK], 0); 
end;

procedure TDemoMain.btnRangeApplyClick(Sender: TObject);
const EditNames: Array[0..3] of String[6]=('edMinX', 'edMaxX', 'edMinY', 'edMaxY');
var i: Integer;

begin
	For i:=0 to 3 do with FindComponent(EditNames[i]) as TEdit do begin
		If Text='' Then Text:='0';

		Case i of
		0: MinX:=StrToInt(Text);
		1: MaxX:=StrToInt(Text);
		2: MinY:=StrToInt(Text);
		3: MaxY:=StrToInt(Text);
		end;
	end;
end;

end.
