(*******************************************************************************
**
**  Explode Form
**
**	Puts a "Exploding" effect on a form. Simply drop the component on
**  the form and set the Source Rect for the effect.  Tested
**  only in Delphi 2.0. I really don't know if it works under Delphi 1.0,
**  but I think it will...
**
**  Feedback to:
**	Carlos Augusto Grahl
**	cgrahl@posthaus.com.br
**
**  Controls:
**  This code may be used, modified, included in applications without any
**  license agreements as long as the disclaimers are accepted, and the
**  comments are left intact.
**
**  Disclaimer:
**  This software is released into the public domain on the strict understanding
**  that neither myself nor any associates or companies I work for have any
**  liability explicity or implied.
**
**  Possible Enhancements:
**	I'm waiting for your ideas/comments...
*******************************************************************************)
unit Explform;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TShowType = (stAlways, stShow, stHide);
  TExplodeForm = class(TComponent)
  private
    FSteps : integer;
    FSource : TControl;
    FShowType: TShowType;
    FSourceLeft: Integer;
    FSourceTop: Integer;
    FSourceWidth: Integer;
    FSourceHeight: Integer;
    OwnerOnShow: TNotifyEvent;
    OwnerOnPaint: TNotifyEvent;
    OwnerOnHide: TNotifyEvent;
    procedure SetShow( Value: TShowType );
  protected
    Explode: boolean;
    Dc : HDc;
    OldPen, NewPen : HPen;
    OldBrush, NewBrush : HBrush;
    OldROP : Integer;
    procedure MyOnShow(Sender: TObject);
    procedure MyOnPaint(Sender: TObject);
    procedure MyOnHide(Sender: TObject);
    procedure ShowForm( Dc: Hdc; Source: TControl; Dest: TForm; Steps: Integer );
    procedure HideForm( Dc: Hdc; Source: TControl; Dest: TForm; Steps: Integer );
  public
    constructor Create( AOwner: TComponent ); override;
    procedure SetSourceRect( SourceControl : TControl );
    procedure SetSourceCenter;
  published
    property Steps: integer read FSteps write FSteps default 40;
    property SourceControl: TControl read FSource write FSource;
    property ShowType: TShowType read FShowType write SetShow default stAlways;
    property SourceLeft: integer read FSourceLeft write FSourceLeft;
    property SourceTop: integer read FSourceTop write FSourceTop;
    property SourceHeight: integer read FSourceHeight write FSourceHeight;
    property SourceWidth: integer read FSourceWidth write FSourceWidth;
  end;

procedure Register;

implementation

constructor TExplodeForm.Create( AOwner: TComponent );
begin
  inherited Create( AOwner );
  FSteps := 40;
  with Owner as TForm do
  begin
     OwnerOnShow := OnShow;  {Save the old Event Address}
     OnShow := MyOnShow;     {redirect the event to my component}
     OwnerOnPaint := OnPaint;
     OnPaint := MyOnPaint;
     OwnerOnHide := OnHide;
     OnHide := MyOnHide;
  end;
  Explode := True;
end;

procedure TExplodeForm.SetShow( Value: TShowType );
begin
  if Value <> FShowType then
     FShowType := Value;
end;

procedure TExplodeForm.MyOnShow(Sender: TObject);
begin
  if ShowType in [stAlways, stShow] then
  begin
    If Explode then
    begin
      Dc := GetDc(0);
      NewPen := GetStockObject( BLACK_PEN );
      NewBrush := GetStockObject( NULL_BRUSH );
      OldPen := SelectObject( Dc, NewPen );
      OldBrush := SelectObject( Dc, NewBrush );
      OldROP := SetROP2(Dc, R2_NOTXORPEN);
      ShowForm( Dc, FSource, Owner as TForm, FSteps );
      SelectObject( Dc, OldPen );
      SelectObject( Dc, OldBrush );
      SetRop2( Dc, OldRop );
      ReleaseDC(0, Dc);
      Explode := False;
      with Owner as TForm do  {Execute the form's OnShow}
      begin
        OnShow := OwnerOnShow;
        if Assigned(OnShow) then OwnerOnShow(Sender);
      end;
    end;
  end;
  Application.ProcessMessages;
end;

procedure TExplodeForm.MyOnPaint(Sender: TObject);
begin
  Explode := True;
  with Owner as Tform do
  begin
    OnPaint := OwnerOnPaint;
    If Assigned(OnPaint) then OwnerOnPaint(sender);
    Application.ProcessMessages;
    OwnerOnPaint := OnPaint;
    OnPaint := MyOnPaint;
    OwnerOnShow := OnShow;
    OnShow := MyOnShow;
    OwnerOnHide := OnHide;
    OnHide := MyOnHide;
  end;
end;

procedure TExplodeForm.MyOnHide(Sender: TObject);
begin
  if ShowType in [stAlways, stHide] then
  begin
    if Explode then
    begin
      Dc := GetDc(0);
      NewPen := GetStockObject( BLACK_PEN );
      NewBrush := GetStockObject( NULL_BRUSH );
      OldPen := SelectObject( Dc, NewPen );
      OldBrush := SelectObject( Dc, NewBrush );
      OldROP := SetROP2(Dc, R2_NOTXORPEN);
      HideForm( Dc, FSource, Owner as TForm, FSteps );
      SelectObject( Dc, OldPen );
      SelectObject( Dc, OldBrush );
      SetRop2( Dc, OldRop );
      ReleaseDC(0, Dc);
      Explode := False;
      Application.ProcessMessages;
      with Owner as TForm do
      begin
        OnHide := OwnerOnHide;
        if Assigned(OnHide) then OwnerOnHide(Sender);
      end;
    end;
  end;
  Application.ProcessMessages;
  Explode :=True;
end;

procedure TExplodeForm.ShowForm( Dc: Hdc; Source: TControl; Dest: TForm; Steps: Integer );
var
  XEnd, YEnd, WEnd, HEnd : Integer;
  IncX, IncY, IncW, IncH : Integer;
  X, Y, W, H : Integer;
  count : integer;
  topPoint, botPoint: TPoint;
  NewPoint : TPoint;
begin
  If Steps = 0 then
    Steps := 1;
  if source = nil then
  begin
    X := FSourceLeft;
    Y := FSourceTop;
    W := FSourceWidth;
    H := FSourceHeight;
  end
  else
  begin
    TopPoint.X := source.left;
    TopPoint.Y := source.Top;
    ClientToScreen(Application.Handle, TopPoint);
    NewPoint := TopPoint;
    X := NewPoint.X;
    Y := NewPoint.Y;
    botPoint.X := source.left + source.Width;
    botPoint.Y := source.Height + source.Top;
    ClientToScreen(Application.Handle, botPoint);
    NewPoint := botPoint;
    W := NewPoint.X;
    H := NewPoint.Y;
  end;
  XEnd := Dest.Left;
  YEnd := Dest.Top;
  WEnd := Dest.Width + Dest.Left;
  HEnd := Dest.Height + Dest.Top;
  IncX := Trunc( (XEnd - X) / steps );
  IncY := Trunc( (YEnd - Y) / steps );
  IncW := Trunc( (WEnd - W) / steps );
  IncH := Trunc( (HEnd - H) / steps );
  For count := 0 to steps do
  begin
    Rectangle( Dc, X, Y, W, H );
    X := X + IncX;
    Y := Y + IncY;
    W := W + IncW;
    H := H + IncH;
    Application.ProcessMessages;
  end;
  Rectangle( Dc, XEnd, YEnd, WEnd, HEnd );
  if source = nil then
  begin
    X := FSourceLeft;
    Y := FSourceTop;
    W := FSourceWidth;
    H := FSourceHeight;
  end
  else
  begin
    TopPoint.X := source.left;
    TopPoint.Y := source.Top;
    ClientToScreen(Application.Handle, TopPoint);
    NewPoint := TopPoint;
    X := NewPoint.X;
    Y := NewPoint.Y;
    botPoint.X := source.left + source.Width;
    botPoint.Y := source.Height + source.Top;
    ClientToScreen(Application.Handle, botPoint);
    NewPoint := botPoint;
    W := NewPoint.X;
    H := NewPoint.Y;
  end;
  For count := 0 to steps do
  begin
    Rectangle( Dc, X, Y, W, H );
    X := X + IncX;
    Y := Y + IncY;
    W := W + IncW;
    H := H + IncH;
    Application.ProcessMessages;
  end;
  Rectangle( Dc, XEnd, YEnd, WEnd, HEnd );
end;

procedure TExplodeForm.HideForm( Dc: Hdc; Source: TControl; Dest: TForm; Steps: Integer );
var
  XEnd, YEnd, WEnd, HEnd : Integer;
  XTemp, YTemp, WTemp, HTemp : Integer;
  IncX, IncY, IncW, IncH : Integer;
  X, Y, W, H : Integer;
  count : integer;
  topPoint, botPoint: TPoint;
  NewPoint : TPoint;
begin
  If Steps = 0 then
    Steps := 1;
  if source = nil then
  begin
    X := FSourceLeft;
    Y := FSourceTop;
    W := FSourceWidth;
    H := FSourceHeight;
  end
  else
  begin
    TopPoint.X := source.left;
    TopPoint.Y := source.Top;
    ClientToScreen(Application.Handle, TopPoint);
    NewPoint := TopPoint;
    X := NewPoint.X;
    Y := NewPoint.Y;
    botPoint.X := source.left + source.Width;
    botPoint.Y := source.Height + source.Top;
    ClientToScreen(Application.Handle, botPoint);
    NewPoint := botPoint;
    W := NewPoint.X;
    H := NewPoint.Y;
  end;
  XTemp := Dest.Left;
  YTemp := Dest.Top;
  WTemp := Dest.Width + Dest.Left;
  HTemp := Dest.Height + Dest.Top;
  XEnd := XTemp;
  YEnd := YTemp;
  WEnd := WTemp;
  HEnd := HTemp;
  IncX := Trunc( (XEnd - X) / steps );
  IncY := Trunc( (YEnd - Y) / steps );
  IncW := Trunc( (WEnd - W) / steps );
  IncH := Trunc( (HEnd - H) / steps );
  For count := 0 to steps do
  begin
    Rectangle( Dc, XEnd, YEnd, WEnd, HEnd );
    XEnd := XEnd - IncX;
    YEnd := YEnd - IncY;
    WEnd := WEnd - IncW;
    HEnd := HEnd - IncH;
    Application.ProcessMessages;
  end;
  Rectangle( Dc, X, Y, W, H );
  XEnd := XTemp;
  YEnd := YTemp;
  WEnd := WTemp;
  HEnd := HTemp;
  For count := 0 to steps do
  begin
    Rectangle( Dc, XEnd, YEnd, WEnd, HEnd );
    XEnd := XEnd - IncX;
    YEnd := YEnd - IncY;
    WEnd := WEnd - IncW;
    HEnd := HEnd - IncH;
    Application.ProcessMessages;
  end;
  Rectangle( Dc, X, Y, W, H );
end;

procedure TExplodeForm.SetSourceRect( SourceControl : TControl );
var
  topPoint, botPoint: TPoint;
  NewPoint : TPoint;
  SourceForm : TControl;
begin
    SourceForm := SourceControl;
    While not (SourceForm is TForm) do  {Find the form that owner the component}
       SourceForm := SourceForm.Parent;
    TopPoint.X := sourceControl.left;
    TopPoint.Y := sourceControl.Top;
    ClientToScreen((SourceForm as TWinControl).Handle, TopPoint);
    NewPoint := TopPoint;
    FSourceLeft := NewPoint.X;
    FSourceTop := NewPoint.Y;
    botPoint.X := sourceControl.left + sourceControl.Width;
    botPoint.Y := sourceControl.Height + sourceControl.Top;
    ClientToScreen((SourceForm as TWinControl).Handle, botPoint);
    NewPoint := botPoint;
    FSourceWidth := NewPoint.X;
    FSourceHeight := NewPoint.Y;
end;

procedure TExplodeForm.SetSourceCenter;
begin
  FSourceTop := Trunc(Screen.Height / 2);
  FSourceHeight := Trunc(Screen.Height / 2);
  FSourceLeft := Trunc(Screen.Width / 2);
  FSource.Width := Trunc(Screen.Width / 2);
end;

procedure Register;
begin
  RegisterComponents('Additional', [TExplodeForm]);
end;

end.
