unit ExitDialogs;

{**********************************************************}
{                                                          }
{  TShutdownDialog & TRestartDialog Unit                   }
{  Copyright 1999 Workshell Software.                     }
{							   }
{  Version 1.0						   }
{                                                          }
{                                                          }
{  Web      -> http://www.workshell.uni.cc/                }
{  E - Mail -> exitdlgs@kinsella.u-net.com                 }
{                                                          }
{**********************************************************}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
 TShutdownDialog = class(TComponent)
  private
    { Private declarations }
  protected
    { Protected declarations }
  public
    { Public declarations }
    procedure Execute;
  published
    { Published declarations }
  end;

type
 TRestartKind = (rkLogoff, rkShutdown, rkReboot, rkRestart);

type
 TRestartDialog = class(TComponent)
  private
    { Private declarations }
    FRestartKind: TRestartKind;
    procedure SetRestartKind(Value: TRestartKind);
  protected
    { Protected declarations }
    constructor Create(AOwner: TComponent); override;
  public
    { Public declarations }
    function Execute: Boolean;
    function ExecuteEx(Kind: TRestartKind): Boolean;
  published
    { Published declarations }
    property RestartKind: TRestartKind read FRestartKind write SetRestartKind;
  end;

var
 Flags: LongInt = 2;

procedure Register;

implementation

procedure ExitWindowsDialog(ParentWnd: HWND); stdcall;
 external 'Shell32.dll' index 60;

function RestartDialog(ParentWnd: HWND; Reason: PAnsiChar; Flags: LongInt): LongInt;
 stdcall; external 'Shell32.dll' index 59;

procedure TShutdownDialog.Execute;
begin
 ExitWindowsDialog(0);
end;

constructor TRestartDialog.Create(AOwner: TComponent);
begin
 inherited Create(AOwner);
 RestartKind := rkRestart;
end;

function TRestartDialog.Execute: Boolean;
begin
case RestartKind of
 rkLogoff: Flags := EWX_LOGOFF;
 rkShutdown: Flags := EWX_SHUTDOWN;
 rkReboot: Flags := EWX_REBOOT;
 rkRestart: Flags := EW_RESTARTWINDOWS;
end;
if RestartDialog(0,nil,Flags) = IDYES then
 begin
  Result := True;
 end
else
 Result := False;
end;

function TRestartDialog.ExecuteEx(Kind: TRestartKind): Boolean;
begin
case Kind of
 rkLogoff: Flags := EWX_LOGOFF;
 rkShutdown: Flags := EWX_SHUTDOWN;
 rkReboot: Flags := EWX_REBOOT;
 rkRestart: Flags := EW_RESTARTWINDOWS;
end;
if RestartDialog(0,nil,Flags) = IDYES then
 begin
  Result := True;
 end
else
Result := False;
end;

procedure TRestartDialog.SetRestartKind(Value: TRestartKind);
begin
if Value <> FRestartKind then
 begin
  FRestartKind := Value;
 end;
end;

procedure Register;
begin
  RegisterComponents('Dialogs', [TShutdownDialog,TRestartDialog]);
end;

end.
