unit demo1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  EnhWave, ExtCtrls, StdCtrls, Buttons;

type
  TForm1 = class(TForm)
    WaveIn: TEnhWaveIn;
    WaveOut: TEnhWaveOut;
    wave: TPaintBox;
    BTOpen: TBitBtn;
    BTClose: TBitBtn;
    Label1: TLabel;
    procedure BTOpenClick(Sender: TObject);
    procedure BTCloseClick(Sender: TObject);
    procedure WaveInData(sender: TObject; data: PChar; size: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.BTOpenClick(Sender: TObject);
begin
WaveIn .open;
WaveOut.open;
end;

procedure TForm1.BTCloseClick(Sender: TObject);
begin
WaveOut.close;
WaveIn .close;
end;

procedure TForm1.WaveInData(sender: TObject; data: PChar; size: Integer);
var i   :integer;
    x   :integer;
    xi  :integer;
    yi  :integer;
    xs  :integer;
    ys  :integer;
begin
if size<>WaveIn.BufferSize then exit;
WaveOut.playback(data,size);
xi:=0;
yi:=0;
xs:=wave.width ;
ys:=wave.height;
{ erase background }
wave.canvas.brush.color:=clWindow;
wave.canvas.CopyMode:=cmSrcCopy;
{wave.canvas.FillRect(Rect(xi,yi,xi+xs,yi+ys));}
wave.canvas.rectangle(xi,yi,xi+xs,yi+ys);
wave.canvas.brush.color:=clGreen;
{ plot }
for x:=0 to xs-1 do
  begin
  i:=trunc(x/xs*size);
  wave.canvas.MoveTo(xi+x,yi+ys div 2);
  wave.canvas.LineTo(xi+x,yi+ys div 2-round((byte(data[i])-128)/128*ys));
  end;  { for i }
end;

end.
