unit UHelp;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls;

type
  TWHelp = class(TForm)
    Panel1: TPanel;
    RichEdit1: TRichEdit;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  WHelp: TWHelp;

implementation

{$R *.DFM}

procedure TWHelp.FormCreate(Sender: TObject);
begin
     RichEdit1.Lines.Add('');

     RichEdit1.SelAttributes.Color := clGreen;
     RichEdit1.SelAttributes.Style := [fsBold,fsUnderline];
     RichEdit1.Lines.Add(' ENumFonts:');

     RichEdit1.SelAttributes.Color := clBlack;
     RichEdit1.SelAttributes.Style := [];
     RichEdit1.Lines.Add('');

     RichEdit1.Lines.Add(' The EnumFonts function enumerates the fonts available ' +
                        'on a specified device. For each font with the specified ' +
                        'typeface name, the EnumFonts function retrieves information ' +
                        'about that font and passes it to the application-defined ' +
                        'callback function. This callback function can process the font ' +
                        'information as desired. Enumeration continues until there are ' +
                        'no more fonts or the callback function returns zero.');
     RichEdit1.Lines.Add('');

     RichEdit1.SelAttributes.Color := clRed;
     RichEdit1.Lines.Add(' This function is provided for compatibility with earlier versions ' +
                        'of Microsoft Windows. Win32-based applications should use the ' +
                        'EnumFontFamilies function.');

     RichEdit1.Lines.Add('');

     RichEdit1.SelAttributes.Color := clGreen;
     RichEdit1.SelAttributes.Style := [fsBold,fsUnderline];
     RichEdit1.Lines.Add(' ENumFontFamilies:');

     RichEdit1.SelAttributes.Color := clBlack;
     RichEdit1.SelAttributes.Style := [];
     RichEdit1.Lines.Add('');

     RichEdit1.Lines.Add(' The EnumFontFamilies function enumerates the fonts in a specified font ' +
                         'family that are available on a specified device. This function supersedes ' +
                         'the EnumFonts function.');
     RichEdit1.Lines.Add('');
     RichEdit1.Lines.Add(' The EnumFontFamilies function differs from the EnumFonts function in that ' +
                         'it retrieves the style names associated with a TrueType font. With ' +
                         'EnumFontFamilies, information can be retrieved about unusual font styles (for ' +
                         'example, Outline) that could not be enumerated by using the EnumFonts function. ' +
                         'Win32-based applications should use EnumFontFamilies instead of EnumFonts.');

     RichEdit1.Lines.Add('');

     RichEdit1.SelAttributes.Color := clGreen;
     RichEdit1.SelAttributes.Style := [fsBold,fsUnderline];
     RichEdit1.Lines.Add(' ENumFontFamiliesEx:');

     RichEdit1.SelAttributes.Color := clRed;
     RichEdit1.SelAttributes.Style := [];
     RichEdit1.Lines.Add('[New - Windows 95]');

     RichEdit1.SelAttributes.Color := clBlack;
     RichEdit1.Lines.Add('');

     RichEdit1.Lines.Add(' The EnumFontFamiliesEx function enumerates all fonts in the system that match ' +
                         'the font characteristics given by the the LOGFONT structure. EnumFontFamiliesEx ' +
                         'enumerates fonts based on typeface name, character set, or both. It is recommended ' +
                         'that Win32-based applications use this function rather than EnumFontFamilies to ' +
                         'enumerate fonts.');
     RichEdit1.Lines.Add('');
     RichEdit1.Lines.Add(' EnumFontFamiliesEx does not use "tagged" typeface names to identify character sets. ' +
                         'Instead, it always passes the correct typeface name and a separate character set value ' +
                         'to the callback function. ');

     RichEdit1.Lines.Add('');
     RichEdit1.Lines.Add('');

     RichEdit1.SelAttributes.Color := clNavy;
     RichEdit1.SelAttributes.Style := [fsBold];
     RichEdit1.Lines.Add(' The Above Information are copied from "Win32 Developer''s References"');

     RichEdit1.Lines.Add('');
     RichEdit1.SelAttributes.Color := clBlack;
     RichEdit1.SelAttributes.Style := [];
     RichEdit1.Lines.Add(' Some short hints:');
     RichEdit1.Lines.Add(' 1. The purpose of this sample is just to show how you can use "Enum..." and "Callback" Functions. ' +
                         'This sample is not perfect and is not supposed to be.');
     RichEdit1.Lines.Add('');
     RichEdit1.Lines.Add(' 2. You might see some unexpected stuff getting added to the string grid. Don''t wonder and study ' +
                         'the sample, then you''ll find out why this unexpected stuff gets added');
     RichEdit1.Lines.Add('');
     RichEdit1.Lines.Add(' 3. This sample is NOT intelligent, (like me!), so forgive me if I did n''t come up with a better ' +
                         'solution to do different stuff. I would be happy if I could get some feedback in case you know a better, ' +
                         'other way to do some of the routines.');
     RichEdit1.Lines.Add('');
     RichEdit1.Lines.Add(' 4. I could not get rid of problems the Font "Modern.fon" generates. If you remove this font, temperory, ' +
                         ' then the sample works fine. If not, then the result will be a bit unexpected. Nothing dangerous.');

end;

end.
