//  Created: 15.04.97
//  Last Update: 16.04.97
//
//  ***************************************************************************
//  Source Project Name     : ENumCallBack.dpr
//  Exe Filename	    : ENumCallBack.exe, Not included
//  Zip Filename	    : enumcall.zip
//  Autor                   : Alex Wernhardt
//  Copyright               : 1997, HelpMakers
//  First Creation          : 15.04.1997
//  Last Update             : 16.04.1997
//  First Release           : 16.04.1997
//  Release State           : Exe File as Freeware, Not included
//                          : Source File included, Freeware
//  Compiler                : Delphi 2.0
//  Custom Components       : None
//  Purpose                 : 1- How to use API Font Enumeration functions
//  			      2- How to use Callback functions
//  Version                 : None
//  Tested under            : Windows 95 [(4.0.95)]
//                                                     |
//                          : Small Font, 600*800      |\
//                          : Samll Font, 1024*768     | \  Pentium 200Mhz, 40Mb, 2Mb
//						       | /
//                                                     |/
//  Platform(s)             : Windows95, WindowsNT
//                          : 32-bit
//*****************************************************************************

unit UEnumCallBack;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids, ExtCtrls;
type
  EArrayOverflow = class(Exception);

type
  TWEnumCallback = class(TForm)
    Panel1: TPanel;
    StringGrid1: TStringGrid;
    Panel2: TPanel;
    bENumFont: TButton;
    bENumFontFam: TButton;
    bENumFontFamEx: TButton;
    Button2: TButton;
    Label1: TLabel;
    Panel3: TPanel;
    StringGrid2: TStringGrid;
    Button1: TButton;
    procedure bENumFontFamClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure bENumFontClick(Sender: TObject);
    procedure bENumFontFamExClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  WEnumCallback: TWEnumCallback;
  GlobLogFont: TLogFont;
  GlobLogFontList: Array[0..70] of TLogFont;
  CRLF: String;
  X: Integer = 0;

implementation

uses UHelp;

{$R *.DFM}

//*********************************//
// You should try NOT to use these //
// function. Refer to Delphi Help  //
//*********************************//
//---------------------------------//
//-- ENumFonts and ENumFontProcs --//
//---------------------------------//
function EnumFontsProc(var LogFont: TLogFont; var TextMetric: TTextMetric;
  FontType: Integer; Data: Pointer): Integer; stdcall;
begin
  TStrings(Data).Add(LogFont.lfFaceName);
  GlobLogFont := LogFont;
  GlobLogFontList[X] := GlobLogFont;
  X := X + 1;
  Result := 1;
end;

procedure TWEnumCallback.bENumFontClick(Sender: TObject);
var
  DC: HDC;
  EFonts: TStringList;
  I: Integer;
begin
  DC := GetDC(0);
  EFonts := TStringList.Create;
  EnumFonts(DC, nil , @EnumFontsProc, Pointer(EFonts));
  ReleaseDC(0, DC);
  // FIll the first column with numbers
  for I := 0 to StringGrid1.RowCount do
      StringGrid1.Rows[I].Add(IntToStr(I));
  StringGrid1.Cols[1] := EFonts;
  StringGrid2.Cols[1].Add('FaceName');
  bENumFont.Enabled := False;
  bENumFontFam.Enabled := True;
end;
//******************************************//


//******************************************//
// You should try to use THESE function     //
// instead. Refer to Delphi Help            //
//******************************************//
//------------------------------------------//
//-- ENumFontFamilies and ENumFontFamProc --//
//------------------------------------------//
function EnumFontFamProc(var EnumLogFont: TEnumLogFont; var NewTextMetric: TNewTextMetric;
  FontType: Integer; Data: Pointer): Integer; stdcall;
begin
  if (FontType = DEVICE_FONTTYPE) or (FontType = RASTER_FONTTYPE) then begin
     TStrings(Data).Add(EnumLogFont.elflogfont.lfFaceName);
     TStrings(Data).Add('No Style');
     end
  else begin
       TStrings(Data).Add(EnumLogFont.elfFullName);
       TStrings(Data).Add(EnumLogFont.elfStyle);
       end;

  Result := 1;
end;

procedure TWEnumCallback.bENumFontFamClick(Sender: TObject);
var
  DC: HDC;
  EFonts: TStringList;
  I, N, J: Integer;
begin
  //-- Choose a Device Context
  DC := GetDC(0);
  //-- Create a list Object
  EFonts := TStringList.Create;
  //-- Enumerate Fonts and put the inforamtion into the above made object
  EnumFontFamilies(DC, nil , @EnumFontFamProc, Integer(EFonts));
  //-- Relase the Device Context
  ReleaseDC(0, DC);
  //-- Sets counters to 0
  I := 0;  N := 0;  J := 0;
  //-- Loop until the last item in the list
  for I := 0 to EFonts.Count - 1 do begin
      //-- To get started from the right position
      if I = 0 then
         J := -1;
      //-- To jump 2 steps each time
      for N := I to I + 1 do begin
          J := J + 1;
          end;
      //-- To avoid the out of bounds Exception
      if J <= EFonts.Count - 1 then begin
         StringGrid1.Cols[4].Add(EFonts[J]);
         StringGrid1.Cols[3].Add(EFonts[J - 1]);
         end;
      end;

  StringGrid2.Cols[3].Add('FullName');
  StringGrid2.Cols[4].Add('Style');

  bENumFontFam.Enabled := False;
  bENumFontFamEx.Enabled := True;
end;
//******************************************//

//******************************************//
// These are NEW functions for Win95. Refer //
// to Delphi Help for more info             //
//******************************************//
//----------------------------------------------//
//-- ENumFontFamiliesEx and ENumFontFamExProc --//
//----------------------------------------------//
function EnumFontFamExProc(var EnumLogFontEx: TEnumLogFontEx; var NewTextMetricEx: TNewTextMetricEx;
  FontType: Integer; Data: Pointer): Integer; stdcall;
begin

     if (FontType = DEVICE_FONTTYPE) or (FontType = RASTER_FONTTYPE) then begin
        TStrings(Data).Add('No FullName');
        TStrings(Data).Add('Raster/Device Font');
        TStrings(Data).Add(StrPas(@EnumLogFontEx.elfScript));
        TStrings(Data).Add(EnumLogFontEx.elfLogFont.lfFaceName);
        end
     else begin
          TStrings(Data).Add(StrPas(@EnumLogFontEx.elfFullName));
          TStrings(Data).Add(StrPas(@EnumLogFontEx.elfStyle));
          TStrings(Data).Add(StrPas(@EnumLogFontEx.elfScript));
          TStrings(Data).Add(EnumLogFontEx.elfLogFont.lfFaceName);
          end;
  Result := 1;
end;

procedure TWEnumCallback.bENumFontFamExClick(Sender: TObject);
var
  DC: HDC;
  EFonts: TStringList;
  I, N, J: Integer;
begin
  DC := GetDC(0);
  EFonts := TStringList.Create;
  For I := 0 to Screen.Fonts.Count do
      EnumFontFamiliesEx(DC, GlobLogFontList[I] , @EnumFontFamExProc, Integer(EFonts), 0);
  ReleaseDC(0, DC);
  //-- Sets counters to 0
  I := 0;  N := 0;  J := 0;
  //-- Loop until the last item in the list
  for I := 0 to EFonts.Count - 1 do begin
      //-- To get started from the right position
      if I = 0 then
         J := -1;
      //-- To jump 3 steps each time
      for N := I to I + 3 do begin
          J := J + 1;
          end;
      //-- To avoid the out of bounds Exception
      if J <= EFonts.Count - 1 then begin
         StringGrid1.Cols[9].Add(EFonts[J]);
         StringGrid1.Cols[8].Add(EFonts[J - 1]);
         StringGrid1.Cols[7].Add(EFonts[J - 2]);
         StringGrid1.Cols[6].Add(EFonts[J - 3]);
         end;
      end;

  StringGrid2.Cols[9].Add('FullName');
  StringGrid2.Cols[8].Add('Script');
  StringGrid2.Cols[7].Add('Style');
  StringGrid2.Cols[6].Add('FaceName');

  bENumFontFamEx.Enabled := False;
end;

//---------//
//-- End --//
//---------//
procedure TWEnumCallback.Button2Click(Sender: TObject);
begin
     Close;
end;

procedure TWEnumCallback.FormCreate(Sender: TObject);
begin
     StringGrid1.ColWidths[0] := 25;
     StringGrid1.ColWidths[2] := 25;
     StringGrid1.ColWidths[5] := 25;
     StringGrid2.ColWidths[0] := 25;
     StringGrid2.ColWidths[2] := 25;
     StringGrid2.ColWidths[5] := 25;
end;

//******************************************
//****** Application Starting Point ********
//******************************************
procedure TWEnumCallback.Button1Click(Sender: TObject);
begin
     WHelp.Show;
end;

initialization
begin
     CRLF := Char(13) + Char(10);
     if Screen.Fonts.Count >= 70 then
        raise
             EArrayOverFlow.Create('Hi!!! Don''t worry, this is not a real Exception! ' +
                                   'It is just raised to catch your attention. Why? ' + CRLF + CRLF +
                                   'Because to run the sample, you got to be sure about ' +
                                   'the number of the fonts installed in your machine. ' +
                                   'If you got more than 70 fonts installed, then you ' +
                                   'got to change the ' + CRLF + CRLF +
                                   'GlobLogFontList: Array[0..70] of TLogFont ' + CRLF +
                                   'to ' + CRLF +
                                   'GlobLogFontList: Array[0..estimated number of installed fonts in your machine] ' +
                                   'of TLogFont' + CRLF + CRLF +
                                   'then run the smaple. If you do not change the value, and you got more than ' +
                                   '40 fonts installed, you receive a real exception, of "ERangeError". type' + CRLF + CRLF + CRLF +
                                   'Alex Wernhardt, HelpMakers, 1997.                 ');
end;
end.



