unit CdrMap;

interface

uses Windows, SysUtils, Classes, Graphics, Dialogs;

Type
  TCdrMap = class(TBitmap)
  private
    FStream: TStream;
    Buffer: array [0..20000] Of Byte;
    MaxSize: Integer;
    FileHeader: TBitmapFileHeader;
    InfoHeader: TBitmapInfoHeader;              { File Header for bitmap file}
    procedure ReadCdr;
    procedure SaveCdrToStream(Stream: TStream);
  public
    Pos: Integer;
    constructor Create; override;
    destructor Destroy; override;
    procedure LoadFromStream(Stream: TStream); override;
  end;


implementation

uses Math;

constructor TCdrMap.Create;
begin
  inherited Create;
  FStream := nil;
end;

destructor TCdrMap.Destroy;
begin
  inherited Destroy;
end;

procedure TCdrMap.LoadFromStream(Stream: TStream);
var
  OutStream : TMemoryStream;
begin
  try
    FStream := Stream;
    OutStream := TMemoryStream.Create;
    ReadCdr;
    try
      SaveCdrToStream(OutStream);
      inherited LoadFromStream(OutStream);
    Finally
      OutStream.Free;
    end;
  Except
  end;
end;

procedure TCdrMap.ReadCdr;
Var
  DtaSize: Integer;
  PalSize: Integer;
Begin
  FStream.Position := 20;
  FStream.Read(FileHeader, SizeOf(FileHeader));
  FStream.Read(InfoHeader, SizeOf(InfoHeader));
  PalSize := (4 * Round(Power(2, InfoHeader.biBitCount)));
  If InfoHeader.biBitCount > 8 Then PalSize := 0;
  DtaSize := (InfoHeader.biWidth * InfoHeader.biHeight * InfoHeader.biBitCount) Div 8;
  With InfoHeader Do
  Begin
    biClrUsed        := 0;            {all colors are used}
    biClrImportant   := 0;            {all colors are important}
  End;
  With FileHeader Do
  Begin
    BfType := $4D42;            { BM }
    bfSize := PalSize +
              Sizeof(TBitmapFileHeader) +  {Color map info}
              Sizeof(TBitmapInfoHeader) +
              DtaSize;
    bfReserved1 := 0; {not currently used}
    bfReserved2 := 0; {not currently used}
    bfOffBits := PalSize +
                 Sizeof(TBitmapFileHeader)+
                 Sizeof(TBitmapInfoHeader);
  End;
  MaxSize := FStream.Read(Buffer, (PalSize + DtaSize));
End;

Procedure TCdrMap.SaveCdrToStream(Stream: TStream);
Begin
  Stream.Position := 0;
  Stream.Write(FileHeader, SizeOf(FileHeader));
  Stream.Write(InfoHeader, SizeOf(InfoHeader));
  MaxSize := Stream.Write(Buffer, MaxSize);
  Stream.Position := 0;
End;

end.
