unit AllMap;

interface

uses Windows, SysUtils, Classes, Graphics, GifMap, TifMap, CdrMap, PcxMap;

Type
  TAnymap = class(TBitmap)
  private
    Def: TPicture;
    Gif: TGifMap;
    Tif: TTifMap;
    Cdr: TCdrMap;
    Pcx: TPcxMap;
  protected
  public
    constructor Create; override;
    destructor Destroy; override;
    Function Supported(const Filename: string): Boolean;
    procedure LoadFromFile(const Filename: string); override;
  end;

implementation

constructor TAnymap.Create;
begin
  inherited Create;
end;

destructor TAnymap.Destroy;
begin
  inherited Destroy;
end;

Function TAnymap.Supported(const Filename: string): Boolean;
Var
  Ext: String;
begin
  Result := False;
  Ext := LowerCase(Copy(ExtractFileExt(Filename), 2, Maxint));
  If (Ext = 'bmp') Or (Ext = 'ico') Or (Ext = 'wmf') Or (Ext = 'emf') or
     (Ext = 'gif') Or (Ext = 'tif') Or (Ext = 'cdr') Or (Ext = 'pcx') Then
    Result := True;
end;

procedure TAnymap.LoadFromFile(const Filename: string);
Var
  Ext: String;
begin
  Ext := LowerCase(Copy(ExtractFileExt(Filename), 2, Maxint));
  If Ext = 'bmp' Then inherited LoadFromFile(Filename)
  Else If (Ext = 'ico') Or (Ext = 'wmf') Or (Ext = 'emf') Then
  Begin
    Def := TPicture.Create;
    Def.LoadFromFile(Filename);
    Height := Def.Height;
    Width := Def.Width;
    Canvas.Draw(0,0, Def.Graphic);
    Def.Free;
  End
  Else If Ext = 'gif' Then
  Begin
    Gif := TGifMap.Create;
    Gif.LoadFromFile(Filename);
    Assign(Gif);
    Gif.Free;
  End
  Else If Ext = 'tif' Then
  Begin
    Tif := TTifMap.Create;
    Tif.LoadFromFile(Filename);
    Assign(Tif);
    Tif.Free;
  End
  Else If Ext = 'cdr' Then
  Begin
    Cdr := TCdrMap.Create;
    Cdr.LoadFromFile(Filename);
    Assign(Cdr);
    Cdr.Free;
  End
  Else If Ext = 'pcx' Then
  Begin
    Pcx := TPcxMap.Create;
    Pcx.LoadFromFile(Filename);
    Assign(Pcx);
    Pcx.Free;
  End;
end;

end.
