unit FEhnOpen;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, FileCtrl, StdCtrls, ComCtrls, FileVDlg, ExtCtrls, Menus;

type
  TFormEnhOpen = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    FileListView: TFileListViewDlg;
    BtnOk: TButton;
    BtnCancel: TButton;
    FilterCmbFileType: TFilterComboBox;
    LabelFName: TLabel;
    LabelFType: TLabel;
    BtnPrevFold: TSpeedButton;
    BtnNewFold: TSpeedButton;
    BtnList: TSpeedButton;
    BtnReport: TSpeedButton;
    BtnSmallIcon: TSpeedButton;
    BtnIcon: TSpeedButton;
    FileNameEdit: TFileNameEditDlg;
    DirectoryComboDlg: TDirectoryComboDlg;
    EditFilePath: TEdit;
    BtnRefresh: TSpeedButton;
    BtnResLink: TSpeedButton;
    procedure FilterCmbFileTypeChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FileListViewDirectoryChange(Sender: TObject; OldDir,
      Directory: string; CanPrev: Boolean);
    procedure FileListViewChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure BtnPrevFoldClick(Sender: TObject);
    procedure BtnNewFoldClick(Sender: TObject);
    procedure BtnListClick(Sender: TObject);
    procedure BtnReportClick(Sender: TObject);
    procedure BtnSmallIconClick(Sender: TObject);
    procedure BtnIconClick(Sender: TObject);
    procedure BtnOkClick(Sender: TObject);
    procedure BtnCancelClick(Sender: TObject);
    procedure FileListViewViewChange(Sender: TObject; Style: TViewStyle);
    procedure BtnResLinkClick(Sender: TObject);
    procedure BtnRefreshClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormEnhOpen: TFormEnhOpen;

implementation

{$R *.DFM}

procedure TFormEnhOpen.FormCreate(Sender: TObject);
begin
  EditFilePath.Align := AlTop;
end;

procedure TFormEnhOpen.FilterCmbFileTypeChange(Sender: TObject);
begin
  FileListView.Mask := FilterCmbFileType.Mask;
end;

procedure TFormEnhOpen.FileListViewDirectoryChange(Sender: TObject; OldDir,
  Directory: string; CanPrev: Boolean);
begin
  BtnPrevFold.Enabled := CanPrev;
end;

procedure TFormEnhOpen.FileListViewChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
begin
  EditFilePath.Text := FileListView.FileName;
end;

procedure TFormEnhOpen.BtnRefreshClick(Sender: TObject);
begin
  FileListView.ReRead;
end;

procedure TFormEnhOpen.BtnPrevFoldClick(Sender: TObject);
begin
  BtnPrevFold.Enabled := FileListView.PrevDirectory;
end;

procedure TFormEnhOpen.BtnResLinkClick(Sender: TObject);
begin
  FileListView.ResolveLink := Not FileListView.ResolveLink;
  BtnResLink.Down := FileListView.ResolveLink;
end;

procedure TFormEnhOpen.BtnNewFoldClick(Sender: TObject);
begin
  FileListView.NewFolder;
end;

procedure TFormEnhOpen.BtnListClick(Sender: TObject);
begin
  FileListView.ViewIconStyle := vsList;
end;

procedure TFormEnhOpen.BtnReportClick(Sender: TObject);
begin
  FileListView.ViewIconStyle := vsReport;
end;

procedure TFormEnhOpen.BtnSmallIconClick(Sender: TObject);
begin
  FileListView.ViewIconStyle := vsSmallIcon;
end;

procedure TFormEnhOpen.BtnIconClick(Sender: TObject);
begin
  FileListView.ViewIconStyle := vsIcon;
end;

procedure TFormEnhOpen.BtnOkClick(Sender: TObject);
begin
  FileListView.ShellOpen;
end;

procedure TFormEnhOpen.BtnCancelClick(Sender: TObject);
begin
  Close;
end;

procedure TFormEnhOpen.FileListViewViewChange(Sender: TObject;
  Style: TViewStyle);
begin
  Case Ord(Style) Of
    0: BtnIcon.Down := True;
    1: BtnSmallIcon.Down := True;
    2: BtnList.Down := True;
    3: BtnReport.Down := True;
  End;
end;

end.
