unit DBEditK;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Mask, DBCtrls;
const VK_NULL = 0;

type
  TFunctionKeys = (kNONE, kF1, kF2, kF3, kF4, kF5, kF6, kF7, kF8,
                  kF9, kF10, kF11, kF12, kUP, kDOWN, kPGUP, kPGDOWN);

  TEditK = class(TEdit)
  private
    { Private declarations }
  protected
    { Protected declarations }
    procedure KeyDown(var Key: Word; Shift: TShiftState);override;
    procedure KeyPress(var Key: Char);override;
  public
    { Public declarations }
  published
    { Published declarations }
  end;

  TDBEditK = class(TDBEdit)
  private
    { Private declarations }
    fNextKey, fPriorKey, fFirstKey, fLastKey, fAppendKey, fInsertKey,
    fEditKey, fPostKey, fCancelKey, fDeleteKey, fRefreshKey: TFunctionKeys;

    NextK, PriorK, FirstK, LastK, AppendK, InsertK, EditK, PostK, CancelK,
    DeleteK, RefreshK: word;
  protected
    { Protected declarations }
    procedure KeyDown(var Key: Word; Shift: TShiftState);override;

    procedure SetNextKey(Value: TFunctionKeys);
    procedure SetPriorKey(Value: TFunctionKeys);
    procedure SetFirstKey(Value: TFunctionKeys);
    procedure SetLastKey(Value: TFunctionKeys);
    procedure SetAppendKey(Value: TFunctionKeys);
    procedure SetInsertKey(Value: TFunctionKeys);
    procedure SetEditKey(Value: TFunctionKeys);
    procedure SetPostKey(Value: TFunctionKeys);
    procedure SetCancelKey(Value: TFunctionKeys);
    procedure SetDeleteKey(Value: TFunctionKeys);
    procedure SetRefreshKey(Value: TFunctionKeys);
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
  published
    { Published declarations }
    Property NextKey: TFunctionKeys Read fNextKey Write SetNextKey default kNONE;
    Property PriorKey: TFunctionKeys Read fPriorKey Write SetPriorKey default kNONE;
    Property FirstKey: TFunctionKeys Read fFirstKey Write SetFirstKey default kNONE;
    Property LastKey: TFunctionKeys Read fLastKey Write SetLastKey default kNONE;
    Property AppendKey: TFunctionKeys Read fAppendKey Write SetAppendKey default kNONE;
    Property InsertKey: TFunctionKeys Read fInsertKey Write SetInsertKey default kNONE;
    Property EditKey: TFunctionKeys Read fEditKey Write SetEditKey default kNONE;
    Property PostKey: TFunctionKeys Read fPostKey Write SetPostKey default kNONE;
    Property CancelKey: TFunctionKeys Read fCancelKey Write SetCancelKey default kNONE;
    Property DeleteKey: TFunctionKeys Read fDeleteKey Write SetDeleteKey default kNONE;
    Property RefreshKey: TFunctionKeys Read fRefreshKey Write SetRefreshKey default kNONE;

  end;

procedure Register;

implementation

procedure TEditK.KeyDown;
begin
  if (Key = VK_RETURN) then begin
    PostMessage(Handle, WM_KEYDOWN, VK_TAB, 0);
  end;
  inherited;
end;

procedure TEditK.KeyPress;
begin
  if (ord(Key) = VK_RETURN) then begin
    Key := chr(0);
  end
  else inherited;
end;

//==========================================================================
//==========================================================================
//==========================================================================
//==========================================================================
//==========================================================================

constructor TDBEditK.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  fNextKey := kNONE;
  fPriorKey := kNONE;
  fFirstKey := kNONE;
  fLastKey := kNONE;
  fAppendKey := kNONE;
  fInsertKey := kNONE;
  fEditKey := kNONE;
  fPostKey := kNONE;
  fCancelKey := kNONE;
  fDeleteKey := kNONE;
  fRefreshKey := kNONE;
end;

procedure TDBEditK.KeyDown;
begin
  with Datasource.Dataset do begin
    if (Key = VK_RETURN) then begin
      PostMessage(Self.Handle, WM_KEYDOWN, VK_TAB, 0);
    end
    else if (Key = PriorK) and (RecordCount > 0) and (State = dsBrowse) and
       (BOF = false)  then begin
       Prior;
    end
    else if (Key = NextK) and (RecordCount > 0) and (State = dsBrowse) and
     (EOF = false)  then begin
      Next;
    end
    else if (Key = FirstK) and (RecordCount > 0) and (State = dsBrowse) and
     (BOF = false)  then begin
      First;
    end
    else if (Key = LastK) and (RecordCount > 0) and (State = dsBrowse) and
     (EOF = false)  then begin
      Last;
    end
    else if (Key = AppendK) and (State = dsBrowse) then begin
     Append;
    end
    else if (Key = InsertK) and (State = dsBrowse) then begin
     Insert;
    end
    else if (Key = EditK) and (State = dsBrowse) then begin
      Edit;
    end
    else if (Key = PostK) and ((State = dsEdit) or (State = dsInsert)) then begin
       Post;
    end
    else if (Key = CancelK) and ((State = dsEdit) or (State = dsInsert)) then begin
      Cancel;
    end
    else if (Key = DeleteK) and (RecordCount > 0) and (State = dsBrowse) then begin
      Delete;
    end
    else if (Key = RefreshK) then begin
      Refresh;
    end
    else if not((Key = VK_RETURN) or (Key = PriorK) or (Key = NextK) or
                (Key = FirstK) or (Key = LastK) or (Key = InsertK) or
                (Key = AppendK) or (Key = EditK) or (Key = PostK) or
                (Key = CancelK) or (Key = DeleteK) or (Key = RefreshK)) then
      inherited;
  end;
end;


procedure TDBEditK.SetNextKey(Value: TFunctionKeys);
begin
if (Value <> fNextKey) then begin
  fNextKey := Value;
  if (Value = kNONE) then
    NextK := 0;
  if (Value = kF1) then
    NextK := VK_F1;
  if (Value = kF2) then
    NextK := VK_F2;
  if (Value = kF3) then
    NextK := VK_F3;
  if (Value = kF4) then
    NextK := VK_F4;
  if (Value = kF5) then
    NextK := VK_F5;
  if (Value = kF6) then
    NextK := VK_F6;
  if (Value = kF7) then
    NextK := VK_F7;
  if (Value = kF8) then
    NextK := VK_F8;
  if (Value = kF9) then
    NextK := VK_F9;
  if (Value = kF10) then
    NextK := VK_F10;
  if (Value = kF11) then
    NextK := VK_F11;
  if (Value = kF12) then
    NextK := VK_F12;
  if (Value = kUP) then
    NextK := VK_UP;
  if (Value = kDOWN) then
    NextK := VK_DOWN;
  if (Value = kPGUP) then
    NextK := VK_PRIOR;
  if (Value = kPGDOWN) then
    NextK := VK_NEXT;
end;
end;
procedure TDBEditK.SetPriorKey(Value: TFunctionKeys);
begin
if (Value <> fPriorKey) then begin
  fPriorKey := Value;
  if (Value = kNONE) then
    PriorK := 0;
  if (Value = kF1) then
    PriorK := VK_F1;
  if (Value = kF2) then
    PriorK := VK_F2;
  if (Value = kF3) then
    PriorK := VK_F3;
  if (Value = kF4) then
    PriorK := VK_F4;
  if (Value = kF5) then
    PriorK := VK_F5;
  if (Value = kF6) then
    PriorK := VK_F6;
  if (Value = kF7) then
    PriorK := VK_F7;
  if (Value = kF8) then
    PriorK := VK_F8;
  if (Value = kF9) then
    PriorK := VK_F9;
  if (Value = kF10) then
    PriorK := VK_F10;
  if (Value = kF11) then
    PriorK := VK_F11;
  if (Value = kF12) then
    PriorK := VK_F12;
  if (Value = kUP) then
    PriorK := VK_UP;
  if (Value = kDOWN) then
    PriorK := VK_DOWN;
  if (Value = kPGUP) then
    PriorK := VK_PRIOR;
  if (Value = kPGDOWN) then
    PriorK := VK_NEXT;
end;
end;
procedure TDBEditK.SetFirstKey(Value: TFunctionKeys);
begin
if (Value <> fFirstKey) then begin
  fFirstKey := Value;
  if (Value = kNONE) then
    FirstK := 0;
  if (Value = kF1) then
    FirstK := VK_F1;
  if (Value = kF2) then
    FirstK := VK_F2;
  if (Value = kF3) then
    FirstK := VK_F3;
  if (Value = kF4) then
    FirstK := VK_F4;
  if (Value = kF5) then
    FirstK := VK_F5;
  if (Value = kF6) then
    FirstK := VK_F6;
  if (Value = kF7) then
    FirstK := VK_F7;
  if (Value = kF8) then
    FirstK := VK_F8;
  if (Value = kF9) then
    FirstK := VK_F9;
  if (Value = kF10) then
    FirstK := VK_F10;
  if (Value = kF11) then
    FirstK := VK_F11;
  if (Value = kF12) then
    FirstK := VK_F12;
  if (Value = kUP) then
    FirstK := VK_UP;
  if (Value = kDOWN) then
    FirstK := VK_DOWN;
  if (Value = kPGUP) then
    FirstK := VK_PRIOR;
  if (Value = kPGDOWN) then
    FirstK := VK_NEXT;
end;
end;
procedure TDBEditK.SetLastKey(Value: TFunctionKeys);
begin
if (Value <> fLastKey) then begin
  fLastKey := Value;
  if (Value = kNONE) then
    LastK := 0;
  if (Value = kF1) then
    LastK := VK_F1;
  if (Value = kF2) then
    LastK := VK_F2;
  if (Value = kF3) then
    LastK := VK_F3;
  if (Value = kF4) then
    LastK := VK_F4;
  if (Value = kF5) then
    LastK := VK_F5;
  if (Value = kF6) then
    LastK := VK_F6;
  if (Value = kF7) then
    LastK := VK_F7;
  if (Value = kF8) then
    LastK := VK_F8;
  if (Value = kF9) then
    LastK := VK_F9;
  if (Value = kF10) then
    LastK := VK_F10;
  if (Value = kF11) then
    LastK := VK_F11;
  if (Value = kF12) then
    LastK := VK_F12;
  if (Value = kUP) then
    LastK := VK_UP;
  if (Value = kDOWN) then
    LastK := VK_DOWN;
  if (Value = kPGUP) then
    LastK := VK_PRIOR;
  if (Value = kPGDOWN) then
    LastK := VK_NEXT;
end;
end;
procedure TDBEditK.SetAppendKey(Value: TFunctionKeys);
begin
if (Value <> fAppendKey) then begin
  fAppendKey := Value;
  if (Value = kNONE) then
    AppendK := 0;
  if (Value = kF1) then
    AppendK := VK_F1;
  if (Value = kF2) then
    AppendK := VK_F2;
  if (Value = kF3) then
    AppendK := VK_F3;
  if (Value = kF4) then
    AppendK := VK_F4;
  if (Value = kF5) then
    AppendK := VK_F5;
  if (Value = kF6) then
    AppendK := VK_F6;
  if (Value = kF7) then
    AppendK := VK_F7;
  if (Value = kF8) then
    AppendK := VK_F8;
  if (Value = kF9) then
    AppendK := VK_F9;
  if (Value = kF10) then
    AppendK := VK_F10;
  if (Value = kF11) then
    AppendK := VK_F11;
  if (Value = kF12) then
    AppendK := VK_F12;
  if (Value = kUP) then
    AppendK := VK_UP;
  if (Value = kDOWN) then
    AppendK := VK_DOWN;
  if (Value = kPGUP) then
    AppendK := VK_PRIOR;
  if (Value = kPGDOWN) then
    AppendK := VK_NEXT;
end;
end;
procedure TDBEditK.SetInsertKey(Value: TFunctionKeys);
begin
if (Value <> fInsertKey) then begin
  fInsertKey := Value;
  if (Value = kNONE) then
    InsertK := 0;
  if (Value = kF1) then
    InsertK := VK_F1;
  if (Value = kF2) then
    InsertK := VK_F2;
  if (Value = kF3) then
    InsertK := VK_F3;
  if (Value = kF4) then
    InsertK := VK_F4;
  if (Value = kF5) then
    InsertK := VK_F5;
  if (Value = kF6) then
    InsertK := VK_F6;
  if (Value = kF7) then
    InsertK := VK_F7;
  if (Value = kF8) then
    InsertK := VK_F8;
  if (Value = kF9) then
    InsertK := VK_F9;
  if (Value = kF10) then
    InsertK := VK_F10;
  if (Value = kF11) then
    InsertK := VK_F11;
  if (Value = kF12) then
    InsertK := VK_F12;
  if (Value = kUP) then
    InsertK := VK_UP;
  if (Value = kDOWN) then
    InsertK := VK_DOWN;
  if (Value = kPGUP) then
    InsertK := VK_PRIOR;
  if (Value = kPGDOWN) then
    InsertK := VK_NEXT;
end;
end;
procedure TDBEditK.SetEditKey(Value: TFunctionKeys);
begin
if (Value <> fEditKey) then begin
  fEditKey := Value;
  if (Value = kNONE) then
    EditK := 0;
  if (Value = kF1) then
    EditK := VK_F1;
  if (Value = kF2) then
    EditK := VK_F2;
  if (Value = kF3) then
    EditK := VK_F3;
  if (Value = kF4) then
    EditK := VK_F4;
  if (Value = kF5) then
    EditK := VK_F5;
  if (Value = kF6) then
    EditK := VK_F6;
  if (Value = kF7) then
    EditK := VK_F7;
  if (Value = kF8) then
    EditK := VK_F8;
  if (Value = kF9) then
    EditK := VK_F9;
  if (Value = kF10) then
    EditK := VK_F10;
  if (Value = kF11) then
    EditK := VK_F11;
  if (Value = kF12) then
    EditK := VK_F12;
  if (Value = kUP) then
    EditK := VK_UP;
  if (Value = kDOWN) then
    EditK := VK_DOWN;
  if (Value = kPGUP) then
    EditK := VK_PRIOR;
  if (Value = kPGDOWN) then
    EditK := VK_NEXT;
end;
end;
procedure TDBEditK.SetPostKey(Value: TFunctionKeys);
begin
if (Value <> fPostKey) then begin
  fPostKey := Value;
  if (Value = kNONE) then
    PostK := 0;
  if (Value = kF1) then
    PostK := VK_F1;
  if (Value = kF2) then
    PostK := VK_F2;
  if (Value = kF3) then
    PostK := VK_F3;
  if (Value = kF4) then
    PostK := VK_F4;
  if (Value = kF5) then
    PostK := VK_F5;
  if (Value = kF6) then
    PostK := VK_F6;
  if (Value = kF7) then
    PostK := VK_F7;
  if (Value = kF8) then
    PostK := VK_F8;
  if (Value = kF9) then
    PostK := VK_F9;
  if (Value = kF10) then
    PostK := VK_F10;
  if (Value = kF11) then
    PostK := VK_F11;
  if (Value = kF12) then
    PostK := VK_F12;
  if (Value = kUP) then
    PostK := VK_UP;
  if (Value = kDOWN) then
    PostK := VK_DOWN;
  if (Value = kPGUP) then
    PostK := VK_PRIOR;
  if (Value = kPGDOWN) then
    PostK := VK_NEXT;
end;
end;
procedure TDBEditK.SetCancelKey(Value: TFunctionKeys);
begin
if (Value <> fCancelKey) then begin
  fCancelKey := Value;
  if (Value = kNONE) then
    CancelK := 0;
  if (Value = kF1) then
    CancelK := VK_F1;
  if (Value = kF2) then
    CancelK := VK_F2;
  if (Value = kF3) then
    CancelK := VK_F3;
  if (Value = kF4) then
    CancelK := VK_F4;
  if (Value = kF5) then
    CancelK := VK_F5;
  if (Value = kF6) then
    CancelK := VK_F6;
  if (Value = kF7) then
    CancelK := VK_F7;
  if (Value = kF8) then
    CancelK := VK_F8;
  if (Value = kF9) then
    CancelK := VK_F9;
  if (Value = kF10) then
    CancelK := VK_F10;
  if (Value = kF11) then
    CancelK := VK_F11;
  if (Value = kF12) then
    CancelK := VK_F12;
  if (Value = kUP) then
    CancelK := VK_UP;
  if (Value = kDOWN) then
    CancelK := VK_DOWN;
  if (Value = kPGUP) then
    CancelK := VK_PRIOR;
  if (Value = kPGDOWN) then
    CancelK := VK_NEXT;
end;
end;
procedure TDBEditK.SetDeleteKey(Value: TFunctionKeys);
begin
if (Value <> fDeleteKey) then begin
  fDeleteKey := Value;
  if (Value = kNONE) then
    DeleteK := 0;
  if (Value = kF1) then
    DeleteK := VK_F1;
  if (Value = kF2) then
    DeleteK := VK_F2;
  if (Value = kF3) then
    DeleteK := VK_F3;
  if (Value = kF4) then
    DeleteK := VK_F4;
  if (Value = kF5) then
    DeleteK := VK_F5;
  if (Value = kF6) then
    DeleteK := VK_F6;
  if (Value = kF7) then
    DeleteK := VK_F7;
  if (Value = kF8) then
    DeleteK := VK_F8;
  if (Value = kF9) then
    DeleteK := VK_F9;
  if (Value = kF10) then
    DeleteK := VK_F10;
  if (Value = kF11) then
    DeleteK := VK_F11;
  if (Value = kF12) then
    DeleteK := VK_F12;
  if (Value = kUP) then
    DeleteK := VK_UP;
  if (Value = kDOWN) then
    DeleteK := VK_DOWN;
  if (Value = kPGUP) then
    DeleteK := VK_PRIOR;
  if (Value = kPGDOWN) then
    DeleteK := VK_NEXT;
end;
end;
procedure TDBEditK.SetRefreshKey(Value: TFunctionKeys);
begin
if (Value <> fRefreshKey) then begin
  fRefreshKey := Value;
  if (Value = kNONE) then
    RefreshK := 0;
  if (Value = kF1) then
    RefreshK := VK_F1;
  if (Value = kF2) then
    RefreshK := VK_F2;
  if (Value = kF3) then
    RefreshK := VK_F3;
  if (Value = kF4) then
    RefreshK := VK_F4;
  if (Value = kF5) then
    RefreshK := VK_F5;
  if (Value = kF6) then
    RefreshK := VK_F6;
  if (Value = kF7) then
    RefreshK := VK_F7;
  if (Value = kF8) then
    RefreshK := VK_F8;
  if (Value = kF9) then
    RefreshK := VK_F9;
  if (Value = kF10) then
    RefreshK := VK_F10;
  if (Value = kF11) then
    RefreshK := VK_F11;
  if (Value = kF12) then
    RefreshK := VK_F12;
  if (Value = kUP) then
    RefreshK := VK_UP;
  if (Value = kDOWN) then
    RefreshK := VK_DOWN;
  if (Value = kPGUP) then
    RefreshK := VK_PRIOR;
  if (Value = kPGDOWN) then
    RefreshK := VK_NEXT;
end;
end;
//==========================================================================

procedure Register;
begin
  RegisterComponents('Samples', [TDBEditK]);
  RegisterComponents('Samples', [TEditK]);
end;

end.


