{ *************************************************************************** }
{                                                                             }
{ VCL component TEditBoxConv                                                  }
{                                                                             }
{ This edit box automatically converts its text property to a float           }
{ variable which is then assigned to the published property                   }
{ ValidatedEntry.                                                             }
{                                                                             }
{ If the conversion fails, the ConversionError property is set to true so     }
{ that this condition can be flagged to the parsing code in your application  }
{                                                                             }
{ You can also set a conversion number range by assigning values to           }
{ RangeMax and RangeMin.  When the user enters a text value in the            }
{ component that falls outside this number range, an optional messagebox      }
{ is displayed; you can use the ShowErrorMessage and ErrorMessage properties  }
{ to control this functionality.  If you set ShowErrorMessage to true but     }
{ leave ErrorMessage blank, the following default error message is            }
{ displayed: 'The [Component Name] value is out of range.'                    }
{                                                                             }
{ In all cases where the number conversion fails, the previous good value     }
{ is re-assigned to the text property and the cursor is placed in its         }
{ previous position.  This causes the handler to run again and so             }
{ ValidatedEntry will also be updated with the last good value.               }
{                                                                             }
{ NB. NUMBER CONVERSION RANGE CHECKING AND REINSTATEMENT OF PREVIOUS          }
{ VALUES WHEN ERRORS OCCUR IS ONLY DONE FOR USER INPUT IE. WHEN THE           }
{ TEDITCONV CONTROL HAS FOCUS.  IF A TEXT VALUE IS ASSIGNED IN CODE           }
{ RATHER THAN BY THE USER, THE STRTOFLOAT CONVERSION PROCEEDS WITHOUT         }
{ COMPLETING THESE CHECKS [SEE THE LAST ELSE CLAUSE OF THE ONCHANGE           }
{ HANDLER]                                                                    }
{                                                                             }
{                                                                             }
{ Code generated by Component Create for Delphi                               }
{ on 16 April 2000 at 16:37                                                   }
{                                                                             }
{ Copyright  2000 by ...SG Walker Syberad                                    }
{                                                                             }
{ *************************************************************************** }

unit MyConvEd;

interface

uses WinTypes, WinProcs, Messages, SysUtils, Classes, Controls, 
     Forms, Graphics, Stdctrls;

type
  TEditBoxConv = class(TEdit)
    private
      { Private fields of TEditBoxConv }
        { Storage for property RangeMax }
        FRangeMax : Double;
        { Storage for property RangeMin }
        FRangeMin : Double;
        { Storage for property ValidatedEntry }
        FValidatedEntry : Double;
        {Used to indicate whether string to number conversion was successful or not}
        FConversionSuccess: boolean;
        {used to enable or disable error messages}
        FShowErrorMessage: boolean;
        {String for use in error message produced when string to num conversion
        is out of range}
        FErrorMessage: string;

      { Private methods of TEditBoxConv }
        { Method to set variable and property values and create objects }
        procedure AutoInitialize;
        { Method to free any objects created by AutoInitialize }
        procedure AutoDestroy;

    protected
      { Protected fields of TEditBoxConv }

      { Protected methods of TEditBoxConv }
        procedure Change; override;
        procedure KeyDown(var Key: Word; Shift: TShiftState); override;
        procedure Loaded; override;

    public
      { Public fields and properties of TEditBoxConv }
        BackSpace : Boolean;
        DeleteSpace : Boolean;
        Buffer: String;


      { Public methods of TEditBoxConv }
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;

    published
      { Published properties of TEditBoxConv }
        property OnChange;
        property OnClick;
        property OnDblClick;
        property OnDragDrop;
        property OnEnter;
        property OnExit;
        property OnKeyDown;
        property OnKeyPress;
        property OnKeyUp;
        property OnMouseDown;
        property OnMouseMove;
        property OnMouseUp;
        property RangeMax : Double read FRangeMax write FRangeMax;
        property RangeMin : Double read FRangeMin write FRangeMin;
        { StrToFloat result is stored in this variable }
        property ValidatedEntry : Double
             read FValidatedEntry write FValidatedEntry;
        property ConversionSuccess: boolean read FConversionSuccess write FConversionSuccess;
        property ShowErrorMessage: boolean read FShowErrorMessage write FShowErrorMessage;
        property ErrorMessage: string read FErrorMessage write FErrorMessage;

  end;

procedure Register;

implementation

procedure Register;
begin
     { Register TEditBoxConv with Standard as its
       default page on the Delphi component palette }
     RegisterComponents('Standard', [TEditBoxConv]);
end;

{ Method to set variable and property values and create objects }
procedure TEditBoxConv.AutoInitialize;
begin
     BackSpace:= False;
     DeleteSpace:= False;
     FRangeMax:= 1e10; {Default range values that will be over-ridden by user entries}
     FRangeMin:= 1e-10;
     FValidatedEntry:= 0.0;
     Buffer:='';
     ShowErrorMessage:=True;
     ErrorMessage:='';
     ConversionSuccess:=False;
end; { of AutoInitialize }

{ Method to free any objects created by AutoInitialize }
procedure TEditBoxConv.AutoDestroy;
begin
     { No objects from AutoInitialize to free }
end; { of AutoDestroy }

{ Override OnChange handler from TEdit }
procedure TEditBoxConv.Change;
Var
  CursorPosition, Cursor: integer;
label finish;

begin
  {The component error handling should only be run if user input is being processed
  rather than text assignments to this component by the application code.  This
  component will always have focus if the user is making input}

  {NB. Remember that throughout this handler, any changes to the text property
  will cause this handler to be immediately called again.  How we handle user input
  must therefore reflect this fact and we must be mindful of recursion risks when
  we change the text property}
  if Focused=True then
  begin
    {If user presses the space bar the following test will return 'true' and so
    we delete the space and exit the onchange handler}
    if Pos(' ',Text)<>0 then
    begin
      SysUtils.Beep;
      {Store the cursor position}
      CursorPosition:=SelStart;
      {Delete the space character by copying all but the space character.  NB. We
      don't need to know where the space character is because it will be last
      character the user entered.}
      Text:=copy(Text,1,CursorPosition-1)+copy(Text,CursorPosition+1,Length(Text));
      SelStart:=CursorPosition-1;
      ConversionSuccess:=False;
    end;
      Try
        if Text='' then
          begin
            Buffer:='';  {Buffer is a global var tha stores the component's text}
            Cursor:=0;   {Stores the component's cursor position}
            {Re-set the string to number conversion var ready for a new value which must
            first be validity tested}
            ValidatedEntry:=0;
            ConversionSuccess:=False;
          end
        else {Do the string to number conversion}
          ValidatedEntry:=StrToFloat(Text);
        {Now test for a number in the required range and for zero etc}
        if (ValidatedEntry<0) or ((ValidatedEntry<RangeMin) and (ValidatedEntry<>0)) or
           (ValidatedEntry>RangeMax) or ((ValidatedEntry=0) and (Pos('e',Text)<>0)) then
        begin {if number 'bad' store cursor position and re-instate the last good
        value which would have been stored in Buffer.  Then re-position the cursor}
          SysUtils.Beep;
          Cursor:=SelStart;
          if length(buffer)>Length(Text) then Cursor:=Cursor+1 else Cursor:=Cursor-1;
          if (Pos('e-',buffer)<>0) and (Pos('e-',Text)=0) then Cursor:=Cursor-1;
          Text:=Buffer;
          SelStart:=Cursor;
          if ShowErrorMessage=True then
          begin
            if ErrorMessage<>'' then Application.MessageBox(PChar(ErrorMessage), 'User Input Error', MB_OK + MB_ICONERROR)
            else
              Application.MessageBox(PChar('The ' + Name + ' value is out of range.'), 'User Input Error', MB_OK + MB_ICONERROR);
          end;
          ConversionSuccess:=False;
        end
        else
          if Text<>Buffer then ConversionSuccess:=True;
          {Number good, so update the buffer with this value so that it can be used
          to re-instate a good entry if the user's next key press gives a bad number
          conversion}
          Buffer:=Text;
      except {For all other types of bad number, eg. character entries}
        SysUtils.Beep;
        Cursor:=SelStart; {Store cursor position}
        Text:=Buffer;     {Load last good value into the text property}
        {The following code intelligently re-instates the cursor.  BackSpace and
        DeleteSpace are set by the KeyDown handler for this component}
        if (BackSpace=False) and (DeleteSpace=False) then SelStart:=Cursor-1;
        if BackSpace=True then
        begin
          SelStart:=Cursor+1;
          BackSpace:=False;
        end;
        if DeleteSpace=True then
        begin
          SelStart:=Cursor;
          DeleteSpace:=False;
        end;
        ConversionSuccess:=False;
      end;
    end
  else {If this control is not focused}
    Try
      if text='' then
      begin
        Buffer:='';  {Buffer is a global component var that stores the component's text}
        {Re-set the string to number conversion var ready for a new value which must
        first be validity tested}
        ValidatedEntry:=0;
        ConversionSuccess:=False;
      end
      else
      begin
        {Since the component is not focused, this method must have been called
        by code rather than use input.  Therefore the text property should be
        a valid number (assuming the application is coded correctly).}
        ValidatedEntry:=StrToFloat(Text);
        if Text<>Buffer then ConversionSuccess:=True;
        Buffer:=Text; {Store the current text in the buffer var so that it can be
        used to re-instate the last good value if subsequent user input in this
        component causes a string to number convesion error.}
      end;
    except {Provide an exception handler just in case the application assigns a
      a 'bad' string in the text property}
      ValidatedEntry:=0;
      ConversionSuccess:=False;
    end;
  {Now run the default onchange handler that will be specific to the application}
  inherited Change;
end;

{ Override OnKeyDown handler from TEdit }
procedure TEditBoxConv.KeyDown(var Key: Word; Shift: TShiftState);
var
 a: string;

begin
  { Obtain the default response of the parent class to this keydown event }
  inherited KeyDown(Key, Shift);

       { Key contains the Windows VK_ (virtual key) code of the key
       that was pressed, such as VK_DELETE.  Many are included in
       the case statement below.  For a complete list of VK_ codes,
       search for Delphi help topic "Virtual Key Codes."

       Shift is a set containing the state of the Shift, Ctrl, and Alt
       keys.  [ssShift] means only Shift key was down, [ssCtrl] means
       only Ctrl key was down, [ssAlt] means only Alt key was down,
       [ssShift, ssCtrl] means Ctrl+Shift, etc. }

  case Key of
  VK_BACK{, VK_DELETE }:   { Backspace, DEL keys }
  begin
    { Response to backspace/delete, if different
    from or additional to response of parent class }
//    Selstart:=Selstart+1;
  end;

     VK_PRIOR,              { PAGE UP key }
     VK_NEXT,               { PAGE DOWN key }
     VK_END,                { END key }
     VK_HOME :              { HOME key }
               begin
               end;

     VK_LEFT,               { LEFT ARROW key }
     VK_UP,                 { UP ARROW key }
     VK_RIGHT,              { RIGHT ARROW key }
     VK_DOWN :              { DOWN ARROW key }
               begin
               end;

     VK_TAB :               { TAB key }
               begin
               end;

     VK_INSERT :            { INS key }
               begin
               end;

     VK_ESCAPE :            { ESC key }
               begin
               end;

     end; { case }
  { Key contains the character produced by the keypress.
  It can be tested or assigned a new value before the
  call to the inherited KeyPress method.  Setting Key
  to #0 before call to the inherited KeyPress method
  terminates any further processing of the character. }

  {Check for 'e' or '-' characters and set these vars so that the onchange handler
  can place the cursor in the correct position within the component's text}
  a:=IntToStr(key);
  if a='8' then
    BackSpace:=True
  else
    BackSpace:=False;
  if a='46' then
    DeleteSpace:=True
  else
    DeleteSpace:=False;
end;

constructor TEditBoxConv.Create(AOwner: TComponent);
begin
     { Call the Create method of the parent class }
     inherited Create(AOwner);

     { AutoInitialize sets the initial values of variables and      }
     { properties; also, it creates objects for properties of       }
     { standard Delphi object types (e.g., TFont, TTimer,           }
     { TPicture) and for any variables marked as objects.           }
     { AutoInitialize method is generated by Component Create.      }
     AutoInitialize;

     { Code to perform other tasks when the component is created }
 
     { Code to perform other tasks when the component is created }
     Text:='0'; {Initialise as zero to avoid errors on component creation}
     Buffer:='';
     BackSpace:=False;
     DeleteSpace:=False;
end;

destructor TEditBoxConv.Destroy;
begin
     { AutoDestroy, which is generated by Component Create, frees any   }
     { objects created by AutoInitialize.                               }
     AutoDestroy;

     { Here, free any other dynamic objects that the component methods  }
     { created but have not yet freed.  Also perform any other clean-up }
     { operations needed before the component is destroyed.             }

     { Last, free the component by calling the Destroy method of the    }
     { parent class.                                                    }
     inherited Destroy;
end;

procedure TEditBoxConv.Loaded;
begin
     inherited Loaded;

     { Perform any component setup that depends on the property
       values having been set }
    Text:='';
end;


end.
