{ TGFGLEasythread beta version .1 copyright Greg Lorriman 1998

greg@lorriman.demon.co.uk

D2 and D3 component. Probably works with with D4.

See comments further down for help.

DISCLAIMER : This component, and associated files, comes with no
warranties express or implied, and the author does not accept
responsibility for any problems that this component may cause.
Use at your own risk.
}

unit easythrd;

interface

uses
  Classes,sysutils;


{$IFNDEF VER80}
 {$IFNDEF VER90}
  {$IFNDEF VER93}
    {$DEFINE GL_D3} { Delphi 3.0 or higher}
  {$ENDIF}
 {$ENDIF}
{$ENDIF}


type TPriority = set of TThreadPriority;

type EEasyTheadException=class(Exception);

type TEasyThreadThread=class;

TExecEvent=procedure(Sender : TObject; Thread : TEasyThreadThread) of object;
{Event based wrapper for the TThread class, for quick and easy access. Only allows one
thread at a time. Create dynamically for mutli-threaded apps (better to derive directly from TThread).

Before reading this helpfile : events are listed under "Properties".

EEasyThreadException is defined.

Assign a handler to the Exec event for your thread code. The handler should normally test for
thread.terminated and exit if true (especially if it is looped).

Use start to begin the thread, and stop to stop (and automatically destroy) the thread.

Assign handlers to ThreadBegin and ThreadEnd for thread start and stop event notification.

Active property indicates that a thread is created and running (not whether it is suspended or not).

Priority property sets the priority of any created threads. Has no effect on the currently running thread.

Use the Thread property to access the TThread derived object. This object surfaces all
protected methods and properties of TThread. You should not instantiate an object of this type yourself
(it is not polymorphic).

 }
TGFGLEasyThread=class(TComponent)

	private

   FHelp : TStrings;
   FStuff : string;
   FVersion : string;

	Fthread : TEasyThreadThread;
   FActive : Boolean;
   FPriority : TThreadPriority;
   FExec : TExecEvent;
	FThreadBegin : TNotifyEvent;
	FThreadEnd : TNotifyEvent;

   protected

   procedure terminated(sender : Tobject);
	procedure dummyWrite( s : string);
	procedure setHelp ( h : TStrings);

   public

	constructor create(AOwner: TComponent);override;
   destructor destroy;override;

   {Creates and starts the thread. Raises an exception if thread already running or if
   Exec event has no handler.}
   procedure start;
   {Terminates the thread, which then automatically destroys itself.
   Does nothing if there is no running thread.}
   procedure stop;

	{This is the TThread derived object that TGFGLEasyThread creates and with which it interacts.
   Protected methods and properties are surfaced for your use. See delphi help for TThread.
   This object is also available via the "thread" parameter of the exec event.}
	property Thread : TEasyThreadThread read Fthread Write Fthread;
   {Boolean read-only : indicates whether the thread has been created. To discover whether it is suspended
   access thread.suspended after checking for active=true.}
	property Active : Boolean read FActive;

   published

   property Help : TStrings  read FHelp  write SetHelp stored false;
   property Version : string read FVersion write dummywrite stored false;
   property OtherGreatStuff : string read FStuff write dummywrite stored false;

   {Thread priority. Note :setting to tpNormal will noticeably slow your app. tpTimeCritical
   will almost certainly lock the computer.}
	property Priority : TThreadPriority read FPriority Write FPriority ;
   {Code placed into handler for this event becomes your thread.

   You must test, within any loops you write, for thread.terminated, and exit if true.

   To update VCL controls etc you must create another method like :

   procedure myVCLUpdate;

   within a class and call it from this event with :

   thread.synchronize(myVCLupdate);

   otherwise big problems. Remember that the code within myVCLUpdate runs within the main app
   thread so you don't need to protect the code within it, and that the thread is as if temporarily suspended.

   If you wish to manipulate variables or objects outside of the event then you must protect them using
   critical sections, mutex's or semaphores if they are also used by code outside of the thread.

   If your thread code or myVCLupdate code generates an exception it will be 'smallowed' by the component. If this were not
   the case you would see system resources drop to 0% and have to reboot. You can, of course, catch it yourself (in order
   to show a message box?)}
   property Exec : TExecEvent read FExec Write FExec ;

   {Fires immediately after the thread begins.}
   property ThreadBegin : TNotifyEvent read FThreadBegin Write FThreadBegin ;
   {Fires immediately after the thread terminates.}
   property ThreadEnd : TNotifyEvent read FThreadEnd Write FThreadEnd ;

end;
{Used by TGFGLEasyThread. Surfaces protected properties and methods of TThread. You
should not instatiate an object of this type (not polymorphic).}
TEasyThreadThread = class(TThread)
  private

    FExec : TExecEvent;
    FOwner : TObject;

  protected

    procedure Execute; override;
	(*exists for passing through to exec event as sender*)
	 property Owner : TObject read FOwner Write FOwner ;

  public

  (*following methods and props are for surfacing purposes*)
	 procedure Synchronize(Method: TThreadMethod);
    procedure DoTerminate; override;
    property Terminated;
    property ReturnValue;

    (*linked to external event*)
	 property Exec : TExecEvent read FExec Write FExec ;

  end;

procedure Register;

implementation

constructor TGFGLEasyThread.create(AOwner: TComponent);
begin
	inherited create(aOwner);
   FVersion:='beta .1';
   FStuff :='http://www.lorriman.demon.co.uk';
   //this coould be placed into a resource file. Rainy day....
   FHelp:=TStringlist.create;
   FHelp.add('Usage : Create handler for "Exec" event. Code within event must exit when'+
   	#13+#10+'thread.terminated=true if not before.');
   FHelp.add('');
   FHelp.add('You must use thread.synchronize(myVCLUpdateMethod) to interact with the'
   +#13+#10+'outside world within your code. Otherwise -> splat.');
   fhelp.add('The method is of the form : procedure myUpdateMethod; [ie. no parameters]');
   fhelp.add('and remember to declare it within a class (TMainform?)');
   fhelp.add('');
	fHelp.add('Variables and other items declared outside of the event must not be used '
   	+#13+#10+'unless both external code and thread code protect access via mutexs,');
   FHelp.add('critical sections, or semaphores, else -> dull thud.');
   Fhelp.add('');
   fhelp.add('Methods :'+#13+#10+' procedure start; '+#13+#10+' procedure stop;');
   fhelp.add(#13+#10+'Properties '+#13+#10+' Active : thread running (readonly)'+
   	#13+#10+' Thread : object derived from TThread (with all protected items surfaced)');
   fhelp.add(#13+#10+' Other properties are visible at design time.');
   fhelp.add(#13+#10+'Notes :'+#13+#10+'Only the "Exec" event is within a thread.');
   fhelp.add('Threads are automatically destroyed when "stop" is called or component is freed.');
   fhelp.add(#13+#10+'Example code :');
   fhelp.add('');
   fhelp.add('procedure TForm1.easythread1Exec(sender : Tobject; thread : TEasythreadthread);');
   fhelp.add('var cntr : integer;');
   fhelp.add('begin'+#13+#10+'   for cntr:=0 to 10 do begin '+#13+#10+'      {do stuff}');
   fhelp.add('      thread.synchronize(mySyncMethod);// to update a label?');
   fhelp.add('      if thread.terminated then'+#13+#10+'         exit;');
   fhelp.add('   end;'+#13+#10+'end;');
   fhelp.add(#13+#10+'SCROLL TO TOP TO SEE START OF HELP');
end;



procedure TEasyThreadThread.Execute;
begin
  { Place thread code here }
  try
  if assigned(Fexec) then
  	fexec(Owner,self);
  except
  end;
end;

procedure TEasyThreadThread.Synchronize(Method: TThreadMethod);
begin
	inherited synchronize(method);
end;

procedure TEasyThreadThread.DoTerminate;
begin
	inherited doTerminate;
end;

destructor TGFGLEasythread.destroy;
begin
	if assigned(Fthread) then
   	fthread.terminate;
   inherited destroy;
end;



procedure TGFGLEasythread.terminated(sender : Tobject);
begin
	factive:=false;
   Fthread:=nil;
end;

procedure TGFGLEasyThread.start;
begin
	if assigned(Fthread) then
   	raise EEasyTheadException.create('Thread already running');
   if not assigned(Fexec) then
   	raise EEasyTheadException.create('Exec event not defined.');
	fthread:=TEasyThreadthread.create(true);
   fthread.onterminate:=terminated;
   fthread.exec:=exec;
	fthread.FreeOnTerminate:=true;
   fthread.priority:=priority;
   fthread.owner:=self;
   factive:=true;
   fthread.resume;
   if assigned(threadbegin) then
   	threadbegin(self);
end;

procedure TGFGLEasyThread.stop;
begin
	if assigned (Fthread) then begin
   	FThread.terminate;
       fthread:=nil;
       Factive:=false;
       if assigned(FThreadEnd) then
       	FthreadEnd(self);
   end;
end;

procedure TGFGLEasyThread.dummyWrite( s : string);
begin
end;

procedure TGFGLEasyThread.SetHelp ( h : TStrings);
begin
end;


procedure Register;
begin
  {$ifndef gl_d3}
  RegisterComponents('Win95', [TGFGLEasyThread]);
  {$else}
  RegisterComponents('Win32', [TGFGLEasyThread]);
{$endif}
{$ifndef win32}
	This component is for D2 or higher
{$endif}

end;


end.


