/*
 WizZip header file
 This implementation by Eric W. Engler
*/
/* WARNING: Although there is much support in this C code for
   Windows 3.1, I have not attempted to validate this code with
   3.1, and I am pretty sure more work is needed to back port
   this code completely. - Eric W. Engler
*/
/* WARNING: Although there is much support in this C code for
   Windows 3.1, I have not attempted to validate this code with
   3.1, and I am pretty sure more work is needed to back port
   this code completely.

   I used Microsoft Visual C++, v4.0 for this port, but I
   understand it is easy to port to Borland C++, v4.5 or up.
   Do not use Borland C++,v5.0 (it's buggy), but 5.01 may work.
   Some Borland-specific code is conditionally used in this
   project, but this version of UNZIP hasn't been tested under
   a Borland C++ compiler.

   No use is made of C++ features in any of the code modules, so
   if you're only familier with C, you will feel right at home.
   Of course, this also means that we aren't using any
   vendor-specific class libraries (MFC, OWL, etc.).
  - Eric W. Engler */


#ifndef _WIZZIP_H
#define _WIZZIP_H

#ifndef MSWIN
#define MSWIN
#endif

/* Porting definations between Win 3.1x and Win32 */
#ifdef WIN32
#  define far
#  define _far
#  define __far
#  define near
#  define _near
#  define __near
#endif

#ifndef NDEBUG
#  define WinAssert(exp) \
        {\
        if (!(exp))\
            {\
            char szBuffer[40];\
            sprintf(szBuffer, "File %s, Line %d",\
                    __FILE__, __LINE__) ;\
            if (IDABORT == MessageBox((HWND)NULL, szBuffer,\
                "Assertion Error",\
                MB_ABORTRETRYIGNORE|MB_ICONSTOP))\
                    FatalExit(-1);\
            }\
        }

#else
#  define WinAssert(exp)
#endif

#define cchFilesMax 4096

/* define the data passed back to the Delphi callback function */
typedef struct {
   HWND handle;
   long caller;
   long version;
   BOOL isoperationzip; // true=zip, false=unzip
   long actioncode;
   long error_code;
   long fsize;
   char filenameormsg[512]; /* NOTE: NOT a pointer - data is here */
} callbackstruct;

// We can't use BOOL as return type in the following typedef, so we use "long".
typedef __declspec(dllimport) long (CALLBACK *DLLCALLBK) (callbackstruct *);

/* The BOOL type in Win32 is the same as Delphi's LongBool */
typedef struct {
   HWND handle;        /* handle of calling pgm's active Window */
   long caller;        /* object instance ("self") of calling Delphi form 
                     (not used in DLL; returned to Delphi via callback) */
   long version;       /* version no. that Delphi Applic. expects */
   DLLCALLBK callback;
   BOOL fTraceEnabled;

   BOOL fEncryptVerify; /* not supported yet */
   BOOL fSuffix;     /* not supported yet */
   BOOL fEncrypt;    /* not supported yet */

   BOOL fSystem;          /* include system and hidden files */
   BOOL fVolume;          /* Include volume label */
   BOOL fExtra;           /* Include extra attributes */
   BOOL fNoDirEntries;    /* Do not add directory entries */
   BOOL fDate;            /* Exclude files earlier than specified date */
   BOOL fVerbose;         /* Mention oddities in zip file structure */
   BOOL fQuiet;           /* Quiet operation */

   int fLevel;            /* Compression level (0 - 9) */
   BOOL fComprSpecial;    /* try to compress files that are alreay compressed */
   BOOL fCRLF_LF;          /* Translate end-of-line */
   BOOL fJunkDir;          /* Junk (remove) directory names */
   BOOL fRecurse;          /* Recurse into subdirectories */
   BOOL fGrow;             /* Allow appending to a zip file */
   BOOL fForce;            /* Make entries using DOS names (k for Katz) */
   BOOL fMove;             /* Delete files added or updated in zip file */
   BOOL fDeleteEntries;    /* Delete files from zip file */
   BOOL fUpdate;           /* Update zip file--overwrite only if newer */
   BOOL fFreshen;          /* Freshen zip file--overwrite only */
   BOOL fJunkSFX;          /* Junk SFX prefix */
   BOOL fLatestTime;       /* Set zip file time to time of latest file in it */

   char Date[7];           /* Date to include after (MMDDYY + 1 null) */
   int  argc;              /* Count of filespecs to zip or delete */
   LPSTR lpszZipFN;        /* name of zip file */
   int seven;              /* stick a 7 in here to validate the struct offsets */
   char *FNV[];            /* array of filespec strings */
} ZCL, *LPZCL;

/* exports from DLL */
__declspec(dllexport) long DllZipUpFiles(ZCL *C);
__declspec(dllexport) void GetDllVersion(WORD *dwVersionHi,
                                         WORD *dwVersionLo);

extern char szFilesToAdd[80];
extern char rgszFiles[cchFilesMax];

#endif /* _WIZZIP_H */
