/* Modified Version for Delphi project, Eric W. Engler, Mar 5, 1997 */
/*---------------------------------------------------------------------------
  unzpriv.h
  This header file contains private (internal) macros, typedefs, prototypes
  and global-variable declarations used by all of the UnZip source files.
  In a prior life it was part of the main unzip.h header, but now it is only
  included by that header if UNZIP_INTERNAL is defined.
  ---------------------------------------------------------------------------*/
#ifndef __unzpriv_h   /* prevent multiple inclusions */
#define __unzpriv_h

/* First thing: Signal all following code that we compile UnZip utilities! */
#ifndef UNZIP
#  define UNZIP
#endif

/* GRR 960218:  testing a new feature...definitely *not* ready for primetime */
#ifdef TIMESTAMP
#  undef TIMESTAMP
#endif

// EWE PATCH - REENTRANT code is multi-threading, but is currently buggy
#ifdef REENTRANT
#undef REENTRANT
#endif

#ifdef SFX
#undef SFX  // EWE: this is only for compiling the actual SFX binary code
#endif

#ifdef NEVER  // EWE: dynamic crc table isn't a good idea
#ifndef DYNAMIC_CRC_TABLE
#  define DYNAMIC_CRC_TABLE
#endif
#ifndef DYNALLOC_CRCTAB
#  define DYNALLOC_CRCTAB
#endif
#endif

#ifdef DYNAMIC_CRC_TABLE
#  undef DYNAMIC_CRC_TABLE
#endif
#ifdef DYNALLOC_CRCTAB
#  undef DYNALLOC_CRCTAB
#endif

#include <stdio.h>

#include <ctype.h>       /* skip for VMS, to use tolower() function? */
#include <errno.h>       /* used in mapname() */
#ifdef USE_STRINGS_H
#  include <strings.h>   /* strcpy, strcmp, memcpy, index/rindex, etc. */
#else
#  include <string.h>    /* strcpy, strcmp, memcpy, strchr/strrchr, etc. */
#endif
#if (defined(MODERN) && !defined(NO_LIMITS_H))
#  include <limits.h>    /* GRR:  EXPERIMENTAL!  (can be deleted) */
#endif

/* this include must be down here for SysV.4, for some reason... */
#include <signal.h>      /* used in unzip.c, fileio.c */

/*---------------------------------------------------------------------------
    MS-DOS and OS/2 section:
  ---------------------------------------------------------------------------*/
#ifdef MORE
#  undef MORE
#endif

#ifndef MSC
#  define MSC
#endif

#include <sys/types.h>      /* off_t, time_t, dev_t, ... */
#include <sys/stat.h>
#include <io.h>             /* lseek(), open(), setftime(), dup(), creat() */
#include <time.h>           /* localtime() */
#include <fcntl.h>          /* O_BINARY for open() w/o CR/LF translation */

#include "doscfg.h"

#define DIR_END '\\'
#define lenEOL          2
#define PutNativeEOL    {*q++ = native(CR); *q++ = native(LF);}
#define USE_EF_UX_TIME

/*---------------------------------------------------------------------------
    Win32 section:
  ---------------------------------------------------------------------------*/
#include "w32cfg.h"

/*************/
/*  Defines  */
/*************/
#define UNZIP_VERSION     20   /* compatible with PKUNZIP 2.0 */

// I hate these multi-system groupings...but we need them
#define DOS_OS2
#define DOS_OS2_W32
#define DOS_W32_OS2          /* historical:  don't use */
#define DOS_H68_OS2_W32
#define DOS_T20_VMS

/* clean up with a few defaults */
#ifndef DIR_END
#  define DIR_END '/'       /* last char before program name (or filename) */
#endif
#ifndef DATE_FORMAT
#  define DATE_FORMAT   DF_MDY  /* defaults to US convention */
#endif
#ifndef RETURN
#  define RETURN  return        /* only used in main() */
#endif
#ifndef EXIT
#  define EXIT    exit
#endif

/* OS-specific exceptions to the "ANSI <--> INT_SPRINTF" rule */

#if (!defined(PCHAR_SPRINTF) && !defined(INT_SPRINTF))
#if (defined(SYSV) || defined(CONVEX) || defined(NeXT) || defined(BSD4_4))
#    define INT_SPRINTF      /* sprintf() returns int:  SysVish/Posix */
#endif
#if (defined(DOS_OS2_W32) || defined(VMS) || defined(AMIGA) || defined(_AIX))
#    define INT_SPRINTF      /* sprintf() returns int:  ANSI */
#endif
#if (defined(ultrix) || defined(__ultrix)) /* Ultrix 4.3 and newer */
#    if (defined(POSIX) || defined(__POSIX))
#      define INT_SPRINTF    /* sprintf() returns int:  ANSI/Posix */
#    endif
#    ifdef __GNUC__
#      define PCHAR_SPRINTF  /* undetermined actual return value */
#    endif
#endif
#if (defined(__osf__) || defined(CMS_MVS))
#    define INT_SPRINTF      /* sprintf() returns int:  ANSI/Posix */
#endif
#if defined(sun)
#    define PCHAR_SPRINTF    /* sprintf() returns char *:  SunOS cc *and* gcc */
#endif
#endif

/* defaults that we hope will take care of most machines in the future */
#if (!defined(PCHAR_SPRINTF) && !defined(INT_SPRINTF))
#ifdef __STDC__
#    define INT_SPRINTF      /* sprintf() returns int:  ANSI */
#endif
#ifndef INT_SPRINTF
#    define PCHAR_SPRINTF    /* sprintf() returns char *:  BSDish */
#endif
#endif

#define MSG_STDERR(f)  (f & 1)        /* bit 0:  0 = stdout, 1 = stderr */
#define MSG_INFO(f)    ((f & 6) == 0) /* bits 1 and 2:  0 = info */
#define MSG_WARN(f)    ((f & 6) == 2) /* bits 1 and 2:  1 = warning */
#define MSG_ERROR(f)   ((f & 6) == 4) /* bits 1 and 2:  2 = error */
#define MSG_FATAL(f)   ((f & 6) == 6) /* bits 1 and 2:  (3 = fatal error) */
#define MSG_ZFN(f)     (f & 0x0008)   /* bit 3:  1 = print zipfile name */
#define MSG_FN(f)      (f & 0x0010)   /* bit 4:  1 = print filename */
#define MSG_LNEWLN(f)  (f & 0x0020)   /* bit 5:  1 = leading newline if !SOL */
#define MSG_TNEWLN(f)  (f & 0x0040)   /* bit 6:  1 = trailing newline if !SOL */
#define MSG_MNEWLN(f)  (f & 0x0080)   /* bit 7:  1 = trailing newline if MPW */

/* the following are subject to change */
#define MSG_NO_WGUI(f) (f & 0x0100)   /* bit 8:  1 = skip if Windows GUI */
#define MSG_NO_AGUI(f) (f & 0x0200)   /* bit 9:  1 = skip if Acorn GUI */
#define MSG_NO_DLL2(f) (f & 0x0400)   /* bit 10:  1 = skip if OS/2 DLL */
#define MSG_NO_NDLL(f) (f & 0x0800)   /* bit 11:  1 = skip if WIN32 DLL */
#define MSG_NO_WDLL(f) (f & 0x1000)   /* bit 12:  1 = skip if Windows DLL */

#define DIR_BLKSIZ  64      /* number of directory entries per block
                             *  (should fit in 4096 bytes, usually) */
#ifndef WSIZE
#  define WSIZE     0x8000  /* window size--must be a power of two, and */
#endif                      /*  at least 32K for zip's deflate method */
                            /* For DLL, can't be > 32K due to buffer code */

#ifndef INBUFSIZ
#if (defined(MED_MEM) || defined(SMALL_MEM))
#    define INBUFSIZ  2048  /* works for MS-DOS small model */
#else
#    define INBUFSIZ  8192  /* larger buffers for real OSes */
#endif
#endif

#ifndef __16BIT__
#  define nearmalloc  malloc
#  define nearfree    free
#ifndef __IBMC__
#    define near
#    define far
#endif
#endif

#if (defined(USE_ZLIB) && !defined(USE_OWN_CRCTAB))
#ifdef DYNALLOC_CRCTAB
#    undef DYNALLOC_CRCTAB
#endif
#endif

#if (defined(USE_ZLIB) && defined(ASM_CRC))
#  undef ASM_CRC
#endif

#  define zfstrcpy(dest, src)    strcpy((dest), (src))
#  define LoadFarString(x)       x
#  define LoadFarStringSmall(x)  x
#  define LoadFarStringSmall2(x) x

//#ifdef MED_MEM
//#    define OUTBUFSIZ 0xFF80         /* can't malloc arrays of 0xFFE8 or more */
//#    define TRANSBUFSIZ 0xFF80
//     typedef short  shrint;
//#else
//#    define OUTBUFSIZ (lenEOL*WSIZE) /* more efficient text conversion */
//#    define TRANSBUFSIZ (lenEOL*OUTBUFSIZ)
//     typedef int  shrint;            /* for efficiency/speed, we hope... */
//#endif
#define OUTBUFSIZ   0x8000      // EWE: 32K (for unshrink.c)
#define TRANSBUFSIZ 0x8000      // EWE: 32K
#define RAWBUFSIZ OUTBUFSIZ
typedef int shrint;           

#ifndef Far
#  define Far
#endif

#ifndef MAIN
#  define MAIN  main
#endif

#if (defined(SFX) && !defined(NO_ZIPINFO))
#  define NO_ZIPINFO
#endif

#if (!defined(COPYRIGHT_CLEAN) && !defined(USE_SMITH_CODE))
#  define COPYRIGHT_CLEAN
#endif

#ifndef O_BINARY
#  define O_BINARY  0
#endif

#ifndef PIPE_ERROR
#  define PIPE_ERROR (errno == EPIPE)
#endif

/* File operations--use "b" for binary if allowed or fixed length 512 on VMS */
#ifndef FOPR
#  define FOPR "rb"
#endif
#ifndef FOPM
#  define FOPM "r+b"
#endif
#ifndef FOPW
#  define FOPW "wb"
#endif
#ifndef FOPWT
#  define FOPWT "wt"
#endif

/* If <limits.h> exists on most systems, should include that, since it may
 * define some or all of the following:  NAME_MAX, PATH_MAX, _POSIX_NAME_MAX,
 * _POSIX_PATH_MAX.
 */
#include <limits.h>

#ifndef PATH_MAX
#ifdef MAXPATHLEN
#    define PATH_MAX      MAXPATHLEN    /* in <sys/param.h> on some systems */
#else
#    ifdef _MAX_PATH
#      define PATH_MAX    _MAX_PATH
#    else
#      if FILENAME_MAX > 255
#        define PATH_MAX  FILENAME_MAX  /* used like PATH_MAX on some systems */
#      else
#        define PATH_MAX  1024
#      endif
#    endif /* ?_MAX_PATH */
#endif /* ?MAXPATHLEN */
#endif /* !PATH_MAX */

#define FILNAMSIZ  PATH_MAX

#define ZSUFX           ".zip"

#define CENTRAL_HDR_SIG   "\001\002"   /* the infamous "PK" signature bytes, */
#define LOCAL_HDR_SIG     "\003\004"   /*  sans "PK" (so unzip executable not */
#define END_CENTRAL_SIG   "\005\006"   /*  mistaken for zipfile itself) */
#define EXTD_LOCAL_SIG    "\007\010"   /* [ASCII "\113" == EBCDIC "\080" ??] */

#define SKIP              0    /* choice of activities for do_string() */
#define DISPLAY           1
#define DS_FN             2
#define EXTRA_FIELD       3
#define DS_EF             3

#define DOES_NOT_EXIST    -1   /* return values for check_for_newer() */
#define EXISTS_AND_OLDER  0
#define EXISTS_AND_NEWER  1

#define ROOT              0    /* checkdir() extract-to path:  called once */
#define INIT              1    /* allocate buildpath:  called once per member */
#define APPEND_DIR        2    /* append a dir comp.:  many times per member */
#define APPEND_NAME       3    /* append actual filename:  once per member */
#define GETPATH           4    /* retrieve the complete path and free it */
#define END               5    /* free root path prior to exiting program */

//----------------------------------------------------------
/* version_made_by codes (central dir):  make sure these */
/*  are not defined on their respective systems!! */
// EWE NOTE: I'm confused, should we pull all these out ???
// FS_FAT_, FS_HPFS_, FS_NTFS_, FS_VFAT_          
//----------------------------------------------------------
#define FS_FAT_           0    /* filesystem used by MS-DOS, OS/2, Win32 */
#define AMIGA_            1
#define VMS_              2
#define UNIX_             3
#define VM_CMS_           4
#define ATARI_            5    /* what if it's a minix filesystem? [cjh] */
#define FS_HPFS_          6    /* filesystem used by OS/2, NT */
#define MAC_              7
#define Z_SYSTEM_         8
#define CPM_              9
#define TOPS20_           10
#define FS_NTFS_          11   /* filesystem used by Windows NT */
#define QDOS_MAYBE_       12   /* a bit premature, but somebody once started */
#define ACORN_            13   /* Archimedes Acorn RISC OS */
#define FS_VFAT_          14   /* filesystem used by Windows 95 */
#define MVS_              15
#define BEBOX_            16
#define NUM_HOSTS         17   /* index of last system + 1 */

#define STORED            0    /* compression methods */
#define SHRUNK            1
#define REDUCED1          2
#define REDUCED2          3
#define REDUCED3          4
#define REDUCED4          5
#define IMPLODED          6
#define TOKENIZED         7   
#define DEFLATED          8
#define NUM_METHODS       9    /* index of last method + 1 */
/* don't forget to update list_files() appropriately if NUM_METHODS changes */

#define PK_OK             0    /* no error */
#define PK_COOL           0    /* no error */
#define PK_GNARLY         0    /* no error */
#define PK_WARN           1    /* warning error */
#define PK_ERR            2    /* error in zipfile */
#define PK_BADERR         3    /* severe error in zipfile */
#define PK_MEM            4    /* insufficient memory */
#define PK_MEM2           5    /* insufficient memory */
#define PK_MEM3           6    /* insufficient memory */
#define PK_MEM4           7    /* insufficient memory */
#define PK_MEM5           8    /* insufficient memory */
#define PK_NOZIP          9    /* zipfile not found */
#define PK_PARAM          10   /* bad or illegal parameters specified */
#define PK_FIND           11   /* no files found */
#define PK_DISK           50   /* disk full */
#define PK_EOF            51   /* unexpected EOF */

#define IZ_DIR            76   /* potential zipfile is a directory */
#define IZ_CREATED_DIR    77   /* directory created: set time and permissions */
#define IZ_VOL_LABEL      78   /* volume label, but can't set on hard disk */
#define IZ_EF_TRUNC       79   /* local extra field truncated (PKZIP'd) */

#define DF_MDY            0    /* date format 10/26/91 (USA only) */
#define DF_DMY            1    /* date format 26/10/91 (most of the world) */
#define DF_YMD            2    /* date format 91/10/26 (a few countries) */

/* extra-field ID values, little-endian: */
#define EF_AV        0x0007    /* PKWARE's authenticity verification ID */
#define EF_OS2       0x0009    /* OS/2 extended attributes ID */
#define EF_PKVMS     0x000c    /* PKWARE's VMS ID */
#define EF_ASIUNIX   0x756e    /* ASi/PKWARE's Unix ID ("nu") */
#define EF_IZVMS     0x4d49    /* Info-ZIP's VMS ID ("IM") */
#define EF_IZUNIX    0x5855    /* Info-ZIP's Unix ID ("UX") */
#define EF_VMCMS     0x4704    /* VM/CMS Extra Field ID ("\004G") */
#define EF_MVS       0x470f    /* MVS Extra Field ID ("\017G") */
#define EF_SPARK     0x4341    /* David Pilling's Acorn/SparkFS ID ("AC") */
#define EF_MD5       0x4b46    /* Fred Kantor's MD5 ID ("FK") */
#define EF_ACL       0x4C41    /* OS/2 ACL ID */

#define EB_HEADSIZE       4    /* length of extra field block header */
#define EB_ID             0    /* offset of block ID in header */
#define EB_LEN            2    /* offset of data length field in header */

#define EB_UX_MINLEN      8    /* minimal "UX" field contains atime, mtime */
#define EB_UX_FULLSIZE    12   /* full "UX" field (atime, mtime, uid, gid) */
#define EB_UX_ATIME       0    /* offset of atime in "UX" extra field data */
#define EB_UX_MTIME       4    /* offset of mtime in "UX" extra field data */
#define EB_UX_UID         8    /* byte offset of UID in "UX" field data */
#define EB_UX_GID         10   /* byte offset of GID in "UX" field data */

/*---------------------------------------------------------------------------
    True sizes of the various headers, as defined by PKWARE--so it is not
    likely that these will ever change.  But if they do, make sure both these
    defines AND the typedefs below get updated accordingly.
  ---------------------------------------------------------------------------*/
#define LREC_SIZE   26   /* lengths of local file headers, central */
#define CREC_SIZE   42   /*  directory headers, and the end-of-    */
#define ECREC_SIZE  18   /*  central-dir record, respectively      */

#define MAX_BITS    13                 /* used in unshrink() */
#define HSIZE       (1 << MAX_BITS)    /* size of global work area */

#define LF     10        /* '\n' on ASCII machines; must be 10 due to EBCDIC */
#define CR     13        /* '\r' on ASCII machines; must be 13 due to EBCDIC */
#define CTRLZ  26        /* DOS & OS/2 EOF marker (used in fileio.c, vms.c) */

#ifdef ZMEM
#  undef ZMEM
#  define memcpy(dest,src,len)   bcopy(src,dest,len)
#  define memzero                bzero
#else
#  define memzero(dest,len)      memset(dest,0,len)
#endif

#define ENV_UNZIP     "UNZIP"          /* the standard names */
#define ENV_ZIPINFO   "ZIPINFO"

#if (!defined(QQ) && !defined(NOQQ))
#  define QQ
#endif

#ifdef QQ                         /* Netware version:  no file */
#  define QCOND     (!G.qflag)    /*  comments with -vq or -vqq */
#else                             /* Bill Davidsen version:  no way to */
#  define QCOND     (which_hdr)   /*  kill file comments when listing */
#endif

#ifdef OLD_QQ
#  define QCOND2    (G.qflag < 2)
#else
#  define QCOND2    (!G.qflag)
#endif

#ifndef TRUE
#  define TRUE      1   /* sort of obvious */
#endif
#ifndef FALSE
#  define FALSE     0
#endif

#ifndef SEEK_SET
#  define SEEK_SET  0
#  define SEEK_CUR  1
#  define SEEK_END  2
#endif

#if (defined(UNIX) && defined(S_IFLNK) && !defined(MTS))
#  define SYMLINKS
#ifndef S_ISLNK
#    define S_ISLNK(m)  (((m) & S_IFMT) == S_IFLNK)
#endif
#endif /* UNIX && S_IFLNK && !MTS */

#ifndef S_ISDIR
#ifdef CMS_MVS
#    define S_ISDIR(m)  (FALSE)
#else
#    define S_ISDIR(m)  (((m) & S_IFMT) == S_IFDIR)
#endif
#endif

#ifndef IS_VOLID
#  define IS_VOLID(m)  ((m) & 0x08)
#endif

/**************/
/*  Typedefs  */
/**************/
#ifdef NO_UID_GID
#ifdef UID_USHORT
     typedef unsigned short  uid_t;    /* TI SysV.3 */
     typedef unsigned short  gid_t;
#else
     typedef unsigned int    uid_t;    /* SCO Xenix */
     typedef unsigned int    gid_t;
#endif
#endif

#if (defined(WIN32) || defined(sgi) || defined(BSD4_4) || defined(ATARI))
   typedef struct utimbuf ztimbuf;
#else
   typedef struct ztimbuf {
       time_t actime;        /* new access time */
       time_t modtime;       /* new modification time */
   } ztimbuf;
#endif

typedef struct min_info {
    long offset;
    ulg compr_size;          /* compressed size (needed if extended header) */
    ulg crc;                 /* crc (needed if extended header) */
    int hostnum;
    unsigned file_attr;      /* local flavor, as used by creat(), chmod()... */
    unsigned encrypted : 1;  /* file encrypted: decrypt before uncompressing */
    unsigned ExtLocHdr : 1;  /* use time instead of CRC for decrypt check */
    unsigned textfile : 1;   /* file is text (according to zip) */
    unsigned textmode : 1;   /* file is to be extracted as text */
    unsigned lcflag : 1;     /* convert filename to lowercase */
    unsigned vollabel : 1;   /* "file" is an MS-DOS volume (disk) label */
} min_info;

typedef struct VMStimbuf {
    char *revdate;    /* (both roughly correspond to Unix modtime/st_mtime) */
    char *credate;
} VMStimbuf;

/*---------------------------------------------------------------------------
    Zipfile work area declarations.
  ---------------------------------------------------------------------------*/
#ifdef MALLOC_WORK
#undef MALLOC_WORK  // EWE
#endif

#ifdef MALLOC_WORK
   union work {
     struct {                 /* unshrink(): */
       shrint *Parent;          /* (8193 * sizeof(short)) */
       uch *value;
       uch *Stack;
     } shrink;
     uch *Slide;              /* explode(), inflate(), unreduce() */
   };
#else /* !MALLOC_WORK */
   union work {
     struct {                 /* unshrink(): */
       shrint Parent[HSIZE];    /* (8192 * sizeof(short)) == 16KB minimum */
       uch value[HSIZE];        /* 8KB */
       uch Stack[HSIZE];        /* 8KB */
     } shrink;                  /* total = 32KB minimum; 80KB on Cray/Alpha */
     uch Slide[WSIZE];        /* explode(), inflate(), unreduce() */
   };
#endif /* ?MALLOC_WORK */

// These are for no redirection:
#define slide      G.area.Slide
#define redirSlide G.area.Slide

/*---------------------------------------------------------------------------
    Zipfile layout declarations.  If these headers ever change, make sure the
    xxREC_SIZE defines (above) change with them!
  ---------------------------------------------------------------------------*/
   typedef uch   local_byte_hdr[ LREC_SIZE ];
#      define L_VERSION_NEEDED_TO_EXTRACT_0     0
#      define L_VERSION_NEEDED_TO_EXTRACT_1     1
#      define L_GENERAL_PURPOSE_BIT_FLAG        2
#      define L_COMPRESSION_METHOD              4
#      define L_LAST_MOD_FILE_TIME              6
#      define L_LAST_MOD_FILE_DATE              8
#      define L_CRC32                           10
#      define L_COMPRESSED_SIZE                 14
#      define L_UNCOMPRESSED_SIZE               18
#      define L_FILENAME_LENGTH                 22
#      define L_EXTRA_FIELD_LENGTH              24

   typedef uch   cdir_byte_hdr[ CREC_SIZE ];
#      define C_VERSION_MADE_BY_0               0
#      define C_VERSION_MADE_BY_1               1
#      define C_VERSION_NEEDED_TO_EXTRACT_0     2
#      define C_VERSION_NEEDED_TO_EXTRACT_1     3
#      define C_GENERAL_PURPOSE_BIT_FLAG        4
#      define C_COMPRESSION_METHOD              6
#      define C_LAST_MOD_FILE_TIME              8
#      define C_LAST_MOD_FILE_DATE              10
#      define C_CRC32                           12
#      define C_COMPRESSED_SIZE                 16
#      define C_UNCOMPRESSED_SIZE               20
#      define C_FILENAME_LENGTH                 24
#      define C_EXTRA_FIELD_LENGTH              26
#      define C_FILE_COMMENT_LENGTH             28
#      define C_DISK_NUMBER_START               30
#      define C_INTERNAL_FILE_ATTRIBUTES        32
#      define C_EXTERNAL_FILE_ATTRIBUTES        34
#      define C_RELATIVE_OFFSET_LOCAL_HEADER    38

   typedef uch   ec_byte_rec[ ECREC_SIZE+4 ];
/*     define SIGNATURE                         0   space-holder only */
#      define NUMBER_THIS_DISK                  4
#      define NUM_DISK_WITH_START_CENTRAL_DIR   6
#      define NUM_ENTRIES_CENTRL_DIR_THS_DISK   8
#      define TOTAL_ENTRIES_CENTRAL_DIR         10
#      define SIZE_CENTRAL_DIRECTORY            12
#      define OFFSET_START_CENTRAL_DIRECTORY    16
#      define ZIPFILE_COMMENT_LENGTH            20


   typedef struct local_file_header {                 /* LOCAL */
       uch version_needed_to_extract[2];
       ush general_purpose_bit_flag;
       ush compression_method;
       ush last_mod_file_time;
       ush last_mod_file_date;
       ulg crc32;
       ulg csize;
       ulg ucsize;
       ush filename_length;
       ush extra_field_length;
   } local_file_hdr;

   typedef struct end_central_dir_record {            /* END CENTRAL */
       ush number_this_disk;
       ush num_disk_start_cdir;
       ush num_entries_centrl_dir_ths_disk;
       ush total_entries_central_dir;
       ulg size_central_directory;
       ulg offset_start_central_directory;
       ush zipfile_comment_length;
   } ecdir_rec;

/* Huffman code lookup table entry--this entry is four bytes for machines
   that have 16-bit pointers (e.g. PC's in the small or medium model).
   Valid extra bits are 0..13.  e == 15 is EOB (end of block), e == 16
   means that v is a literal, 16 < e < 32 means that v is a pointer to
   the next table, which codes e - 16 bits, and lastly e == 99 indicates
   an unused code.  If a code with e == 99 is looked up, this implies an
   error in the data. */
struct huft {
    uch e;                /* number of extra bits or operation */
    uch b;                /* number of bits in this code or subcode */
    union {
        ush n;            /* literal, length base, or distance base */
        struct huft *t;   /* pointer to next level of table */
    } v;
};

typedef struct _APIDocStruct {
    char *compare;
    char *function;
    char *syntax;
    char *purpose;
} APIDocStruct;

/*************/
/*  Globals  */
/*************/
#include "globals.h"

/*************************/
/*  Function Prototypes  */
/*************************/
/*---------------------------------------------------------------------------
    Functions in unzip.c (initialization routines):
  ---------------------------------------------------------------------------*/
int    unzip                     OF((__GPRO__ int argc, char **argv));
int    uz_opts                   OF((__GPRO__ int *pargc, char ***pargv));
int    usage                     OF((__GPRO__ int error));

/*---------------------------------------------------------------------------
    Functions in process.c (main driver routines):
  ---------------------------------------------------------------------------*/
int      process_zipfiles        OF((__GPRO));
int      uz_end_central          OF((__GPRO));
int      process_cdir_file_hdr   OF((__GPRO));
int      get_cdir_ent            OF((__GPRO));
int      process_local_file_hdr  OF((__GPRO));
unsigned ef_scan_for_izux        OF((uch *ef_buf, unsigned ef_len,
                                     ztimbuf *z_utim, ush *z_uidgid));

/*---------------------------------------------------------------------------
    Functions in zipinfo.c (`zipinfo-style' listing routines):
  ---------------------------------------------------------------------------*/
int      zi_opts                 OF((__GPRO__ int *pargc, char ***pargv));
int      zi_end_central          OF((__GPRO));
int      zipinfo                 OF((__GPRO));

/*---------------------------------------------------------------------------
    Functions in list.c (generic zipfile-listing routines):
  ---------------------------------------------------------------------------*/
int      list_files              OF((__GPRO));
int      ratio                   OF((ulg uc, ulg c));
void     fnprint                 OF((__GPRO));

/*---------------------------------------------------------------------------
    Functions in fileio.c:
  ---------------------------------------------------------------------------*/
int      open_input_file      OF((__GPRO));
int      open_outfile         OF((__GPRO));                    /* also vms.c */
void     undefer_input        OF((__GPRO));
void     defer_leftover_input OF((__GPRO));
unsigned readbuf              OF((__GPRO__ char *buf, register unsigned len));
int      readbyte             OF((__GPRO));
int      fillinbuf            OF((__GPRO));
int      flush                OF((__GPRO__ uch *buf, ulg size, int unshrink));
void     handler              OF((int signal));
time_t   dos_to_unix_time     OF((unsigned ddate, unsigned dtime));
int      check_for_newer      OF((__GPRO__ char *filename)); /* os2,vmcms,vms */
int      do_string            OF((__GPRO__ unsigned int len, int option));
ush      makeword             OF((uch *b));
ulg      makelong             OF((uch *sig));
int      zstrnicmp            OF((register const char *s1,
                                  register const char *s2,
                                  register unsigned n));
#ifdef ZMEM   /* MUST be ifdef'd because of conflicts with the standard def. */
   zvoid *memset OF((register zvoid *, register int, register unsigned int));
   zvoid *memcpy OF((register zvoid *, register const zvoid *,
                     register unsigned int));
#endif

/*---------------------------------------------------------------------------
    Functions in extract.c:
  ---------------------------------------------------------------------------*/
int    extract_or_test_files     OF((__GPRO));
int    memextract                OF((__GPRO__ uch *tgt, ulg tgtsize,
                                     uch *src, ulg srcsize));
int    memflush                  OF((__GPRO__ uch *rawbuf, ulg size));
char  *fnfilter                  OF((char *raw, uch *space));

/*---------------------------------------------------------------------------
    Decompression functions:
  ---------------------------------------------------------------------------*/
int    explode                   OF((__GPRO));                  /* explode.c */
int    huft_free                 OF((struct huft *t));          /* inflate.c */
int    huft_build                OF((__GPRO__ unsigned *b, unsigned n,
                                     unsigned s, ush *d, ush *e,
                                     struct huft **t, int *m));
int    inflate                   OF((__GPRO));                  /* inflate.c */
int    inflate_free              OF((__GPRO));                  /* inflate.c */
void   unreduce                  OF((__GPRO));                 /* unreduce.c */
int    unshrink                  OF((__GPRO));                 /* unshrink.c */

/*---------------------------------------------------------------------------
    MSDOS-only functions:
  ---------------------------------------------------------------------------*/
#if (defined(__GO32__) || (defined(MSDOS) && defined(__EMX__)))
   unsigned _dos_getcountryinfo(void *);                          /* msdos.c */
#if (!defined(__DJGPP__) || (__DJGPP__ < 2))
   void _dos_setftime(int, unsigned short, unsigned short);       /* msdos.c */
   void _dos_setfileattr(char *, int);                            /* msdos.c */
   unsigned _dos_creat(char *, unsigned, int *);                  /* msdos.c */
   void _dos_getdrive(unsigned *);                                /* msdos.c */
   unsigned _dos_close(int);                                      /* msdos.c */
#endif /* !__DJGPP__ || (__DJGPP__ < 2) */
#endif

/*---------------------------------------------------------------------------
    OS/2-only functions:
  ---------------------------------------------------------------------------*/
#ifdef OS2  /* GetFileTime conflicts with something in Win32 header files */
#if (defined(REENTRANT) && defined(USETHREADID))
   ulg   GetThreadId      OF((void));
#endif
   int   GetCountryInfo   OF((void));                               /* os2.c */
   long  GetFileTime      OF((char *name));                         /* os2.c */
   int   IsUpperNLS       OF((int nChr));                           /* os2.c */
   int   ToLowerNLS       OF((int nChr));                           /* os2.c */
   void  DebugMalloc      OF((void));                               /* os2.c */
#endif

/*---------------------------------------------------------------------------
    Miscellaneous/shared functions:
  ---------------------------------------------------------------------------*/
struct Globals *globalsCtor  OF((void));                        /* globals.c */

void     envargs         OF((__GPRO__ int *Pargc, char ***Pargv,
                             char *envstr, char *envstr2));     /* envargs.c */
void     mksargs         OF((int *argcp, char ***argvp));       /* envargs.c */

int      match           OF((char *s, char *p, int ic));          /* match.c */
int      iswild          OF((char *p));                           /* match.c */

ulg near *get_crc_table  OF((void));                             /* crctab.c */
ulg      crc32           OF((ulg crc, const uch *buf,
                                extent len));                    /* crc32.c */

int      dateformat      OF((void));              /* currently, only msdos.c */
void     version         OF((__GPRO));                              /* local */
int      mapattr         OF((__GPRO));                              /* local */
int      mapname         OF((__GPRO__ int renamed));                /* local */
int      checkdir        OF((__GPRO__ char *pathcomp, int flag));   /* local */
char    *do_wild         OF((__GPRO__ char *wildzipfn));            /* local */
char    *GetLoadPath     OF((__GPRO));                              /* local */

void  close_outfile   OF((__GPRO));                                 /* local */
#ifdef SYSTEM_SPECIFIC_CTOR
   void  SYSTEM_SPECIFIC_CTOR   OF((__GPRO));                       /* local */
#endif

/************/
/*  Macros  */
/************/
#ifndef MAX
#  define MAX(a,b)   ((a) > (b) ? (a) : (b))
#endif
#ifndef MIN
#  define MIN(a,b)   ((a) < (b) ? (a) : (b))
#endif

#define Trace(x)   MyTrace x

#ifdef DEBUG_TIME
#  define TTrace(x)  fprintf x
#else
#  define TTrace(x)
#endif

#ifdef NO_DEBUG_IN_MACROS
#  define MTrace(x)
#else
#  define MTrace(x)  Trace(x)
#endif

#if (defined(UNIX) || defined(T20_VMS)) /* generally old systems */
#  define ToLower(x)   ((char)(isupper((int)x)? tolower((int)x) : x))
#else
#  define ToLower      tolower          /* assumed "smart"; used in match() */
#endif

#ifdef USE_STRM_INPUT
   /* ``Replace'' the unbuffered UNIX style I/O function with similar
    * standard C functions from <stdio.h>.
    */
#  define read(fd,buf,n) fread((buf),1,(n),(FILE *)(fd))
#  define lseek(fd,o,w)  fseek((FILE *)(fd),(o),(w))
#  define close(fd)      fclose((FILE *)(fd))
#endif /* USE_STRM_INPUT */

/* The return value of the Info() "macro function" is never checked in
 * UnZip. Otherwise, to get the same behaviour as for (*G.message)(), the
 * Info() definition for "FUNZIP" would have to be corrected:
 * #define Info(buf,flag,sprf_arg) \
 *      (fprintf((flag)&1? stderr : stdout, \
 *               (char *)(sprintf sprf_arg, (buf))) == EOF)
 */
// EWE: I'm not using Info()
#define Info(buf,flag,sprf_arg)

//#define Info(buf,flag,sprf_arg) \
//       (*G.message)((zvoid *)&G, (uch *)(buf), \
//          (ulg)(sprintf sprf_arg, strlen((char *)(buf))), (flag))

// EWE: Check this out:
#define MESSAGE(str,len,flag)  (*G.message)((zvoid *)&G,(str),(len),(flag))

#define CRCVAL_INITIAL  0L

/*  Seek to the block boundary of the block which includes abs_offset,
 *  then read block into input buffer and set pointers appropriately.
 *  If block is already in the buffer, just set the pointers.  This macro
 *  is used by uz_end_central (process.c), zi_end_central (zipinfo.c) and
 *  do_string (fileio.c).  A slightly modified version is embedded within
 *  extract_or_test_files (extract.c).  readbyte() and readbuf() (fileio.c)
 *  are compatible.  NOTE THAT abs_offset is intended to be the "proper off-
 *  set" (i.e., if there were no extra bytes prepended); cur_zipfile_bufstart
 *  contains the corrected offset.
 *
 *  Since ZLSEEK is never used during decompression, it is safe to use the
 *  slide[] buffer for the error message.
 *
 *  The awkward "%cbs_offset" construct is provided for the obnoxious Solaris
 *  compiler, which wants to do macro substitution inside strings.
 */
#ifndef ZLSEEK
#ifdef USE_STRM_INPUT
#    define _ZLS_RELOAD(abs_offset) {\
         MTrace((stderr, "ZLSEEK: %cbs_offset = %ld, G.extra_bytes = %ld\n",\
           'a', (abs_offset), G.extra_bytes));\
         fseek(G.zipfd,(LONGINT)bufstart,SEEK_SET);\
         G.cur_zipfile_bufstart = ftell(G.zipfd);\
         MTrace((stderr,\
           "       request = %ld, (abs+extra) = %ld, inbuf_offset = %ld\n",\
           request, ((abs_offset)+G.extra_bytes), inbuf_offset));\
         MTrace((stderr, "       bufstart = %ld, cur_zipfile_bufstart = %ld\n",\
           bufstart, G.cur_zipfile_bufstart));\
         if ((G.incnt = fread((char *)G.inbuf,1,INBUFSIZ,G.zipfd)) <= 0)\
             return(PK_EOF);\
         G.inptr = G.inbuf + (int)inbuf_offset;\
         G.incnt -= (int)inbuf_offset;\
     }
#else /* !USE_STRM_INPUT */
#    define _ZLS_RELOAD(abs_offset) {\
         MTrace((stderr, "ZLSEEK: %cbs_offset = %ld, G.extra_bytes = %ld\n",\
           'a', (abs_offset), G.extra_bytes));\
         G.cur_zipfile_bufstart = lseek(G.zipfd,(LONGINT)bufstart,SEEK_SET);\
         MTrace((stderr,\
           "       request = %ld, (abs+extra) = %ld, inbuf_offset = %ld\n",\
           request, ((abs_offset)+G.extra_bytes), inbuf_offset));\
         MTrace((stderr, "       bufstart = %ld, cur_zipfile_bufstart = %ld\n",\
           bufstart, G.cur_zipfile_bufstart));\
         if ((G.incnt = read(G.zipfd,(char *)G.inbuf,INBUFSIZ)) <= 0)\
             return(PK_EOF);\
         G.inptr = G.inbuf + (int)inbuf_offset;\
         G.incnt -= (int)inbuf_offset;\
     }
#endif /* ?USE_STRM_INPUT */

#  define ZLSEEK(abs_offset) {\
       LONGINT request = (abs_offset) + G.extra_bytes;\
       LONGINT inbuf_offset = request % INBUFSIZ;\
       LONGINT bufstart = request - inbuf_offset;\
\
       if (request < 0) {\
           Info(slide, 1, ((char *)slide, LoadFarStringSmall(SeekMsg),\
             LoadFarString(ReportMsg)));\
           return(PK_BADERR);\
       } else if (bufstart != G.cur_zipfile_bufstart)\
           _ZLS_RELOAD(abs_offset)\
       else {\
           G.incnt += (G.inptr-G.inbuf) - (int)inbuf_offset;\
           G.inptr = G.inbuf + (int)inbuf_offset;\
       }\
   }
#endif /* !ZLSEEK */

#define SKIP_(length) if(length&&((error=do_string(__G__ length,SKIP))!=0))\
  {error_in_archive=error; if(error>1) return error;}

/*  Skip a variable-length field, and report any errors.  Used in zipinfo.c
 *  and unzip.c in several functions.
 *
 *  macro SKIP_(length)
 *      ush length;
 *  {
 *      if (length && ((error = do_string(length, SKIP)) != 0)) {
 *          error_in_archive = error;   /-* might be warning *-/
 *          if (error > 1)              /-* fatal *-/
 *              return (error);
 *      }
 *  }
 */

#  define FLUSH(w)  if (G.mem_mode) memflush(__G__ redirSlide,(ulg)(w)); \
     else flush(__G__ redirSlide,(ulg)(w),0)
#  define NEXTBYTE  (--G.incnt >= 0 ? (int)(*G.inptr++) : readbyte(__G))

#define READBITS(nbits,zdest) {if(nbits>G.bits_left) {int temp; G.zipeof=1;\
  while (G.bits_left<=8*(sizeof(G.bitbuf)-1) && (temp=NEXTBYTE)!=EOF) {\
  G.bitbuf|=(ulg)temp<<G.bits_left; G.bits_left+=8; G.zipeof=0;}}\
  zdest=(shrint)((ush)G.bitbuf&mask_bits[nbits]);G.bitbuf>>=nbits;\
  G.bits_left-=nbits;}

/* macro READBITS(nbits,zdest)    * only used by unreduce and unshrink *
 * {
 *      if (nbits > G.bits_left) {  * fill G.bitbuf, 8*sizeof(ulg) bits *
 *          int temp;
 *
 *          G.zipeof = 1;
 *          while (G.bits_left <= 8*(sizeof(G.bitbuf)-1) &&
 *                 (temp = NEXTBYTE) != EOF) {
 *              G.bitbuf |= (ulg)temp << G.bits_left;
 *              G.bits_left += 8;
 *              G.zipeof = 0;
 *          }
 *      }
 *      zdest = (shrint)((ush)G.bitbuf & mask_bits[nbits]);
 *      G.bitbuf >>= nbits;
 *      G.bits_left -= nbits;
 *  }
 */

/* GRR:  should change name to STRLOWER and use StringLower, if possible.
 *  Copy the zero-terminated string in str1 into str2, converting any
 *  uppercase letters to lowercase as we go.  str2 gets zero-terminated
 *  as well, of course.  str1 and str2 may be the same character array.
 */
#  define TOLOWER(str1, str2) \
   { \
       char  *p, *q; \
       p = (str1) - 1; \
       q = (str2); \
       while (*++p) \
           *q++ = (char)(isupper((int)(*p))? tolower((int)(*p)) : *p); \
       *q = '\0'; \
   }
/* NOTES:  This macro makes no assumptions about the characteristics of
 *    the tolower() function or macro (beyond its existence), nor does it
 *    make assumptions about the structure of the character set (i.e., it
 *    should work on EBCDIC machines, too).  The fact that either or both
 *    of isupper() and tolower() may be macros has been taken into account;
 *    watch out for "side effects" (in the C sense) when modifying this
 *    macro.
 */

#ifndef native
#  define native(c)   (c)
#  define A_TO_N(str1)
#else
#ifndef NATIVE
#    define NATIVE     "native chars"
#endif
#  define A_TO_N(str1) {register uch *p;\
     for (p=str1; *p; p++) *p=native(*p);}
#endif
/*  Translate the zero-terminated string in str1 from ASCII to the native
 *  character set. The translation is performed in-place and uses the
 *  "native" macro to translate each character.
 *
 *  NOTE:  Using the "native" macro means that is it the only part of unzip
 *    which knows which translation table (if any) is actually in use to
 *    produce the native character set.  This makes adding new character set
 *    translation tables easy, insofar as all that is needed is an appropriate
 *    "native" macro definition and the translation table itself.  Currently,
 *    the only non-ASCII native character set implemented is EBCDIC, but this
 *    may not always be so.
 */

/**********************/
/*  Global constants  */
/**********************/
   extern ush near  mask_bits[];
   extern char     *fnames[2];
   extern char Far  CentSigMsg[];
   extern char Far  EndSigMsg[];
   extern char Far  SeekMsg[];
   extern char Far  FilenameNotMatched[];
   extern char Far  ExclFilenameNotMatched[];
   extern char Far  ReportMsg[];
   extern char Far  CompiledWith[];

/***********************************/
/*  Global (shared?) RTL variables */
/***********************************/

#ifdef DECLARE_ERRNO
   extern int       errno;
#endif

#endif /* !__unzpriv_h */
